/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.aggregate;

import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.framework.WriteObjectTest;
import org.eclipse.persistence.testing.models.aggregate.Company;
import org.eclipse.persistence.testing.models.aggregate.Customer;
import org.eclipse.persistence.testing.models.aggregate.Dependant;
import org.eclipse.persistence.testing.models.aggregate.House;
import org.eclipse.persistence.testing.models.aggregate.Oid;
import org.eclipse.persistence.testing.tests.aggregate.AgentBuilderHelper;

public class AggregateCollectionUoWTest
extends WriteObjectTest {
    public Object unitOfWorkWorkingCopy;
    public UnitOfWork unitOfWork;

    public AggregateCollectionUoWTest() {
    }

    public AggregateCollectionUoWTest(Object originalObject) {
        super(originalObject);
    }

    protected void changeUnitOfWorkWorkingCopy() {
        Object object = this.unitOfWorkWorkingCopy;
        AgentBuilderHelper.setLastName(object, "Jackson");
        List customers = AgentBuilderHelper.getCustomers(object);
        Customer customer1 = (Customer)customers.get(0);
        customer1.setName("Vince Carter");
        customer1.addDependant(new Dependant("lily", 12));
        List houses = AgentBuilderHelper.getHouses(object);
        AgentBuilderHelper.removeHouse(object, (House)houses.get(0));
        House house2 = (House)houses.get(houses.size() - 1);
        house2.setDescriptions("do not buy it, it collapses -:)");
        Oid newInsurancePolicyId = new Oid();
        newInsurancePolicyId.setOid(new Integer(893453));
        house2.setInsuranceId(newInsurancePolicyId);
        House newHouse = new House();
        newHouse.setLocation("123 Slater Street");
        newHouse.setDescriptions("every convinent to who works with The Object People");
        AgentBuilderHelper.addHouse(object, newHouse);
        Customer newCustomer = new Customer();
        newCustomer.setName("Micheal Chang");
        newCustomer.setIncome(1000000);
        newCustomer.setCompany(Company.example4());
        Vector<Dependant> changDependnants = new Vector<Dependant>(3);
        changDependnants.addElement(new Dependant("Susan", 9));
        changDependnants.addElement(new Dependant("Julie", 5));
        changDependnants.addElement(new Dependant("David", 2));
        newCustomer.setDependants(changDependnants);
        AgentBuilderHelper.addCustomer(object, newCustomer);
    }

    protected void setup() {
        super.setup();
        this.unitOfWork = this.getSession().acquireUnitOfWork();
        this.unitOfWorkWorkingCopy = this.unitOfWork.registerObject(this.objectToBeWritten);
        this.changeUnitOfWorkWorkingCopy();
        if (!this.compareObjects(this.originalObject, this.objectToBeWritten)) {
            throw new TestErrorException("The original object was changed through changing the clone.");
        }
    }

    protected void test() {
        try {
            this.unitOfWork.commit();
        }
        catch (OptimisticLockException ex) {
            new TestWarningException("Optimistic locking exception thrown when object was changed outside during the transaction");
        }
    }

    protected void verify() {
        if (!this.compareObjects(this.unitOfWorkWorkingCopy, this.objectToBeWritten)) {
            throw new TestErrorException("The original object did not receive the changes correctly, in the merge.");
        }
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        this.objectFromDatabase = this.getSession().executeQuery((DatabaseQuery)this.query);
        if (!this.compareObjects(this.objectToBeWritten, this.objectFromDatabase)) {
            throw new TestErrorException("The object inserted into the database, '" + this.objectFromDatabase + "' does not match the original, '" + this.objectToBeWritten + ".");
        }
    }
}

