/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.identitymaps.cacheinvalidation;

import java.util.Calendar;
import java.util.GregorianCalendar;
import junit.framework.Test;
import org.eclipse.persistence.descriptors.invalidation.CacheInvalidationPolicy;
import org.eclipse.persistence.descriptors.invalidation.DailyCacheInvalidationPolicy;
import org.eclipse.persistence.descriptors.invalidation.NoExpiryCacheInvalidationPolicy;
import org.eclipse.persistence.descriptors.invalidation.TimeToLiveCacheInvalidationPolicy;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.testing.framework.TestSuite;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.identitymaps.cacheinvalidation.CacheExpiryAPITest;
import org.eclipse.persistence.testing.tests.identitymaps.cacheinvalidation.CacheExpiryPolicyTest;
import org.eclipse.persistence.testing.tests.identitymaps.cacheinvalidation.CacheExpiryReadAllQueryTest;
import org.eclipse.persistence.testing.tests.identitymaps.cacheinvalidation.CacheExpiryReadObjectQueryTest;
import org.eclipse.persistence.testing.tests.identitymaps.cacheinvalidation.CacheExpiryTest;
import org.eclipse.persistence.testing.tests.identitymaps.cacheinvalidation.CacheExpiryUnitOfWorkReadTest;
import org.eclipse.persistence.testing.tests.identitymaps.cacheinvalidation.CacheExpiryValueholderTest;
import org.eclipse.persistence.testing.tests.identitymaps.cacheinvalidation.CacheInvalidationPolicyCloneTest;
import org.eclipse.persistence.testing.tests.identitymaps.cacheinvalidation.DailyCacheExpiryTest;
import org.eclipse.persistence.testing.tests.identitymaps.cacheinvalidation.InvalidateAllExternalChangeTest;
import org.eclipse.persistence.testing.tests.identitymaps.cacheinvalidation.InvalidateAllTest;
import org.eclipse.persistence.testing.tests.identitymaps.cacheinvalidation.InvalidateClassRecurseOptionTest;
import org.eclipse.persistence.testing.tests.identitymaps.cacheinvalidation.NoExpiryInvalidationTest;
import org.eclipse.persistence.testing.tests.identitymaps.cacheinvalidation.PrimaryKeyQueryInUOWTest;
import org.eclipse.persistence.testing.tests.identitymaps.cacheinvalidation.ReadAllQueryCheckCacheOnlyExpiryTest;
import org.eclipse.persistence.testing.tests.identitymaps.cacheinvalidation.ReadAllQueryConformExpiryTest;
import org.eclipse.persistence.testing.tests.identitymaps.cacheinvalidation.ReadObjectCheckCacheOnlyExpiryTest;
import org.eclipse.persistence.testing.tests.identitymaps.cacheinvalidation.ReadObjectQueryConformExpiryTest;
import org.eclipse.persistence.testing.tests.identitymaps.cacheinvalidation.RefreshIfNewerVersionTest;
import org.eclipse.persistence.testing.tests.identitymaps.cacheinvalidation.RefreshQueryCacheExpiryTest;
import org.eclipse.persistence.testing.tests.identitymaps.cacheinvalidation.SessionCreateObjectReadTimeTest;
import org.eclipse.persistence.testing.tests.identitymaps.cacheinvalidation.UnitOfWorkCreateObjectReadTimeTest;
import org.eclipse.persistence.testing.tests.identitymaps.cacheinvalidation.UnitOfWorkExpiredObjectTest;
import org.eclipse.persistence.testing.tests.identitymaps.cacheinvalidation.UnitOfWorkRefreshAfterInvalidationTest;
import org.eclipse.persistence.testing.tests.identitymaps.cacheinvalidation.UpdateQueryChangeExpiryTest;
import org.eclipse.persistence.tools.schemaframework.PopulationManager;

public class CacheExpiryTestSuite
extends TestSuite {
    public CacheExpiryTestSuite() {
        this.setDescription("Test the cache expiry feature.");
    }

    public void addTests() {
        this.addTest((Test)new CacheExpiryAPITest());
        TimeToLiveCacheInvalidationPolicy ttlPolicy = new TimeToLiveCacheInvalidationPolicy(0L);
        CacheExpiryTest test = new CacheExpiryPolicyTest((CacheInvalidationPolicy)ttlPolicy, true);
        test.setDescription("Ensure Objects expire with TIME_TO_LIVE_EXPIRY.");
        test.setName("TIME_TO_LIVE_EXPIRY(0s) - Expire");
        this.addTest((Test)test);
        ttlPolicy = new TimeToLiveCacheInvalidationPolicy(100000L);
        test = new CacheExpiryPolicyTest((CacheInvalidationPolicy)ttlPolicy, false);
        test.setDescription("Ensure Objects survive with TIME_TO_LIVE_EXPIRY.");
        test.setName("TIME_TO_LIVE_EXPIRY(100s) - Live");
        this.addTest((Test)test);
        ttlPolicy = new TimeToLiveCacheInvalidationPolicy(-100000L);
        test = new CacheExpiryPolicyTest((CacheInvalidationPolicy)ttlPolicy, true);
        test.setDescription("Ensure Objects expire with TIME_TO_LIVE_EXPIRY.");
        test.setName("TIME_TO_LIVE_EXPIRY(-100s) - Expire");
        this.addTest((Test)test);
        GregorianCalendar calendar = new GregorianCalendar();
        ((Calendar)calendar).add(14, -1);
        DailyCacheInvalidationPolicy dPolicy = new DailyCacheInvalidationPolicy(calendar.get(11), calendar.get(12), calendar.get(13), calendar.get(14));
        test = new CacheExpiryPolicyTest((CacheInvalidationPolicy)dPolicy, true);
        test.setDescription("Ensure Objects expire with DAILY_EXPIRY.");
        test.setName("DAILY - Expire");
        this.addTest((Test)test);
        calendar = new GregorianCalendar();
        dPolicy = new DailyCacheInvalidationPolicy(calendar.get(11), calendar.get(12), calendar.get(13), calendar.get(14));
        test = new CacheExpiryPolicyTest((CacheInvalidationPolicy)dPolicy, true);
        test.setDescription("Ensure Objects expire with DAILY_EXPIRY.");
        test.setName("DAILY_EXPIRY - Expire");
        this.addTest((Test)test);
        calendar = new GregorianCalendar();
        ((Calendar)calendar).add(11, 1);
        dPolicy = new DailyCacheInvalidationPolicy(calendar.get(11), calendar.get(12), calendar.get(13), calendar.get(14));
        test = new CacheExpiryPolicyTest((CacheInvalidationPolicy)dPolicy, false);
        test.setDescription("Ensure Objects survive with DAILY_EXPIRY.");
        test.setName("DAILY_EXPIRY - Live");
        this.addTest((Test)test);
        test = new CacheExpiryPolicyTest((CacheInvalidationPolicy)new NoExpiryCacheInvalidationPolicy(), false);
        test.setDescription("Ensure Objects survive with NO_EXPIRY.");
        test.setName("NO_EXPIRY - Live");
        this.addTest((Test)test);
        long oneDay = 86400000L;
        long minusOneDay = -1L * oneDay;
        test = new DailyCacheExpiryTest(oneDay + 1000L, 0L, false);
        test.setDescription("Ensure cache expiry works correctly when expiry is greater than one day away.");
        test.setName("Daily Expiry (+ One Day)");
        this.addTest((Test)test);
        test = new DailyCacheExpiryTest(minusOneDay - 100L, minusOneDay - 1000L, true);
        test.setDescription("Ensure cache expiry works correctly when expiry is greater than one day ago.");
        test.setName("Daily Expiry (- One Day)");
        this.addTest((Test)test);
        test = new DailyCacheExpiryTest(0L, 3L * minusOneDay - 1000L, true);
        test.setDescription("Ensure cache expiry works correctly when expiry is many days.");
        test.setName("Daily Expiry (- 3 Days)");
        this.addTest((Test)test);
        test = new DailyCacheExpiryTest(3L * oneDay, 0L, false);
        test.setDescription("Ensure cache expiry works correctly when expiry is many days.");
        test.setName("Daily Expiry (+ 3 Days)");
        this.addTest((Test)test);
        this.addTest((Test)new NoExpiryInvalidationTest());
        PopulationManager manager = PopulationManager.getDefaultManager();
        Employee employeeToRead = (Employee)manager.getObject(Employee.class, "0001");
        ReadObjectQuery query = new ReadObjectQuery((Object)employeeToRead);
        query.checkCacheThenDatabase();
        test = new CacheExpiryReadObjectQueryTest(employeeToRead, query, true);
        test.setDescription("Verify Read Object Query with expiry and a query object.");
        test.setName("ReadObjectQuery (query object) Expiry Test");
        this.addTest((Test)test);
        query = new ReadObjectQuery((Object)employeeToRead);
        query.checkCacheThenDatabase();
        test = new CacheExpiryReadObjectQueryTest(employeeToRead, query, false);
        test.setDescription("Verify Read Object Query which does not expire.");
        test.setName("ReadObjectQuery No Expiry Test");
        this.addTest((Test)test);
        query = new ReadObjectQuery(Employee.class);
        query.checkCacheThenDatabase();
        test = new CacheExpiryReadObjectQueryTest(employeeToRead, query, false);
        test.setDescription("Verify Read Object Query which does not expire and queries with no selection criteria.");
        test.setName("ReadObjectQuery (no criteria) No Expiry Test");
        this.addTest((Test)test);
        ExpressionBuilder exactPKBuilder = new ExpressionBuilder();
        Expression exactPK = exactPKBuilder.get("id").equal((Object)employeeToRead.getId());
        query = new ReadObjectQuery(Employee.class, exactPK);
        query.checkCacheThenDatabase();
        test = new CacheExpiryReadObjectQueryTest(employeeToRead, query, false);
        test.setDescription("Verify Read Object Query which does not expire and queries by primary key.");
        test.setName("ReadObjectQuery (exact primary key) No Expiry Test");
        this.addTest((Test)test);
        ExpressionBuilder inExactPKBuilder = new ExpressionBuilder();
        Expression inExactPK = inExactPKBuilder.get("firstName").equal((Object)employeeToRead.getFirstName());
        inExactPK = inExactPK.and(inExactPKBuilder.get("lastName").equal((Object)employeeToRead.getLastName()));
        inExactPK = inExactPK.and(inExactPKBuilder.get("id").equal((Object)employeeToRead.getId()));
        query = new ReadObjectQuery(Employee.class, inExactPK);
        query.checkCacheThenDatabase();
        test = new CacheExpiryReadObjectQueryTest(employeeToRead, query, false);
        test.setDescription("Verify Read Object Query which does not expire and queries by in exact primary key.");
        test.setName("ReadObjectQuery (in-exact primary key) No Expiry Test");
        this.addTest((Test)test);
        test = new CacheExpiryReadAllQueryTest(true);
        test.setDescription("Verify Read All Query which does expires.");
        test.setName("ReadAllQuery Expiry Test");
        this.addTest((Test)test);
        test = new CacheExpiryReadAllQueryTest(false);
        test.setDescription("Verify Read All Query which does not expire.");
        test.setName("ReadAllQuery No Expiry Test");
        this.addTest((Test)test);
        this.addTest((Test)new ReadAllQueryCheckCacheOnlyExpiryTest());
        this.addTest((Test)new ReadObjectCheckCacheOnlyExpiryTest());
        this.addTest((Test)new RefreshQueryCacheExpiryTest());
        this.addTest((Test)new RefreshIfNewerVersionTest());
        test = new UpdateQueryChangeExpiryTest(false);
        test.setDescription("Verify expiry time does not get updated when Updates are not set to update expiry.");
        test.setName("Update - do not update expiry test.");
        this.addTest((Test)test);
        test = new UpdateQueryChangeExpiryTest(true);
        test.setDescription("Verify expiry time gets updated when updates are set to update expiry.");
        test.setName("Update - update expiry test.");
        this.addTest((Test)test);
        this.addTest((Test)new ReadAllQueryConformExpiryTest());
        this.addTest((Test)new ReadObjectQueryConformExpiryTest());
        this.addTest((Test)new CacheExpiryValueholderTest());
        this.addTest((Test)new UnitOfWorkExpiredObjectTest());
        this.addTest((Test)new CacheExpiryUnitOfWorkReadTest());
        this.addTest((Test)new UnitOfWorkCreateObjectReadTimeTest());
        this.addTest((Test)new SessionCreateObjectReadTimeTest());
        this.addTest((Test)new InvalidateClassRecurseOptionTest(true));
        this.addTest((Test)new InvalidateClassRecurseOptionTest(false));
        this.addTest((Test)new InvalidateAllExternalChangeTest());
        this.addTest((Test)new InvalidateAllTest());
        this.addTest((Test)new PrimaryKeyQueryInUOWTest());
        this.addTest((Test)new UnitOfWorkRefreshAfterInvalidationTest());
        this.addTest((Test)new CacheInvalidationPolicyCloneTest(NoExpiryCacheInvalidationPolicy.class));
        this.addTest((Test)new CacheInvalidationPolicyCloneTest(DailyCacheInvalidationPolicy.class));
        this.addTest((Test)new CacheInvalidationPolicyCloneTest(TimeToLiveCacheInvalidationPolicy.class));
    }
}

