/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.validation;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.IntegrityChecker;
import org.eclipse.persistence.internal.descriptors.InstantiationPolicy;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.testing.tests.validation.ClassWithProblemConstructor;
import org.eclipse.persistence.testing.tests.validation.ExceptionTest;

public class TargetInvocationWhileConstructorInstantiationOfFactoryTest
extends ExceptionTest {
    RelationalDescriptor descriptor;
    InstantiationPolicy policy;
    IntegrityChecker orgIntegrityChecker;

    public TargetInvocationWhileConstructorInstantiationOfFactoryTest() {
        this.setDescription("This tests Target Invocation While Constructor Instantiation Of Factory (TL-ERROR 169)");
    }

    protected void setup() {
        this.descriptor = new RelationalDescriptor();
        this.descriptor.setJavaClass(ClassWithProblemConstructor.class);
        this.descriptor.addTableName("EMPLOYEE");
        this.policy = this.descriptor.getInstantiationPolicy();
        this.policy.setMethodName("method");
        this.policy.useFactoryInstantiationPolicy(ClassWithProblemConstructor.class, "method");
        this.orgIntegrityChecker = this.getSession().getIntegrityChecker();
        this.getSession().setIntegrityChecker(new IntegrityChecker());
        this.getSession().getIntegrityChecker().dontCatchExceptions();
        this.expectedException = DescriptorException.targetInvocationWhileConstructorInstantiationOfFactory((ClassDescriptor)this.descriptor, (Exception)new Exception());
    }

    @Override
    public void reset() {
        this.getSession().setIntegrityChecker(this.orgIntegrityChecker);
    }

    public void test() {
        try {
            this.policy.initialize((AbstractSession)this.getSession());
        }
        catch (EclipseLinkException exception) {
            this.caughtException = exception;
        }
    }
}

