/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.models.employee.relational;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.descriptors.VersionLockingPolicy;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.descriptors.OptimisticLockingPolicy;
import org.eclipse.persistence.mappings.AggregateObjectMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectCollectionMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.mappings.ManyToManyMapping;
import org.eclipse.persistence.mappings.OneToManyMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.mappings.TransformationMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.converters.ObjectTypeConverter;
import org.eclipse.persistence.platform.database.DatabasePlatform;
import org.eclipse.persistence.platform.database.OraclePlatform;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.InMemoryQueryIndirectionPolicy;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.Login;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.testing.models.employee.domain.Address;
import org.eclipse.persistence.testing.models.employee.domain.Child;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.domain.EmploymentPeriod;
import org.eclipse.persistence.testing.models.employee.domain.LargeProject;
import org.eclipse.persistence.testing.models.employee.domain.PhoneNumber;
import org.eclipse.persistence.testing.models.employee.interfaces.SmallProject;

public class EmployeeProject
extends Project {
    public EmployeeProject() {
        this.setName("Employee");
        this.applyLogin();
        this.addDescriptor(this.buildAddressDescriptor());
        this.addDescriptor(this.buildChildDescriptor());
        this.addDescriptor(this.buildEmployeeDescriptor());
        this.addDescriptor(this.buildEmploymentPeriodDescriptor());
        this.addDescriptor(this.buildLargeProjectDescriptor());
        this.addDescriptor(this.buildPhoneNumberDescriptor());
        this.addDescriptor(this.buildProjectDescriptor());
        this.addDescriptor(this.buildSmallProjectDescriptor());
    }

    public void applyLogin() {
        DatabaseLogin login = new DatabaseLogin();
        login.usePlatform((DatabasePlatform)new OraclePlatform());
        login.setDriverClassName("oracle.jdbc.OracleDriver");
        login.setConnectionString("jdbc:oracle:thin:@localhost:1521:orcl");
        login.setUserName("scott");
        login.setEncryptedPassword("3E20F8982C53F4ABA825E30206EC8ADE");
        login.setUsesExternalConnectionPooling(false);
        login.setUsesExternalTransactionController(false);
        this.setDatasourceLogin((Login)login);
    }

    public ClassDescriptor buildAddressDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Address.class);
        descriptor.addTableName("ADDRESS");
        descriptor.addPrimaryKeyFieldName("ADDRESS.ADDRESS_ID");
        descriptor.useSoftCacheWeakIdentityMap();
        descriptor.setIdentityMapSize(100);
        descriptor.setSequenceNumberFieldName("ADDRESS.ADDRESS_ID");
        descriptor.setSequenceNumberName("ADDRESS_SEQ");
        descriptor.setAlias("Address");
        descriptor.getQueryManager().checkCacheForDoesExist();
        DirectToFieldMapping cityMapping = new DirectToFieldMapping();
        cityMapping.setAttributeName("city");
        cityMapping.setFieldName("ADDRESS.CITY");
        descriptor.addMapping((DatabaseMapping)cityMapping);
        DirectToFieldMapping countryMapping = new DirectToFieldMapping();
        countryMapping.setAttributeName("country");
        countryMapping.setFieldName("ADDRESS.COUNTRY");
        descriptor.addMapping((DatabaseMapping)countryMapping);
        DirectToFieldMapping idMapping = new DirectToFieldMapping();
        idMapping.setAttributeName("id");
        idMapping.setFieldName("ADDRESS.ADDRESS_ID");
        descriptor.addMapping((DatabaseMapping)idMapping);
        DirectToFieldMapping postalCodeMapping = new DirectToFieldMapping();
        postalCodeMapping.setAttributeName("postalCode");
        postalCodeMapping.setFieldName("ADDRESS.P_CODE");
        descriptor.addMapping((DatabaseMapping)postalCodeMapping);
        DirectToFieldMapping provinceMapping = new DirectToFieldMapping();
        provinceMapping.setAttributeName("province");
        provinceMapping.setFieldName("ADDRESS.PROVINCE");
        descriptor.addMapping((DatabaseMapping)provinceMapping);
        DirectToFieldMapping streetMapping = new DirectToFieldMapping();
        streetMapping.setAttributeName("street");
        streetMapping.setFieldName("ADDRESS.STREET");
        descriptor.addMapping((DatabaseMapping)streetMapping);
        return descriptor;
    }

    public ClassDescriptor buildChildDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Child.class);
        descriptor.addTableName("CHILD");
        descriptor.addPrimaryKeyFieldName("CHILD.CHILD_ID");
        descriptor.useSoftCacheWeakIdentityMap();
        descriptor.setIdentityMapSize(50);
        descriptor.setSequenceNumberFieldName("CHILD.CHILD_ID");
        descriptor.setSequenceNumberName("CHILD_SEQ");
        descriptor.setAlias("Child");
        descriptor.getQueryManager().checkCacheForDoesExist();
        DirectToFieldMapping firstNameMapping = new DirectToFieldMapping();
        firstNameMapping.setAttributeName("firstName");
        firstNameMapping.setFieldName("F_NAME");
        firstNameMapping.setNullValue((Object)"");
        descriptor.addMapping((DatabaseMapping)firstNameMapping);
        DirectToFieldMapping idMapping = new DirectToFieldMapping();
        idMapping.setAttributeName("id");
        idMapping.setFieldName("CHILD_ID");
        descriptor.addMapping((DatabaseMapping)idMapping);
        DirectToFieldMapping lastNameMapping = new DirectToFieldMapping();
        lastNameMapping.setAttributeName("lastName");
        lastNameMapping.setFieldName("L_NAME");
        lastNameMapping.setNullValue((Object)"");
        descriptor.addMapping((DatabaseMapping)lastNameMapping);
        DirectToFieldMapping genderMapping = new DirectToFieldMapping();
        genderMapping.setAttributeName("gender");
        genderMapping.setFieldName("GENDER");
        ObjectTypeConverter genderMappingConverter = new ObjectTypeConverter();
        genderMappingConverter.addConversionValue((Object)"F", (Object)"Female");
        genderMappingConverter.addConversionValue((Object)"M", (Object)"Male");
        genderMapping.setConverter((Converter)genderMappingConverter);
        descriptor.addMapping((DatabaseMapping)genderMapping);
        DirectToFieldMapping birthdayMapping = new DirectToFieldMapping();
        birthdayMapping.setAttributeName("birthday");
        birthdayMapping.setFieldName("BIRTHDAY");
        descriptor.addMapping((DatabaseMapping)birthdayMapping);
        OneToOneMapping managerMapping = new OneToOneMapping();
        managerMapping.setAttributeName("parent");
        managerMapping.setReferenceClass(Employee.class);
        managerMapping.dontUseIndirection();
        managerMapping.addForeignKeyFieldName("CHILD.PARENT_EMP_ID", "EMPLOYEE.EMP_ID");
        descriptor.addMapping((DatabaseMapping)managerMapping);
        return descriptor;
    }

    public ClassDescriptor buildEmployeeDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Employee.class);
        descriptor.addTableName("EMPLOYEE");
        descriptor.addTableName("SALARY");
        descriptor.addPrimaryKeyFieldName("EMPLOYEE.EMP_ID");
        descriptor.getInterfacePolicy().addParentInterface(org.eclipse.persistence.testing.models.employee.interfaces.Employee.class);
        descriptor.useSoftCacheWeakIdentityMap();
        descriptor.setIdentityMapSize(100);
        descriptor.getCachePolicy().addCacheIndex(new String[]{"F_NAME", "L_NAME"});
        descriptor.setSequenceNumberFieldName("EMPLOYEE.EMP_ID");
        descriptor.setSequenceNumberName("EMP_SEQ");
        VersionLockingPolicy lockingPolicy = new VersionLockingPolicy();
        lockingPolicy.setWriteLockFieldName("EMPLOYEE.VERSION");
        descriptor.setOptimisticLockingPolicy((OptimisticLockingPolicy)lockingPolicy);
        descriptor.setAlias("Employee");
        descriptor.getQueryManager().checkCacheForDoesExist();
        DirectToFieldMapping firstNameMapping = new DirectToFieldMapping();
        firstNameMapping.setAttributeName("firstName");
        firstNameMapping.setFieldName("EMPLOYEE.F_NAME");
        firstNameMapping.setNullValue((Object)"");
        descriptor.addMapping((DatabaseMapping)firstNameMapping);
        DirectToFieldMapping idMapping = new DirectToFieldMapping();
        idMapping.setAttributeName("id");
        idMapping.setFieldName("EMPLOYEE.EMP_ID");
        descriptor.addMapping((DatabaseMapping)idMapping);
        DirectToFieldMapping lastNameMapping = new DirectToFieldMapping();
        lastNameMapping.setAttributeName("lastName");
        lastNameMapping.setFieldName("EMPLOYEE.L_NAME");
        lastNameMapping.setNullValue((Object)"");
        descriptor.addMapping((DatabaseMapping)lastNameMapping);
        DirectToFieldMapping salaryMapping = new DirectToFieldMapping();
        salaryMapping.setAttributeName("salary");
        salaryMapping.setFieldName("SALARY.SALARY");
        descriptor.addMapping((DatabaseMapping)salaryMapping);
        DirectToFieldMapping genderMapping = new DirectToFieldMapping();
        genderMapping.setAttributeName("gender");
        genderMapping.setFieldName("EMPLOYEE.GENDER");
        ObjectTypeConverter genderMappingConverter = new ObjectTypeConverter();
        genderMappingConverter.addConversionValue((Object)"F", (Object)"Female");
        genderMappingConverter.addConversionValue((Object)"M", (Object)"Male");
        genderMapping.setConverter((Converter)genderMappingConverter);
        descriptor.addMapping((DatabaseMapping)genderMapping);
        TransformationMapping normalHoursMapping = new TransformationMapping();
        normalHoursMapping.setAttributeName("normalHours");
        normalHoursMapping.setAttributeTransformation("buildNormalHours");
        normalHoursMapping.addFieldTransformation("EMPLOYEE.START_TIME", "getStartTime");
        normalHoursMapping.addFieldTransformation("EMPLOYEE.END_TIME", "getEndTime");
        normalHoursMapping.setIsMutable(true);
        descriptor.addMapping((DatabaseMapping)normalHoursMapping);
        AggregateObjectMapping periodMapping = new AggregateObjectMapping();
        periodMapping.setAttributeName("period");
        periodMapping.setReferenceClass(EmploymentPeriod.class);
        periodMapping.setIsNullAllowed(true);
        periodMapping.addFieldNameTranslation("EMPLOYEE.END_DATE", "endDate->DIRECT");
        periodMapping.addFieldNameTranslation("EMPLOYEE.START_DATE", "startDate->DIRECT");
        descriptor.addMapping((DatabaseMapping)periodMapping);
        DirectCollectionMapping responsibilitiesListMapping = new DirectCollectionMapping();
        responsibilitiesListMapping.setAttributeName("responsibilitiesList");
        responsibilitiesListMapping.useBasicIndirection();
        responsibilitiesListMapping.setReferenceTableName("RESPONS");
        responsibilitiesListMapping.setDirectFieldName("RESPONS.DESCRIP");
        responsibilitiesListMapping.addReferenceKeyFieldName("RESPONS.EMP_ID", "EMPLOYEE.EMP_ID");
        descriptor.addMapping((DatabaseMapping)responsibilitiesListMapping);
        OneToOneMapping addressMapping = new OneToOneMapping();
        addressMapping.setAttributeName("address");
        addressMapping.setReferenceClass(Address.class);
        addressMapping.useBasicIndirection();
        addressMapping.privateOwnedRelationship();
        addressMapping.addForeignKeyFieldName("EMPLOYEE.ADDR_ID", "ADDRESS.ADDRESS_ID");
        descriptor.addMapping((DatabaseMapping)addressMapping);
        OneToOneMapping managerMapping = new OneToOneMapping();
        managerMapping.setAttributeName("manager");
        managerMapping.setReferenceClass(Employee.class);
        managerMapping.useBasicIndirection();
        managerMapping.addForeignKeyFieldName("EMPLOYEE.MANAGER_ID", "EMPLOYEE.EMP_ID");
        descriptor.addMapping((DatabaseMapping)managerMapping);
        OneToManyMapping managedEmployeesMapping = new OneToManyMapping();
        managedEmployeesMapping.setAttributeName("managedEmployees");
        managedEmployeesMapping.setReferenceClass(Employee.class);
        managedEmployeesMapping.useBasicIndirection();
        managedEmployeesMapping.addTargetForeignKeyFieldName("EMPLOYEE.MANAGER_ID", "EMPLOYEE.EMP_ID");
        descriptor.addMapping((DatabaseMapping)managedEmployeesMapping);
        OneToManyMapping childrenMapping = new OneToManyMapping();
        childrenMapping.setAttributeName("children");
        childrenMapping.setReferenceClass(Child.class);
        childrenMapping.addAscendingOrdering("birthday");
        childrenMapping.useTransparentList();
        childrenMapping.privateOwnedRelationship();
        childrenMapping.addTargetForeignKeyFieldName("CHILD.PARENT_EMP_ID", "EMPLOYEE.EMP_ID");
        descriptor.addMapping((DatabaseMapping)childrenMapping);
        OneToManyMapping phoneNumbersMapping = new OneToManyMapping();
        phoneNumbersMapping.setAttributeName("phoneNumbers");
        phoneNumbersMapping.setReferenceClass(PhoneNumber.class);
        phoneNumbersMapping.useBasicIndirection();
        phoneNumbersMapping.privateOwnedRelationship();
        phoneNumbersMapping.addTargetForeignKeyFieldName("PHONE.EMP_ID", "EMPLOYEE.EMP_ID");
        descriptor.addMapping((DatabaseMapping)phoneNumbersMapping);
        ManyToManyMapping projectsMapping = new ManyToManyMapping();
        projectsMapping.setAttributeName("projects");
        projectsMapping.setReferenceClass(org.eclipse.persistence.testing.models.employee.domain.Project.class);
        projectsMapping.useBasicIndirection();
        projectsMapping.setRelationTableName("PROJ_EMP");
        projectsMapping.addSourceRelationKeyFieldName("PROJ_EMP.EMP_ID", "EMPLOYEE.EMP_ID");
        projectsMapping.addTargetRelationKeyFieldName("PROJ_EMP.PROJ_ID", "PROJECT.PROJ_ID");
        descriptor.addMapping((DatabaseMapping)projectsMapping);
        return descriptor;
    }

    public ClassDescriptor buildEmploymentPeriodDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.descriptorIsAggregate();
        descriptor.setJavaClass(EmploymentPeriod.class);
        descriptor.setAlias("EmploymentPeriod");
        DirectToFieldMapping endDateMapping = new DirectToFieldMapping();
        endDateMapping.setAttributeName("endDate");
        endDateMapping.setFieldName("endDate->DIRECT");
        descriptor.addMapping((DatabaseMapping)endDateMapping);
        DirectToFieldMapping startDateMapping = new DirectToFieldMapping();
        startDateMapping.setAttributeName("startDate");
        startDateMapping.setFieldName("startDate->DIRECT");
        descriptor.addMapping((DatabaseMapping)startDateMapping);
        return descriptor;
    }

    public ClassDescriptor buildLargeProjectDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(LargeProject.class);
        descriptor.addTableName("LPROJECT");
        descriptor.getInheritancePolicy().setParentClass(org.eclipse.persistence.testing.models.employee.domain.Project.class);
        descriptor.getInheritancePolicy().dontReadSubclassesOnQueries();
        descriptor.getInterfacePolicy().addParentInterface(org.eclipse.persistence.testing.models.employee.interfaces.LargeProject.class);
        descriptor.setAlias("LargeProject");
        descriptor.getQueryManager().checkCacheForDoesExist();
        DirectToFieldMapping budgetMapping = new DirectToFieldMapping();
        budgetMapping.setAttributeName("budget");
        budgetMapping.setFieldName("LPROJECT.BUDGET");
        descriptor.addMapping((DatabaseMapping)budgetMapping);
        DirectToFieldMapping milestoneVersionMapping = new DirectToFieldMapping();
        milestoneVersionMapping.setAttributeName("milestoneVersion");
        milestoneVersionMapping.setFieldName("LPROJECT.MILESTONE");
        descriptor.addMapping((DatabaseMapping)milestoneVersionMapping);
        return descriptor;
    }

    public ClassDescriptor buildPhoneNumberDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(PhoneNumber.class);
        descriptor.addTableName("PHONE");
        descriptor.addPrimaryKeyFieldName("PHONE.EMP_ID");
        descriptor.addPrimaryKeyFieldName("PHONE.TYPE");
        descriptor.useSoftCacheWeakIdentityMap();
        descriptor.setIdentityMapSize(100);
        descriptor.setAlias("PhoneNumber");
        descriptor.getQueryManager().checkCacheForDoesExist();
        ReadObjectQuery namedQuery0 = new ReadObjectQuery(PhoneNumber.class);
        namedQuery0.setName("localNumbers");
        namedQuery0.setCascadePolicy(1);
        namedQuery0.setShouldUseWrapperPolicy(true);
        namedQuery0.setShouldMaintainCache(true);
        namedQuery0.setShouldPrepare(true);
        namedQuery0.setMaxRows(0);
        namedQuery0.setShouldRefreshIdentityMapResult(false);
        namedQuery0.setCacheUsage(2);
        namedQuery0.setLockMode((short)0);
        namedQuery0.setDistinctState((short)0);
        namedQuery0.setInMemoryQueryIndirectionPolicy(new InMemoryQueryIndirectionPolicy(0));
        ExpressionBuilder expBuilder0 = namedQuery0.getExpressionBuilder();
        namedQuery0.setSelectionCriteria(expBuilder0.get("id").equal(expBuilder0.getParameter("ID")).and(expBuilder0.get("areaCode").equal((Object)"613")));
        namedQuery0.addArgument("ID", Number.class);
        descriptor.getQueryManager().addQuery("localNumbers", (DatabaseQuery)namedQuery0);
        descriptor.addDirectQueryKey("id", "PHONE.EMP_ID");
        DirectToFieldMapping areaCodeMapping = new DirectToFieldMapping();
        areaCodeMapping.setAttributeName("areaCode");
        areaCodeMapping.setFieldName("PHONE.AREA_CODE");
        descriptor.addMapping((DatabaseMapping)areaCodeMapping);
        DirectToFieldMapping numberMapping = new DirectToFieldMapping();
        numberMapping.setAttributeName("number");
        numberMapping.setFieldName("PHONE.P_NUMBER");
        descriptor.addMapping((DatabaseMapping)numberMapping);
        DirectToFieldMapping typeMapping = new DirectToFieldMapping();
        typeMapping.setAttributeName("type");
        typeMapping.setFieldName("PHONE.TYPE");
        descriptor.addMapping((DatabaseMapping)typeMapping);
        OneToOneMapping ownerMapping = new OneToOneMapping();
        ownerMapping.setAttributeName("owner");
        ownerMapping.setReferenceClass(Employee.class);
        ownerMapping.useBasicIndirection();
        ownerMapping.addForeignKeyFieldName("PHONE.EMP_ID", "EMPLOYEE.EMP_ID");
        descriptor.addMapping((DatabaseMapping)ownerMapping);
        return descriptor;
    }

    public ClassDescriptor buildProjectDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(org.eclipse.persistence.testing.models.employee.domain.Project.class);
        descriptor.addTableName("PROJECT");
        descriptor.addPrimaryKeyFieldName("PROJECT.PROJ_ID");
        descriptor.getInheritancePolicy().setClassIndicatorFieldName("PROJECT.PROJ_TYPE");
        descriptor.getInheritancePolicy().addClassIndicator(org.eclipse.persistence.testing.models.employee.domain.SmallProject.class, (Object)"S");
        descriptor.getInheritancePolicy().addClassIndicator(LargeProject.class, (Object)"L");
        descriptor.getInterfacePolicy().addParentInterface(org.eclipse.persistence.testing.models.employee.interfaces.Project.class);
        descriptor.useSoftCacheWeakIdentityMap();
        descriptor.setIdentityMapSize(100);
        descriptor.setSequenceNumberFieldName("PROJECT.PROJ_ID");
        descriptor.setSequenceNumberName("PROJ_SEQ");
        VersionLockingPolicy lockingPolicy = new VersionLockingPolicy();
        lockingPolicy.setWriteLockFieldName("PROJECT.VERSION");
        descriptor.setOptimisticLockingPolicy((OptimisticLockingPolicy)lockingPolicy);
        descriptor.setAlias("Project");
        descriptor.getQueryManager().checkCacheForDoesExist();
        DirectToFieldMapping descriptionMapping = new DirectToFieldMapping();
        descriptionMapping.setAttributeName("description");
        descriptionMapping.setFieldName("PROJECT.DESCRIP");
        descriptionMapping.setNullValue((Object)"");
        descriptor.addMapping((DatabaseMapping)descriptionMapping);
        DirectToFieldMapping idMapping = new DirectToFieldMapping();
        idMapping.setAttributeName("id");
        idMapping.setFieldName("PROJECT.PROJ_ID");
        descriptor.addMapping((DatabaseMapping)idMapping);
        DirectToFieldMapping nameMapping = new DirectToFieldMapping();
        nameMapping.setAttributeName("name");
        nameMapping.setFieldName("PROJECT.PROJ_NAME");
        nameMapping.setNullValue((Object)"");
        descriptor.addMapping((DatabaseMapping)nameMapping);
        OneToOneMapping teamLeaderMapping = new OneToOneMapping();
        teamLeaderMapping.setAttributeName("teamLeader");
        teamLeaderMapping.setReferenceClass(Employee.class);
        teamLeaderMapping.useBasicIndirection();
        teamLeaderMapping.addForeignKeyFieldName("PROJECT.LEADER_ID", "EMPLOYEE.EMP_ID");
        descriptor.addMapping((DatabaseMapping)teamLeaderMapping);
        return descriptor;
    }

    public ClassDescriptor buildSmallProjectDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(org.eclipse.persistence.testing.models.employee.domain.SmallProject.class);
        descriptor.addTableName("PROJECT");
        descriptor.getInheritancePolicy().setParentClass(org.eclipse.persistence.testing.models.employee.domain.Project.class);
        descriptor.getInheritancePolicy().dontReadSubclassesOnQueries();
        descriptor.getInterfacePolicy().addParentInterface(SmallProject.class);
        descriptor.setAlias("SmallProject");
        descriptor.getQueryManager().checkCacheForDoesExist();
        return descriptor;
    }
}

