/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.distributedservers;

import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.aggregate.Agent;
import org.eclipse.persistence.testing.models.aggregate.Builder;
import org.eclipse.persistence.testing.models.aggregate.Customer;
import org.eclipse.persistence.testing.models.aggregate.Dependant;
import org.eclipse.persistence.testing.tests.aggregate.AgentBuilderHelper;
import org.eclipse.persistence.testing.tests.distributedservers.ComplexUpdateTest;

public class VerifyAggregateCollectionObjectsDeletedFromCacheTest
extends ComplexUpdateTest {
    public VerifyAggregateCollectionObjectsDeletedFromCacheTest() {
    }

    public VerifyAggregateCollectionObjectsDeletedFromCacheTest(Agent originalObject) {
        super(originalObject);
    }

    public VerifyAggregateCollectionObjectsDeletedFromCacheTest(Builder originalObject) {
        super(originalObject);
    }

    @Override
    protected void changeObject() {
        Object object = this.workingCopy;
        List customers = AgentBuilderHelper.getCustomers(object);
        Customer customerx = (Customer)customers.get(0);
        Vector dependants = customerx.getDependants();
        customerx.removeDependant((Dependant)dependants.lastElement());
        AgentBuilderHelper.removeCustomer(object, (Customer)customers.get(customers.size() - 1));
    }

    @Override
    protected void verify() {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        this.objectFromDatabase = this.getSession().executeQuery((DatabaseQuery)this.query);
        if (!((AbstractSession)this.getSession()).compareObjects(this.objectToBeWritten, this.objectFromDatabase)) {
            throw new TestErrorException("The object inserted into the database, '" + this.objectFromDatabase + "' does not match the original, '" + this.objectToBeWritten + ".");
        }
        this.distributedCopy = this.getObjectFromDistributedSession((DatabaseQuery)this.query);
        if (!((AbstractSession)this.getSession()).compareObjects(this.distributedCopy, this.objectFromDatabase)) {
            throw new TestErrorException("The object inserted into the database, '" + this.objectFromDatabase + "' does not match the distributed Copy, '" + this.distributedCopy + ".");
        }
    }
}

