/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.junit.failover;

import java.math.BigDecimal;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.sessions.ArrayRecord;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.sessions.DatabaseRecord;

public final class Address {
    public BigDecimal id;
    public String street = "";
    public String city = "";
    public String province = "";
    public String postalCode = "";
    public String country = "";

    static ClassDescriptor descriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Address.class);
        descriptor.addTableName("ADDRESS");
        descriptor.addPrimaryKeyFieldName("ADDRESS.ADDRESS_ID");
        descriptor.useSoftCacheWeakIdentityMap();
        descriptor.setIdentityMapSize(100);
        descriptor.setSequenceNumberFieldName("ADDRESS.ADDRESS_ID");
        descriptor.setSequenceNumberName("ADDRESS_SEQ");
        descriptor.setAlias("Address");
        descriptor.getQueryManager().checkCacheForDoesExist();
        DirectToFieldMapping cityMapping = new DirectToFieldMapping();
        cityMapping.setAttributeName("city");
        cityMapping.setFieldName("ADDRESS.CITY");
        descriptor.addMapping((DatabaseMapping)cityMapping);
        DirectToFieldMapping countryMapping = new DirectToFieldMapping();
        countryMapping.setAttributeName("country");
        countryMapping.setFieldName("ADDRESS.COUNTRY");
        descriptor.addMapping((DatabaseMapping)countryMapping);
        DirectToFieldMapping idMapping = new DirectToFieldMapping();
        idMapping.setAttributeName("id");
        idMapping.setFieldName("ADDRESS.ADDRESS_ID");
        descriptor.addMapping((DatabaseMapping)idMapping);
        DirectToFieldMapping postalCodeMapping = new DirectToFieldMapping();
        postalCodeMapping.setAttributeName("postalCode");
        postalCodeMapping.setFieldName("ADDRESS.P_CODE");
        descriptor.addMapping((DatabaseMapping)postalCodeMapping);
        DirectToFieldMapping provinceMapping = new DirectToFieldMapping();
        provinceMapping.setAttributeName("province");
        provinceMapping.setFieldName("ADDRESS.PROVINCE");
        descriptor.addMapping((DatabaseMapping)provinceMapping);
        DirectToFieldMapping streetMapping = new DirectToFieldMapping();
        streetMapping.setAttributeName("street");
        streetMapping.setFieldName("ADDRESS.STREET");
        descriptor.addMapping((DatabaseMapping)streetMapping);
        return descriptor;
    }

    static String getSQL() {
        return "SELECT ADDRESS_ID, CITY, COUNTRY, P_CODE, PROVINCE, STREET FROM ADDRESS";
    }

    static Vector<DatabaseRecord> getData(ClassDescriptor desc) {
        Vector<DatabaseRecord> rows = new Vector<DatabaseRecord>();
        Vector fields = desc.getAllFields();
        DatabaseField[] fieldsArray = fields.toArray(new DatabaseField[0]);
        rows.add((DatabaseRecord)new ArrayRecord(fields, fieldsArray, new Object[]{51, "Calgary", "Canada", "J5J2B5", "ALB", "1111 Moose Rd."}));
        rows.add((DatabaseRecord)new ArrayRecord(fields, fieldsArray, new Object[]{52, "Metcalfe", "Canada", "Y4F7V6", "ONT", "2 Anderson Rd."}));
        rows.add((DatabaseRecord)new ArrayRecord(fields, fieldsArray, new Object[]{53, "Montreal", "Canada", "Q2S5Z5", "QUE", "1 Habs Place"}));
        return rows;
    }
}

