/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.readonly;

import java.util.Vector;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.inheritance.Bicycle;
import org.eclipse.persistence.testing.models.inheritance.Boat;
import org.eclipse.persistence.testing.models.inheritance.Bus;
import org.eclipse.persistence.testing.models.inheritance.Car;
import org.eclipse.persistence.testing.models.inheritance.Company;
import org.eclipse.persistence.testing.models.inheritance.FueledVehicle;
import org.eclipse.persistence.testing.models.inheritance.NonFueledVehicle;
import org.eclipse.persistence.testing.models.inheritance.SportsCar;
import org.eclipse.persistence.testing.models.inheritance.Vehicle;

public class ReadOnlyClassOneToManyTestCase
extends AutoVerifyTestCase {
    public Vehicle originalVehicle;
    UnitOfWork uow;
    Company originalCompany;
    Integer origCapacity;

    public void reset() {
        this.originalVehicle.setPassengerCapacity(this.origCapacity);
        this.rollbackTransaction();
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
    }

    protected void setup() {
        this.beginTransaction();
        this.originalCompany = (Company)this.getSession().readObject(Company.class);
        this.originalVehicle = (Vehicle)((Vector)this.originalCompany.getVehicles().getValue()).firstElement();
        this.origCapacity = this.originalVehicle.passengerCapacity;
        this.uow = this.getSession().acquireUnitOfWork();
        this.uow.addReadOnlyClass(Bus.class);
        this.uow.addReadOnlyClass(SportsCar.class);
        this.uow.addReadOnlyClass(Bicycle.class);
        this.uow.addReadOnlyClass(Boat.class);
        this.uow.addReadOnlyClass(Car.class);
        this.uow.addReadOnlyClass(NonFueledVehicle.class);
        this.uow.addReadOnlyClass(FueledVehicle.class);
        this.uow.addReadOnlyClass(Vehicle.class);
        Company cloneCompany = (Company)this.uow.registerObject((Object)this.originalCompany);
        ((Vehicle)((Vector)cloneCompany.getVehicles().getValue()).firstElement()).setPassengerCapacity(new Integer(this.origCapacity + 1));
    }

    protected void test() {
        this.uow.commit();
    }

    protected void verify() {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        ExpressionBuilder expBuilder = new ExpressionBuilder();
        Expression exp = expBuilder.get("id").equal((Object)this.originalVehicle.id);
        Vehicle dbVehicle = (Vehicle)this.getSession().readObject(Vehicle.class, exp);
        if (!this.origCapacity.equals(dbVehicle.passengerCapacity)) {
            throw new TestErrorException("We succeeded in changing a read-only objects in a 1:M mapping. This is very bad!");
        }
    }
}

