/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.advanced;

import java.sql.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.persistence.internal.jpa.EntityManagerImpl;
import org.eclipse.persistence.jpa.JpaEntityManager;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestException;
import org.eclipse.persistence.testing.models.jpa.advanced.Address;
import org.eclipse.persistence.testing.models.jpa.advanced.Employee;
import org.eclipse.persistence.testing.models.jpa.advanced.EmploymentPeriod;
import org.eclipse.persistence.testing.models.jpa.advanced.ModelExamples;
import org.eclipse.persistence.testing.models.jpa.advanced.PhoneNumber;
import org.eclipse.persistence.testing.models.jpa.advanced.Project;
import org.eclipse.persistence.testing.tests.jpa.EntityContainerTestBase;

public class EMModifyAndFlushTest
extends EntityContainerTestBase {
    public Integer[] empIDs = new Integer[3];
    public Integer[] projIDs = new Integer[2];
    public HashMap persistedItems = new HashMap(4);

    @Override
    public void setup() {
        super.setup();
        Employee empClone1 = ModelExamples.employeeExample1();
        empClone1.setAddress(ModelExamples.addressExample1());
        empClone1.addPhoneNumber(ModelExamples.phoneExample1());
        empClone1.addPhoneNumber(ModelExamples.phoneExample9());
        Employee empClone2 = ModelExamples.employeeExample2();
        empClone2.setAddress(ModelExamples.addressExample2());
        empClone2.addPhoneNumber(ModelExamples.phoneExample2());
        empClone2.addPhoneNumber(ModelExamples.phoneExample8());
        Employee empClone3 = ModelExamples.employeeExample3();
        empClone3.setAddress(ModelExamples.addressExample3());
        empClone3.addPhoneNumber(ModelExamples.phoneExample3());
        empClone3.addPhoneNumber(ModelExamples.phoneExample7());
        empClone1.addManagedEmployee(empClone2);
        empClone1.addManagedEmployee(empClone3);
        Project projClone1 = ModelExamples.projectExample1();
        Project projClone2 = ModelExamples.projectExample2();
        projClone1.setTeamLeader(empClone1);
        projClone1.addTeamMember(empClone1);
        projClone1.addTeamMember(empClone2);
        projClone1.addTeamMember(empClone3);
        empClone1.addProject(projClone1);
        empClone2.addProject(projClone1);
        empClone3.addProject(projClone1);
        try {
            this.beginTransaction();
            this.getEntityManager().persist((Object)empClone1);
            this.getEntityManager().persist((Object)empClone2);
            this.getEntityManager().persist((Object)empClone3);
            this.getEntityManager().persist((Object)projClone1);
            this.getEntityManager().persist((Object)projClone2);
            this.commitTransaction();
        }
        catch (Exception ex) {
            this.rollbackTransaction();
            throw new TestException("Unable to setup Test" + ex);
        }
        ((EntityManagerImpl)this.getEntityManager()).getActiveSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        this.empIDs[0] = empClone1.getId();
        this.empIDs[1] = empClone2.getId();
        this.empIDs[2] = empClone3.getId();
        this.projIDs[0] = projClone1.getId();
        this.projIDs[1] = projClone2.getId();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public void test() {
        Employee employee;
        try {
            this.beginTransaction();
            employee = (Employee)this.getEntityManager().find(Employee.class, (Object)this.empIDs[0]);
            employee.setFirstName("Wilfred");
            this.getEntityManager().flush();
            ((JpaEntityManager)this.getEntityManager()).getActiveSession().getIdentityMapAccessor().initializeAllIdentityMaps();
            this.persistedItems.put("after flush Employee 0", this.getEntityManager().find(Employee.class, (Object)this.empIDs[0]));
            this.commitTransaction();
        }
        catch (Exception ex) {
            this.rollbackTransaction();
            throw new TestErrorException("Exception thrown durring the change of employee's name" + ex);
        }
        try {
            this.beginTransaction();
            employee = (Employee)this.getEntityManager().find(Employee.class, (Object)this.empIDs[1]);
            Project project = (Project)this.getEntityManager().find(Project.class, (Object)this.projIDs[1]);
            project.addTeamMember(employee);
            employee.addProject(project);
            Employee manager = (Employee)this.getEntityManager().find(Employee.class, (Object)this.empIDs[2]);
            manager.addManagedEmployee(employee);
            this.getEntityManager().flush();
            ((JpaEntityManager)this.getEntityManager()).getActiveSession().getIdentityMapAccessor().initializeAllIdentityMaps();
            this.persistedItems.put("after flush Employee 1", this.getEntityManager().find(Employee.class, (Object)this.empIDs[1]));
            this.commitTransaction();
        }
        catch (Exception ex) {
            this.rollbackTransaction();
            throw new TestErrorException("Exception thrown durring assignment of employee to a project" + ex);
        }
        try {
            this.beginTransaction();
            PhoneNumber phone = ModelExamples.phoneExample4();
            this.getEntityManager().persist((Object)phone);
            Employee employee2 = (Employee)this.getEntityManager().find(Employee.class, (Object)this.empIDs[2]);
            employee2.addPhoneNumber(phone);
            Address address = ModelExamples.addressExample4();
            this.getEntityManager().persist((Object)address);
            employee2.setAddress(address);
            EmploymentPeriod period = new EmploymentPeriod();
            period.setStartDate(employee2.getPeriod().getStartDate());
            period.setEndDate(new Date(System.currentTimeMillis()));
            employee2.setPeriod(period);
            employee2.setSalary(0);
            this.getEntityManager().flush();
            ((JpaEntityManager)this.getEntityManager()).getActiveSession().getIdentityMapAccessor().initializeAllIdentityMaps();
            this.persistedItems.put("after flush Employee 2", this.getEntityManager().find(Employee.class, (Object)this.empIDs[2]));
            this.commitTransaction();
        }
        catch (Exception ex) {
            this.rollbackTransaction();
            throw new TestErrorException("Exception thrown durring assignment of a phone to an employee" + ex);
        }
        try {
            this.beginTransaction();
            List employees = this.getEntityManager().createQuery("SELECT OBJECT(employee) FROM Employee employee").getResultList();
            Iterator employeesIter = employees.iterator();
            int totalRaisePercent = 103;
            while (employeesIter.hasNext()) {
                Employee employee3 = (Employee)employeesIter.next();
                int newSalary = (int)((double)employee3.getSalary() * ((double)totalRaisePercent / 100.0));
                employee3.setSalary(newSalary);
            }
            this.getEntityManager().flush();
            ((JpaEntityManager)this.getEntityManager()).getActiveSession().getIdentityMapAccessor().initializeAllIdentityMaps();
            this.persistedItems.put("after flush Employees 0 with raise", this.getEntityManager().find(Employee.class, (Object)this.empIDs[0]));
            this.persistedItems.put("after flush Employees 1 with raise", this.getEntityManager().find(Employee.class, (Object)this.empIDs[1]));
            this.persistedItems.put("after flush Employees 2 with raise", this.getEntityManager().find(Employee.class, (Object)this.empIDs[2]));
            this.commitTransaction();
        }
        catch (Exception ex) {
            this.rollbackTransaction();
            throw new TestErrorException("Exception thrown durring employee raises" + ex);
        }
    }

    public void verify() {
        Employee employee = (Employee)this.persistedItems.get("after flush Employee 0");
        if (!employee.getFirstName().equals("Wilfred")) {
            throw new TestErrorException("Employee ID :" + this.empIDs[0] + " First Name not Updated");
        }
        employee = (Employee)this.persistedItems.get("after flush Employee 1");
        if (!((Project)((List)employee.getProjects()).get(1)).getName().equals("Feline Demographics Assesment")) {
            throw new TestErrorException("Employee ID :" + this.empIDs[1] + " Projects not Updated");
        }
        if (!employee.getManager().getId().equals(this.empIDs[2])) {
            throw new TestErrorException("Employee ID :" + this.empIDs[1] + " Manager not Updated");
        }
        employee = (Employee)this.persistedItems.get("after flush Employee 2");
        if (employee.getManagedEmployees().size() <= 0) {
            throw new TestErrorException("Employee ID :" + this.empIDs[2] + " Managed Employees not Updated");
        }
        if (employee.getPhoneNumbers().size() <= 2) {
            throw new TestErrorException("Employee ID :" + this.empIDs[2] + " PhoneNumbers not Updated");
        }
        if (!employee.getAddress().getStreet().equals("324 Bay Street")) {
            throw new TestErrorException("Employee ID :" + this.empIDs[2] + " Address not Updated");
        }
        if (employee.getPeriod().getEndDate().getTime() >= System.currentTimeMillis()) {
            throw new TestErrorException("Employee ID :" + this.empIDs[2] + " EndDate not Updated");
        }
        employee = (Employee)this.persistedItems.get("after flush Employees 0 with raise");
        if (employee.getSalary() <= 15000) {
            throw new TestErrorException("Employee ID :" + this.empIDs[0] + " Salary Not Updated");
        }
        employee = (Employee)this.persistedItems.get("after flush Employees 1 with raise");
        if (employee.getSalary() <= 1000) {
            throw new TestErrorException("Employee ID :" + this.empIDs[1] + " Salary Not updated");
        }
        employee = (Employee)this.persistedItems.get("after flush Employees 2 with raise");
        if (employee.getSalary() != 0) {
            throw new TestErrorException("Employee ID :" + this.empIDs[2] + " Salary Not updated");
        }
    }
}

