/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.criteria;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Parameter;
import javax.persistence.Tuple;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Fetch;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.ParameterExpression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.criteria.Subquery;
import javax.persistence.metamodel.EmbeddableType;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.Metamodel;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.internal.jpa.querydef.CompoundExpressionImpl;
import org.eclipse.persistence.internal.jpa.querydef.CriteriaQueryImpl;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.jpa.JpaCriteriaBuilder;
import org.eclipse.persistence.jpa.JpaQuery;
import org.eclipse.persistence.queries.Cursor;
import org.eclipse.persistence.queries.ScrollableCursor;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.server.ServerSession;
import org.eclipse.persistence.testing.framework.QuerySQLTracker;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.advanced.Address;
import org.eclipse.persistence.testing.models.jpa.advanced.AdvancedTableCreator;
import org.eclipse.persistence.testing.models.jpa.advanced.Dealer;
import org.eclipse.persistence.testing.models.jpa.advanced.Employee;
import org.eclipse.persistence.testing.models.jpa.advanced.EmployeePopulator;
import org.eclipse.persistence.testing.models.jpa.advanced.EmploymentPeriod;
import org.eclipse.persistence.testing.models.jpa.advanced.PhoneNumber;
import org.eclipse.persistence.testing.models.jpa.advanced.Project;
import org.eclipse.persistence.testing.tests.jpa.jpql.JUnitDomainObjectComparer;

public class AdvancedCriteriaQueryTestSuite
extends JUnitTestCase {
    static JUnitDomainObjectComparer comparer;

    public AdvancedCriteriaQueryTestSuite() {
    }

    public AdvancedCriteriaQueryTestSuite(String name) {
        super(name);
    }

    public void setUp() {
    }

    public void tearDown() {
        this.clearCache();
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("AdvancedCriteriaQueryTestSuite");
        suite.addTest((Test)new AdvancedCriteriaQueryTestSuite("testSetup"));
        suite.addTest((Test)new AdvancedCriteriaQueryTestSuite("testInCollectionEntity"));
        suite.addTest((Test)new AdvancedCriteriaQueryTestSuite("testInCollectionPrimitives"));
        suite.addTest((Test)new AdvancedCriteriaQueryTestSuite("testInParameterCollection"));
        suite.addTest((Test)new AdvancedCriteriaQueryTestSuite("testInParameterCollection2"));
        suite.addTest((Test)new AdvancedCriteriaQueryTestSuite("testProd"));
        suite.addTest((Test)new AdvancedCriteriaQueryTestSuite("testSize"));
        suite.addTest((Test)new AdvancedCriteriaQueryTestSuite("testJoinDistinct"));
        suite.addTest((Test)new AdvancedCriteriaQueryTestSuite("testSome"));
        suite.addTest((Test)new AdvancedCriteriaQueryTestSuite("testWhereConjunction"));
        suite.addTest((Test)new AdvancedCriteriaQueryTestSuite("testWhereNotConjunction"));
        suite.addTest((Test)new AdvancedCriteriaQueryTestSuite("testWhereDisjunction"));
        suite.addTest((Test)new AdvancedCriteriaQueryTestSuite("testWhereNotDisjunction"));
        suite.addTest((Test)new AdvancedCriteriaQueryTestSuite("testWhereConjunctionAndDisjunction"));
        suite.addTest((Test)new AdvancedCriteriaQueryTestSuite("testWhereDisjunctionAndConjunction"));
        suite.addTest((Test)new AdvancedCriteriaQueryTestSuite("testWhereConjunctionOrDisjunction"));
        suite.addTest((Test)new AdvancedCriteriaQueryTestSuite("testWhereUsingAndWithPredicates"));
        suite.addTest((Test)new AdvancedCriteriaQueryTestSuite("testWhereUsingOrWithPredicates"));
        suite.addTest((Test)new AdvancedCriteriaQueryTestSuite("testVerySimpleJoin"));
        suite.addTest((Test)new AdvancedCriteriaQueryTestSuite("testGroupByHaving"));
        suite.addTest((Test)new AdvancedCriteriaQueryTestSuite("testGroupByHaving2"));
        suite.addTest((Test)new AdvancedCriteriaQueryTestSuite("testAlternateSelection"));
        suite.addTest((Test)new AdvancedCriteriaQueryTestSuite("testSubqueryExists"));
        suite.addTest((Test)new AdvancedCriteriaQueryTestSuite("testSubqueryNotExists"));
        suite.addTest((Test)new AdvancedCriteriaQueryTestSuite("testSubqueryExistsAfterAnd"));
        suite.addTest((Test)new AdvancedCriteriaQueryTestSuite("testSubqueryExistsBeforeAnd"));
        suite.addTest((Test)new AdvancedCriteriaQueryTestSuite("testSubqueryNotExistsAfterAnd"));
        suite.addTest((Test)new AdvancedCriteriaQueryTestSuite("testSubqueryNotExistsBeforeAnd"));
        suite.addTest((Test)new AdvancedCriteriaQueryTestSuite("testSubqueryExistsNested"));
        suite.addTest((Test)new AdvancedCriteriaQueryTestSuite("testSubqueryExistsNestedUnusedRoot"));
        suite.addTest((Test)new AdvancedCriteriaQueryTestSuite("testSubqueryExistsNestedAfterAnd"));
        suite.addTest((Test)new AdvancedCriteriaQueryTestSuite("testSubqueryExistsNestedAfterLiteralAnd"));
        suite.addTest((Test)new AdvancedCriteriaQueryTestSuite("testSubQuery"));
        suite.addTest((Test)new AdvancedCriteriaQueryTestSuite("testInSubQuery"));
        suite.addTest((Test)new AdvancedCriteriaQueryTestSuite("testInLiteral"));
        suite.addTest((Test)new AdvancedCriteriaQueryTestSuite("testInlineInParameter"));
        suite.addTest((Test)new AdvancedCriteriaQueryTestSuite("testSimpleJoin"));
        suite.addTest((Test)new AdvancedCriteriaQueryTestSuite("testSimpleFetch"));
        suite.addTest((Test)new AdvancedCriteriaQueryTestSuite("testObjectResultType"));
        suite.addTest((Test)new AdvancedCriteriaQueryTestSuite("testSimple"));
        suite.addTest((Test)new AdvancedCriteriaQueryTestSuite("testSimpleWhere"));
        suite.addTest((Test)new AdvancedCriteriaQueryTestSuite("testSimpleWhereObject"));
        suite.addTest((Test)new AdvancedCriteriaQueryTestSuite("testSharedWhere"));
        suite.addTest((Test)new AdvancedCriteriaQueryTestSuite("testTupleQuery"));
        suite.addTest((Test)new AdvancedCriteriaQueryTestSuite("testQueryCacheFirstCacheHits"));
        suite.addTest((Test)new AdvancedCriteriaQueryTestSuite("testQueryCacheOnlyCacheHits"));
        suite.addTest((Test)new AdvancedCriteriaQueryTestSuite("testQueryCacheOnlyCacheHitsOnSession"));
        suite.addTest((Test)new AdvancedCriteriaQueryTestSuite("testQueryExactPrimaryKeyCacheHits"));
        suite.addTest((Test)new AdvancedCriteriaQueryTestSuite("testQueryHintFetch"));
        suite.addTest((Test)new AdvancedCriteriaQueryTestSuite("testCursors"));
        suite.addTest((Test)new AdvancedCriteriaQueryTestSuite("testIsEmpty"));
        suite.addTest((Test)new AdvancedCriteriaQueryTestSuite("testNeg"));
        suite.addTest((Test)new AdvancedCriteriaQueryTestSuite("testIsMember"));
        suite.addTest((Test)new AdvancedCriteriaQueryTestSuite("testIsMemberEntity"));
        suite.addTest((Test)new AdvancedCriteriaQueryTestSuite("testNullRestrictionGetRestriction"));
        suite.addTest((Test)new AdvancedCriteriaQueryTestSuite("testFromToExpression"));
        suite.addTest((Test)new AdvancedCriteriaQueryTestSuite("testUnusedJoinDoesNotAffectOtherJoins"));
        suite.addTest((Test)new AdvancedCriteriaQueryTestSuite("testUnusedJoinDoesNotAffectFetchJoin"));
        suite.addTest((Test)new AdvancedCriteriaQueryTestSuite("testGetRestrictionReturningCorrectPredicate"));
        suite.addTest((Test)new AdvancedCriteriaQueryTestSuite("testJoinDuplication"));
        return suite;
    }

    public void testSetup() {
        this.clearCache();
        ServerSession session = JUnitTestCase.getServerSession();
        EmployeePopulator employeePopulator = new EmployeePopulator();
        new AdvancedTableCreator().replaceTables((DatabaseSession)session);
        comparer = new JUnitDomainObjectComparer();
        comparer.setSession((AbstractSession)session.getActiveSession());
        employeePopulator.buildExamples();
        employeePopulator.persistExample((Session)session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAlternateSelection() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            em.createQuery("select p.teamLeader from Project p where p.name = 'Sales Reporting'").getResultList();
            Metamodel mm = em.getMetamodel();
            CriteriaBuilder qbuilder = em.getCriteriaBuilder();
            CriteriaQuery cquery = qbuilder.createQuery(Employee.class);
            Root spouse = cquery.from(Project.class);
            cquery.where((Expression)qbuilder.equal((Expression)spouse.get("name"), (Object)"Sales Reporting")).select((Selection)spouse.get("teamLeader"));
            TypedQuery tquery = em.createQuery(cquery);
            AdvancedCriteriaQueryTestSuite.assertTrue((String)"Did not find the correct leaders of Project Swirly Dirly.", (tquery.getResultList().size() > 1 ? 1 : 0) != 0);
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTupleQuery() {
        EntityManager em = this.createEntityManager();
        QuerySQLTracker counter = null;
        this.beginTransaction(em);
        try {
            CriteriaBuilder qb = em.getCriteriaBuilder();
            TypedQuery query = em.createQuery(em.getCriteriaBuilder().createQuery(Employee.class));
            List result = query.getResultList();
            Employee employee = (Employee)result.get(0);
            counter = new QuerySQLTracker((Session)AdvancedCriteriaQueryTestSuite.getServerSession());
            CriteriaQuery cq = qb.createQuery(Tuple.class);
            Root from = cq.from(Employee.class);
            cq.multiselect(new Selection[]{from.get("id"), from.get("firstName")});
            cq.where((Expression)qb.and((Expression)qb.equal((Expression)from.get("id"), (Expression)qb.parameter(from.get("id").getModel().getBindableJavaType(), "id")), (Expression)qb.equal((Expression)from.get("firstName"), (Expression)qb.parameter(from.get("firstName").getModel().getBindableJavaType(), "firstName"))));
            TypedQuery typedQuery = em.createQuery(cq);
            typedQuery.setParameter("id", (Object)employee.getId());
            typedQuery.setParameter("firstName", (Object)employee.getFirstName());
            Tuple queryResult = (Tuple)typedQuery.getSingleResult();
            AdvancedCriteriaQueryTestSuite.assertTrue((String)"Query Results do not match selection", (queryResult.get(0).equals(employee.getId()) && queryResult.get(1).equals(employee.getFirstName()) ? 1 : 0) != 0);
        }
        finally {
            this.rollbackTransaction(em);
            if (counter != null) {
                counter.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSharedWhere() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            CriteriaQuery cq = em.getCriteriaBuilder().createQuery(Employee.class);
            CriteriaBuilder qb = em.getCriteriaBuilder();
            Root root = cq.from(em.getMetamodel().entity(Employee.class));
            cq.where((Expression)qb.equal((Expression)root.get("firstName"), qb.literal((Object)"Bob")));
            TypedQuery tq = em.createQuery(cq);
            List result = tq.getResultList();
            AdvancedCriteriaQueryTestSuite.assertFalse((String)"No Employees were returned", (boolean)result.isEmpty());
            AdvancedCriteriaQueryTestSuite.assertTrue((String)"Did not return Employee", (boolean)((Employee)result.get(0)).getClass().equals(Employee.class));
            AdvancedCriteriaQueryTestSuite.assertTrue((String)"Employee had wrong firstname", (boolean)((Employee)result.get(0)).getFirstName().equalsIgnoreCase("bob"));
            CriteriaQuery cq2 = em.getCriteriaBuilder().createQuery(Employee.class);
            cq2.where((Expression)cq.getRestriction());
            TypedQuery tq2 = em.createQuery(cq);
            List result2 = tq.getResultList();
            AdvancedCriteriaQueryTestSuite.assertTrue((String)"Employee's did not match with query with same where clause", (boolean)comparer.compareObjects(result.get(0), result2.get(0)));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSimple() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            CriteriaQuery cq = em.getCriteriaBuilder().createQuery(Employee.class);
            List result = em.createQuery(cq).getResultList();
            AdvancedCriteriaQueryTestSuite.assertFalse((String)"No Employees were returned", (boolean)result.isEmpty());
            AdvancedCriteriaQueryTestSuite.assertTrue((String)"Did not return Employee", (boolean)((Employee)result.get(0)).getClass().equals(Employee.class));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGroupByHaving() {
        EntityManager em = this.createEntityManager();
        List jpqlResult = em.createQuery("Select e.address, count(e) from Employee e group by e.address having count(e.address) < 3").getResultList();
        this.beginTransaction(em);
        try {
            Metamodel mm = em.getMetamodel();
            CriteriaBuilder qbuilder = em.getCriteriaBuilder();
            CriteriaQuery cquery = qbuilder.createQuery();
            Root customer = cquery.from(Employee.class);
            cquery.multiselect(new Selection[]{customer.get("address"), qbuilder.count((Expression)customer)});
            cquery.groupBy(new Expression[]{customer.get("address")});
            cquery.having((Expression)qbuilder.lt(qbuilder.count((Expression)customer.get("address")), (Number)3));
            List result = em.createQuery(cquery).getResultList();
            AdvancedCriteriaQueryTestSuite.assertTrue((boolean)comparer.compareObjects(jpqlResult, (Collection)result));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGroupByHaving2() {
        EntityManager em = this.createEntityManager();
        List jpqlResult = em.createQuery("Select e.period, count(e) from Employee e group by e.period having count(e.period) > 3").getResultList();
        this.beginTransaction(em);
        try {
            Metamodel mm = em.getMetamodel();
            CriteriaBuilder qbuilder = em.getCriteriaBuilder();
            CriteriaQuery cquery = qbuilder.createQuery();
            Root customer = cquery.from(Employee.class);
            EntityType Customer_ = customer.getModel();
            EmbeddableType Country_ = mm.embeddable(EmploymentPeriod.class);
            cquery.multiselect(new Selection[]{customer.get(Customer_.getSingularAttribute("period", EmploymentPeriod.class)), qbuilder.count((Expression)customer)});
            cquery.groupBy(new Expression[]{customer.get(Customer_.getSingularAttribute("period", EmploymentPeriod.class))});
            cquery.having((Expression)qbuilder.gt(qbuilder.count((Expression)customer.get(Customer_.getSingularAttribute("period", EmploymentPeriod.class))), (Number)3));
            List result = em.createQuery(cquery).getResultList();
            AdvancedCriteriaQueryTestSuite.assertTrue((boolean)comparer.compareObjects(jpqlResult, (Collection)result));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInLiteral() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            CriteriaBuilder qb = em.getCriteriaBuilder();
            CriteriaQuery cq = qb.createQuery(Employee.class);
            Root emp = cq.from(Employee.class);
            CriteriaBuilder.In in = qb.in((Expression)emp.get("address").get("city"));
            in.value((Object)"Ottawa").value((Object)"Halifax").value((Object)"Toronto");
            cq.where((Expression)in);
            List result = em.createQuery(cq).getResultList();
            AdvancedCriteriaQueryTestSuite.assertFalse((String)"No Employees were returned", (boolean)result.isEmpty());
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInSubQuery() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            CriteriaBuilder qb = em.getCriteriaBuilder();
            CriteriaQuery cq = qb.createQuery(Employee.class);
            Root emp = cq.from(Employee.class);
            Subquery sq = cq.subquery(String.class);
            Root sqEmp = sq.from(Address.class);
            sq.select((Expression)sqEmp.get("city"));
            sq.where((Expression)qb.notLike((Expression)sqEmp.get("city"), "5"));
            CriteriaBuilder.In in = qb.in((Expression)emp.get("address").get("city"));
            in.value((Expression)sq);
            cq.where((Expression)in);
            List result = em.createQuery(cq).getResultList();
            AdvancedCriteriaQueryTestSuite.assertFalse((String)"No Employees were returned", (boolean)result.isEmpty());
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInCollectionEntity() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            CriteriaBuilder qb = em.getCriteriaBuilder();
            CriteriaQuery cq = qb.createQuery(Employee.class);
            Root emp = cq.from(Employee.class);
            Root phone = cq.from(PhoneNumber.class);
            cq.where((Expression)qb.and((Expression)qb.equal((Expression)phone.get("areaCode"), (Object)"613"), (Expression)phone.in((Expression)emp.get("phoneNumbers"))));
            TypedQuery query = em.createQuery(cq);
            List result = query.getResultList();
            AdvancedCriteriaQueryTestSuite.assertFalse((String)"No Employees were returned", (boolean)result.isEmpty());
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInCollectionPrimitives() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            CriteriaBuilder qb = em.getCriteriaBuilder();
            CriteriaQuery cq = qb.createQuery(Employee.class);
            Root emp = cq.from(Employee.class);
            Root phone = cq.from(PhoneNumber.class);
            cq.where((Expression)qb.literal((Object)"Bug fixes").in((Expression)emp.get("responsibilities")));
            TypedQuery query = em.createQuery(cq);
            List result = query.getResultList();
            AdvancedCriteriaQueryTestSuite.assertFalse((String)"No Employees were returned", (boolean)result.isEmpty());
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInCollectionEmpty() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            CriteriaBuilder qb = em.getCriteriaBuilder();
            CriteriaQuery cq = qb.createQuery(Employee.class);
            Root emp = cq.from(Employee.class);
            Root phone = cq.from(PhoneNumber.class);
            cq.where((Expression)qb.literal((Object)"Bug fixes").in(new HashSet()));
            TypedQuery query = em.createQuery(cq);
            List result = query.getResultList();
            AdvancedCriteriaQueryTestSuite.assertTrue((String)"No any Employees was expected", (boolean)result.isEmpty());
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInCollectionNull() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            CriteriaBuilder qb = em.getCriteriaBuilder();
            CriteriaQuery cq = qb.createQuery(Employee.class);
            Root emp = cq.from(Employee.class);
            Root phone = cq.from(PhoneNumber.class);
            Collection list = null;
            cq.where((Expression)qb.literal((Object)"Bug fixes").in(list));
            TypedQuery query = em.createQuery(cq);
            List result = query.getResultList();
            AdvancedCriteriaQueryTestSuite.assertTrue((String)"No any Employees was expected", (boolean)result.isEmpty());
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInParameterCollection() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        Vector<String> respons = new Vector<String>();
        respons.add("NoResults");
        respons.add("Bug fixes");
        try {
            CriteriaBuilder qbuilder = em.getCriteriaBuilder();
            CriteriaQuery cquery = qbuilder.createQuery(Employee.class);
            Root emp = cquery.from(Employee.class);
            ParameterExpression pe = qbuilder.parameter(Collection.class, "param");
            cquery.where((Expression)emp.join("responsibilities").in((Expression)pe));
            List result = em.createQuery(cquery).setParameter("param", respons).getResultList();
            AdvancedCriteriaQueryTestSuite.assertFalse((String)"testInParameterCollection failed: No Employees were returned", (boolean)result.isEmpty());
        }
        finally {
            this.closeEntityManagerAndTransaction(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInParameterCollection2() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        Vector<String> response = new Vector<String>();
        response.add("NoResults");
        response.add("Bug fixes");
        try {
            CriteriaBuilder qbuilder = em.getCriteriaBuilder();
            CriteriaQuery cquery = qbuilder.createQuery(Employee.class);
            Root emp = cquery.from(Employee.class);
            cquery.where((Expression)emp.join("responsibilities").in(new Expression[]{qbuilder.parameter(Collection.class, "param")}));
            List result = em.createQuery(cquery).setParameter("param", response).getResultList();
            AdvancedCriteriaQueryTestSuite.assertFalse((String)"testInParameterCollection failed: No Employees were returned", (boolean)result.isEmpty());
        }
        finally {
            this.closeEntityManagerAndTransaction(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInlineInParameter() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            CriteriaBuilder qb = em.getCriteriaBuilder();
            CriteriaQuery cq = qb.createQuery(Employee.class);
            Root emp = cq.from(Employee.class);
            cq.where((Expression)emp.get("address").get("city").in(new Expression[]{qb.parameter(String.class, "city")}));
            TypedQuery query = em.createQuery(cq);
            query.setParameter("city", (Object)"Ottawa");
            List result = query.getResultList();
            AdvancedCriteriaQueryTestSuite.assertFalse((String)"No Employees were returned", (boolean)result.isEmpty());
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIsEmpty() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            CriteriaBuilder qb = em.getCriteriaBuilder();
            CriteriaQuery cq = qb.createQuery(Employee.class);
            Root emp = cq.from(Employee.class);
            cq.where((Expression)qb.isEmpty((Expression)emp.get("phoneNumbers")));
            List result = em.createQuery(cq).getResultList();
            AdvancedCriteriaQueryTestSuite.assertFalse((String)"No Employees were returned", (boolean)result.isEmpty());
            for (Employee e : result) {
                AdvancedCriteriaQueryTestSuite.assertTrue((String)"PhoneNumbers Found", (boolean)e.getPhoneNumbers().isEmpty());
            }
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNeg() {
        if (this.getPlatform().isSymfoware()) {
            AdvancedCriteriaQueryTestSuite.getServerSession().logMessage("Test testNeg skipped for this platform, Symfoware doesn't allow arithmetic expression in subquery. (bug 304907)");
            return;
        }
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            CriteriaBuilder qb = em.getCriteriaBuilder();
            CriteriaQuery cq = qb.createQuery(Employee.class);
            Root emp = cq.from(Employee.class);
            cq.where((Expression)qb.lessThan(qb.neg(qb.size((Expression)emp.get("phoneNumbers"))), (Comparable)Integer.valueOf(0)));
            List result = em.createQuery(cq).getResultList();
            AdvancedCriteriaQueryTestSuite.assertFalse((String)"No Employees were returned", (boolean)result.isEmpty());
            for (Employee e : result) {
                AdvancedCriteriaQueryTestSuite.assertTrue((String)"PhoneNumbers Found", (!e.getPhoneNumbers().isEmpty() ? 1 : 0) != 0);
            }
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNullIf() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            CriteriaBuilder qb = em.getCriteriaBuilder();
            CriteriaQuery cq = qb.createQuery(Employee.class);
            Root emp = cq.from(Employee.class);
            cq.where((Expression)qb.isNull(qb.nullif(qb.size((Expression)emp.get("phoneNumbers")), (Expression)qb.parameter(Integer.class))));
            List result = em.createQuery(cq).getResultList();
            AdvancedCriteriaQueryTestSuite.assertFalse((String)"No Employees were returned", (boolean)result.isEmpty());
            for (Employee e : result) {
                AdvancedCriteriaQueryTestSuite.assertTrue((String)"PhoneNumbers Found", (!e.getPhoneNumbers().isEmpty() ? 1 : 0) != 0);
            }
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNullRestrictionGetRestriction() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Metamodel mm = em.getMetamodel();
            CriteriaBuilder qbuilder = em.getCriteriaBuilder();
            CriteriaQuery cquery = qbuilder.createQuery(Employee.class);
            cquery.getRestriction();
        }
        catch (NullPointerException ex) {
            AdvancedCriteriaQueryTestSuite.fail((String)"'getRestriction()' with null restriction threw NullPointerException");
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIsMember() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            CriteriaBuilder qb = em.getCriteriaBuilder();
            CriteriaQuery cq = qb.createQuery(Employee.class);
            Root emp = cq.from(Employee.class);
            cq.where((Expression)qb.isMember((Expression)qb.parameter(String.class, "1"), (Expression)emp.get("responsibilities")));
            TypedQuery query = em.createQuery(cq);
            query.setParameter("1", (Object)"Sort files");
            List result = query.getResultList();
            AdvancedCriteriaQueryTestSuite.assertFalse((String)"No Employees were returned", (boolean)result.isEmpty());
            for (Employee e : result) {
                AdvancedCriteriaQueryTestSuite.assertTrue((String)"Employee Found without Responcibilities", (boolean)e.getResponsibilities().contains("Sort files"));
            }
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIsMemberEntity() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            CriteriaBuilder qb = em.getCriteriaBuilder();
            CriteriaQuery cq = qb.createQuery(Employee.class);
            Root emp = cq.from(Employee.class);
            Root phone = cq.from(PhoneNumber.class);
            cq.where((Expression)qb.and((Expression)qb.equal((Expression)phone.get("areaCode"), (Object)"416"), (Expression)qb.isMember((Expression)phone, (Expression)emp.get("phoneNumbers"))));
            TypedQuery query = em.createQuery(cq);
            List result = query.getResultList();
            AdvancedCriteriaQueryTestSuite.assertFalse((String)"No Employees were returned", (boolean)result.isEmpty());
            for (Employee e : result) {
                boolean areacode = false;
                for (PhoneNumber p : e.getPhoneNumbers()) {
                    areacode = areacode || p.getAreaCode().equals("416");
                }
                AdvancedCriteriaQueryTestSuite.assertTrue((String)"No PhoneNumbers with '416'area code", (boolean)areacode);
            }
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testVerySimpleJoin() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            CriteriaQuery cq = em.getCriteriaBuilder().createQuery(Employee.class);
            CriteriaBuilder qb = em.getCriteriaBuilder();
            Root root = cq.from(em.getMetamodel().entity(Employee.class));
            root.join("phoneNumbers");
            if (!AdvancedCriteriaQueryTestSuite.usesSOP() || !AdvancedCriteriaQueryTestSuite.getServerSession().getPlatform().isOracle()) {
                cq.distinct(true);
            }
            TypedQuery tq = em.createQuery(cq);
            List result = tq.getResultList();
            for (Employee emp : result) {
                AdvancedCriteriaQueryTestSuite.assertFalse((String)"Found someone without a phone", (boolean)emp.getPhoneNumbers().isEmpty());
            }
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSimpleJoin() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            CriteriaQuery cq = em.getCriteriaBuilder().createQuery(Employee.class);
            CriteriaBuilder qb = em.getCriteriaBuilder();
            Root root = cq.from(em.getMetamodel().entity(Employee.class));
            root.join("phoneNumbers");
            cq.where((Expression)qb.isEmpty((Expression)root.get("phoneNumbers")));
            TypedQuery tq = em.createQuery(cq);
            List result = tq.getResultList();
            AdvancedCriteriaQueryTestSuite.assertTrue((String)"Found employee but joins should have canceled isEmpty", (boolean)result.isEmpty());
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSimpleWhere() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            CriteriaQuery cq = em.getCriteriaBuilder().createQuery(Employee.class);
            CriteriaBuilder qb = em.getCriteriaBuilder();
            Root root = cq.from(em.getMetamodel().entity(Employee.class));
            cq.where((Expression)qb.equal((Expression)root.get("firstName"), qb.literal((Object)"Bob")));
            TypedQuery tq = em.createQuery(cq);
            List result = tq.getResultList();
            AdvancedCriteriaQueryTestSuite.assertFalse((String)"No Employees were returned", (boolean)result.isEmpty());
            AdvancedCriteriaQueryTestSuite.assertTrue((String)"Did not return Employee", (boolean)((Employee)result.get(0)).getClass().equals(Employee.class));
            AdvancedCriteriaQueryTestSuite.assertTrue((String)"Employee had wrong firstname", (boolean)((Employee)result.get(0)).getFirstName().equalsIgnoreCase("bob"));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testWhereDisjunction() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            CriteriaQuery cq = em.getCriteriaBuilder().createQuery(Employee.class);
            CriteriaBuilder qb = em.getCriteriaBuilder();
            cq.where((Expression)qb.disjunction());
            TypedQuery tq = em.createQuery(cq);
            List result = tq.getResultList();
            AdvancedCriteriaQueryTestSuite.assertTrue((String)"Employees were returned", (boolean)result.isEmpty());
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testWhereNotDisjunction() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            CriteriaQuery cq = em.getCriteriaBuilder().createQuery(Employee.class);
            CriteriaBuilder qb = em.getCriteriaBuilder();
            cq.where((Expression)qb.disjunction().not());
            TypedQuery tq = em.createQuery(cq);
            List result = tq.getResultList();
            AdvancedCriteriaQueryTestSuite.assertFalse((String)"Employees were not returned", (boolean)result.isEmpty());
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testWhereConjunction() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            CriteriaQuery cq = em.getCriteriaBuilder().createQuery(Employee.class);
            CriteriaBuilder qb = em.getCriteriaBuilder();
            cq.where((Expression)qb.conjunction());
            TypedQuery tq = em.createQuery(cq);
            List result = tq.getResultList();
            AdvancedCriteriaQueryTestSuite.assertFalse((String)"Employees were not returned", (boolean)result.isEmpty());
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testWhereNotConjunction() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            CriteriaQuery cq = em.getCriteriaBuilder().createQuery(Employee.class);
            CriteriaBuilder qb = em.getCriteriaBuilder();
            cq.where((Expression)qb.conjunction().not());
            TypedQuery tq = em.createQuery(cq);
            List result = tq.getResultList();
            AdvancedCriteriaQueryTestSuite.assertTrue((String)"Employees were returned", (boolean)result.isEmpty());
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testJoinDistinct() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            CriteriaBuilder qbuilder = em.getCriteriaBuilder();
            CriteriaQuery cquery = qbuilder.createQuery(Employee.class);
            Root customer = cquery.from(Employee.class);
            Fetch o = customer.fetch("phoneNumbers", JoinType.LEFT);
            cquery.where((Expression)customer.get("address").get("city").in(new Object[]{"Ottawa", "Halifax"}));
            cquery.select((Selection)customer).distinct(true);
            TypedQuery tquery = em.createQuery(cquery);
            if (AdvancedCriteriaQueryTestSuite.usesSOP() && AdvancedCriteriaQueryTestSuite.getServerSession().getPlatform().isOracle()) {
                tquery.setHint("eclipselink.serialized-object", (Object)"false");
            }
            List result = tquery.getResultList();
            AdvancedCriteriaQueryTestSuite.assertFalse((String)"No results found", (boolean)result.isEmpty());
            Long count = (Long)em.createQuery("Select count(e) from Employee e where e.address.city in ('Ottawa', 'Halifax')").getSingleResult();
            AdvancedCriteriaQueryTestSuite.assertTrue((String)"Incorrect number of results returned", ((long)result.size() == count ? 1 : 0) != 0);
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testWhereConjunctionAndDisjunction() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            CriteriaQuery cq = em.getCriteriaBuilder().createQuery(Employee.class);
            CriteriaBuilder qb = em.getCriteriaBuilder();
            cq.where((Expression)qb.and((Expression)qb.disjunction(), (Expression)qb.conjunction()));
            TypedQuery tq = em.createQuery(cq);
            List result = tq.getResultList();
            AdvancedCriteriaQueryTestSuite.assertTrue((String)"Employees were returned", (boolean)result.isEmpty());
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testWhereDisjunctionAndConjunction() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            CriteriaQuery cq = em.getCriteriaBuilder().createQuery(Employee.class);
            CriteriaBuilder qb = em.getCriteriaBuilder();
            cq.where((Expression)qb.and((Expression)qb.conjunction(), (Expression)qb.disjunction()));
            TypedQuery tq = em.createQuery(cq);
            List result = tq.getResultList();
            AdvancedCriteriaQueryTestSuite.assertTrue((String)"Employees were returned", (boolean)result.isEmpty());
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testWhereConjunctionOrDisjunction() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            CriteriaQuery cq = em.getCriteriaBuilder().createQuery(Employee.class);
            CriteriaBuilder qb = em.getCriteriaBuilder();
            cq.where((Expression)qb.or((Expression)qb.disjunction(), (Expression)qb.conjunction()));
            TypedQuery tq = em.createQuery(cq);
            List result = tq.getResultList();
            AdvancedCriteriaQueryTestSuite.assertTrue((String)"Employees were not returned", (!result.isEmpty() ? 1 : 0) != 0);
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testWhereUsingAndWithPredicates() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            CriteriaQuery cq = em.getCriteriaBuilder().createQuery(Employee.class);
            CriteriaBuilder qb = em.getCriteriaBuilder();
            Root root = cq.from(em.getMetamodel().entity(Employee.class));
            cq.where((Expression)qb.and((Expression)qb.conjunction(), (Expression)qb.equal((Expression)root.get("lastName"), (Object)"Smith")));
            TypedQuery tq = em.createQuery(cq);
            List result = tq.getResultList();
            AdvancedCriteriaQueryTestSuite.assertFalse((String)"Employees were not returned for 'true and lastName='Smith' '", (boolean)result.isEmpty());
            cq = em.getCriteriaBuilder().createQuery(Employee.class);
            qb = em.getCriteriaBuilder();
            root = cq.from(em.getMetamodel().entity(Employee.class));
            cq.where((Expression)qb.and((Expression)qb.equal((Expression)root.get("lastName"), (Object)"Smith"), (Expression)qb.conjunction()));
            tq = em.createQuery(cq);
            result = tq.getResultList();
            AdvancedCriteriaQueryTestSuite.assertFalse((String)"Employees were not returned for 'lastName='Smith' and true'", (boolean)result.isEmpty());
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testWhereUsingOrWithPredicates() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            CriteriaQuery cq = em.getCriteriaBuilder().createQuery(Employee.class);
            CriteriaBuilder qb = em.getCriteriaBuilder();
            Root root = cq.from(em.getMetamodel().entity(Employee.class));
            cq.where((Expression)qb.or((Expression)qb.disjunction(), (Expression)qb.equal((Expression)root.get("lastName"), (Object)"Smith")));
            TypedQuery tq = em.createQuery(cq);
            List result = tq.getResultList();
            AdvancedCriteriaQueryTestSuite.assertFalse((String)"Employees were not returned for 'false or lastName='Smith' '", (boolean)result.isEmpty());
            cq = em.getCriteriaBuilder().createQuery(Employee.class);
            qb = em.getCriteriaBuilder();
            root = cq.from(em.getMetamodel().entity(Employee.class));
            cq.where((Expression)qb.or((Expression)qb.equal((Expression)root.get("lastName"), (Object)"Smith"), (Expression)qb.disjunction()));
            tq = em.createQuery(cq);
            result = tq.getResultList();
            AdvancedCriteriaQueryTestSuite.assertFalse((String)"Employees were not returned for 'lastName='Smith' or false'", (boolean)result.isEmpty());
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSimpleWhereObject() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            CriteriaQuery cq = em.getCriteriaBuilder().createQuery();
            CriteriaBuilder qb = em.getCriteriaBuilder();
            Root root = cq.from(em.getMetamodel().entity(Employee.class));
            cq.where((Expression)qb.equal((Expression)root.get("firstName"), qb.literal((Object)"Bob")));
            TypedQuery tq = em.createQuery(cq);
            List result = tq.getResultList();
            AdvancedCriteriaQueryTestSuite.assertFalse((String)"No Employees were returned", (boolean)result.isEmpty());
            AdvancedCriteriaQueryTestSuite.assertTrue((String)"Did not return Employee", (boolean)((Employee)result.get(0)).getClass().equals(Employee.class));
            AdvancedCriteriaQueryTestSuite.assertTrue((String)"Employee had wrong firstname", (boolean)((Employee)result.get(0)).getFirstName().equalsIgnoreCase("bob"));
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSimpleFetch() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            CriteriaQuery cq = em.getCriteriaBuilder().createQuery(Employee.class);
            CriteriaBuilder qb = em.getCriteriaBuilder();
            Root root = cq.from(em.getMetamodel().entity(Employee.class));
            root.fetch("projects");
            cq.where((Expression)qb.equal((Expression)root.get("firstName"), qb.literal((Object)"Bob")));
            TypedQuery tq = em.createQuery(cq);
            List result = tq.getResultList();
            AdvancedCriteriaQueryTestSuite.assertFalse((String)"No Employees were returned", (boolean)result.isEmpty());
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            try {
                ObjectOutputStream stream = new ObjectOutputStream(byteStream);
                stream.writeObject(result.get(0));
                stream.flush();
                byte[] arr = byteStream.toByteArray();
                ByteArrayInputStream inByteStream = new ByteArrayInputStream(arr);
                ObjectInputStream inObjStream = new ObjectInputStream(inByteStream);
                Employee emp = (Employee)inObjStream.readObject();
                AdvancedCriteriaQueryTestSuite.assertTrue((String)"Did not return Employee", (boolean)emp.getClass().equals(Employee.class));
                AdvancedCriteriaQueryTestSuite.assertTrue((String)"Employee had wrong firstname", (boolean)emp.getFirstName().equalsIgnoreCase("bob"));
                emp.getProjects().size();
            }
            catch (IOException e) {
                AdvancedCriteriaQueryTestSuite.fail((String)"Failed during serialization");
            }
            catch (ClassNotFoundException e) {
                AdvancedCriteriaQueryTestSuite.fail((String)"Failed during serialization");
            }
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSize() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            CriteriaBuilder qbuilder = em.getCriteriaBuilder();
            CriteriaQuery cquery = qbuilder.createQuery(Object[].class);
            Root customer = cquery.from(Employee.class);
            cquery.select((Selection)qbuilder.array(new Selection[]{customer.get("id"), qbuilder.size((Expression)customer.get("responsibilities"))}));
            TypedQuery tquery = em.createQuery(cquery);
            List result = tquery.getResultList();
            for (Object[] value : result) {
                AdvancedCriteriaQueryTestSuite.assertTrue((String)"Incorrect responsibilities count", (((Employee)em.find(Employee.class, value[0])).getResponsibilities().size() == ((Integer)value[1]).intValue() ? 1 : 0) != 0);
            }
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSome() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            em.createQuery("SELECT e from Employee e, IN(e.phoneNumbers) p where p.type = some(select p2.type from PhoneNumber p2 where p2.areaCode = '613')").getResultList();
            CriteriaBuilder qbuilder = em.getCriteriaBuilder();
            CriteriaQuery cquery = qbuilder.createQuery(Employee.class);
            Root customer = cquery.from(Employee.class);
            Join orders = customer.join("phoneNumbers");
            Subquery sq = cquery.subquery(String.class);
            Root order = sq.from(PhoneNumber.class);
            sq.select((Expression)order.get("type")).where((Expression)qbuilder.equal((Expression)order.get("areaCode"), (Object)"613"));
            cquery.where((Expression)qbuilder.equal((Expression)orders.get("type"), qbuilder.some(sq)));
            if (!AdvancedCriteriaQueryTestSuite.usesSOP() || !AdvancedCriteriaQueryTestSuite.getServerSession().getPlatform().isOracle()) {
                cquery.distinct(true);
            }
            em.createQuery(cquery).getResultList();
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSubQuery() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            CriteriaBuilder qbuilder = em.getCriteriaBuilder();
            CriteriaQuery cquery = qbuilder.createQuery(Employee.class);
            Root customer = cquery.from(Employee.class);
            Join o = customer.join("dealers");
            if (AdvancedCriteriaQueryTestSuite.usesSOP() && AdvancedCriteriaQueryTestSuite.getServerSession().getPlatform().isOracle()) {
                cquery.select((Selection)customer);
            } else {
                cquery.select((Selection)customer).distinct(true);
            }
            Subquery sq = cquery.subquery(Integer.class);
            Root sqo = sq.from(Dealer.class);
            sq.select(qbuilder.min((Expression)sqo.get("version")));
            cquery.where((Expression)qbuilder.equal((Expression)o.get("version"), (Expression)sq));
            TypedQuery tquery = em.createQuery(cquery);
            List list = tquery.getResultList();
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFromToExpression() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            JpaCriteriaBuilder cb = (JpaCriteriaBuilder)em.getCriteriaBuilder();
            CriteriaQuery cquery = cb.createQuery(Employee.class);
            Root emp = cquery.from(Employee.class);
            cquery.where(cb.fromExpression(cb.toExpression((Expression)emp).get("id").notNull()));
            TypedQuery tquery = em.createQuery(cquery);
            List result = tquery.getResultList();
            result.size();
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    protected static Set<Integer> getIds(Collection<Employee> employees) {
        HashSet<Integer> ids = new HashSet<Integer>(employees.size());
        for (Employee emp : employees) {
            ids.add(emp.getId());
        }
        return ids;
    }

    protected void compareIds(List<Employee> jpqlEmployees, List<Employee> criteriaEmployees) {
        Set<Integer> criteriaIds;
        Set<Integer> jpqlIds = AdvancedCriteriaQueryTestSuite.getIds(jpqlEmployees);
        if (!jpqlIds.equals(criteriaIds = AdvancedCriteriaQueryTestSuite.getIds(criteriaEmployees))) {
            AdvancedCriteriaQueryTestSuite.fail((String)("jpql: " + jpqlIds + "; criteria: " + criteriaIds));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSubqueryExists() {
        List criteriaEmployees;
        List jpqlEmployees;
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            jpqlEmployees = em.createQuery("SELECT e FROM Employee e WHERE EXISTS (SELECT p FROM e.projects p)").getResultList();
            em.clear();
            CriteriaBuilder qbuilder = em.getCriteriaBuilder();
            CriteriaQuery cquery = qbuilder.createQuery(Employee.class);
            Root customer = cquery.from(Employee.class);
            Subquery sq = cquery.subquery(Project.class);
            Root sqc = sq.correlate(customer);
            Join sqo = sqc.join("projects");
            sq.select((Expression)sqo);
            cquery.where((Expression)qbuilder.exists(sq));
            TypedQuery tquery = em.createQuery(cquery);
            criteriaEmployees = tquery.getResultList();
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
        this.compareIds(jpqlEmployees, criteriaEmployees);
        for (Employee emp : criteriaEmployees) {
            AdvancedCriteriaQueryTestSuite.assertTrue((String)"Found someone without projects", (!emp.getProjects().isEmpty() ? 1 : 0) != 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSubqueryNotExists() {
        List criteriaEmployees;
        List jpqlEmployees;
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            jpqlEmployees = em.createQuery("SELECT e FROM Employee e WHERE NOT EXISTS (SELECT p FROM e.projects p)").getResultList();
            em.clear();
            CriteriaBuilder qbuilder = em.getCriteriaBuilder();
            CriteriaQuery cquery = qbuilder.createQuery(Employee.class);
            Root customer = cquery.from(Employee.class);
            Subquery sq = cquery.subquery(Project.class);
            Root sqc = sq.correlate(customer);
            Join sqo = sqc.join("projects");
            sq.select((Expression)sqo);
            cquery.where((Expression)qbuilder.not((Expression)qbuilder.exists(sq)));
            TypedQuery tquery = em.createQuery(cquery);
            criteriaEmployees = tquery.getResultList();
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
        this.compareIds(jpqlEmployees, criteriaEmployees);
        for (Employee emp : criteriaEmployees) {
            AdvancedCriteriaQueryTestSuite.assertTrue((String)"Found someone with projects", (boolean)emp.getProjects().isEmpty());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSubqueryExistsAfterAnd() {
        List criteriaEmployees;
        List jpqlEmployees;
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            jpqlEmployees = em.createQuery("SELECT e FROM Employee e WHERE e.gender = org.eclipse.persistence.testing.models.jpa.advanced.Employee.Gender.Male AND EXISTS (SELECT p FROM e.projects p)").getResultList();
            em.clear();
            CriteriaBuilder qbuilder = em.getCriteriaBuilder();
            CriteriaQuery cquery = qbuilder.createQuery(Employee.class);
            Root customer = cquery.from(Employee.class);
            Subquery sq = cquery.subquery(Project.class);
            Root sqc = sq.correlate(customer);
            Join sqo = sqc.join("projects");
            sq.select((Expression)sqo);
            Predicate isMale = qbuilder.equal((Expression)customer.get("gender"), (Object)Employee.Gender.Male);
            cquery.where((Expression)qbuilder.and((Expression)isMale, (Expression)qbuilder.exists(sq)));
            TypedQuery tquery = em.createQuery(cquery);
            criteriaEmployees = tquery.getResultList();
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
        this.compareIds(jpqlEmployees, criteriaEmployees);
        for (Employee emp : criteriaEmployees) {
            AdvancedCriteriaQueryTestSuite.assertTrue((String)"Found someone not male", (emp.getGender() != null && emp.isMale() ? 1 : 0) != 0);
            AdvancedCriteriaQueryTestSuite.assertTrue((String)"Found someone without projects", (!emp.getProjects().isEmpty() ? 1 : 0) != 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSubqueryExistsBeforeAnd() {
        List criteriaEmployees;
        List jpqlEmployees;
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            jpqlEmployees = em.createQuery("SELECT e FROM Employee e WHERE EXISTS (SELECT p FROM e.projects p) AND e.gender = org.eclipse.persistence.testing.models.jpa.advanced.Employee.Gender.Male").getResultList();
            em.clear();
            CriteriaBuilder qbuilder = em.getCriteriaBuilder();
            CriteriaQuery cquery = qbuilder.createQuery(Employee.class);
            Root customer = cquery.from(Employee.class);
            Subquery sq = cquery.subquery(Project.class);
            Root sqc = sq.correlate(customer);
            Join sqo = sqc.join("projects");
            sq.select((Expression)sqo);
            Predicate isMale = qbuilder.equal((Expression)customer.get("gender"), (Object)Employee.Gender.Male);
            cquery.where((Expression)qbuilder.and((Expression)qbuilder.exists(sq), (Expression)isMale));
            TypedQuery tquery = em.createQuery(cquery);
            criteriaEmployees = tquery.getResultList();
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
        this.compareIds(jpqlEmployees, criteriaEmployees);
        for (Employee emp : criteriaEmployees) {
            AdvancedCriteriaQueryTestSuite.assertTrue((String)"Found someone not male", (emp.getGender() != null && emp.isMale() ? 1 : 0) != 0);
            AdvancedCriteriaQueryTestSuite.assertTrue((String)"Found someone without projects", (!emp.getProjects().isEmpty() ? 1 : 0) != 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSubqueryNotExistsAfterAnd() {
        List criteriaEmployees;
        List jpqlEmployees;
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            jpqlEmployees = em.createQuery("SELECT e FROM Employee e WHERE e.gender = org.eclipse.persistence.testing.models.jpa.advanced.Employee.Gender.Female AND NOT EXISTS (SELECT p FROM e.projects p)").getResultList();
            em.clear();
            CriteriaBuilder qbuilder = em.getCriteriaBuilder();
            CriteriaQuery cquery = qbuilder.createQuery(Employee.class);
            Root customer = cquery.from(Employee.class);
            Subquery sq = cquery.subquery(Project.class);
            Root sqc = sq.correlate(customer);
            Join sqo = sqc.join("projects");
            sq.select((Expression)sqo);
            Predicate isFemale = qbuilder.equal((Expression)customer.get("gender"), (Object)Employee.Gender.Female);
            cquery.where((Expression)qbuilder.and((Expression)isFemale, (Expression)qbuilder.not((Expression)qbuilder.exists(sq))));
            TypedQuery tquery = em.createQuery(cquery);
            criteriaEmployees = tquery.getResultList();
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
        this.compareIds(jpqlEmployees, criteriaEmployees);
        for (Employee emp : criteriaEmployees) {
            AdvancedCriteriaQueryTestSuite.assertTrue((String)"Found someone not female", (emp.getGender() != null && emp.isFemale() ? 1 : 0) != 0);
            AdvancedCriteriaQueryTestSuite.assertTrue((String)"Found someone with projects", (boolean)emp.getProjects().isEmpty());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSubqueryNotExistsBeforeAnd() {
        List criteriaEmployees;
        List jpqlEmployees;
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            jpqlEmployees = em.createQuery("SELECT e FROM Employee e WHERE NOT EXISTS (SELECT p FROM e.projects p) AND e.gender = org.eclipse.persistence.testing.models.jpa.advanced.Employee.Gender.Female").getResultList();
            em.clear();
            CriteriaBuilder qbuilder = em.getCriteriaBuilder();
            CriteriaQuery cquery = qbuilder.createQuery(Employee.class);
            Root customer = cquery.from(Employee.class);
            Subquery sq = cquery.subquery(Project.class);
            Root sqc = sq.correlate(customer);
            Join sqo = sqc.join("projects");
            sq.select((Expression)sqo);
            Predicate isFemale = qbuilder.equal((Expression)customer.get("gender"), (Object)Employee.Gender.Female);
            cquery.where((Expression)qbuilder.and((Expression)qbuilder.not((Expression)qbuilder.exists(sq)), (Expression)isFemale));
            TypedQuery tquery = em.createQuery(cquery);
            criteriaEmployees = tquery.getResultList();
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
        this.compareIds(jpqlEmployees, criteriaEmployees);
        for (Employee emp : criteriaEmployees) {
            AdvancedCriteriaQueryTestSuite.assertTrue((String)"Found someone not female", (emp.getGender() != null && emp.isFemale() ? 1 : 0) != 0);
            AdvancedCriteriaQueryTestSuite.assertTrue((String)"Found someone with projects", (boolean)emp.getProjects().isEmpty());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSubqueryExistsNested() {
        List criteriaEmployees;
        List jpqlEmployees;
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            jpqlEmployees = em.createQuery("SELECT e FROM Employee e join e.projects ep WHERE EXISTS (SELECT p FROM Project p WHERE ep = p AND EXISTS (SELECT t FROM Employee t WHERE p.teamLeader = t))").getResultList();
            em.clear();
            CriteriaBuilder builder = em.getCriteriaBuilder();
            CriteriaQuery mainQuery = builder.createQuery(Employee.class);
            Subquery subQuery1 = mainQuery.subquery(Object.class);
            Subquery subQuery2 = subQuery1.subquery(Object.class);
            Root mainEmployee = mainQuery.from(Employee.class);
            mainQuery.select((Selection)mainEmployee);
            Root sub1Project = subQuery1.from(Project.class);
            Join mainEmployeeProjects = mainEmployee.join("projects");
            Root sub2Employee = subQuery2.from(Employee.class);
            Join sub1ProjectTeamLeader = sub1Project.join("teamLeader");
            subQuery2.where((Expression)builder.equal((Expression)sub2Employee, (Expression)sub1ProjectTeamLeader));
            subQuery1.where((Expression)builder.and((Expression)builder.exists(subQuery2), (Expression)builder.equal((Expression)sub1Project, (Expression)mainEmployeeProjects)));
            mainQuery.where((Expression)builder.exists(subQuery1));
            TypedQuery tquery = em.createQuery(mainQuery);
            criteriaEmployees = tquery.getResultList();
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
        this.compareIds(jpqlEmployees, criteriaEmployees);
        for (Employee emp : criteriaEmployees) {
            AdvancedCriteriaQueryTestSuite.assertTrue((String)"Found someone without projects", (!emp.getProjects().isEmpty() ? 1 : 0) != 0);
            boolean atLeastOneProjectHasLeader = false;
            for (Project proj : emp.getProjects()) {
                if (proj.getTeamLeader() == null) continue;
                atLeastOneProjectHasLeader = true;
                break;
            }
            AdvancedCriteriaQueryTestSuite.assertTrue((String)"None of employee's projects has a leader", (boolean)atLeastOneProjectHasLeader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSubqueryExistsNestedUnusedRoot() {
        List criteriaEmployees;
        List jpqlEmployees;
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            jpqlEmployees = em.createQuery("SELECT e FROM Employee e join e.projects ep WHERE EXISTS (SELECT p FROM Project p WHERE ep = p AND EXISTS (SELECT t FROM Employee t WHERE p.teamLeader = t))").getResultList();
            em.clear();
            CriteriaBuilder builder = em.getCriteriaBuilder();
            CriteriaQuery mainQuery = builder.createQuery(Employee.class);
            Subquery subQuery1 = mainQuery.subquery(Object.class);
            Subquery subQuery2 = subQuery1.subquery(Object.class);
            mainQuery.from(Dealer.class);
            Root mainEmployee = mainQuery.from(Employee.class);
            mainQuery.from(Address.class);
            mainQuery.select((Selection)mainEmployee);
            Root sub1Project = subQuery1.from(Project.class);
            Join mainEmployeeProjects = mainEmployee.join("projects");
            Root sub2Employee = subQuery2.from(Employee.class);
            Join sub1ProjectTeamLeader = sub1Project.join("teamLeader");
            subQuery2.where((Expression)builder.equal((Expression)sub2Employee, (Expression)sub1ProjectTeamLeader));
            subQuery1.where((Expression)builder.and((Expression)builder.exists(subQuery2), (Expression)builder.equal((Expression)sub1Project, (Expression)mainEmployeeProjects)));
            mainQuery.where((Expression)builder.exists(subQuery1));
            TypedQuery tquery = em.createQuery(mainQuery);
            criteriaEmployees = tquery.getResultList();
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
        this.compareIds(jpqlEmployees, criteriaEmployees);
        for (Employee emp : criteriaEmployees) {
            AdvancedCriteriaQueryTestSuite.assertTrue((String)"Found someone without projects", (!emp.getProjects().isEmpty() ? 1 : 0) != 0);
            boolean atLeastOneProjectHasLeader = false;
            for (Project proj : emp.getProjects()) {
                if (proj.getTeamLeader() == null) continue;
                atLeastOneProjectHasLeader = true;
                break;
            }
            AdvancedCriteriaQueryTestSuite.assertTrue((String)"None of employee's projects has a leader", (boolean)atLeastOneProjectHasLeader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSubqueryExistsNestedAfterAnd() {
        List criteriaEmployees;
        List jpqlEmployees;
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            jpqlEmployees = em.createQuery("SELECT e FROM Employee e join e.projects ep WHERE e.gender = org.eclipse.persistence.testing.models.jpa.advanced.Employee.Gender.Male AND EXISTS (SELECT p FROM Project p WHERE 'Sales Reporting' <> p.name AND ep = p AND EXISTS (SELECT t FROM Employee t WHERE p.teamLeader = t))").getResultList();
            em.clear();
            CriteriaBuilder builder = em.getCriteriaBuilder();
            CriteriaQuery mainQuery = builder.createQuery(Employee.class);
            Subquery subQuery1 = mainQuery.subquery(Object.class);
            Subquery subQuery2 = subQuery1.subquery(Object.class);
            Root mainEmployee = mainQuery.from(Employee.class);
            mainQuery.select((Selection)mainEmployee);
            Root sub1Project = subQuery1.from(Project.class);
            Join mainEmployeeProjects = mainEmployee.join("projects");
            Root sub2Employee = subQuery2.from(Employee.class);
            Join sub1ProjectTeamLeader = sub1Project.join("teamLeader");
            subQuery2.where((Expression)builder.equal((Expression)sub2Employee, (Expression)sub1ProjectTeamLeader));
            Predicate notSalesReporting = builder.not((Expression)builder.equal(builder.literal((Object)"Sales Reporting"), (Expression)sub1Project.get("name")));
            subQuery1.where((Expression)builder.and((Expression)notSalesReporting, (Expression)builder.and((Expression)builder.exists(subQuery2), (Expression)builder.equal((Expression)sub1Project, (Expression)mainEmployeeProjects))));
            Predicate isMale = builder.equal((Expression)mainEmployee.get("gender"), (Object)Employee.Gender.Male);
            mainQuery.where((Expression)builder.and((Expression)isMale, (Expression)builder.exists(subQuery1)));
            TypedQuery tquery = em.createQuery(mainQuery);
            criteriaEmployees = tquery.getResultList();
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
        this.compareIds(jpqlEmployees, criteriaEmployees);
        for (Employee emp : criteriaEmployees) {
            AdvancedCriteriaQueryTestSuite.assertTrue((String)"Found someone not male", (emp.getGender() != null && emp.isMale() ? 1 : 0) != 0);
            AdvancedCriteriaQueryTestSuite.assertTrue((String)"Found someone without projects", (!emp.getProjects().isEmpty() ? 1 : 0) != 0);
            boolean atLeastOneProjectHasLeader = false;
            for (Project proj : emp.getProjects()) {
                if (proj.getName().equals("Sales Reporting") || proj.getTeamLeader() == null) continue;
                atLeastOneProjectHasLeader = true;
                break;
            }
            AdvancedCriteriaQueryTestSuite.assertTrue((String)"None of employee's projects has a leader", (boolean)atLeastOneProjectHasLeader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSubqueryExistsNestedAfterLiteralAnd() {
        List criteriaEmployees;
        List jpqlEmployees;
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            jpqlEmployees = em.createQuery("SELECT e FROM Employee e join e.projects ep WHERE EXISTS (SELECT p FROM Project p WHERE ep = p AND EXISTS (SELECT t FROM Employee t WHERE p.teamLeader = t))").getResultList();
            em.clear();
            CriteriaBuilder builder = em.getCriteriaBuilder();
            CriteriaQuery mainQuery = builder.createQuery(Employee.class);
            Subquery subQuery1 = mainQuery.subquery(Object.class);
            Subquery subQuery2 = subQuery1.subquery(Object.class);
            Root mainEmployee = mainQuery.from(Employee.class);
            mainQuery.select((Selection)mainEmployee);
            Root sub1Project = subQuery1.from(Project.class);
            Join mainEmployeeProjects = mainEmployee.join("projects");
            Root sub2Employee = subQuery2.from(Employee.class);
            Join sub1ProjectTeamLeader = sub1Project.join("teamLeader");
            subQuery2.where((Expression)builder.equal((Expression)sub2Employee, (Expression)sub1ProjectTeamLeader));
            Predicate oneEqualsOne = builder.equal(builder.literal((Object)1), builder.literal((Object)1));
            subQuery1.where((Expression)builder.and((Expression)oneEqualsOne, (Expression)builder.and((Expression)builder.exists(subQuery2), (Expression)builder.equal((Expression)sub1Project, (Expression)mainEmployeeProjects))));
            Predicate twoEqualsTwo = builder.equal(builder.literal((Object)2), builder.literal((Object)2));
            mainQuery.where((Expression)builder.and((Expression)twoEqualsTwo, (Expression)builder.exists(subQuery1)));
            TypedQuery tquery = em.createQuery(mainQuery);
            criteriaEmployees = tquery.getResultList();
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
        this.compareIds(jpqlEmployees, criteriaEmployees);
        for (Employee emp : criteriaEmployees) {
            AdvancedCriteriaQueryTestSuite.assertTrue((String)"Found someone without projects", (!emp.getProjects().isEmpty() ? 1 : 0) != 0);
            boolean atLeastOneProjectHasLeader = false;
            for (Project proj : emp.getProjects()) {
                if (proj.getTeamLeader() == null) continue;
                atLeastOneProjectHasLeader = true;
                break;
            }
            AdvancedCriteriaQueryTestSuite.assertTrue((String)"None of employee's projects has a leader", (boolean)atLeastOneProjectHasLeader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCursors() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            TypedQuery query = em.createQuery(em.getCriteriaBuilder().createQuery(Employee.class));
            query.setHint("eclipselink.cursor", (Object)true);
            query.setHint("eclipselink.cursor.initial-size", (Object)2);
            query.setHint("eclipselink.cursor.page-size", (Object)5);
            query.setHint("eclipselink.cursor.size-sql", (Object)"Select count(*) from CMP3_EMPLOYEE");
            Cursor cursor = (Cursor)query.getSingleResult();
            cursor.nextElement();
            cursor.size();
            cursor.close();
            JpaQuery jpaQuery = (JpaQuery)((EntityManager)em.getDelegate()).createQuery(em.getCriteriaBuilder().createQuery(Employee.class));
            jpaQuery.setHint("eclipselink.cursor", (Object)true);
            cursor = jpaQuery.getResultCursor();
            cursor.nextElement();
            cursor.size();
            cursor.close();
            jpaQuery = (JpaQuery)((EntityManager)em.getDelegate()).createQuery(em.getCriteriaBuilder().createQuery(Employee.class));
            jpaQuery.setHint("eclipselink.cursor.scrollable", (Object)true);
            jpaQuery.setHint("eclipselink.cursor.scrollable.result-set-concurrency", (Object)"ReadOnly");
            String resultSetType = "ScrollInsensitive";
            if (this.getPlatform().isHANA()) {
                resultSetType = "ForwardOnly";
            }
            jpaQuery.setHint("eclipselink.cursor.scrollable.result-set-type", (Object)resultSetType);
            ScrollableCursor scrollableCursor = (ScrollableCursor)jpaQuery.getResultCursor();
            scrollableCursor.next();
            scrollableCursor.close();
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testObjectResultType() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            List listResult;
            TypedQuery query = em.createQuery(em.getCriteriaBuilder().createQuery(Employee.class));
            List result = query.getResultList();
            Employee employee = (Employee)result.get(0);
            CriteriaBuilder qb = em.getCriteriaBuilder();
            CriteriaQuery cq = qb.createQuery(Object[].class);
            Root from = cq.from(Employee.class);
            cq.multiselect(new Selection[]{from, from.get("address"), from.get("id")});
            ParameterExpression firstNameParam = qb.parameter(from.get("firstName").getModel().getBindableJavaType(), "firstName");
            cq.where((Expression)qb.and((Expression)qb.equal((Expression)from.get("id"), (Expression)qb.parameter(from.get("id").getModel().getBindableJavaType(), "id")), (Expression)qb.equal((Expression)from.get("firstName"), (Object)firstNameParam)));
            query = em.createQuery(cq);
            query.setParameter("id", (Object)employee.getId());
            query.setParameter((Parameter)firstNameParam, (Object)employee.getFirstName());
            Object[] arrayResult = (Object[])query.getSingleResult();
            if (arrayResult.length != 3 && arrayResult[0] != employee || arrayResult[1] != employee.getAddress() || !arrayResult[2].equals(employee.getId())) {
                AdvancedCriteriaQueryTestSuite.fail((String)("Array result not correct: " + arrayResult));
            }
            if ((arrayResult = (Object[])(listResult = query.getResultList()).get(0)).length != 3 || arrayResult[0] != employee || arrayResult[1] != employee.getAddress() || !arrayResult[2].equals(employee.getId())) {
                AdvancedCriteriaQueryTestSuite.fail((String)("Array result not correct: " + arrayResult));
            }
            cq = qb.createQuery(Object[].class);
            from = cq.from(Employee.class);
            cq.multiselect(new Selection[]{from.get("id")});
            cq.where((Expression)qb.and((Expression)qb.equal((Expression)from.get("id"), (Expression)qb.parameter(from.get("id").getModel().getBindableJavaType(), "id")), (Expression)qb.equal((Expression)from.get("firstName"), (Expression)qb.parameter(from.get("firstName").getModel().getBindableJavaType(), "firstName"))));
            query = em.createQuery(cq);
            query.setHint("eclipselink.result-type", (Object)"Array");
            query.setParameter("id", (Object)employee.getId());
            query.setParameter("firstName", (Object)employee.getFirstName());
            arrayResult = (Object[])query.getSingleResult();
            if (arrayResult.length != 1 || !arrayResult[0].equals(employee.getId())) {
                AdvancedCriteriaQueryTestSuite.fail((String)("Array result not correct: " + arrayResult));
            }
            if ((arrayResult = (Object[])(listResult = query.getResultList()).get(0)).length != 1 || !arrayResult[0].equals(employee.getId())) {
                AdvancedCriteriaQueryTestSuite.fail((String)("Array result not correct: " + arrayResult));
            }
            cq = qb.createQuery(Object[].class);
            from = cq.from(Employee.class);
            cq.multiselect(new Selection[]{from.alias("employee"), from.get("address").alias("address"), from.get("id").alias("id")});
            cq.where((Expression)qb.and((Expression)qb.equal((Expression)from.get("id"), (Expression)qb.parameter(from.get("id").getModel().getBindableJavaType(), "id")), (Expression)qb.equal((Expression)from.get("firstName"), (Expression)qb.parameter(from.get("firstName").getModel().getBindableJavaType(), "firstName"))));
            query = em.createQuery(cq);
            query.setHint("eclipselink.result-type", (Object)"Map");
            query.setParameter("id", (Object)employee.getId());
            query.setParameter("firstName", (Object)employee.getFirstName());
            Map mapResult = (Map)query.getSingleResult();
            if (mapResult.size() != 3 || mapResult.get("employee") != employee || mapResult.get("address") != employee.getAddress() || !mapResult.get("id").equals(employee.getId())) {
                AdvancedCriteriaQueryTestSuite.fail((String)("Map result not correct: " + mapResult));
            }
            if ((mapResult = (Map)(listResult = query.getResultList()).get(0)).size() != 3 || mapResult.get("employee") != employee || mapResult.get("address") != employee.getAddress() || !mapResult.get("id").equals(employee.getId())) {
                AdvancedCriteriaQueryTestSuite.fail((String)("Map result not correct: " + mapResult));
            }
            cq = qb.createQuery(Object[].class);
            from = cq.from(Employee.class);
            cq.multiselect(new Selection[]{from.get("id").alias("id")});
            cq.where((Expression)qb.and((Expression)qb.equal((Expression)from.get("id"), (Expression)qb.parameter(from.get("id").getModel().getBindableJavaType(), "id")), (Expression)qb.equal((Expression)from.get("firstName"), (Expression)qb.parameter(from.get("firstName").getModel().getBindableJavaType(), "firstName"))));
            query = em.createQuery(cq);
            query.setHint("eclipselink.result-type", (Object)"Map");
            query.setParameter("id", (Object)employee.getId());
            query.setParameter("firstName", (Object)employee.getFirstName());
            mapResult = (Map)query.getSingleResult();
            if (mapResult.size() != 1 || !mapResult.get("id").equals(employee.getId())) {
                AdvancedCriteriaQueryTestSuite.fail((String)("Map result not correct: " + mapResult));
            }
            if ((mapResult = (Map)(listResult = query.getResultList()).get(0)).size() != 1 || !mapResult.get("id").equals(employee.getId())) {
                AdvancedCriteriaQueryTestSuite.fail((String)("Map result not correct: " + mapResult));
            }
            cq = qb.createQuery(Employee.class);
            from = cq.from(Employee.class);
            cq.where((Expression)qb.and((Expression)qb.equal((Expression)from.get("id"), (Expression)qb.parameter(from.get("id").getModel().getBindableJavaType(), "id")), (Expression)qb.equal((Expression)from.get("firstName"), (Expression)qb.parameter(from.get("firstName").getModel().getBindableJavaType(), "firstName"))));
            query = em.createQuery(cq);
            query.setHint("eclipselink.query-type", (Object)"Report");
            query.setHint("eclipselink.result-type", (Object)"Array");
            query.setParameter("id", (Object)employee.getId());
            query.setParameter("firstName", (Object)employee.getFirstName());
            arrayResult = (Object[])query.getSingleResult();
            if (arrayResult[0] != employee) {
                AdvancedCriteriaQueryTestSuite.fail((String)("Array result not correct: " + arrayResult));
            }
            cq = qb.createQuery(Object[].class);
            from = cq.from(Employee.class);
            cq.multiselect(new Selection[]{from.get("id")});
            cq.where((Expression)qb.and((Expression)qb.equal((Expression)from.get("id"), (Expression)qb.parameter(from.get("id").getModel().getBindableJavaType(), "id")), (Expression)qb.equal((Expression)from.get("firstName"), (Expression)qb.parameter(from.get("firstName").getModel().getBindableJavaType(), "firstName"))));
            query = em.createQuery(cq);
            query.setParameter("id", (Object)employee.getId());
            query.setParameter("firstName", (Object)employee.getFirstName());
            Object valueResult = query.getSingleResult();
            if (!valueResult.equals(employee.getId())) {
                AdvancedCriteriaQueryTestSuite.fail((String)("Value result not correct: " + valueResult));
            }
            if (!(valueResult = (listResult = query.getResultList()).get(0)).equals(employee.getId())) {
                AdvancedCriteriaQueryTestSuite.fail((String)("Value result not correct: " + valueResult));
            }
            cq = qb.createQuery(Object[].class);
            from = cq.from(Employee.class);
            cq.multiselect(new Selection[]{from.get("id"), from.get("firstName")});
            cq.where((Expression)qb.and((Expression)qb.equal((Expression)from.get("id"), (Expression)qb.parameter(from.get("id").getModel().getBindableJavaType(), "id")), (Expression)qb.equal((Expression)from.get("firstName"), (Expression)qb.parameter(from.get("firstName").getModel().getBindableJavaType(), "firstName"))));
            query = em.createQuery(cq);
            query.setHint("eclipselink.result-type", (Object)"Value");
            query.setParameter("id", (Object)employee.getId());
            query.setParameter("firstName", (Object)employee.getFirstName());
            valueResult = query.getSingleResult();
            if (!valueResult.equals(employee.getId())) {
                AdvancedCriteriaQueryTestSuite.fail((String)("Value result not correct: " + valueResult));
            }
            cq = qb.createQuery(Object[].class);
            from = cq.from(Employee.class);
            cq.multiselect(new Selection[]{from.get("id")});
            cq.where((Expression)qb.and((Expression)qb.equal((Expression)from.get("id"), (Expression)qb.parameter(from.get("id").getModel().getBindableJavaType(), "id")), (Expression)qb.equal((Expression)from.get("firstName"), (Expression)qb.parameter(from.get("firstName").getModel().getBindableJavaType(), "firstName"))));
            query = em.createQuery(cq);
            query.setHint("eclipselink.result-type", (Object)"Attribute");
            query.setParameter("id", (Object)employee.getId());
            query.setParameter("firstName", (Object)employee.getFirstName());
            valueResult = query.getSingleResult();
            if (!valueResult.equals(employee.getId())) {
                AdvancedCriteriaQueryTestSuite.fail((String)("Value result not correct: " + valueResult));
            }
            if (!(valueResult = (listResult = query.getResultList()).get(0)).equals(employee.getId())) {
                AdvancedCriteriaQueryTestSuite.fail((String)("Value result not correct: " + valueResult));
            }
        }
        finally {
            this.rollbackTransaction(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testQueryExactPrimaryKeyCacheHits() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        QuerySQLTracker counter = null;
        try {
            CriteriaBuilder qb = em.getCriteriaBuilder();
            CriteriaQuery cq = qb.createQuery(Employee.class);
            TypedQuery query = em.createQuery(cq);
            List result = query.getResultList();
            Employee employee = (Employee)result.get(0);
            counter = new QuerySQLTracker((Session)AdvancedCriteriaQueryTestSuite.getServerSession());
            cq = qb.createQuery(Employee.class);
            Root from = cq.from(Employee.class);
            cq.where((Expression)qb.equal((Expression)from.get("id"), (Expression)qb.parameter(from.get("id").getModel().getBindableJavaType(), "id")));
            query = em.createQuery(cq);
            query.setHint("eclipselink.cache-usage", (Object)"CheckCacheByExactPrimaryKey");
            query.setParameter("id", (Object)employee.getId());
            Employee queryResult = (Employee)query.getSingleResult();
            if (queryResult != employee) {
                AdvancedCriteriaQueryTestSuite.fail((String)("Employees are not equal: " + employee + ", " + queryResult));
            }
            if (counter.getSqlStatements().size() > 0) {
                AdvancedCriteriaQueryTestSuite.fail((String)("Cache hit do not occur: " + counter.getSqlStatements()));
            }
        }
        finally {
            this.rollbackTransaction(em);
            if (counter != null) {
                counter.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testQueryHintFetch() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            CriteriaQuery cq = em.getCriteriaBuilder().createQuery(Employee.class);
            CriteriaBuilder qb = em.getCriteriaBuilder();
            Root root = cq.from(em.getMetamodel().entity(Employee.class));
            cq.where((Expression)qb.equal((Expression)root.get("firstName"), qb.literal((Object)"Bob")));
            TypedQuery tq = em.createQuery(cq);
            tq.setHint("eclipselink.join-fetch", (Object)"e.projects");
            List result = tq.getResultList();
            AdvancedCriteriaQueryTestSuite.assertFalse((String)"No Employees were returned", (boolean)result.isEmpty());
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            try {
                ObjectOutputStream stream = new ObjectOutputStream(byteStream);
                stream.writeObject(result.get(0));
                stream.flush();
                byte[] arr = byteStream.toByteArray();
                ByteArrayInputStream inByteStream = new ByteArrayInputStream(arr);
                ObjectInputStream inObjStream = new ObjectInputStream(inByteStream);
                Employee emp = (Employee)inObjStream.readObject();
                AdvancedCriteriaQueryTestSuite.assertTrue((String)"Did not return Employee", (boolean)emp.getClass().equals(Employee.class));
                AdvancedCriteriaQueryTestSuite.assertTrue((String)"Employee had wrong firstname", (boolean)emp.getFirstName().equalsIgnoreCase("bob"));
                emp.getProjects().size();
            }
            catch (IOException e) {
                AdvancedCriteriaQueryTestSuite.fail((String)"Failed during serialization");
            }
            catch (ClassNotFoundException e) {
                AdvancedCriteriaQueryTestSuite.fail((String)"Failed during serialization");
            }
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testProd() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            CriteriaBuilder qbuilder = em.getCriteriaBuilder();
            CriteriaQuery cquery = qbuilder.createQuery(BigInteger.class);
            Root customer = cquery.from(Employee.class);
            cquery.select((Selection)qbuilder.toBigInteger(qbuilder.prod(qbuilder.literal((Object)BigInteger.valueOf(5L)), (Expression)customer.get("salary"))));
            TypedQuery tquery = em.createQuery(cquery);
            List result = tquery.getResultList();
            for (BigInteger value : result) {
                AdvancedCriteriaQueryTestSuite.assertTrue((String)"Incorrect arithmatic returned ", (boolean)value.mod(BigInteger.valueOf(5L)).equals(BigInteger.valueOf(0L)));
            }
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testQueryCacheFirstCacheHits() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        QuerySQLTracker counter = null;
        try {
            CriteriaBuilder qb = em.getCriteriaBuilder();
            CriteriaQuery cq = qb.createQuery(Employee.class);
            TypedQuery query = em.createQuery(cq);
            List result = query.getResultList();
            Employee employee = (Employee)result.get(result.size() - 1);
            counter = new QuerySQLTracker((Session)AdvancedCriteriaQueryTestSuite.getServerSession());
            cq = qb.createQuery(Employee.class);
            Root from = cq.from(Employee.class);
            cq.where((Expression)qb.equal((Expression)from.get("firstName"), (Expression)qb.parameter(from.get("firstName").getModel().getBindableJavaType(), "firstName")));
            query = em.createQuery(cq);
            query.setHint("eclipselink.cache-usage", (Object)"CheckCacheThenDatabase");
            query.setParameter("firstName", (Object)employee.getFirstName());
            Employee queryResult = (Employee)query.getSingleResult();
            if (!queryResult.getFirstName().equals(employee.getFirstName())) {
                AdvancedCriteriaQueryTestSuite.fail((String)("Employees are not equal: " + employee + ", " + queryResult));
            }
            if (counter.getSqlStatements().size() > 0) {
                AdvancedCriteriaQueryTestSuite.fail((String)("Cache hit do not occur: " + counter.getSqlStatements()));
            }
        }
        finally {
            this.rollbackTransaction(em);
            if (counter != null) {
                counter.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testQueryCacheOnlyCacheHits() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        QuerySQLTracker counter = null;
        try {
            CriteriaBuilder qb = em.getCriteriaBuilder();
            CriteriaQuery cq = qb.createQuery(Employee.class);
            TypedQuery query = em.createQuery(cq);
            List result = query.getResultList();
            Employee employee = (Employee)result.get(result.size() - 1);
            counter = new QuerySQLTracker((Session)AdvancedCriteriaQueryTestSuite.getServerSession());
            cq = qb.createQuery(Employee.class);
            Root from = cq.from(Employee.class);
            cq.where((Expression)qb.equal((Expression)from.get("firstName"), (Expression)qb.parameter(from.get("firstName").getModel().getBindableJavaType(), "firstName")));
            query = em.createQuery(cq);
            query.setHint("eclipselink.cache-usage", (Object)"CheckCacheOnly");
            query.setParameter("firstName", (Object)employee.getFirstName());
            query.getResultList();
            if (counter.getSqlStatements().size() > 0) {
                AdvancedCriteriaQueryTestSuite.fail((String)("Cache hit do not occur: " + counter.getSqlStatements()));
            }
        }
        finally {
            this.rollbackTransaction(em);
            if (counter != null) {
                counter.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testQueryCacheOnlyCacheHitsOnSession() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        QuerySQLTracker counter = null;
        try {
            CriteriaBuilder qb = em.getCriteriaBuilder();
            CriteriaQuery cq = qb.createQuery(Employee.class);
            TypedQuery query = em.createQuery(cq);
            List result = query.getResultList();
            Employee employee = (Employee)result.get(result.size() - 1);
            counter = new QuerySQLTracker((Session)AdvancedCriteriaQueryTestSuite.getServerSession());
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
            em = this.createEntityManager();
            this.beginTransaction(em);
            cq = qb.createQuery(Employee.class);
            Root from = cq.from(Employee.class);
            cq.where((Expression)qb.equal((Expression)from.get("id"), (Expression)qb.parameter(from.get("id").getModel().getBindableJavaType(), "id")));
            query = em.createQuery(cq);
            query.setHint("eclipselink.query-type", (Object)"ReadObject");
            query.setHint("eclipselink.cache-usage", (Object)"CheckCacheOnly");
            query.setParameter("id", (Object)employee.getId());
            if (query.getSingleResult() == null) {
                AdvancedCriteriaQueryTestSuite.fail((String)"Query did not check session cache.");
            }
            if (counter.getSqlStatements().size() > 0) {
                AdvancedCriteriaQueryTestSuite.fail((String)("Cache hit do not occur: " + counter.getSqlStatements()));
            }
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
            em = this.createEntityManager();
            this.beginTransaction(em);
            cq = qb.createQuery(Employee.class);
            from = cq.from(Employee.class);
            cq.where((Expression)qb.equal((Expression)from.get("id"), (Expression)qb.parameter(from.get("id").getModel().getBindableJavaType(), "id")));
            query = em.createQuery(cq);
            query.setHint("eclipselink.cache-usage", (Object)"CheckCacheOnly");
            query.setParameter("id", (Object)employee.getId());
            if (query.getResultList().size() != 1) {
                AdvancedCriteriaQueryTestSuite.fail((String)"Query did not check session cache.");
            }
            if (counter.getSqlStatements().size() > 0) {
                AdvancedCriteriaQueryTestSuite.fail((String)("Cache hit do not occur: " + counter.getSqlStatements()));
            }
        }
        finally {
            if (counter != null) {
                counter.remove();
            }
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUnusedJoinDoesNotAffectOtherJoins() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            CriteriaBuilder qbuilder = em.getCriteriaBuilder();
            CriteriaQuery cquery = qbuilder.createQuery(Employee.class);
            Root customer = cquery.from(Employee.class);
            Path pathToIgnore = customer.get("manager").get("address");
            Join manager = customer.join("manager", JoinType.LEFT);
            TypedQuery tquery = em.createQuery(cquery);
            List result = tquery.getResultList();
            AdvancedCriteriaQueryTestSuite.assertFalse((String)"No results found", (boolean)result.isEmpty());
            long count = (Long)em.createQuery("Select count(e) from Employee e ").getSingleResult();
            AdvancedCriteriaQueryTestSuite.assertTrue((String)"Incorrect number of results returned", ((long)result.size() == count ? 1 : 0) != 0);
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUnusedJoinDoesNotAffectFetchJoin() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            CriteriaBuilder qbuilder = em.getCriteriaBuilder();
            CriteriaQuery cquery = qbuilder.createQuery(Employee.class);
            Root customer = cquery.from(Employee.class);
            Path pathToIgnore = customer.get("manager").get("address");
            customer.fetch("manager", JoinType.LEFT);
            TypedQuery tquery = em.createQuery(cquery);
            List result = tquery.getResultList();
            AdvancedCriteriaQueryTestSuite.assertFalse((String)"No results found", (boolean)result.isEmpty());
            long count = (Long)em.createQuery("Select count(e) from Employee e ").getSingleResult();
            AdvancedCriteriaQueryTestSuite.assertTrue((String)"Incorrect number of results returned", ((long)result.size() == count ? 1 : 0) != 0);
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetRestrictionReturningCorrectPredicate() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            CriteriaBuilder builder = em.getCriteriaBuilder();
            CriteriaQuery criteriaQuery = builder.createQuery(Employee.class);
            Root root = criteriaQuery.from(Employee.class);
            criteriaQuery.where((Expression)builder.equal((Expression)root.get("firstName"), (Object)"Bob"));
            TypedQuery query1 = em.createQuery(criteriaQuery);
            List results1 = query1.getResultList();
            long count1 = (Long)em.createQuery("select count(e) from Employee e where e.firstName = 'Bob'").getSingleResult();
            Predicate predicate = criteriaQuery.getRestriction();
            AdvancedCriteriaQueryTestSuite.assertNotNull((String)"Predicate should be non-null", (Object)predicate);
            AdvancedCriteriaQueryTestSuite.assertTrue((String)("Invalid predicate type returned: " + predicate.getClass().getName()), (boolean)(predicate instanceof CompoundExpressionImpl));
            CompoundExpressionImpl compoundExpression = (CompoundExpressionImpl)predicate;
            List expressions = compoundExpression.getChildExpressions();
            AdvancedCriteriaQueryTestSuite.assertSame((String)"Predicate should have two child expressions", (Object)2, (Object)expressions.size());
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testJoinDuplication() throws NoSuchFieldException, IllegalAccessException {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            CriteriaBuilder qb = em.getCriteriaBuilder();
            CriteriaQuery cq = qb.createQuery(Employee.class);
            Root root = cq.from(Employee.class);
            root.join("manager");
            em.createQuery(cq);
            Field field = cq.getClass().getDeclaredField("joins");
            field.setAccessible(true);
            Set value = (Set)field.get(cq);
            AdvancedCriteriaQueryTestSuite.assertEquals((int)1, (int)value.size());
            em.createQuery(cq);
            ((CriteriaQueryImpl)cq).translate();
            value = (Set)field.get(cq);
            AdvancedCriteriaQueryTestSuite.assertEquals((int)1, (int)value.size());
        }
        finally {
            this.rollbackTransaction(em);
            this.closeEntityManager(em);
        }
    }
}

