/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.models.optimisticlocking;

import java.math.BigDecimal;
import java.sql.Timestamp;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.mappings.AggregateObjectMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.optimisticlocking.LockObject;
import org.eclipse.persistence.testing.models.optimisticlocking.TimestampVersion;
import org.eclipse.persistence.tools.schemaframework.TableDefinition;

public class TimestampInAggregateObject
extends LockObject {
    public TimestampVersion version = new TimestampVersion();

    public static RelationalDescriptor descriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(TimestampInAggregateObject.class);
        descriptor.setTableName("TSAO_LCK");
        descriptor.setPrimaryKeyFieldName("ID");
        descriptor.setSequenceNumberName("SEQ");
        descriptor.setSequenceNumberFieldName("ID");
        descriptor.useTimestampLocking("AGG_VERSION", false);
        descriptor.addDirectMapping("id", "ID");
        descriptor.addDirectMapping("value", "A_VALUE");
        AggregateObjectMapping aggregateobjectmapping = new AggregateObjectMapping();
        aggregateobjectmapping.setAttributeName("version");
        aggregateobjectmapping.setIsReadOnly(false);
        aggregateobjectmapping.setReferenceClass(TimestampVersion.class);
        aggregateobjectmapping.setIsNullAllowed(true);
        descriptor.addMapping((DatabaseMapping)aggregateobjectmapping);
        return descriptor;
    }

    public static TimestampInAggregateObject example1() {
        TimestampInAggregateObject tio = new TimestampInAggregateObject();
        tio.value = "1st";
        tio.version = new TimestampVersion();
        return tio;
    }

    public static TimestampInAggregateObject example2() {
        TimestampInAggregateObject tio = new TimestampInAggregateObject();
        tio.value = "2nd";
        tio.version = new TimestampVersion();
        tio.version.setVersionInfo("info2");
        return tio;
    }

    public static TimestampInAggregateObject example3() {
        TimestampInAggregateObject tio = new TimestampInAggregateObject();
        tio.value = "3rd";
        tio.version = new TimestampVersion();
        tio.version.setVersionInfo("info3");
        return tio;
    }

    public static TableDefinition tableDefinition() {
        TableDefinition definition = new TableDefinition();
        definition.setName("TSAO_LCK");
        definition.addIdentityField("ID", BigDecimal.class, 15);
        definition.addField("A_VALUE", String.class, 30);
        definition.addField("AGG_VERSION", Timestamp.class);
        definition.addField("AGG_INFO", String.class, 30);
        return definition;
    }

    @Override
    public void verify(TestCase testCase) {
        if (this.version.t_id == null) {
            throw new TestErrorException("Value did not get set in object");
        }
    }
}

