/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.aggregate;

import java.util.Collection;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.aggregate.Transport;

public class AggregateTransientValueTestCase
extends AutoVerifyTestCase {
    private int transportId = 0;
    Transport transport;

    public AggregateTransientValueTestCase() {
        this.setDescription("Test that transient value in the aggregate object is not reset");
    }

    public void reset() {
        DatabaseSession session = (DatabaseSession)this.getSession();
        UnitOfWork uow = session.acquireUnitOfWork();
        ExpressionBuilder transport = new ExpressionBuilder();
        Expression expression = transport.get("id").equal(this.transportId);
        uow.deleteAllObjects((Collection)uow.readAllObjects(Transport.class, expression));
        uow.commit();
    }

    public void setup() {
    }

    public void test() {
        this.transport = Transport.example6();
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        uow.registerObject((Object)this.transport);
        uow.commit();
        this.transportId = this.transport.getId();
        DatabaseSession session = (DatabaseSession)this.getSession();
        ExpressionBuilder exp = new ExpressionBuilder();
        Expression expression = exp.get("id").equal(this.transportId);
        this.transport = (Transport)session.readObject(Transport.class, expression);
    }

    public void verify() {
        if (this.transport.getVehicle() == null) {
            throw new TestErrorException("Transport.getVehicle() was null.");
        }
        if (this.transport.getVehicle().getTransientValue() == null) {
            throw new TestErrorException("TransientValue should not be null.");
        }
    }
}

