/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.clientserver;

import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.domain.SmallProject;
import org.eclipse.persistence.testing.tests.clientserver.Server;

public class Client2
extends Thread {
    protected Server server;
    protected Session clientSession;
    protected Session session;
    public Throwable exception;

    public Client2(Server server, Session session, String name) {
        super(name);
        this.server = server;
        this.session = session;
        this.clientSession = this.server.serverSession.acquireClientSession();
    }

    public void release() {
        this.clientSession.release();
    }

    @Override
    public void run() {
        try {
            ExpressionBuilder exb = new ExpressionBuilder();
            for (int i = 0; i < 5; ++i) {
                UnitOfWork uow = this.clientSession.acquireUnitOfWork();
                Employee readEmployee = (Employee)uow.readObject(Employee.class, exb.get("lastName").equal((Object)"MacIvor"));
                Employee newManagedEmployee = new Employee();
                newManagedEmployee.setFirstName(this.getName() + " Employee" + i);
                readEmployee.addManagedEmployee(newManagedEmployee);
                SmallProject newProject = new SmallProject();
                newProject.setName(this.getName() + " Project" + i);
                readEmployee.addProject(newProject);
                uow.commit();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.exception = t;
        }
    }
}

