/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.distributedservers.rcm;

import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.tests.distributedservers.DistributedServer;
import org.eclipse.persistence.testing.tests.distributedservers.DistributedServersModel;

public class ConfigurableCacheSyncDistributedTest
extends AutoVerifyTestCase {
    protected Hashtable cacheSyncConfigValues = null;
    protected Hashtable oldCacheSyncConfigValues = null;

    public ConfigurableCacheSyncDistributedTest(Hashtable cacheSyncConfigValues) {
        this.cacheSyncConfigValues = cacheSyncConfigValues;
    }

    public ConfigurableCacheSyncDistributedTest() {
        this.cacheSyncConfigValues = new Hashtable();
    }

    public Object getObjectFromDistributedSession(DatabaseQuery query) {
        Enumeration servers = DistributedServersModel.getDistributedServers().elements();
        while (servers.hasMoreElements()) {
            try {
                Object result = ((DistributedServer)servers.nextElement()).getDistributedSession().executeQuery(query);
                if (result == null) continue;
                return result;
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    public Object getObjectFromDistributedCache(Object object) {
        Enumeration servers = DistributedServersModel.getDistributedServers().elements();
        while (servers.hasMoreElements()) {
            try {
                DistributedServer server = (DistributedServer)servers.nextElement();
                Object result = server.getDistributedSession().getIdentityMapAccessor().getFromIdentityMap(object);
                if (result == null) continue;
                return result;
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    public boolean isObjectValidOnDistributedServer(Object object) {
        Enumeration servers = DistributedServersModel.getDistributedServers().elements();
        while (servers.hasMoreElements()) {
            try {
                DistributedServer server = (DistributedServer)servers.nextElement();
                Object result = server.getDistributedSession().getIdentityMapAccessor().getFromIdentityMap(object);
                if (result == null) continue;
                return server.isObjectValid(object);
            }
            catch (Exception exception) {
            }
        }
        return true;
    }

    public void setup() {
        this.oldCacheSyncConfigValues = new Hashtable();
        Enumeration keys = this.cacheSyncConfigValues.keys();
        while (keys.hasMoreElements()) {
            Class keyClass = (Class)keys.nextElement();
            ClassDescriptor descriptor = this.getSession().getDescriptor(keyClass);
            if (descriptor == null) continue;
            int cacheSyncType = descriptor.getCacheSynchronizationType();
            Object newCacheSyncType = this.cacheSyncConfigValues.get(keyClass);
            if (newCacheSyncType == null) continue;
            this.oldCacheSyncConfigValues.put(keyClass, new Integer(cacheSyncType));
            descriptor.setCacheSynchronizationType(((Integer)newCacheSyncType).intValue());
        }
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        this.getAbstractSession().beginTransaction();
    }

    public void reset() {
        this.getAbstractSession().rollbackTransaction();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        Enumeration enumtr = DistributedServersModel.getDistributedServers().elements();
        while (enumtr.hasMoreElements()) {
            ((DistributedServer)enumtr.nextElement()).getDistributedSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        }
        Enumeration keys = this.oldCacheSyncConfigValues.keys();
        while (keys.hasMoreElements()) {
            Class keyClass = (Class)keys.nextElement();
            ClassDescriptor descriptor = this.getSession().getDescriptor(keyClass);
            int newCacheSyncType = (Integer)this.oldCacheSyncConfigValues.get(keyClass);
            descriptor.setCacheSynchronizationType(newCacheSyncType);
        }
    }
}

