/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.distributedservers.rcm;

import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Address;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.domain.LargeProject;
import org.eclipse.persistence.testing.models.employee.domain.PhoneNumber;
import org.eclipse.persistence.testing.models.employee.domain.Project;
import org.eclipse.persistence.testing.models.employee.domain.SmallProject;
import org.eclipse.persistence.testing.tests.distributedservers.DistributedServer;
import org.eclipse.persistence.testing.tests.distributedservers.DistributedServersModel;
import org.eclipse.persistence.testing.tests.distributedservers.rcm.ConfigurableCacheSyncDistributedTest;

public class MultipleCacheSyncTypeTest
extends ConfigurableCacheSyncDistributedTest {
    protected Expression expression = null;
    protected Project project = null;
    protected Address address = null;
    protected Employee verbal = null;

    public MultipleCacheSyncTypeTest() {
        this.cacheSyncConfigValues.put(Employee.class, new Integer(3));
        this.cacheSyncConfigValues.put(Project.class, new Integer(2));
        this.cacheSyncConfigValues.put(SmallProject.class, new Integer(2));
        this.cacheSyncConfigValues.put(LargeProject.class, new Integer(2));
        this.cacheSyncConfigValues.put(Address.class, new Integer(4));
        this.cacheSyncConfigValues.put(PhoneNumber.class, new Integer(1));
    }

    @Override
    public void setup() {
        super.setup();
        ExpressionBuilder employees = new ExpressionBuilder();
        this.expression = employees.get("firstName").equal((Object)"Charles");
        this.expression = this.expression.and(employees.get("lastName").equal((Object)"Chanley"));
        DistributedServer server = (DistributedServer)DistributedServersModel.getDistributedServers().get(0);
        Object result = server.getDistributedSession().readObject(Employee.class, this.expression);
        ((Employee)result).getManagedEmployees();
        ((Employee)result).getPhoneNumbers();
        ((Employee)result).getAddress();
        ((Employee)result).getManager();
        ((Employee)result).getProjects();
        ((Employee)result).getResponsibilitiesList();
    }

    public void test() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        Employee charles = (Employee)this.getSession().readObject(Employee.class, this.expression);
        Employee workingCharles = (Employee)uow.registerObject((Object)charles);
        workingCharles.setSalary(workingCharles.getSalary() + 1);
        this.project = (Project)workingCharles.getProjects().firstElement();
        this.project.setName(this.project.getName().substring(0, 2) + "-changed");
        this.address = workingCharles.getAddress();
        this.address.setCity(this.address.getCity() + "-changed");
        PhoneNumber phoneNumber = (PhoneNumber)workingCharles.getPhoneNumbers().firstElement();
        phoneNumber.setNumber("7654321");
        this.verbal = new Employee();
        this.verbal.setFirstName("Verbal");
        this.verbal.setLastName("Kint");
        uow.registerObject((Object)this.verbal);
        uow.commit();
    }

    public void verify() {
        Employee chuck = (Employee)this.getSession().readObject(Employee.class, this.expression);
        Employee distributedChuck = (Employee)this.getObjectFromDistributedCache(chuck);
        if (distributedChuck.getSalary() != chuck.getSalary()) {
            throw new TestErrorException("Updated Employee Object not propogated to distributed cache.");
        }
        if (this.isObjectValidOnDistributedServer(this.project)) {
            throw new TestErrorException("Project was not invalidated in distributed cache.");
        }
        if (distributedChuck.getAddress().getCity().equals(chuck.getAddress().getCity())) {
            throw new TestErrorException("Address was propogated to distributed cache even though it was not set to.");
        }
        if (distributedChuck.getPhoneNumbers().firstElement().equals(chuck.getPhoneNumbers().firstElement())) {
            throw new TestErrorException("PhoneNumber was not propogated to distributed cache.");
        }
        if (this.getObjectFromDistributedCache(this.verbal) == null) {
            throw new TestErrorException("New employee was not propogated to distributed cache.");
        }
    }
}

