/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.nls.japanese;

import java.sql.Time;
import java.util.Vector;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.testing.models.employee.domain.Address;
import org.eclipse.persistence.testing.models.employee.domain.EmploymentPeriod;
import org.eclipse.persistence.testing.models.employee.domain.LargeProject;
import org.eclipse.persistence.testing.models.employee.domain.PhoneNumber;
import org.eclipse.persistence.testing.models.employee.interfaces.Employee;
import org.eclipse.persistence.testing.models.employee.interfaces.SmallProject;
import org.eclipse.persistence.testing.tests.nls.japanese.NLSEmployee;
import org.eclipse.persistence.tools.schemaframework.PopulationManager;

public class NLSEmployeePopulator {
    protected PopulationManager populationManager = PopulationManager.getDefaultManager();

    public Address addressExample1() {
        Address address = new Address();
        address.setCity("\u3068\u30db\u30c4\u30db\u30bb\u30c8\u30db");
        address.setPostalCode("L5J2B5");
        address.setProvince("\u305d\u305b\u3068");
        address.setStreet("1450 \u3042\u30a6\u30b9\u30aa \u3046\u30c4., \u30c6\u30ca\u30b1\u30c8\u30aa 4");
        address.setCountry("\u3046\u30a2\u30bb\u30a2\u30a8\u30a2");
        return address;
    }

    public Address addressExample10() {
        Address address = new Address();
        address.setCity("\u3046\u30a2\u30b7\u30ad\u30a2\u30c4\u30ce");
        address.setPostalCode("J5J2B5");
        address.setProvince("\u3042\u3057\u3044");
        address.setStreet("1111 \u3059\u30db\u30db\u30c6\u30aa \u3064\u30a8.");
        address.setCountry("\u3046\u30a2\u30bb\u30a2\u30a8\u30a2");
        return address;
    }

    public Address addressExample11() {
        Address address = new Address();
        address.setCity("\u3042\u30c4\u30bb\u30de\u30c4\u30b1\u30db\u30c4");
        address.setPostalCode("W1A2B5");
        address.setProvince("\u305d\u305b\u3068");
        address.setStreet("1 \u305b\u30db\u30cc\u30af\u30aa\u30c4\u30aa \u3048\u30c4\u30b1\u30cb\u30aa");
        address.setCountry("\u3046\u30a2\u30bb\u30a2\u30a8\u30a2");
        return address;
    }

    public Address addressExample12() {
        Address address = new Address();
        address.setCity("\u306e\u30aa\u30b7\u30b7\u30db\u30cc \u3055\u30bb\u30b1\u30ab\u30aa");
        address.setPostalCode("Y5J2N5");
        address.setProvince("\u306e\u3055");
        address.setStreet("1112 \u304d\u30db\u30b7\u30a8 \u3064\u30ca\u30c6\u30af \u30c4\u30a8.");
        address.setCountry("\u3046\u30a2\u30bb\u30a2\u30a8\u30a2");
        return address;
    }

    public Address addressExample2() {
        Address address = new Address();
        address.setCity("\u305d\u30c8\u30c8\u30a2\u30cc\u30a2");
        address.setPostalCode("K5J2B5");
        address.setProvince("\u305d\u305b\u3068");
        address.setStreet("12 \u3059\u30aa\u30c4\u30b1\u30cb\u30a2\u30b7 \u3064\u30a8., \u30c6\u30ca\u30b1\u30c8\u30aa 5");
        address.setCountry("\u3046\u30a2\u30bb\u30a2\u30a8\u30a2");
        return address;
    }

    public Address addressExample3() {
        Address address = new Address();
        address.setCity("\u305f\u30aa\u30c4\u30c8\u30af");
        address.setPostalCode("Y3Q2N9");
        address.setProvince("\u305d\u305b\u3068");
        address.setStreet("234 \u3051'\u30b9 \u3057\u30db\u30c6\u30c8 \u3057\u30a2\u30bb\u30aa");
        address.setCountry("\u3046\u30a2\u30bb\u30a2\u30a8\u30a2");
        return address;
    }

    public Address addressExample4() {
        Address address = new Address();
        address.setCity("\u305f\u30c4\u30b1\u30bb\u30a6\u30aa \u3064\u30ca\u30de\u30aa\u30c4\u30c8");
        address.setPostalCode("K3k5DD");
        address.setProvince("\u3044\u3046");
        address.setStreet("3254 \u3064\u30aa\u30a2\u30b7 \u3046\u30db\u30b7\u30a8 \u305f\u30b7\u30a2\u30a6\u30aa");
        address.setCountry("\u3046\u30a2\u30bb\u30a2\u30a8\u30a2");
        return address;
    }

    public Address addressExample5() {
        Address address = new Address();
        address.setCity("\u306b\u30a2\u30bb\u30a6\u30db\u30ca\u30cb\u30aa\u30c4");
        address.setPostalCode("N5J2N5");
        address.setProvince("\u3044\u3046");
        address.setStreet("1111 \u3059\u30db\u30ca\u30bb\u30c8\u30a2\u30b1\u30bb \u3044\u30b7\u30cb\u30a8. \u304b\u30b7\u30db\u30db\u30c4 53, \u30c6\u30ca\u30b1\u30c8\u30aa 6");
        address.setCountry("\u3046\u30a2\u30bb\u30a2\u30a8\u30a2");
        return address;
    }

    public Address addressExample6() {
        Address address = new Address();
        address.setCity("\u3059\u30db\u30bb\u30c8\u30c4\u30aa\u30a2\u30b7");
        address.setPostalCode("Q2S5Z5");
        address.setProvince("\u3061\u306a\u304a");
        address.setStreet("1 \u304f\u30a2\u30a4\u30c6 \u305f\u30b7\u30a2\u30a6\u30aa");
        address.setCountry("\u3046\u30a2\u30bb\u30a2\u30a8\u30a2");
        return address;
    }

    public Address addressExample7() {
        Address address = new Address();
        address.setCity("\u3059\u30aa\u30c8\u30a6\u30a2\u30b7\u30ab\u30aa");
        address.setPostalCode("Y4F7V6");
        address.setProvince("\u305d\u305b\u3068");
        address.setStreet("2 \u3042\u30bb\u30a8\u30aa\u30c4\u30c6\u30db\u30bb \u3064\u30a8.");
        address.setCountry("\u3046\u30a2\u30bb\u30a2\u30a8\u30a2");
        return address;
    }

    public Address addressExample8() {
        Address address = new Address();
        address.setCity("\u306b\u30b1\u30a6\u30c8\u30db\u30c4\u30b1\u30a2");
        address.setPostalCode("Z5J2N5");
        address.setProvince("\u3044\u3046");
        address.setStreet("382 \u304f\u30ce\u30a8\u30aa \u305f\u30a2\u30c4\u30b5");
        address.setCountry("\u3046\u30a2\u30bb\u30a2\u30a8\u30a2");
        return address;
    }

    public Address addressExample9() {
        Address address = new Address();
        address.setCity("\u3066\u30b9\u30b1\u30c8\u30af \u304b\u30a2\u30b7\u30b7\u30c6");
        address.setPostalCode("C6C6C6");
        address.setProvince("\u305d\u305b\u3068");
        address.setStreet("1 \u3046\u30af\u30db\u30a6\u30db\u30b7\u30a2\u30c8\u30aa \u3048\u30c4\u30b1\u30cb\u30aa");
        address.setCountry("\u3046\u30a2\u30bb\u30a2\u30a8\u30a2");
        return address;
    }

    public Employee basicEmployeeExample1() {
        Employee employee = this.createEmployee();
        try {
            employee.setFirstName("\u3044\u30db\u30a4");
            employee.setLastName("\u3066\u30b9\u30b1\u30c8\u30af");
            employee.setMale();
            employee.setSalary(35000);
            employee.setPeriod(this.employmentPeriodExample1());
            employee.setAddress(this.addressExample1());
            employee.addResponsibility("\u3059\u30a2\u30b5\u30aa \u30c8\u30af\u30aa \u30a6\u30db\u30ab\u30ab\u30aa\u30aa.");
            employee.addResponsibility("\u3046\u30b7\u30aa\u30a2\u30bb \u30c8\u30af\u30aa \u30b5\u30b1\u30c8\u30a6\u30af\u30aa\u30bb.");
            employee.addPhoneNumber(this.phoneNumberExample1());
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString());
        }
        return employee;
    }

    public Employee basicEmployeeExample10() {
        Employee employee = this.createEmployee();
        try {
            employee.setFirstName("\u3053\u30b1\u30b7\u30b7");
            employee.setLastName("\u3059\u30a2\u30ce");
            employee.setFemale();
            employee.setPeriod(this.employmentPeriodExample10());
            employee.setAddress(this.addressExample10());
            employee.setSalary(56232);
            employee.addPhoneNumber(this.phoneNumberExample1());
            employee.addPhoneNumber(this.phoneNumberExample2());
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString());
        }
        return employee;
    }

    public Employee basicEmployeeExample11() {
        Employee employee = this.createEmployee();
        try {
            employee.setFirstName("\u3066\u30a2\u30c4\u30a2\u30af-\u30b7\u30db\u30db");
            employee.setLastName("\u3066\u30b9\u30b1\u30c8\u30c8\u30ce");
            employee.setFemale();
            employee.setPeriod(this.employmentPeriodExample11());
            employee.setAddress(this.addressExample11());
            employee.setSalary(75000);
            employee.addPhoneNumber(this.phoneNumberExample2());
            employee.addPhoneNumber(this.phoneNumberExample3());
            employee.addPhoneNumber(this.phoneNumberExample4());
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString());
        }
        return employee;
    }

    public Employee basicEmployeeExample12() {
        Employee employee = this.createEmployee();
        try {
            employee.setFirstName("\u3053\u30b1\u30b9-\u30a4\u30db\u30a4");
            employee.setLastName("\u3053\u30aa\u30ab\u30ab\u30aa\u30c4\u30c6\u30db\u30bb");
            employee.setMale();
            employee.setPeriod(this.employmentPeriodExample12());
            employee.setAddress(this.addressExample12());
            employee.setSalary(50000);
            employee.addPhoneNumber(this.phoneNumberExample3());
            employee.addPhoneNumber(this.phoneNumberExample4());
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString());
        }
        return employee;
    }

    public Employee basicEmployeeExample2() {
        Employee employee = this.createEmployee();
        try {
            employee.setFirstName("\u3053\u30db\u30af\u30bb");
            employee.setLastName("\u306c\u30a2\u30ce");
            employee.setMale();
            employee.setSalary(53000);
            employee.setNormalHours(new Time[]{Helper.timeFromHourMinuteSecond((int)8, (int)0, (int)0), Helper.timeFromHourMinuteSecond((int)17, (int)30, (int)0)});
            employee.setPeriod(this.employmentPeriodExample2());
            employee.setAddress(this.addressExample2());
            employee.addResponsibility("\u304b\u30b1\u30c4\u30aa \u30de\u30aa\u30db\u30de\u30b7\u30aa \u30ab\u30db\u30c4 \u30ad\u30db\u30db\u30ab\u30b1\u30bb\u30ad \u30db\u30ab\u30ab.");
            employee.addResponsibility("\u304f\u30b1\u30c4\u30aa \u30de\u30aa\u30db\u30de\u30b7\u30aa \u30cc\u30af\u30aa\u30bb \u30b9\u30db\u30c4\u30aa \u30de\u30aa\u30db\u30de\u30b7\u30aa \u30a2\u30c4\u30aa \u30c4\u30aa\u30c1\u30ca\u30b1\u30c4\u30aa\u30a8.");
            employee.addPhoneNumber(this.phoneNumberExample1());
            employee.addPhoneNumber(this.phoneNumberExample6());
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString());
        }
        return employee;
    }

    public Employee basicEmployeeExample3() {
        Employee employee = this.createEmployee();
        try {
            employee.setFirstName("\u3046\u30af\u30a2\u30c4\u30b7\u30aa\u30c6");
            employee.setLastName("\u3046\u30af\u30a2\u30bb\u30b7\u30aa\u30ce");
            employee.setMale();
            employee.setSalary(43000);
            employee.setNormalHours(new Time[]{Helper.timeFromHourMinuteSecond((int)7, (int)0, (int)0), Helper.timeFromHourMinuteSecond((int)15, (int)30, (int)0)});
            employee.setPeriod(this.employmentPeriodExample6());
            employee.setAddress(this.addressExample6());
            employee.addResponsibility("\u306c\u30c4\u30b1\u30c8\u30aa \u30b7\u30db\u30c8\u30c6 \u30db\u30ab \u3053\u30a2\u30cb\u30a2 \u30a6\u30db\u30a8\u30aa.");
            employee.addPhoneNumber(this.phoneNumberExample5());
            employee.addPhoneNumber(this.phoneNumberExample6());
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString());
        }
        return employee;
    }

    public Employee basicEmployeeExample4() {
        Employee employee = this.createEmployee();
        try {
            employee.setFirstName("\u304a\u30b9\u30a2\u30bb\u30ca\u30a2\u30b7");
            employee.setLastName("\u3066\u30b9\u30b1\u30c8\u30af");
            employee.setMale();
            employee.setSalary(49631);
            employee.setNormalHours(new Time[]{Helper.timeFromHourMinuteSecond((int)6, (int)45, (int)0), Helper.timeFromHourMinuteSecond((int)16, (int)32, (int)0)});
            employee.setPeriod(this.employmentPeriodExample5());
            employee.setAddress(this.addressExample5());
            employee.addResponsibility("\u304f\u30a2\u30cb\u30aa \u30c8\u30db \u30ab\u30b1\u30cd \u30c8\u30af\u30aa \u3048\u30a2\u30c8\u30a2\u30a4\u30a2\u30c6\u30aa \u30de\u30c4\u30db\u30a4\u30b7\u30aa\u30b9.");
            employee.addPhoneNumber(this.phoneNumberExample2());
            employee.addPhoneNumber(this.phoneNumberExample4());
            employee.addPhoneNumber(this.phoneNumberExample5());
            employee.addPhoneNumber(this.phoneNumberExample6());
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString());
        }
        return employee;
    }

    public Employee basicEmployeeExample5() {
        Employee employee = this.createEmployee();
        try {
            employee.setFirstName("\u3066\u30a2\u30c4\u30a2\u30af");
            employee.setLastName("\u306c\u30a2\u30ce");
            employee.setFemale();
            employee.setSalary(87000);
            employee.setNormalHours(new Time[]{Helper.timeFromHourMinuteSecond((int)12, (int)0, (int)0), Helper.timeFromHourMinuteSecond((int)20, (int)0, (int)30)});
            employee.setPeriod(this.employmentPeriodExample4());
            employee.setAddress(this.addressExample4());
            employee.addResponsibility("\u306c\u30c4\u30b1\u30c8\u30aa \u30a6\u30db\u30a8\u30aa \u30a8\u30db\u30a6\u30ca\u30b9\u30aa\u30bb\u30c8\u30a2\u30c8\u30b1\u30db\u30bb.");
            employee.addPhoneNumber(this.phoneNumberExample1());
            employee.addPhoneNumber(this.phoneNumberExample6());
            employee.addPhoneNumber(this.phoneNumberExample3());
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString());
        }
        return employee;
    }

    public Employee basicEmployeeExample6() {
        Employee employee = this.createEmployee();
        try {
            employee.setFirstName("\u3059\u30a2\u30c4\u30a6\u30ca\u30c6");
            employee.setLastName("\u3066\u30a2\u30ca\u30bb\u30a8\u30aa\u30c4\u30c6");
            employee.setMale();
            employee.setSalary(54300);
            employee.setPeriod(this.employmentPeriodExample3());
            employee.setAddress(this.addressExample3());
            employee.addResponsibility("\u306c\u30c4\u30b1\u30c8\u30aa \u30ca\u30c6\u30aa\u30c4 \u30c6\u30de\u30aa\u30a6\u30b1\u30ab\u30b1\u30a6\u30a2\u30c8\u30b1\u30db\u30bb\u30c6.");
            employee.addPhoneNumber(this.phoneNumberExample6());
            employee.addPhoneNumber(this.phoneNumberExample1());
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString());
        }
        return employee;
    }

    public Employee basicEmployeeExample7() {
        Employee employee = this.createEmployee();
        try {
            employee.setFirstName("\u305b\u30a2\u30bb\u30a6\u30ce");
            employee.setLastName("\u306c\u30af\u30b1\u30c8\u30aa");
            employee.setFemale();
            employee.setSalary(31000);
            employee.setPeriod(this.employmentPeriodExample7());
            employee.setAddress(this.addressExample7());
            employee.addPhoneNumber(this.phoneNumberExample3());
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString());
        }
        return employee;
    }

    public Employee basicEmployeeExample8() {
        Employee employee = this.createEmployee();
        try {
            employee.setFirstName("\u304b\u30c4\u30aa\u30a8");
            employee.setLastName("\u3053\u30db\u30bb\u30aa\u30c6");
            employee.setMale();
            employee.setSalary(500000);
            employee.setPeriod(this.employmentPeriodExample8());
            employee.setAddress(this.addressExample8());
            employee.addPhoneNumber(this.phoneNumberExample4());
            employee.addPhoneNumber(this.phoneNumberExample6());
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString());
        }
        return employee;
    }

    public Employee basicEmployeeExample9() {
        Employee employee = this.createEmployee();
        try {
            employee.setFirstName("\u3044\u30aa\u30c8\u30c8\u30ce");
            employee.setLastName("\u3053\u30db\u30bb\u30aa\u30c6");
            employee.setFemale();
            employee.setSalary(500001);
            employee.setNormalHours(new Time[]{Helper.timeFromHourMinuteSecond((int)22, (int)0, (int)0), Helper.timeFromHourMinuteSecond((int)5, (int)30, (int)0)});
            employee.setPeriod(this.employmentPeriodExample9());
            employee.setAddress(this.addressExample9());
            employee.addPhoneNumber(this.phoneNumberExample1());
            employee.addPhoneNumber(this.phoneNumberExample6());
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString());
        }
        return employee;
    }

    public org.eclipse.persistence.testing.models.employee.interfaces.LargeProject basicLargeProjectExample1() {
        org.eclipse.persistence.testing.models.employee.interfaces.LargeProject largeProject = this.createLargeProject();
        try {
            largeProject.setName("\u3066\u30a2\u30b7\u30aa\u30c6 \u3064\u30aa\u30de\u30db\u30c4\u30c8\u30b1\u30bb\u30ad");
            largeProject.setDescription("\u3042 \u30c4\u30aa\u30de\u30db\u30c4\u30c8\u30b1\u30bb\u30ad \u30a2\u30de\u30de\u30b7\u30b1\u30a6\u30a2\u30c8\u30b1\u30db\u30bb \u30c8\u30db \u30c4\u30aa\u30de\u30db\u30c4\u30c8 \u30db\u30bb \u30c8\u30af\u30aa \u30a6\u30db\u30c4\u30de\u30db\u30c4\u30a2\u30c8\u30b1\u30db\u30bb\u30c6 \u30a8\u30a2\u30c8\u30a2\u30a4\u30a2\u30c6\u30aa \u30c8\u30af\u30c4\u30db\u30ca\u30ad\u30af \u3068\u30db\u30de\u3057\u30b1\u30bb\u30b5.");
            largeProject.setBudget(5000.0);
            largeProject.setMilestoneVersion(Helper.timestampFromYearMonthDateHourMinuteSecondNanos((int)1991, (int)10, (int)11, (int)12, (int)0, (int)0, (int)0));
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString());
        }
        return largeProject;
    }

    public org.eclipse.persistence.testing.models.employee.interfaces.LargeProject basicLargeProjectExample2() {
        org.eclipse.persistence.testing.models.employee.interfaces.LargeProject largeProject = this.createLargeProject();
        try {
            largeProject.setName("\u3066\u30cc\u30b1\u30c4\u30b7\u30ce \u3048\u30b1\u30c4\u30b7\u30ce");
            largeProject.setDescription("\u3042 \u30c6\u30cc\u30b1\u30c4\u30b7\u30ce \u30a2\u30de\u30de\u30b7\u30b1\u30a6\u30a2\u30c8\u30b1\u30db\u30bb \u30c8\u30db \u30c4\u30aa\u30de\u30db\u30c4\u30c8 \u30db\u30bb \u30c8\u30af\u30aa \u30a6\u30db\u30c4\u30de\u30db\u30c4\u30a2\u30c8\u30b1\u30db\u30bb\u30c6 \u30a8\u30a2\u30c8\u30a2\u30a4\u30a2\u30c6\u30aa \u30c8\u30af\u30c4\u30db\u30ca\u30ad\u30af \u3068\u30db\u30de\u3057\u30b1\u30bb\u30b5.");
            largeProject.setBudget(100.98);
            largeProject.setMilestoneVersion(Helper.timestampFromYearMonthDateHourMinuteSecondNanos((int)1999, (int)11, (int)25, (int)11, (int)40, (int)44, (int)0));
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString());
        }
        return largeProject;
    }

    public org.eclipse.persistence.testing.models.employee.interfaces.LargeProject basicLargeProjectExample3() {
        org.eclipse.persistence.testing.models.employee.interfaces.LargeProject largeProject = this.createLargeProject();
        try {
            largeProject.setName("\u3068\u305d\u305f\u304a\u30b9\u30de\u30b7\u30db\u30ce\u30aa\u30aa \u3059\u30a2\u30bb\u30a2\u30ad\u30aa\u30b9\u30aa\u30bb\u30c8");
            largeProject.setDescription("\u3042 \u30b9\u30a2\u30bb\u30a2\u30ad\u30aa\u30b9\u30aa\u30bb\u30c8 \u30a2\u30de\u30de\u30b7\u30b1\u30a6\u30a2\u30c8\u30b1\u30db\u30bb \u30c8\u30db \u30c4\u30aa\u30de\u30db\u30c4\u30c8 \u30db\u30bb \u30c8\u30af\u30aa \u30a6\u30db\u30c4\u30de\u30db\u30c4\u30a2\u30c8\u30b1\u30db\u30bb\u30c6 \u30a8\u30a2\u30c8\u30a2\u30a4\u30a2\u30c6\u30aa \u30c8\u30af\u30c4\u30db\u30ca\u30ad\u30af \u3068\u30db\u30de\u3057\u30b1\u30bb\u30b5.");
            largeProject.setBudget(4000.98);
            largeProject.setMilestoneVersion(Helper.timestampFromYearMonthDateHourMinuteSecondNanos((int)1997, (int)10, (int)12, (int)1, (int)0, (int)0, (int)0));
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString());
        }
        return largeProject;
    }

    public org.eclipse.persistence.testing.models.employee.interfaces.LargeProject basicLargeProjectExample4() {
        org.eclipse.persistence.testing.models.employee.interfaces.LargeProject largeProject = this.createLargeProject();
        try {
            largeProject.setName("\u304a\u30bb\u30c8\u30aa\u30c4\u30de\u30c4\u30b1\u30c6\u30aa \u3066\u30ce\u30c6\u30c8\u30aa\u30b9");
            largeProject.setDescription("\u3042 \u30aa\u30bb\u30c8\u30aa\u30c4\u30de\u30c4\u30b1\u30c6\u30aa \u30cc\u30b1\u30a8\u30aa \u30a2\u30de\u30de\u30b7\u30b1\u30a6\u30a2\u30c8\u30b1\u30db\u30bb \u30c8\u30db \u30c4\u30aa\u30de\u30db\u30c4\u30c8 \u30db\u30bb \u30c8\u30af\u30aa \u30a6\u30db\u30c4\u30de\u30db\u30c4\u30a2\u30c8\u30b1\u30db\u30bb\u30c6 \u30a8\u30a2\u30c8\u30a2\u30a4\u30a2\u30c6\u30aa \u30c8\u30af\u30c4\u30db\u30ca\u30ad\u30af \u3068\u30db\u30de\u3057\u30b1\u30bb\u30b5.");
            largeProject.setBudget(40.98);
            largeProject.setMilestoneVersion(Helper.timestampFromYearMonthDateHourMinuteSecondNanos((int)1996, (int)8, (int)6, (int)6, (int)40, (int)44, (int)0));
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString());
        }
        return largeProject;
    }

    public org.eclipse.persistence.testing.models.employee.interfaces.LargeProject basicLargeProjectExample5() {
        org.eclipse.persistence.testing.models.employee.interfaces.LargeProject largeProject = this.createLargeProject();
        try {
            largeProject.setName("\u305f\u30c4\u30db\u30a4\u30b7\u30aa\u30b9 \u3064\u30aa\u30de\u30db\u30c4\u30c8\u30b1\u30bb\u30ad \u3066\u30ce\u30c6\u30c8\u30aa\u30b9");
            largeProject.setDescription("\u3042 \u305f\u3064\u3066 \u30a2\u30de\u30de\u30b7\u30b1\u30a6\u30a2\u30c8\u30b1\u30db\u30bb \u30c8\u30db \u30c4\u30aa\u30de\u30db\u30c4\u30c8 \u30db\u30bb \u30c8\u30af\u30aa \u30a6\u30db\u30c4\u30de\u30db\u30c4\u30a2\u30c8\u30b1\u30db\u30bb\u30c6 \u30a8\u30a2\u30c8\u30a2\u30a4\u30a2\u30c6\u30aa \u30c8\u30af\u30c4\u30db\u30ca\u30ad\u30af \u3068\u30db\u30de\u3057\u30b1\u30bb\u30b5.");
            largeProject.setBudget(101.98);
            largeProject.setMilestoneVersion(Helper.timestampFromYearMonthDateHourMinuteSecondNanos((int)1997, (int)9, (int)6, (int)1, (int)40, (int)44, (int)0));
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString());
        }
        return largeProject;
    }

    public SmallProject basicSmallProjectExample1() {
        SmallProject smallProject = this.createSmallProject();
        try {
            smallProject.setName("\u304a\u30bb\u30c8\u30aa\u30c4\u30de\u30c4\u30b1\u30c6\u30aa");
            smallProject.setDescription("\u3042 \u30aa\u30bb\u30c8\u30aa\u30c4\u30de\u30c4\u30b1\u30c6\u30aa \u30cc\u30b1\u30a8\u30aa \u30a2\u30de\u30de\u30b7\u30b1\u30a6\u30a2\u30c8\u30b1\u30db\u30bb \u30c8\u30db \u30c4\u30aa\u30de\u30db\u30c4\u30c8 \u30db\u30bb \u30c8\u30af\u30aa \u30a6\u30db\u30c4\u30de\u30db\u30c4\u30a2\u30c8\u30b1\u30db\u30bb\u30c6 \u30a8\u30a2\u30c8\u30a2\u30a4\u30a2\u30c6\u30aa \u30c8\u30af\u30c4\u30db\u30ca\u30ad\u30af \u3068\u30db\u30de\u3057\u30b1\u30bb\u30b5.");
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString());
        }
        return smallProject;
    }

    public SmallProject basicSmallProjectExample10() {
        SmallProject smallProject = this.createSmallProject();
        try {
            smallProject.setName("\u3066\u30c8\u30a2\u30ab\u30ab \u3061\u30ca\u30aa\u30c4\u30ce \u3068\u30db\u30db\u30b7");
            smallProject.setDescription("\u3042 \u30c8\u30db\u30db\u30b7 \u30c8\u30db \u30af\u30aa\u30b7\u30de \u30c6\u30c8\u30a2\u30ab\u30ab \u30c1\u30ca\u30aa\u30c4\u30ce \u30c8\u30af\u30b1\u30bb\u30ad\u30c6.");
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString());
        }
        return smallProject;
    }

    public SmallProject basicSmallProjectExample2() {
        SmallProject smallProject = this.createSmallProject();
        try {
            smallProject.setName("\u3066\u30a2\u30b7\u30aa\u30c6 \u3064\u30aa\u30de\u30db\u30c4\u30c8\u30aa\u30c4");
            smallProject.setDescription("\u3042 \u30c4\u30aa\u30de\u30db\u30c4\u30c8\u30b1\u30bb\u30ad \u30a2\u30de\u30de\u30b7\u30b1\u30a6\u30a2\u30c8\u30b1\u30db\u30bb \u30ca\u30c6\u30b1\u30bb\u30ad \u3053\u3048\u3055 \u30c8\u30db \u30c4\u30aa\u30de\u30db\u30c4\u30c8 \u30db\u30bb \u30c8\u30af\u30aa \u30a6\u30db\u30c4\u30de\u30db\u30c4\u30a2\u30c8\u30b1\u30db\u30bb\u30c6 \u30a8\u30a2\u30c8\u30a2\u30a4\u30a2\u30c6\u30aa \u30c8\u30af\u30c4\u30db\u30ca\u30ad\u30af \u3068\u30db\u30de\u3057\u30b1\u30bb\u30b5.");
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString());
        }
        return smallProject;
    }

    public SmallProject basicSmallProjectExample3() {
        SmallProject smallProject = this.createSmallProject();
        try {
            smallProject.setName("\u3068\u305d\u305f\u304a\u30b9\u30de\u30b7\u30db\u30ce\u30aa\u30aa \u3059\u30a2\u30bb\u30a2\u30ad\u30aa\u30c4");
            smallProject.setDescription("\u3042 \u30b9\u30a2\u30bb\u30a2\u30ad\u30aa\u30b9\u30aa\u30bb\u30c8 \u30a2\u30de\u30de\u30b7\u30b1\u30a6\u30a2\u30c8\u30b1\u30db\u30bb \u30c8\u30db \u30c4\u30aa\u30de\u30db\u30c4\u30c8 \u30db\u30bb \u30c8\u30af\u30aa \u30a6\u30db\u30c4\u30de\u30db\u30c4\u30a2\u30c8\u30b1\u30db\u30bb\u30c6 \u30a8\u30a2\u30c8\u30a2\u30a4\u30a2\u30c6\u30aa \u30c8\u30af\u30c4\u30db\u30ca\u30ad\u30af \u3068\u30db\u30de\u3057\u30b1\u30bb\u30b5.");
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString());
        }
        return smallProject;
    }

    public SmallProject basicSmallProjectExample4() {
        SmallProject smallProject = this.createSmallProject();
        try {
            smallProject.setName("\u305f\u30c4\u30db\u30a4\u30b7\u30aa\u30b9 \u3064\u30aa\u30de\u30db\u30c4\u30c8\u30aa\u30c4");
            smallProject.setDescription("\u3042 \u305f\u3064\u3066 \u30a2\u30de\u30de\u30b7\u30b1\u30a6\u30a2\u30c8\u30b1\u30db\u30bb \u30c8\u30db \u30c4\u30aa\u30de\u30db\u30c4\u30c8 \u30db\u30bb \u30c8\u30af\u30aa \u30a6\u30db\u30c4\u30de\u30db\u30c4\u30a2\u30c8\u30b1\u30db\u30bb\u30c6 \u30a8\u30a2\u30c8\u30a2\u30a4\u30a2\u30c6\u30aa \u30c8\u30af\u30c4\u30db\u30ca\u30ad\u30af \u3068\u30db\u30de\u3057\u30b1\u30bb\u30b5.");
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString());
        }
        return smallProject;
    }

    public SmallProject basicSmallProjectExample5() {
        SmallProject smallProject = this.createSmallProject();
        try {
            smallProject.setName("\u3066\u30cc\u30b1\u30c4\u30b7\u30ce \u3048\u30b1\u30c4\u30b7");
            smallProject.setDescription("\u3042 \u30c6\u30cc\u30b1\u30c4\u30b7\u30b7\u30ce \u30a2\u30de\u30de\u30b7\u30b1\u30a6\u30a2\u30c8\u30b1\u30db\u30bb \u30c8\u30db \u30c4\u30aa\u30de\u30db\u30c4\u30c8 \u30db\u30bb \u30c8\u30af\u30aa \u30a6\u30db\u30c4\u30de\u30db\u30c4\u30a2\u30c8\u30b1\u30db\u30bb\u30c6 \u30a8\u30a2\u30c8\u30a2\u30a4\u30a2\u30c6\u30aa \u30c8\u30af\u30c4\u30db\u30ca\u30ad\u30af \u3068\u30db\u30de\u3057\u30b1\u30bb\u30b5.");
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString());
        }
        return smallProject;
    }

    public SmallProject basicSmallProjectExample6() {
        SmallProject smallProject = this.createSmallProject();
        try {
            smallProject.setName("\u3044\u30b7\u30aa\u30aa\u30de \u3044\u30b7\u30db\u30a4");
            smallProject.setDescription("\u3044\u30b7\u30aa\u30aa\u30de \u30a4\u30b7\u30db\u30a4 \u30b1\u30c6 \u30b3\u30ca\u30c6\u30c8 \u30a2 \u30bb\u30b1\u30a6\u30aa \u30c8\u30db\u30ce.");
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString());
        }
        return smallProject;
    }

    public SmallProject basicSmallProjectExample7() {
        SmallProject smallProject = this.createSmallProject();
        try {
            smallProject.setName("\u3059\u30a2\u30c4\u30b5\u30aa\u30c8\u30b1\u30bb\u30ad \u3061\u30ca\u30aa\u30c4\u30ce \u3068\u30db\u30db\u30b7");
            smallProject.setDescription("\u3042 \u30c8\u30db\u30db\u30b7 \u30c8\u30db \u30af\u30aa\u30b7\u30de \u30b9\u30a2\u30c4\u30b5\u30aa\u30c8\u30b1\u30bb\u30ad \u30c1\u30ca\u30aa\u30c4\u30ce \u30c8\u30af\u30b1\u30bb\u30ad\u30c6.");
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString());
        }
        return smallProject;
    }

    public SmallProject basicSmallProjectExample8() {
        SmallProject smallProject = this.createSmallProject();
        try {
            smallProject.setName("\u3066\u30af\u30b1\u30de\u30de\u30b1\u30bb\u30ad \u3061\u30ca\u30aa\u30c4\u30ce \u3068\u30db\u30db\u30b7");
            smallProject.setDescription("\u3042 \u30c8\u30db\u30db\u30b7 \u30c8\u30db \u30af\u30aa\u30b7\u30de \u30c6\u30af\u30b1\u30de\u30de\u30b1\u30bb\u30ad \u30c1\u30ca\u30aa\u30c4\u30ce \u30c8\u30af\u30b1\u30bb\u30ad\u30c6.");
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString());
        }
        return smallProject;
    }

    public SmallProject basicSmallProjectExample9() {
        SmallProject smallProject = this.createSmallProject();
        try {
            smallProject.setName("\u3042\u30a6\u30a6\u30db\u30ca\u30bb\u30c8\u30b1\u30bb\u30ad \u3061\u30ca\u30aa\u30c4\u30ce \u3068\u30db\u30db\u30b7");
            smallProject.setDescription("\u3042 \u30c8\u30db\u30db\u30b7 \u30c8\u30db \u30af\u30aa\u30b7\u30de \u30a2\u30a6\u30a6\u30db\u30ca\u30bb\u30c8\u30b1\u30bb\u30ad \u30c1\u30ca\u30aa\u30c4\u30ce \u30c8\u30af\u30b1\u30bb\u30ad\u30c6.");
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString());
        }
        return smallProject;
    }

    public void buildExamples() {
        PopulationManager.getDefaultManager().getRegisteredObjects().remove(NLSEmployee.class);
        PopulationManager.getDefaultManager().getRegisteredObjects().remove(org.eclipse.persistence.testing.models.employee.domain.SmallProject.class);
        PopulationManager.getDefaultManager().getRegisteredObjects().remove(LargeProject.class);
        this.employeeExample1();
        this.employeeExample2();
        this.employeeExample3();
        this.employeeExample4();
        this.employeeExample5();
        this.employeeExample6();
        this.employeeExample7();
        this.employeeExample8();
        this.employeeExample9();
        this.employeeExample10();
        this.employeeExample11();
        this.employeeExample12();
        this.largeProjectExample1();
        this.largeProjectExample2();
        this.largeProjectExample3();
        this.largeProjectExample4();
        this.largeProjectExample5();
        this.smallProjectExample1();
        this.smallProjectExample2();
        this.smallProjectExample3();
        this.smallProjectExample4();
        this.smallProjectExample5();
        this.smallProjectExample6();
        this.smallProjectExample7();
        this.smallProjectExample8();
        this.smallProjectExample9();
        this.smallProjectExample10();
    }

    protected boolean containsObject(Class domainClass, String identifier) {
        return this.populationManager.containsObject(domainClass, identifier);
    }

    public Employee createEmployee() {
        return new NLSEmployee();
    }

    public org.eclipse.persistence.testing.models.employee.interfaces.LargeProject createLargeProject() {
        return new LargeProject();
    }

    public SmallProject createSmallProject() {
        return new org.eclipse.persistence.testing.models.employee.domain.SmallProject();
    }

    public Employee employeeExample1() {
        if (this.containsObject(NLSEmployee.class, "0001")) {
            return (Employee)this.getObject(NLSEmployee.class, "0001");
        }
        Employee employee = this.basicEmployeeExample1();
        this.registerObject(NLSEmployee.class, employee, "0001");
        try {
            employee.addManagedEmployee(this.employeeExample3());
            employee.addManagedEmployee(this.employeeExample4());
            employee.addManagedEmployee(this.employeeExample5());
            employee.addProject(this.smallProjectExample1());
            employee.addProject(this.smallProjectExample2());
            employee.addProject(this.smallProjectExample3());
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString());
        }
        return employee;
    }

    public Employee employeeExample10() {
        if (this.containsObject(NLSEmployee.class, "0010")) {
            return (Employee)this.getObject(NLSEmployee.class, "0010");
        }
        Employee employee = this.basicEmployeeExample10();
        try {
            employee.addManagedEmployee(this.employeeExample12());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.registerObject(NLSEmployee.class, employee, "0010");
        return employee;
    }

    public Employee employeeExample11() {
        if (this.containsObject(NLSEmployee.class, "0011")) {
            return (Employee)this.getObject(NLSEmployee.class, "0011");
        }
        Employee employee = this.basicEmployeeExample11();
        try {
            employee.addManagedEmployee(this.employeeExample7());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.registerObject(NLSEmployee.class, employee, "0011");
        return employee;
    }

    public Employee employeeExample12() {
        if (this.containsObject(NLSEmployee.class, "0012")) {
            return (Employee)this.getObject(NLSEmployee.class, "0012");
        }
        Employee employee = this.basicEmployeeExample12();
        this.registerObject(NLSEmployee.class, employee, "0012");
        try {
            employee.addManagedEmployee(this.employeeExample2());
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString());
        }
        return employee;
    }

    public Employee employeeExample2() {
        if (this.containsObject(NLSEmployee.class, "0002")) {
            return (Employee)this.getObject(NLSEmployee.class, "0002");
        }
        Employee employee = this.basicEmployeeExample2();
        this.registerObject(NLSEmployee.class, employee, "0002");
        try {
            employee.addManagedEmployee(this.employeeExample6());
            employee.addManagedEmployee(this.employeeExample1());
            employee.addProject(this.smallProjectExample4());
            employee.addProject(this.smallProjectExample5());
            employee.addProject(this.largeProjectExample1());
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString());
        }
        return employee;
    }

    public Employee employeeExample3() {
        if (this.containsObject(NLSEmployee.class, "0003")) {
            return (Employee)this.getObject(NLSEmployee.class, "0003");
        }
        Employee employee = this.basicEmployeeExample3();
        this.registerObject(NLSEmployee.class, employee, "0003");
        try {
            employee.addProject(this.smallProjectExample4());
            employee.addProject(this.largeProjectExample4());
            employee.addProject(this.largeProjectExample5());
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString());
        }
        return employee;
    }

    public Employee employeeExample4() {
        if (this.containsObject(NLSEmployee.class, "0004")) {
            return (Employee)this.getObject(NLSEmployee.class, "0004");
        }
        Employee employee = this.basicEmployeeExample4();
        this.registerObject(NLSEmployee.class, employee, "0004");
        return employee;
    }

    public Employee employeeExample5() {
        if (this.containsObject(NLSEmployee.class, "0005")) {
            return (Employee)this.getObject(NLSEmployee.class, "0005");
        }
        Employee employee = this.basicEmployeeExample5();
        this.registerObject(NLSEmployee.class, employee, "0005");
        try {
            employee.addProject(this.smallProjectExample4());
            employee.addProject(this.largeProjectExample1());
            employee.addProject(this.largeProjectExample3());
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString());
        }
        return employee;
    }

    public Employee employeeExample6() {
        if (this.containsObject(NLSEmployee.class, "0006")) {
            return (Employee)this.getObject(NLSEmployee.class, "0006");
        }
        Employee employee = this.basicEmployeeExample6();
        this.registerObject(NLSEmployee.class, employee, "0006");
        try {
            employee.addProject(this.largeProjectExample2());
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString());
        }
        return employee;
    }

    public Employee employeeExample7() {
        if (this.containsObject(NLSEmployee.class, "0007")) {
            return (Employee)this.getObject(NLSEmployee.class, "0007");
        }
        Employee employee = this.basicEmployeeExample7();
        this.registerObject(NLSEmployee.class, employee, "0007");
        try {
            employee.addProject(this.largeProjectExample2());
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString());
        }
        return employee;
    }

    public Employee employeeExample8() {
        if (this.containsObject(NLSEmployee.class, "0008")) {
            return (Employee)this.getObject(NLSEmployee.class, "0008");
        }
        Employee employee = this.basicEmployeeExample8();
        this.registerObject(NLSEmployee.class, employee, "0008");
        return employee;
    }

    public Employee employeeExample9() {
        if (this.containsObject(NLSEmployee.class, "0009")) {
            return (Employee)this.getObject(NLSEmployee.class, "0009");
        }
        Employee employee = this.basicEmployeeExample9();
        this.registerObject(NLSEmployee.class, employee, "0009");
        return employee;
    }

    public EmploymentPeriod employmentPeriodExample1() {
        EmploymentPeriod employmentPeriod = new EmploymentPeriod();
        employmentPeriod.setEndDate(Helper.dateFromYearMonthDate((int)1996, (int)0, (int)1));
        employmentPeriod.setStartDate(Helper.dateFromYearMonthDate((int)1993, (int)0, (int)1));
        return employmentPeriod;
    }

    public EmploymentPeriod employmentPeriodExample10() {
        EmploymentPeriod employmentPeriod = new EmploymentPeriod();
        employmentPeriod.setStartDate(Helper.dateFromYearMonthDate((int)1991, (int)10, (int)11));
        return employmentPeriod;
    }

    public EmploymentPeriod employmentPeriodExample11() {
        EmploymentPeriod employmentPeriod = new EmploymentPeriod();
        employmentPeriod.setEndDate(Helper.dateFromYearMonthDate((int)1996, (int)0, (int)1));
        employmentPeriod.setStartDate(Helper.dateFromYearMonthDate((int)1993, (int)0, (int)1));
        return employmentPeriod;
    }

    public EmploymentPeriod employmentPeriodExample12() {
        EmploymentPeriod employmentPeriod = new EmploymentPeriod();
        employmentPeriod.setEndDate(Helper.dateFromYearMonthDate((int)1901, (int)11, (int)31));
        employmentPeriod.setStartDate(Helper.dateFromYearMonthDate((int)1995, (int)0, (int)12));
        return employmentPeriod;
    }

    public EmploymentPeriod employmentPeriodExample2() {
        EmploymentPeriod employmentPeriod = new EmploymentPeriod();
        employmentPeriod.setStartDate(Helper.dateFromYearMonthDate((int)1991, (int)10, (int)11));
        return employmentPeriod;
    }

    public EmploymentPeriod employmentPeriodExample3() {
        EmploymentPeriod employmentPeriod = new EmploymentPeriod();
        employmentPeriod.setEndDate(Helper.dateFromYearMonthDate((int)1901, (int)11, (int)31));
        employmentPeriod.setStartDate(Helper.dateFromYearMonthDate((int)1995, (int)0, (int)12));
        return employmentPeriod;
    }

    public EmploymentPeriod employmentPeriodExample4() {
        EmploymentPeriod employmentPeriod = new EmploymentPeriod();
        employmentPeriod.setEndDate(Helper.dateFromYearMonthDate((int)19101, (int)6, (int)31));
        employmentPeriod.setStartDate(Helper.dateFromYearMonthDate((int)1995, (int)4, (int)1));
        return employmentPeriod;
    }

    public EmploymentPeriod employmentPeriodExample5() {
        EmploymentPeriod employmentPeriod = new EmploymentPeriod();
        employmentPeriod.setEndDate(Helper.dateFromYearMonthDate((int)1901, (int)11, (int)31));
        employmentPeriod.setStartDate(Helper.dateFromYearMonthDate((int)14, (int)0, (int)1));
        return employmentPeriod;
    }

    public EmploymentPeriod employmentPeriodExample6() {
        EmploymentPeriod employmentPeriod = new EmploymentPeriod();
        employmentPeriod.setEndDate(Helper.dateFromYearMonthDate((int)1901, (int)11, (int)31));
        employmentPeriod.setStartDate(Helper.dateFromYearMonthDate((int)1995, (int)0, (int)12));
        return employmentPeriod;
    }

    public EmploymentPeriod employmentPeriodExample7() {
        EmploymentPeriod employmentPeriod = new EmploymentPeriod();
        employmentPeriod.setEndDate(Helper.dateFromYearMonthDate((int)1996, (int)0, (int)1));
        employmentPeriod.setStartDate(Helper.dateFromYearMonthDate((int)1993, (int)0, (int)1));
        return employmentPeriod;
    }

    public EmploymentPeriod employmentPeriodExample8() {
        EmploymentPeriod employmentPeriod = new EmploymentPeriod();
        employmentPeriod.setEndDate(Helper.dateFromYearMonthDate((int)1901, (int)11, (int)31));
        employmentPeriod.setStartDate(Helper.dateFromYearMonthDate((int)1895, (int)0, (int)1));
        return employmentPeriod;
    }

    public EmploymentPeriod employmentPeriodExample9() {
        EmploymentPeriod employmentPeriod = new EmploymentPeriod();
        employmentPeriod.setEndDate(Helper.dateFromYearMonthDate((int)1901, (int)11, (int)31));
        employmentPeriod.setStartDate(Helper.dateFromYearMonthDate((int)1895, (int)0, (int)1));
        return employmentPeriod;
    }

    protected Vector getAllObjects() {
        return this.populationManager.getAllObjects();
    }

    public Vector getAllObjectsForClass(Class domainClass) {
        return this.populationManager.getAllObjectsForClass(domainClass);
    }

    protected Object getObject(Class domainClass, String identifier) {
        return this.populationManager.getObject(domainClass, identifier);
    }

    public org.eclipse.persistence.testing.models.employee.interfaces.LargeProject largeProjectExample1() {
        if (this.containsObject(LargeProject.class, "0001")) {
            return (LargeProject)this.getObject(LargeProject.class, "0001");
        }
        org.eclipse.persistence.testing.models.employee.interfaces.LargeProject largeProject = this.basicLargeProjectExample1();
        this.registerObject(largeProject, "0001");
        try {
            largeProject.setTeamLeader(this.employeeExample2());
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString());
        }
        return largeProject;
    }

    public org.eclipse.persistence.testing.models.employee.interfaces.LargeProject largeProjectExample2() {
        if (this.containsObject(LargeProject.class, "0002")) {
            return (LargeProject)this.getObject(LargeProject.class, "0002");
        }
        org.eclipse.persistence.testing.models.employee.interfaces.LargeProject largeProject = this.basicLargeProjectExample2();
        this.registerObject(largeProject, "0002");
        return largeProject;
    }

    public org.eclipse.persistence.testing.models.employee.interfaces.LargeProject largeProjectExample3() {
        if (this.containsObject(LargeProject.class, "0003")) {
            return (LargeProject)this.getObject(LargeProject.class, "0003");
        }
        org.eclipse.persistence.testing.models.employee.interfaces.LargeProject largeProject = this.basicLargeProjectExample3();
        this.registerObject(largeProject, "0003");
        return largeProject;
    }

    public org.eclipse.persistence.testing.models.employee.interfaces.LargeProject largeProjectExample4() {
        if (this.containsObject(LargeProject.class, "0004")) {
            return (LargeProject)this.getObject(LargeProject.class, "0004");
        }
        org.eclipse.persistence.testing.models.employee.interfaces.LargeProject largeProject = this.basicLargeProjectExample4();
        this.registerObject(largeProject, "0004");
        try {
            largeProject.setTeamLeader(this.employeeExample3());
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString());
        }
        return largeProject;
    }

    public org.eclipse.persistence.testing.models.employee.interfaces.LargeProject largeProjectExample5() {
        if (this.containsObject(LargeProject.class, "0005")) {
            return (LargeProject)this.getObject(LargeProject.class, "0005");
        }
        org.eclipse.persistence.testing.models.employee.interfaces.LargeProject largeProject = this.basicLargeProjectExample5();
        this.registerObject(largeProject, "0005");
        try {
            largeProject.setTeamLeader(this.employeeExample5());
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString());
        }
        return largeProject;
    }

    public PhoneNumber phoneNumberExample1() {
        return new PhoneNumber("\u306c\u30db\u30c4\u30b5", "613", "2258812");
    }

    public PhoneNumber phoneNumberExample2() {
        return new PhoneNumber("\u306c\u30db\u30c4\u30b5 \u304b\u30a2\u30cd", "613", "2255943");
    }

    public PhoneNumber phoneNumberExample3() {
        return new PhoneNumber("\u304f\u30db\u30b9\u30aa", "613", "5551234");
    }

    public PhoneNumber phoneNumberExample4() {
        return new PhoneNumber("\u3046\u30aa\u30b7\u30b7\u30ca\u30b7\u30a2\u30c4", "416", "5551111");
    }

    public PhoneNumber phoneNumberExample5() {
        return new PhoneNumber("\u305f\u30a2\u30ad\u30aa\u30c4", "976", "5556666");
    }

    public PhoneNumber phoneNumberExample6() {
        return new PhoneNumber("\u3051\u3066\u3048\u305b", "905", "5553691");
    }

    protected void registerObject(Class domainClass, Object domainObject, String identifier) {
        this.populationManager.registerObject(domainClass, domainObject, identifier);
    }

    protected void registerObject(Object domainObject, String identifier) {
        this.populationManager.registerObject(domainObject, identifier);
    }

    public SmallProject smallProjectExample1() {
        if (this.containsObject(org.eclipse.persistence.testing.models.employee.domain.SmallProject.class, "0001")) {
            return (org.eclipse.persistence.testing.models.employee.domain.SmallProject)this.getObject(org.eclipse.persistence.testing.models.employee.domain.SmallProject.class, "0001");
        }
        SmallProject smallProject = this.basicSmallProjectExample1();
        this.registerObject(smallProject, "0001");
        return smallProject;
    }

    public SmallProject smallProjectExample10() {
        if (this.containsObject(org.eclipse.persistence.testing.models.employee.domain.SmallProject.class, "0010")) {
            return (org.eclipse.persistence.testing.models.employee.domain.SmallProject)this.getObject(org.eclipse.persistence.testing.models.employee.domain.SmallProject.class, "0010");
        }
        SmallProject smallProject = this.basicSmallProjectExample10();
        this.registerObject(smallProject, "0010");
        return smallProject;
    }

    public SmallProject smallProjectExample2() {
        if (this.containsObject(org.eclipse.persistence.testing.models.employee.domain.SmallProject.class, "0002")) {
            return (org.eclipse.persistence.testing.models.employee.domain.SmallProject)this.getObject(org.eclipse.persistence.testing.models.employee.domain.SmallProject.class, "0002");
        }
        SmallProject smallProject = this.basicSmallProjectExample2();
        this.registerObject(smallProject, "0002");
        return smallProject;
    }

    public SmallProject smallProjectExample3() {
        if (this.containsObject(org.eclipse.persistence.testing.models.employee.domain.SmallProject.class, "0003")) {
            return (org.eclipse.persistence.testing.models.employee.domain.SmallProject)this.getObject(org.eclipse.persistence.testing.models.employee.domain.SmallProject.class, "0003");
        }
        SmallProject smallProject = this.basicSmallProjectExample3();
        this.registerObject(smallProject, "0003");
        return smallProject;
    }

    public SmallProject smallProjectExample4() {
        if (this.containsObject(org.eclipse.persistence.testing.models.employee.domain.SmallProject.class, "0004")) {
            return (org.eclipse.persistence.testing.models.employee.domain.SmallProject)this.getObject(org.eclipse.persistence.testing.models.employee.domain.SmallProject.class, "0004");
        }
        SmallProject smallProject = this.basicSmallProjectExample4();
        this.registerObject(smallProject, "0004");
        return smallProject;
    }

    public SmallProject smallProjectExample5() {
        if (this.containsObject(org.eclipse.persistence.testing.models.employee.domain.SmallProject.class, "0005")) {
            return (org.eclipse.persistence.testing.models.employee.domain.SmallProject)this.getObject(org.eclipse.persistence.testing.models.employee.domain.SmallProject.class, "0005");
        }
        SmallProject smallProject = this.basicSmallProjectExample5();
        this.registerObject(smallProject, "0005");
        return smallProject;
    }

    public SmallProject smallProjectExample6() {
        if (this.containsObject(org.eclipse.persistence.testing.models.employee.domain.SmallProject.class, "0006")) {
            return (org.eclipse.persistence.testing.models.employee.domain.SmallProject)this.getObject(org.eclipse.persistence.testing.models.employee.domain.SmallProject.class, "0006");
        }
        SmallProject smallProject = this.basicSmallProjectExample6();
        this.registerObject(smallProject, "0006");
        return smallProject;
    }

    public SmallProject smallProjectExample7() {
        if (this.containsObject(org.eclipse.persistence.testing.models.employee.domain.SmallProject.class, "0007")) {
            return (org.eclipse.persistence.testing.models.employee.domain.SmallProject)this.getObject(org.eclipse.persistence.testing.models.employee.domain.SmallProject.class, "0007");
        }
        SmallProject smallProject = this.basicSmallProjectExample7();
        this.registerObject(smallProject, "0007");
        return smallProject;
    }

    public SmallProject smallProjectExample8() {
        if (this.containsObject(org.eclipse.persistence.testing.models.employee.domain.SmallProject.class, "0008")) {
            return (org.eclipse.persistence.testing.models.employee.domain.SmallProject)this.getObject(org.eclipse.persistence.testing.models.employee.domain.SmallProject.class, "0008");
        }
        SmallProject smallProject = this.basicSmallProjectExample8();
        this.registerObject(smallProject, "0008");
        return smallProject;
    }

    public SmallProject smallProjectExample9() {
        if (this.containsObject(org.eclipse.persistence.testing.models.employee.domain.SmallProject.class, "0009")) {
            return (org.eclipse.persistence.testing.models.employee.domain.SmallProject)this.getObject(org.eclipse.persistence.testing.models.employee.domain.SmallProject.class, "0009");
        }
        SmallProject smallProject = this.basicSmallProjectExample9();
        this.registerObject(smallProject, "0009");
        return smallProject;
    }
}

