/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.optimization.queryandsqlcounting.querycache;

import java.util.Vector;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DataReadQuery;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.QueryResultsCachePolicy;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.optimization.queryandsqlcounting.QuerySQLTracker;

public class QueryCacheHitTest
extends TestCase {
    private String testType;
    protected QuerySQLTracker tracker = null;
    public static final String NO_RESULTS_CACHED_READALL = "testNoResultsCachedReadAll";
    public static final String VALID_RESULTS_CACHED_READALL = "testValidResultsCachedReadAll";
    public static final String NO_RESULTS_CACHED_READOBJECT = "testNoResultsCachedReadObject";
    public static final String VALID_RESULTS_CACHED_READOBJECT = "testValidResultsCachedReadObject";
    public static final String NO_RESULTS_CACHED_DATAREAD = "testNoResultsCachedDataRead";
    public static final String VALID_RESULTS_CACHED_DATAREAD = "testValidResultsCachedDataRead";

    public QueryCacheHitTest(String testType) {
        this.testType = testType;
        this.setDescription("Test to ensure that the database is not hit for queries that are cached, including cached zero results.");
    }

    public void setup() {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        this.tracker = new QuerySQLTracker(this.getSession());
    }

    public void test() {
        if (this.testType == NO_RESULTS_CACHED_DATAREAD) {
            this.testNoResultsCachedDataRead();
        } else if (this.testType == NO_RESULTS_CACHED_READALL) {
            this.testNoResultsCachedReadAll();
        } else if (this.testType == VALID_RESULTS_CACHED_READALL) {
            this.testValidResultsCachedReadAll();
        } else if (this.testType == NO_RESULTS_CACHED_READOBJECT) {
            this.testNoResultsCachedReadObject();
        } else if (this.testType == VALID_RESULTS_CACHED_READOBJECT) {
            this.testValidResultsCachedReadObject();
        } else if (this.testType == NO_RESULTS_CACHED_DATAREAD) {
            this.testNoResultsCachedDataRead();
        } else if (this.testType == VALID_RESULTS_CACHED_DATAREAD) {
            this.testValidResultsCachedDataRead();
        } else {
            throw new TestErrorException("Invalid test type (" + this.testType + ") passed");
        }
    }

    public void testNoResultsCachedReadAll() {
        ReadAllQuery query = new ReadAllQuery(Employee.class);
        ExpressionBuilder builder = query.getExpressionBuilder();
        Expression exp = builder.get("firstName").like(builder.getParameter("fName"));
        query.setSelectionCriteria(exp);
        query.addArgument("fName");
        query.setQueryResultsCachePolicy(new QueryResultsCachePolicy(2));
        Vector<String> params = new Vector<String>(1);
        params.add("impossiblefirstname");
        for (int i = 0; i < 3; ++i) {
            Vector results = (Vector)this.getSession().executeQuery((DatabaseQuery)query, params);
            QueryCacheHitTest.assertNotNull((Object)results);
            if (results != null) {
                QueryCacheHitTest.assertTrue((boolean)results.isEmpty());
            }
            QueryCacheHitTest.assertEquals((int)this.tracker.getSqlStatements().size(), (int)1);
        }
    }

    public void testValidResultsCachedReadAll() {
        ReadAllQuery query = new ReadAllQuery(Employee.class);
        ExpressionBuilder builder = query.getExpressionBuilder();
        Expression exp = builder.get("firstName").like(builder.getParameter("fName"));
        query.setSelectionCriteria(exp);
        query.addArgument("fName");
        query.setQueryResultsCachePolicy(new QueryResultsCachePolicy(2));
        Vector<String> params = new Vector<String>(1);
        params.add("B%");
        for (int i = 0; i < 3; ++i) {
            Vector results = (Vector)this.getSession().executeQuery((DatabaseQuery)query, params);
            QueryCacheHitTest.assertNotNull((Object)results);
            if (results != null) {
                QueryCacheHitTest.assertTrue((!results.isEmpty() ? 1 : 0) != 0);
            }
            QueryCacheHitTest.assertEquals((int)this.tracker.getSqlStatements().size(), (int)1);
        }
    }

    public void testNoResultsCachedReadObject() {
        ReadObjectQuery query = new ReadObjectQuery(Employee.class);
        ExpressionBuilder builder2 = query.getExpressionBuilder();
        Expression exp2 = builder2.get("lastName").like(builder2.getParameter("lName"));
        query.setSelectionCriteria(exp2);
        query.addArgument("lName");
        query.setQueryResultsCachePolicy(new QueryResultsCachePolicy(2));
        Vector<String> params = new Vector<String>(1);
        params.add("impossiblelastname");
        for (int i = 0; i < 3; ++i) {
            Object result = this.getSession().executeQuery((DatabaseQuery)query, params);
            QueryCacheHitTest.assertNull((Object)result);
            QueryCacheHitTest.assertEquals((int)this.tracker.getSqlStatements().size(), (int)1);
        }
    }

    public void testValidResultsCachedReadObject() {
        ReadObjectQuery query = new ReadObjectQuery(Employee.class);
        ExpressionBuilder builder2 = query.getExpressionBuilder();
        Expression exp2 = builder2.get("lastName").like(builder2.getParameter("lName"));
        query.setSelectionCriteria(exp2);
        query.addArgument("lName");
        query.setQueryResultsCachePolicy(new QueryResultsCachePolicy(2));
        Vector<String> params = new Vector<String>(1);
        params.add("Smith");
        for (int i = 0; i < 3; ++i) {
            Object result = this.getSession().executeQuery((DatabaseQuery)query, params);
            QueryCacheHitTest.assertNotNull((Object)result);
            QueryCacheHitTest.assertEquals((int)this.tracker.getSqlStatements().size(), (int)1);
        }
    }

    public void testNoResultsCachedDataRead() {
        DataReadQuery dataReadQuery1 = new DataReadQuery();
        String sqlString1 = "SELECT F_NAME, L_NAME FROM EMPLOYEE WHERE F_NAME = 'impossible'";
        dataReadQuery1.setSQLString(sqlString1);
        dataReadQuery1.setQueryResultsCachePolicy(new QueryResultsCachePolicy(2));
        for (int i = 0; i < 3; ++i) {
            Vector results = (Vector)this.getSession().executeQuery((DatabaseQuery)dataReadQuery1);
            QueryCacheHitTest.assertNotNull((Object)results);
            if (results != null) {
                QueryCacheHitTest.assertTrue((boolean)results.isEmpty());
            }
            QueryCacheHitTest.assertEquals((int)this.tracker.getSqlStatements().size(), (int)1);
        }
    }

    public void testValidResultsCachedDataRead() {
        DataReadQuery dataReadQuery2 = new DataReadQuery();
        String sqlString2 = "SELECT F_NAME, L_NAME FROM EMPLOYEE";
        dataReadQuery2.setSQLString(sqlString2);
        dataReadQuery2.setQueryResultsCachePolicy(new QueryResultsCachePolicy(2));
        for (int i = 0; i < 3; ++i) {
            Vector results = (Vector)this.getSession().executeQuery((DatabaseQuery)dataReadQuery2);
            QueryCacheHitTest.assertNotNull((Object)results);
            if (results != null) {
                QueryCacheHitTest.assertTrue((!results.isEmpty() ? 1 : 0) != 0);
            }
            QueryCacheHitTest.assertEquals((int)this.tracker.getSqlStatements().size(), (int)1);
        }
    }

    public void reset() {
        this.tracker.remove();
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
    }
}

