/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries;

import java.util.Vector;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class ConformingTestConfiguration {
    UnitOfWork unitOfWork;

    public void setup(Session session) {
        this.unitOfWork = session.acquireUnitOfWork();
        ExpressionBuilder emp = new ExpressionBuilder();
        Expression criteria = emp.get("salary").lessThan(50000);
        ReadAllQuery query = new ReadAllQuery(Employee.class, criteria);
        Vector initiallyUnconforming = (Vector)session.executeQuery((DatabaseQuery)query);
        Employee modifiedIn1 = (Employee)this.unitOfWork.registerExistingObject(initiallyUnconforming.elementAt(0));
        Employee modifiedIn2 = (Employee)this.unitOfWork.registerExistingObject(initiallyUnconforming.elementAt(initiallyUnconforming.size() - 1));
        Employee newEmployee = (Employee)this.unitOfWork.newInstance(Employee.class);
        emp = new ExpressionBuilder();
        criteria = emp.get("salary").greaterThan(50000);
        query = new ReadAllQuery(Employee.class, criteria);
        Vector initiallyConforming = (Vector)session.executeQuery((DatabaseQuery)query);
        Employee deleted = (Employee)initiallyConforming.elementAt(0);
        Employee modifiedOut1 = (Employee)this.unitOfWork.registerExistingObject(initiallyConforming.elementAt(1));
        Employee modifiedOut2 = (Employee)this.unitOfWork.registerExistingObject(initiallyConforming.elementAt(initiallyConforming.size() - 1));
        modifiedIn1.setSalary(80000);
        modifiedIn2.setSalary(70000);
        newEmployee.setSalary(60000);
        this.unitOfWork.deleteObject((Object)deleted);
        modifiedOut1.setSalary(40000);
        modifiedOut2.setSalary(30000);
    }

    public void reset() {
        this.unitOfWork.release();
    }

    public UnitOfWork getUnitOfWork() {
        return this.unitOfWork;
    }

    public void setUnitOfWork(UnitOfWork unitOfWork) {
        this.unitOfWork = unitOfWork;
    }
}

