/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.returning;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.InsertObjectQuery;
import org.eclipse.persistence.queries.StoredProcedureCall;
import org.eclipse.persistence.queries.UpdateObjectQuery;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.tools.schemaframework.FieldDefinition;
import org.eclipse.persistence.tools.schemaframework.SchemaManager;
import org.eclipse.persistence.tools.schemaframework.StoredProcedureDefinition;
import org.eclipse.persistence.tools.schemaframework.StoredProcedureGenerator;

public class StoredProcedureGeneratorForAdapter
extends StoredProcedureGenerator {
    protected Hashtable insertStoredProcedures = new Hashtable();
    protected Hashtable updateStoredProcedures = new Hashtable();
    protected Hashtable substituteName = new Hashtable();
    protected boolean useTableNames;

    public StoredProcedureGeneratorForAdapter(SchemaManager schemaMngr) {
        super(schemaMngr);
    }

    public boolean usesTableNames() {
        return this.useTableNames;
    }

    public void setUseTableNames(boolean useTableNames) {
        this.useTableNames = useTableNames;
    }

    public void generateInsertStoredProceduresDefinitionsForProject(Project project) {
        this.verifyProject(project);
        Map descrpts = project.getDescriptors();
        Iterator iterator = descrpts.keySet().iterator();
        while (iterator.hasNext()) {
            ClassDescriptor desc = (ClassDescriptor)descrpts.get(iterator.next());
            if (desc.isDescriptorForInterface() || desc.isAggregateDescriptor()) continue;
            if (!desc.getQueryManager().hasInsertQuery()) {
                InsertObjectQuery insertQuery = new InsertObjectQuery();
                insertQuery.setModifyRow(desc.getObjectBuilder().buildTemplateInsertRow(this.getSession()));
                desc.getQueryManager().setInsertQuery(insertQuery);
            }
            StoredProcedureDefinition definition = this.generateStoredProcedureDefinition(desc, (DatabaseQuery)desc.getQueryManager().getInsertQuery(), "INS_");
            this.insertStoredProcedures.put(desc, definition);
        }
    }

    public void generateUpdateStoredProceduresDefinitionsForProject(Project project) {
        this.verifyProject(project);
        Map descrpts = project.getDescriptors();
        Iterator iterator = descrpts.keySet().iterator();
        while (iterator.hasNext()) {
            ClassDescriptor desc = (ClassDescriptor)descrpts.get(iterator.next());
            if (desc.isDescriptorForInterface() || desc.isAggregateDescriptor()) continue;
            if (!desc.getQueryManager().hasUpdateQuery()) {
                UpdateObjectQuery updateQuery = new UpdateObjectQuery();
                updateQuery.setModifyRow(desc.getObjectBuilder().buildTemplateUpdateRow(this.getSession()));
                if (updateQuery.getModifyRow().size() > 0) {
                    desc.getQueryManager().setUpdateQuery(updateQuery);
                }
            }
            if (desc.getQueryManager().getUpdateQuery() == null) continue;
            StoredProcedureDefinition definition = this.generateStoredProcedureDefinition(desc, (DatabaseQuery)desc.getQueryManager().getUpdateQuery(), "UPD_");
            this.updateStoredProcedures.put(desc, definition);
        }
    }

    protected StoredProcedureDefinition generateStoredProcedureDefinition(ClassDescriptor desc, DatabaseQuery query, String namePrefix) {
        Vector fields = desc.getFields();
        Hashtable namesNewToNames = null;
        if (this.shouldCapitalizeNames()) {
            namesNewToNames = new Hashtable();
            fields = this.capitalize(fields, namesNewToNames);
        }
        StoredProcedureDefinition definition = this.generateObjectStoredProcedure(query, fields, namePrefix);
        if (namesNewToNames != null && !namesNewToNames.isEmpty()) {
            this.substituteName.put(definition, namesNewToNames);
        }
        return definition;
    }

    public void generateStoredProceduresDefinitionsForProject(Project project) {
        this.generateInsertStoredProceduresDefinitionsForProject(project);
        this.generateUpdateStoredProceduresDefinitionsForProject(project);
    }

    public void writeInsertStoredProcedures() {
        Enumeration descriptorEnum = this.insertStoredProcedures.keys();
        while (descriptorEnum.hasMoreElements()) {
            ClassDescriptor descriptor = (ClassDescriptor)descriptorEnum.nextElement();
            StoredProcedureDefinition definition = (StoredProcedureDefinition)this.insertStoredProcedures.get(descriptor);
            this.writeDefinition(definition);
        }
    }

    public void writeUpdateStoredProcedures() {
        Enumeration descriptorEnum = this.updateStoredProcedures.keys();
        while (descriptorEnum.hasMoreElements()) {
            ClassDescriptor descriptor = (ClassDescriptor)descriptorEnum.nextElement();
            StoredProcedureDefinition definition = (StoredProcedureDefinition)this.updateStoredProcedures.get(descriptor);
            this.writeDefinition(definition);
        }
    }

    public void writeStoredProcedures() {
        this.writeInsertStoredProcedures();
        this.writeUpdateStoredProcedures();
    }

    protected void verify() throws ValidationException {
    }

    protected void verifyProject(Project project) {
        if (project.usesOptimisticLocking()) {
            throw ValidationException.optimisticLockingNotSupportedWithStoredProcedureGeneration();
        }
    }

    public void amendDescriptorsInsertQuery() {
        Enumeration descriptorEnum = this.insertStoredProcedures.keys();
        while (descriptorEnum.hasMoreElements()) {
            ClassDescriptor descriptor = (ClassDescriptor)descriptorEnum.nextElement();
            StoredProcedureDefinition definition = (StoredProcedureDefinition)this.insertStoredProcedures.get(descriptor);
            InsertObjectQuery insertQuery = new InsertObjectQuery();
            this.defineQuery((DatabaseQuery)insertQuery, definition);
            descriptor.getQueryManager().setInsertQuery(insertQuery);
        }
    }

    public void amendDescriptorsUpdateQuery() {
        Enumeration descriptorEnum = this.updateStoredProcedures.keys();
        while (descriptorEnum.hasMoreElements()) {
            ClassDescriptor descriptor = (ClassDescriptor)descriptorEnum.nextElement();
            StoredProcedureDefinition definition = (StoredProcedureDefinition)this.updateStoredProcedures.get(descriptor);
            UpdateObjectQuery updateQuery = new UpdateObjectQuery();
            descriptor.getQueryManager().setUpdateQuery(updateQuery);
        }
    }

    public void defineQuery(DatabaseQuery query, StoredProcedureDefinition definition) {
        Hashtable namesNewToNames = (Hashtable)this.substituteName.get(definition);
        query.setShouldBindAllParameters(true);
        StoredProcedureCall call = new StoredProcedureCall();
        call.setProcedureName(definition.getName());
        for (int i = 0; i < definition.getArguments().size(); ++i) {
            String fieldNameOriginal;
            String fieldName;
            FieldDefinition fieldDefinition = (FieldDefinition)definition.getArguments().elementAt(i);
            String procedureParameterName = fieldDefinition.getName();
            String argumentFieldName = fieldName = this.getFieldName(fieldDefinition.getName());
            if (namesNewToNames != null && (fieldNameOriginal = (String)namesNewToNames.get(fieldName)) != null) {
                argumentFieldName = fieldNameOriginal;
            }
            call.addNamedArgument(procedureParameterName, argumentFieldName);
        }
        query.setCall((Call)call);
    }

    public void amendDescriptors() {
        this.amendDescriptorsInsertQuery();
        this.amendDescriptorsUpdateQuery();
    }

    protected Vector capitalize(Vector fields, Hashtable namesCapitalizedToNames) {
        Vector newFields = null;
        for (int i = 0; i < fields.size(); ++i) {
            DatabaseField field = (DatabaseField)fields.elementAt(i);
            String fieldNameUpper = field.getName().toUpperCase();
            String tableNameUpper = field.getTableName().toUpperCase();
            if (fieldNameUpper.equals(field.getName()) && tableNameUpper.equals(field.getTableName())) continue;
            DatabaseField newField = new DatabaseField(fieldNameUpper, tableNameUpper);
            newField.setType(field.getType());
            if (newFields == null) {
                newFields = (Vector)fields.clone();
            }
            newFields.set(i, newField);
            namesCapitalizedToNames.put(fieldNameUpper, field.getName());
        }
        if (newFields == null) {
            return fields;
        }
        return newFields;
    }

    protected boolean shouldCapitalizeNames() {
        return this.getSession().getPlatform().isOracle();
    }

    protected String shortClassName(String originalClassName, int numberOfPackagesToIncludeIntoShortName) {
        int nLastIndex = originalClassName.length() - 1;
        for (int i = 0; i <= numberOfPackagesToIncludeIntoShortName && nLastIndex > 0; ++i) {
            nLastIndex = originalClassName.lastIndexOf(46, nLastIndex - 1);
        }
        if (nLastIndex < 0 || nLastIndex == originalClassName.length() - 1) {
            return new String(originalClassName);
        }
        return originalClassName.substring(nLastIndex + 1);
    }

    protected StoredProcedureDefinition generateObjectStoredProcedure(DatabaseQuery query, Vector fields, String namePrefix) {
        String tableName;
        String namePrefixToUse = namePrefix;
        String className = Helper.getShortClassName((Class)query.getDescriptor().getJavaClass());
        if (this.useTableNames && !this.compareNames(className, tableName = query.getDescriptor().getTableName())) {
            namePrefixToUse = namePrefix + tableName + "_";
        }
        return this.generateStoredProcedure(query, fields, this.getPrefix() + namePrefixToUse + className);
    }

    protected boolean compareNames(String name1, String name2) {
        if (this.shouldCapitalizeNames()) {
            return name1.equalsIgnoreCase(name2);
        }
        return name1.equals(name2);
    }
}

