/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.sessionbroker;

import java.util.Vector;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.databaseaccess.Platform;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.DeleteAllQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.UpdateAllQuery;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.sessions.broker.SessionBroker;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.models.employee.domain.Address;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.relational.EmployeeProject;
import org.eclipse.persistence.testing.tests.sessionbroker.CustomDatabasePlatform;
import org.eclipse.persistence.testing.tests.sessionbroker.ServerBrokerTestModel;

public class SessionBrokerCustomFunctionTest
extends TestCase {
    protected SessionBroker sessionBroker;
    protected int testType = -1;
    public static final int READALLQUERY_TEST = 0;
    public static final int UPDATEALLQUERY_TEST = 1;
    public static final int DELETEALLQUERY_TEST = 2;

    public SessionBrokerCustomFunctionTest(int testType) {
        this.setDescription("Test using custom functions in a platform subclass using session broker");
        this.testType = testType;
    }

    public void setup() {
        EmployeeProject project = new EmployeeProject();
        DatabaseLogin login = ServerBrokerTestModel.getLogin1();
        login.setPlatform((Platform)new CustomDatabasePlatform());
        project.setLogin(login);
        DatabaseSession aSession = project.createDatabaseSession();
        this.sessionBroker = new SessionBroker();
        this.sessionBroker.registerSession("broker1", (Session)aSession);
        this.sessionBroker.setSessionLog(this.getSession().getSessionLog());
        this.sessionBroker.setLogLevel(this.getSession().getLogLevel());
        this.sessionBroker.login();
    }

    public void test() {
        if (this.testType == 0) {
            this.testReadAllQuery();
        } else if (this.testType == 1) {
            this.testUpdateAllQuery();
        } else if (this.testType == 2) {
            this.testDeleteAllQueryTest();
        } else {
            this.throwError("test: Invalid test indicator passed to constructor: " + this.testType);
        }
    }

    public void testReadAllQuery() {
        try {
            UnitOfWorkImpl uow = this.sessionBroker.acquireUnitOfWork();
            ReadAllQuery query = new ReadAllQuery(Address.class);
            ExpressionBuilder builder = query.getExpressionBuilder();
            Vector<Expression> args = new Vector<Expression>();
            args.add(builder.get("country"));
            Expression expression = builder.getFunction(CustomDatabasePlatform.OPERATOR_SELECTOR, args).equal((Object)"CANADA");
            query.setSelectionCriteria(expression);
            uow.executeQuery((DatabaseQuery)query);
        }
        catch (EclipseLinkException exception) {
            this.throwError("testReadAllQuery: failed to use configured platform to acquire custom function: " + exception.getMessage());
        }
    }

    public void testUpdateAllQuery() {
        try {
            DatabaseSession session = (DatabaseSession)this.sessionBroker.getSessionForName("broker1");
            session.beginTransaction();
            UnitOfWork uow = session.acquireUnitOfWork();
            UpdateAllQuery query = new UpdateAllQuery(Employee.class);
            ExpressionBuilder builder = query.getExpressionBuilder();
            Vector<Expression> args = new Vector<Expression>();
            args.add(builder.get("lastName"));
            Expression expression = builder.getFunction(CustomDatabasePlatform.OPERATOR_SELECTOR, args).equal((Object)"SMITH");
            query.setSelectionCriteria(expression);
            query.addUpdate(builder.get("lastName"), (Object)"oneincrediblyunlikelylastname");
            uow.executeQuery((DatabaseQuery)query);
            uow.commit();
            session.rollbackTransaction();
        }
        catch (EclipseLinkException exception) {
            this.throwError("testUpdateAllQuery: failed to use configured platform to acquire custom function: " + exception.getMessage());
        }
    }

    public void testDeleteAllQueryTest() {
        try {
            DatabaseSession session = (DatabaseSession)this.sessionBroker.getSessionForName("broker1");
            session.beginTransaction();
            UnitOfWork uow = session.acquireUnitOfWork();
            DeleteAllQuery query = new DeleteAllQuery(Employee.class);
            ExpressionBuilder builder = query.getExpressionBuilder();
            Vector<Expression> args = new Vector<Expression>();
            args.add(builder.get("lastName"));
            Expression expression = builder.getFunction(CustomDatabasePlatform.OPERATOR_SELECTOR, args).equal((Object)"SMITH");
            query.setSelectionCriteria(expression);
            uow.executeQuery((DatabaseQuery)query);
            uow.commit();
            session.rollbackTransaction();
        }
        catch (EclipseLinkException exception) {
            this.throwError("testDeleteAllQueryTest: failed to use configured platform to acquire custom function: " + exception.getMessage());
        }
    }

    public void reset() {
        this.sessionBroker.logout();
    }
}

