/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.transparentindirection;

import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.transparentindirection.Player;
import org.eclipse.persistence.testing.models.transparentindirection.Team;

public class BidirectionalRelationshipMaintenanceTest
extends AutoVerifyTestCase {
    boolean m_exceptionCaught;

    public BidirectionalRelationshipMaintenanceTest() {
        this.setDescription("Test bidrectional relationship maintenance on an indirect transparent map.");
    }

    public void reset() {
        this.rollbackTransaction();
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
    }

    public void setup() throws Exception {
        this.m_exceptionCaught = false;
        this.beginTransaction();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public void test() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        Team team = (Team)uow.registerObject((Object)new Team());
        Player player = (Player)uow.registerObject((Object)new Player());
        player.setTeam(team);
        try {
            uow.commit();
        }
        catch (Exception e) {
            this.m_exceptionCaught = true;
        }
    }

    public void verify() throws Exception {
        if (this.m_exceptionCaught) {
            throw new TestErrorException("Relationship maintenance failed.");
        }
    }
}

