/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database.oracle.plsql;

import java.io.Serializable;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.databaseaccess.DatabaseAccessor;
import org.eclipse.persistence.internal.helper.ComplexDatabaseType;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseType;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.structures.ObjectRelationalDatabaseField;
import org.eclipse.persistence.platform.database.jdbc.JDBCTypes;
import org.eclipse.persistence.platform.database.oracle.jdbc.OracleArrayType;
import org.eclipse.persistence.platform.database.oracle.plsql.OraclePLSQLTypes;
import org.eclipse.persistence.platform.database.oracle.plsql.PLSQLCollection;
import org.eclipse.persistence.platform.database.oracle.plsql.PLSQLargument;
import org.eclipse.persistence.platform.database.oracle.plsql.PLSQLrecord;
import org.eclipse.persistence.queries.StoredProcedureCall;
import org.eclipse.persistence.sessions.DatabaseRecord;

public class PLSQLStoredProcedureCall
extends StoredProcedureCall {
    static final String BEGIN_DECLARE_BLOCK = "\nDECLARE\n";
    static final String BEGIN_BEGIN_BLOCK = "BEGIN\n";
    static final String END_BEGIN_BLOCK = "END;";
    static final String PL2SQL_PREFIX = "EL_PL2SQL_";
    static final String SQL2PL_PREFIX = "EL_SQL2PL_";
    static final String BEGIN_DECLARE_FUNCTION = "FUNCTION ";
    static final String RTURN = "RETURN ";
    protected List<PLSQLargument> arguments = new ArrayList<PLSQLargument>();
    protected int originalIndex = 0;
    protected AbstractRecord translationRow;
    protected Map<String, TypeInfo> typesInfo;
    protected int functionId = 0;

    public PLSQLStoredProcedureCall() {
        this.setIsCallableStatementRequired(true);
    }

    public void addNamedArgument(String procedureParameterName, DatabaseType databaseType) {
        DatabaseType dt = databaseType.isComplexDatabaseType() ? ((ComplexDatabaseType)databaseType).clone() : databaseType;
        this.arguments.add(new PLSQLargument(procedureParameterName, this.originalIndex++, IN, dt));
    }

    public void addNamedArgument(String procedureParameterName, DatabaseType databaseType, int length) {
        DatabaseType dt = databaseType.isComplexDatabaseType() ? ((ComplexDatabaseType)databaseType).clone() : databaseType;
        this.arguments.add(new PLSQLargument(procedureParameterName, this.originalIndex++, IN, dt, length));
    }

    public void addNamedArgument(String procedureParameterName, DatabaseType databaseType, int precision, int scale) {
        DatabaseType dt = databaseType.isComplexDatabaseType() ? ((ComplexDatabaseType)databaseType).clone() : databaseType;
        this.arguments.add(new PLSQLargument(procedureParameterName, this.originalIndex++, IN, dt, precision, scale));
    }

    @Override
    public void addNamedArgument(String procedureParameterName, String argumentFieldName, int type) {
        this.arguments.add(new PLSQLargument(procedureParameterName, this.originalIndex++, IN, JDBCTypes.getDatabaseTypeForCode(type)));
    }

    @Override
    public void addNamedArgument(String procedureParameterName, String argumentFieldName, int type, String typeName) {
        this.arguments.add(new PLSQLargument(procedureParameterName, this.originalIndex++, IN, JDBCTypes.getDatabaseTypeForCode(type)));
    }

    public void addNamedInOutputArgument(String procedureParameterName, DatabaseType databaseType) {
        DatabaseType dt = databaseType.isComplexDatabaseType() ? ((ComplexDatabaseType)databaseType).clone() : databaseType;
        this.arguments.add(new PLSQLargument(procedureParameterName, this.originalIndex++, INOUT, dt));
    }

    public void addNamedInOutputArgument(String procedureParameterName, DatabaseType databaseType, int length) {
        DatabaseType dt = databaseType.isComplexDatabaseType() ? ((ComplexDatabaseType)databaseType).clone() : databaseType;
        this.arguments.add(new PLSQLargument(procedureParameterName, this.originalIndex++, INOUT, dt, length));
    }

    public void addNamedInOutputArgument(String procedureParameterName, DatabaseType databaseType, int precision, int scale) {
        DatabaseType dt = databaseType.isComplexDatabaseType() ? ((ComplexDatabaseType)databaseType).clone() : databaseType;
        this.arguments.add(new PLSQLargument(procedureParameterName, this.originalIndex++, INOUT, dt, precision, scale));
    }

    @Override
    public void addNamedInOutputArgument(String procedureParameterName, String inArgumentFieldName, String outArgumentFieldName, int type) {
        this.arguments.add(new PLSQLargument(procedureParameterName, this.originalIndex++, INOUT, JDBCTypes.getDatabaseTypeForCode(type)));
    }

    @Override
    public void addNamedInOutputArgument(String procedureParameterName, String inArgumentFieldName, String outArgumentFieldName, int type, String typeName) {
        this.arguments.add(new PLSQLargument(procedureParameterName, this.originalIndex++, INOUT, JDBCTypes.getDatabaseTypeForCode(type)));
    }

    @Override
    public void addNamedInOutputArgument(String procedureParameterName, String inArgumentFieldName, String outArgumentFieldName, int type, String typeName, Class classType) {
        this.arguments.add(new PLSQLargument(procedureParameterName, this.originalIndex++, INOUT, JDBCTypes.getDatabaseTypeForCode(type)));
    }

    @Override
    public void addNamedInOutputArgument(String procedureParameterName, String inArgumentFieldName, String outArgumentFieldName, int type, String typeName, Class javaType, DatabaseField nestedType) {
        this.arguments.add(new PLSQLargument(procedureParameterName, this.originalIndex++, INOUT, JDBCTypes.getDatabaseTypeForCode(type)));
    }

    public void addNamedOutputArgument(String procedureParameterName, DatabaseType databaseType) {
        DatabaseType dt = databaseType.isComplexDatabaseType() ? ((ComplexDatabaseType)databaseType).clone() : databaseType;
        this.arguments.add(new PLSQLargument(procedureParameterName, this.originalIndex++, OUT, dt));
    }

    public void addNamedOutputArgument(String procedureParameterName, DatabaseType databaseType, int length) {
        DatabaseType dt = databaseType.isComplexDatabaseType() ? ((ComplexDatabaseType)databaseType).clone() : databaseType;
        this.arguments.add(new PLSQLargument(procedureParameterName, this.originalIndex++, OUT, dt, length));
    }

    public void addNamedOutputArgument(String procedureParameterName, DatabaseType databaseType, int precision, int scale) {
        DatabaseType dt = databaseType.isComplexDatabaseType() ? ((ComplexDatabaseType)databaseType).clone() : databaseType;
        this.arguments.add(new PLSQLargument(procedureParameterName, this.originalIndex++, OUT, dt, precision, scale));
    }

    @Override
    public void addNamedOutputArgument(String procedureParameterName, String argumentFieldName, int jdbcType, String typeName, Class javaType) {
        this.arguments.add(new PLSQLargument(procedureParameterName, this.originalIndex++, OUT, JDBCTypes.getDatabaseTypeForCode(jdbcType)));
    }

    @Override
    public void addNamedOutputArgument(String procedureParameterName, String argumentFieldName, int jdbcType, String typeName, Class javaType, DatabaseField nestedType) {
        this.arguments.add(new PLSQLargument(procedureParameterName, this.originalIndex++, OUT, JDBCTypes.getDatabaseTypeForCode(jdbcType)));
    }

    @Override
    public void addNamedOutputArgument(String procedureParameterName, String argumentFieldName, int type, String typeName) {
        this.arguments.add(new PLSQLargument(procedureParameterName, this.originalIndex++, OUT, JDBCTypes.getDatabaseTypeForCode(type)));
    }

    @Override
    public void addNamedOutputArgument(String procedureParameterName, String argumentFieldName, int type) {
        this.arguments.add(new PLSQLargument(procedureParameterName, this.originalIndex++, OUT, JDBCTypes.getDatabaseTypeForCode(type)));
    }

    @Override
    public void addNamedArgument(String procedureParameterAndArgumentFieldName) {
        throw QueryException.addArgumentsNotSupported("named arguments without DatabaseType classification");
    }

    @Override
    public void addNamedArgumentValue(String procedureParameterName, Object argumentValue) {
        throw QueryException.addArgumentsNotSupported("named argument values without DatabaseType classification");
    }

    @Override
    public void addNamedArgument(String procedureParameterName, String argumentFieldName) {
        throw QueryException.addArgumentsNotSupported("named argument values without DatabaseType classification");
    }

    @Override
    public void addNamedInOutputArgument(String procedureParameterAndArgumentFieldName) {
        throw QueryException.addArgumentsNotSupported("named IN OUT argument without DatabaseType classification");
    }

    @Override
    public void addNamedInOutputArgument(String procedureParameterName, String argumentFieldName) {
        throw QueryException.addArgumentsNotSupported("named IN OUT arguments without DatabaseType classification");
    }

    @Override
    public void addNamedInOutputArgument(String procedureParameterName, String argumentFieldName, Class type) {
        throw QueryException.addArgumentsNotSupported("named IN OUT arguments without DatabaseType classification");
    }

    @Override
    public void addNamedInOutputArgument(String procedureParameterName, String inArgumentFieldName, String outArgumentFieldName, Class type) {
        throw QueryException.addArgumentsNotSupported("named IN OUT arguments without DatabaseType classification");
    }

    @Override
    public void addNamedInOutputArgumentValue(String procedureParameterName, Object inArgumentValue, String outArgumentFieldName, Class type) {
        throw QueryException.addArgumentsNotSupported("named IN OUT argument values without DatabaseType classification");
    }

    @Override
    public void addNamedOutputArgument(String procedureParameterAndArgumentFieldName) {
        throw QueryException.addArgumentsNotSupported("named OUT arguments without DatabaseType classification");
    }

    @Override
    public void addNamedOutputArgument(String procedureParameterName, String argumentFieldName) {
        throw QueryException.addArgumentsNotSupported("named OUT arguments without DatabaseType classification");
    }

    @Override
    public void addNamedOutputArgument(String procedureParameterName, String argumentFieldName, Class type) {
        throw QueryException.addArgumentsNotSupported("named OUT arguments without DatabaseType classification");
    }

    @Override
    public void useNamedCursorOutputAsResultSet(String argumentName) {
        throw QueryException.addArgumentsNotSupported("named OUT cursor arguments without DatabaseType classification");
    }

    @Override
    public void addUnamedArgument(String argumentFieldName, Class type) {
        throw QueryException.unnamedArgumentsNotSupported();
    }

    @Override
    public void addUnamedArgument(String argumentFieldName, int type, String typeName, DatabaseField nestedType) {
        throw QueryException.unnamedArgumentsNotSupported();
    }

    @Override
    public void addUnamedArgument(String argumentFieldName, int type, String typeName) {
        throw QueryException.unnamedArgumentsNotSupported();
    }

    @Override
    public void addUnamedArgument(String argumentFieldName, int type) {
        throw QueryException.unnamedArgumentsNotSupported();
    }

    @Override
    public void addUnamedArgument(String argumentFieldName) {
        throw QueryException.unnamedArgumentsNotSupported();
    }

    @Override
    public void addUnamedArgumentValue(Object argumentValue) {
        throw QueryException.unnamedArgumentsNotSupported();
    }

    @Override
    public void addUnamedInOutputArgument(String argumentFieldName, Class type) {
        throw QueryException.unnamedArgumentsNotSupported();
    }

    @Override
    public void addUnamedInOutputArgument(String inArgumentFieldName, String outArgumentFieldName, Class type) {
        throw QueryException.unnamedArgumentsNotSupported();
    }

    @Override
    public void addUnamedInOutputArgument(String inArgumentFieldName, String outArgumentFieldName, int type, String typeName, Class collection, DatabaseField nestedType) {
        throw QueryException.unnamedArgumentsNotSupported();
    }

    @Override
    public void addUnamedInOutputArgument(String inArgumentFieldName, String outArgumentFieldName, int type, String typeName, Class collection) {
        throw QueryException.unnamedArgumentsNotSupported();
    }

    @Override
    public void addUnamedInOutputArgument(String inArgumentFieldName, String outArgumentFieldName, int type, String typeName) {
        throw QueryException.unnamedArgumentsNotSupported();
    }

    @Override
    public void addUnamedInOutputArgument(String inArgumentFieldName, String outArgumentFieldName, int type) {
        throw QueryException.unnamedArgumentsNotSupported();
    }

    @Override
    public void addUnamedInOutputArgument(String argumentFieldName) {
        throw QueryException.unnamedArgumentsNotSupported();
    }

    @Override
    public void addUnamedInOutputArgumentValue(Object inArgumentValue, String outArgumentFieldName, Class type) {
        throw QueryException.unnamedArgumentsNotSupported();
    }

    @Override
    public void addUnamedOutputArgument(String argumentFieldName, Class type) {
        throw QueryException.unnamedArgumentsNotSupported();
    }

    @Override
    public void addUnamedOutputArgument(String argumentFieldName, int jdbcType, String typeName, Class javaType, DatabaseField nestedType) {
        throw QueryException.unnamedArgumentsNotSupported();
    }

    @Override
    public void addUnamedOutputArgument(String argumentFieldName, int jdbcType, String typeName, Class javaType) {
        throw QueryException.unnamedArgumentsNotSupported();
    }

    @Override
    public void addUnamedOutputArgument(String argumentFieldName, int type, String typeName) {
        throw QueryException.unnamedArgumentsNotSupported();
    }

    @Override
    public void addUnamedOutputArgument(String argumentFieldName, int type) {
        throw QueryException.unnamedArgumentsNotSupported();
    }

    @Override
    public void addUnamedOutputArgument(String argumentFieldName) {
        throw QueryException.unnamedArgumentsNotSupported();
    }

    @Override
    public void useUnnamedCursorOutputAsResultSet() {
        throw QueryException.unnamedArgumentsNotSupported();
    }

    public void useNamedCursorOutputAsResultSet(String argumentName, DatabaseType databaseType) {
        DatabaseType dt = databaseType.isComplexDatabaseType() ? ((ComplexDatabaseType)databaseType).clone() : databaseType;
        PLSQLargument newArg = new PLSQLargument(argumentName, this.originalIndex++, OUT, dt);
        newArg.cursorOutput = true;
        this.arguments.add(newArg);
    }

    protected void assignIndices() {
        PLSQLargument inArg2;
        List<PLSQLargument> inArguments = PLSQLStoredProcedureCall.getArguments(this.arguments, IN);
        List<PLSQLargument> inOutArguments = PLSQLStoredProcedureCall.getArguments(this.arguments, INOUT);
        inArguments.addAll(inOutArguments);
        int newIndex = 1;
        ArrayList<PLSQLargument> expandedArguments = new ArrayList<PLSQLargument>();
        Iterator<PLSQLargument> inArgsIter = inArguments.listIterator();
        while (inArgsIter.hasNext()) {
            inArg2 = inArgsIter.next();
            if (!inArg2.databaseType.isComplexDatabaseType() || ((ComplexDatabaseType)inArg2.databaseType).hasCompatibleType()) continue;
            expandedArguments.add(inArg2);
            inArgsIter.remove();
        }
        inArguments.addAll(expandedArguments);
        inArgsIter = inArguments.listIterator();
        while (inArgsIter.hasNext()) {
            inArg2 = inArgsIter.next();
            newIndex = inArg2.databaseType.computeInIndex(inArg2, newIndex, (ListIterator<PLSQLargument>)inArgsIter);
        }
        for (PLSQLargument inArg2 : inArguments) {
            ObjectRelationalDatabaseField field;
            DatabaseType nestedType;
            DatabaseType type = inArg2.databaseType;
            String inArgName = inArg2.name;
            if (!type.isComplexDatabaseType()) {
                if (type == OraclePLSQLTypes.XMLType) {
                    super.addNamedArgument(inArgName, inArgName, type.getConversionCode(), type.getTypeName());
                    continue;
                }
                super.addNamedArgument(inArgName, inArgName, type.getConversionCode());
                continue;
            }
            ComplexDatabaseType complexType = (ComplexDatabaseType)type;
            if (inArg2.inIndex == Integer.MIN_VALUE) continue;
            if (complexType.isStruct()) {
                super.addNamedArgument(inArgName, inArgName, complexType.getSqlCode(), complexType.getTypeName());
                continue;
            }
            if (complexType.isArray()) {
                nestedType = ((OracleArrayType)complexType).getNestedType();
                if (nestedType != null) {
                    field = new ObjectRelationalDatabaseField("");
                    field.setSqlType(nestedType.getSqlCode());
                    field.setSqlTypeName(nestedType.getTypeName());
                    super.addNamedArgument(inArgName, inArgName, complexType.getSqlCode(), complexType.getTypeName(), field);
                    continue;
                }
                super.addNamedArgument(inArgName, inArgName, complexType.getSqlCode(), complexType.getTypeName());
                continue;
            }
            if (complexType.isCollection()) {
                nestedType = ((PLSQLCollection)complexType).getNestedType();
                if (nestedType != null) {
                    field = new ObjectRelationalDatabaseField("");
                    field.setSqlType(nestedType.getConversionCode());
                    if (nestedType.isComplexDatabaseType()) {
                        field.setSqlTypeName(((ComplexDatabaseType)nestedType).getCompatibleType());
                    }
                    super.addNamedArgument(inArgName, inArgName, type.getConversionCode(), complexType.getCompatibleType(), field);
                    continue;
                }
                super.addNamedArgument(inArgName, inArgName, type.getConversionCode(), complexType.getCompatibleType());
                continue;
            }
            super.addNamedArgument(inArgName, inArgName, type.getConversionCode(), complexType.getCompatibleType());
        }
        List<PLSQLargument> outArguments = PLSQLStoredProcedureCall.getArguments(this.arguments, OUT);
        outArguments.addAll(inOutArguments);
        ListIterator<PLSQLargument> outArgsIter = outArguments.listIterator();
        while (outArgsIter.hasNext()) {
            PLSQLargument outArg = outArgsIter.next();
            newIndex = outArg.databaseType.computeOutIndex(outArg, newIndex, outArgsIter);
        }
        for (PLSQLargument outArg : outArguments) {
            ComplexDatabaseType complexNestedType;
            ObjectRelationalDatabaseField nestedField;
            DatabaseType nestedType;
            String outArgName = outArg.name;
            if (outArg.cursorOutput) {
                super.useNamedCursorOutputAsResultSet(outArgName);
                continue;
            }
            DatabaseType type = outArg.databaseType;
            if (!type.isComplexDatabaseType()) {
                if (type == OraclePLSQLTypes.XMLType) {
                    super.addNamedOutputArgument(outArgName, outArgName, type.getConversionCode(), type.getTypeName());
                    continue;
                }
                super.addNamedOutputArgument(outArgName, outArgName, type.getConversionCode());
                continue;
            }
            ComplexDatabaseType complexType = (ComplexDatabaseType)type;
            if (outArg.outIndex == Integer.MIN_VALUE) continue;
            if (complexType.isStruct()) {
                super.addNamedOutputArgument(outArgName, outArgName, complexType.getSqlCode(), complexType.getTypeName(), complexType.getJavaType());
                continue;
            }
            if (complexType.isArray()) {
                nestedType = ((OracleArrayType)complexType).getNestedType();
                if (nestedType != null) {
                    nestedField = new ObjectRelationalDatabaseField("");
                    nestedField.setSqlType(nestedType.getSqlCode());
                    if (nestedType.isComplexDatabaseType()) {
                        complexNestedType = (ComplexDatabaseType)nestedType;
                        nestedField.setType(complexNestedType.getJavaType());
                        nestedField.setSqlTypeName(complexNestedType.getCompatibleType());
                    }
                    super.addNamedOutputArgument(outArgName, outArgName, type.getSqlCode(), complexType.getTypeName(), complexType.getJavaType(), nestedField);
                    continue;
                }
                super.addNamedOutputArgument(outArgName, outArgName, type.getSqlCode(), complexType.getTypeName(), complexType.getJavaType());
                continue;
            }
            if (complexType.isCollection()) {
                nestedType = ((PLSQLCollection)complexType).getNestedType();
                if (nestedType != null) {
                    nestedField = new ObjectRelationalDatabaseField(outArgName);
                    nestedField.setSqlType(nestedType.getSqlCode());
                    if (nestedType.isComplexDatabaseType()) {
                        complexNestedType = (ComplexDatabaseType)nestedType;
                        nestedField.setType(complexNestedType.getJavaType());
                        nestedField.setSqlTypeName(complexNestedType.getCompatibleType());
                    }
                    super.addNamedOutputArgument(outArgName, outArgName, type.getSqlCode(), complexType.getCompatibleType(), complexType.getJavaType(), nestedField);
                    continue;
                }
                super.addNamedOutputArgument(outArgName, outArgName, type.getSqlCode(), complexType.getCompatibleType());
                continue;
            }
            if (complexType.hasCompatibleType()) {
                super.addNamedOutputArgument(outArgName, outArgName, type.getSqlCode(), complexType.getCompatibleType(), complexType.getJavaType());
                continue;
            }
            super.addNamedOutputArgument(outArgName, outArgName, type.getSqlCode());
        }
    }

    protected void buildDeclareBlock(StringBuilder sb, List<PLSQLargument> arguments) {
        List<PLSQLargument> inArguments = PLSQLStoredProcedureCall.getArguments(arguments, IN);
        List<PLSQLargument> inOutArguments = PLSQLStoredProcedureCall.getArguments(arguments, INOUT);
        inArguments.addAll(inOutArguments);
        List<PLSQLargument> outArguments = PLSQLStoredProcedureCall.getArguments(arguments, OUT);
        Collections.sort(inArguments, new InArgComparer());
        for (PLSQLargument arg : inArguments) {
            arg.databaseType.buildInDeclare(sb, arg);
        }
        Collections.sort(outArguments, new OutArgComparer());
        for (PLSQLargument arg : outArguments) {
            arg.databaseType.buildOutDeclare(sb, arg);
        }
    }

    protected void addNestedFunctionsForArgument(List functions, PLSQLargument argument, DatabaseType databaseType, Set<DatabaseType> processed) {
        if (databaseType == null || !databaseType.isComplexDatabaseType() || databaseType.isJDBCType() || argument.cursorOutput || processed.contains(databaseType)) {
            return;
        }
        ComplexDatabaseType type = (ComplexDatabaseType)databaseType;
        if (!type.hasCompatibleType()) {
            return;
        }
        processed.add(type);
        boolean isNestedTable = false;
        if (type.isCollection()) {
            isNestedTable = ((PLSQLCollection)type).isNestedTable();
            DatabaseType nestedType = ((PLSQLCollection)type).getNestedType();
            this.addNestedFunctionsForArgument(functions, argument, nestedType, processed);
        } else if (type.isRecord()) {
            for (PLSQLargument field : ((PLSQLrecord)type).getFields()) {
                DatabaseType nestedType = field.databaseType;
                this.addNestedFunctionsForArgument(functions, argument, nestedType, processed);
            }
        }
        TypeInfo info = this.typesInfo.get(type.getTypeName());
        if (info == null) {
            info = this.generateNestedFunction(type, isNestedTable);
        }
        if (argument.direction == IN) {
            if (!functions.contains(info.sql2PlConv)) {
                functions.add(info.sql2PlConv);
            }
        } else if (argument.direction == INOUT) {
            if (!functions.contains(info.sql2PlConv)) {
                functions.add(info.sql2PlConv);
            }
            if (!functions.contains(info.pl2SqlConv)) {
                functions.add(info.pl2SqlConv);
            }
        } else if (argument.direction == OUT && !functions.contains(info.pl2SqlConv)) {
            functions.add(info.pl2SqlConv);
        }
    }

    protected TypeInfo generateNestedFunction(ComplexDatabaseType type) {
        return this.generateNestedFunction(type, false);
    }

    protected TypeInfo generateNestedFunction(ComplexDatabaseType type, boolean isNonAssociativeCollection) {
        TypeInfo info = new TypeInfo();
        info.pl2SqlName = PL2SQL_PREFIX + this.functionId++;
        info.sql2PlName = SQL2PL_PREFIX + this.functionId++;
        if (type.isRecord()) {
            PLSQLrecord record = (PLSQLrecord)type;
            StringBuilder sb = new StringBuilder();
            sb.append("  ");
            sb.append(BEGIN_DECLARE_FUNCTION);
            sb.append(info.pl2SqlName);
            sb.append("(aPlsqlItem ");
            sb.append(record.getTypeName());
            sb.append(")");
            sb.append("\n");
            sb.append("  ");
            sb.append(RTURN);
            sb.append(record.getCompatibleType());
            sb.append(" IS");
            sb.append("\n");
            sb.append("  ");
            sb.append("  ");
            sb.append("aSqlItem ");
            sb.append(record.getCompatibleType());
            sb.append(";");
            sb.append("\n");
            sb.append("  ");
            sb.append(BEGIN_BEGIN_BLOCK);
            sb.append("  ");
            sb.append("  ");
            sb.append("aSqlItem := ");
            sb.append(record.getCompatibleType());
            sb.append("(");
            int size = record.getFields().size();
            for (int index = 0; index < size; ++index) {
                sb.append("NULL");
                if (index + 1 == size) continue;
                sb.append(", ");
            }
            sb.append(");");
            sb.append("\n");
            for (PLSQLargument argument : record.getFields()) {
                sb.append("  ");
                sb.append("  ");
                sb.append("aSqlItem.");
                sb.append(argument.name);
                if (argument.databaseType.isComplexDatabaseType() && !argument.databaseType.isJDBCType()) {
                    sb.append(" := ");
                    sb.append(this.getPl2SQLName((ComplexDatabaseType)argument.databaseType));
                    sb.append("(aPlsqlItem.");
                    sb.append(argument.name);
                    sb.append(");");
                } else if (argument.databaseType.equals(OraclePLSQLTypes.PLSQLBoolean)) {
                    sb.append(" := ");
                    sb.append("SYS.SQLJUTL.BOOL2INT");
                    sb.append("(aPlsqlItem.");
                    sb.append(argument.name);
                    sb.append(");");
                } else {
                    sb.append(" := aPlsqlItem.");
                    sb.append(argument.name);
                    sb.append(";");
                }
                sb.append("\n");
            }
            sb.append("  ");
            sb.append("  ");
            sb.append(RTURN);
            sb.append("aSqlItem;");
            sb.append("\n");
            sb.append("  ");
            sb.append("END ");
            sb.append(info.pl2SqlName);
            sb.append(";");
            sb.append("\n");
            info.pl2SqlConv = sb.toString();
            sb = new StringBuilder();
            sb.append("  ");
            sb.append(BEGIN_DECLARE_FUNCTION);
            sb.append(info.sql2PlName);
            sb.append("(aSqlItem ");
            sb.append(record.getCompatibleType());
            sb.append(") ");
            sb.append("\n");
            sb.append("  ");
            sb.append(RTURN);
            sb.append(record.getTypeName());
            sb.append(" IS");
            sb.append("\n");
            sb.append("  ");
            sb.append("  ");
            sb.append("aPlsqlItem ");
            sb.append(record.getTypeName());
            sb.append(";");
            sb.append("\n");
            sb.append("  ");
            sb.append(BEGIN_BEGIN_BLOCK);
            for (PLSQLargument argument : record.getFields()) {
                sb.append("  ");
                sb.append("  ");
                sb.append("aPlsqlItem.");
                sb.append(argument.name);
                if (argument.databaseType.isComplexDatabaseType() && !argument.databaseType.isJDBCType()) {
                    sb.append(" := ");
                    sb.append(this.getSQL2PlName((ComplexDatabaseType)argument.databaseType));
                    sb.append("(aSqlItem.");
                    sb.append(argument.name);
                    sb.append(");");
                } else if (argument.databaseType.equals(OraclePLSQLTypes.PLSQLBoolean)) {
                    sb.append(" := ");
                    sb.append("SYS.SQLJUTL.INT2BOOL");
                    sb.append("(aSqlItem.");
                    sb.append(argument.name);
                    sb.append(");");
                } else {
                    sb.append(" := aSqlItem.");
                    sb.append(argument.name);
                    sb.append(";");
                }
                sb.append("\n");
            }
            sb.append("  ");
            sb.append("  ");
            sb.append(RTURN);
            sb.append("aPlsqlItem;");
            sb.append("\n");
            sb.append("  ");
            sb.append("END ");
            sb.append(info.sql2PlName);
            sb.append(";");
            sb.append("\n");
            info.sql2PlConv = sb.toString();
        } else if (type.isCollection()) {
            PLSQLCollection collection = (PLSQLCollection)type;
            StringBuilder sb = new StringBuilder();
            sb.append("  ");
            sb.append(BEGIN_DECLARE_FUNCTION);
            sb.append(info.pl2SqlName);
            sb.append("(aPlsqlItem ");
            sb.append(collection.getTypeName());
            sb.append(")");
            sb.append("\n");
            sb.append("  ");
            sb.append(RTURN);
            sb.append(collection.getCompatibleType());
            sb.append(" IS");
            sb.append("\n");
            sb.append("  ");
            sb.append("  ");
            sb.append("aSqlItem ");
            sb.append(collection.getCompatibleType());
            sb.append(";");
            sb.append("\n");
            sb.append("  ");
            sb.append(BEGIN_BEGIN_BLOCK);
            sb.append("  ");
            sb.append("  ");
            sb.append("aSqlItem := ");
            sb.append(collection.getCompatibleType());
            sb.append("();");
            sb.append("\n");
            sb.append("  ");
            sb.append("  ");
            sb.append("aSqlItem.EXTEND(aPlsqlItem.COUNT);");
            sb.append("\n");
            sb.append("  ");
            sb.append("  ");
            sb.append("IF aPlsqlItem.COUNT > 0 THEN");
            sb.append("\n");
            sb.append("  ");
            sb.append("  ");
            sb.append("FOR I IN aPlsqlItem.FIRST..aPlsqlItem.LAST LOOP");
            sb.append("\n");
            sb.append("  ");
            sb.append("  ");
            sb.append("  ");
            sb.append("aSqlItem(I + 1 - aPlsqlItem.FIRST) := ");
            if (collection.nestedType != null && collection.nestedType.isComplexDatabaseType() && !collection.nestedType.isJDBCType()) {
                sb.append(this.getPl2SQLName((ComplexDatabaseType)collection.nestedType));
                sb.append("(aPlsqlItem(I));");
            } else if (OraclePLSQLTypes.PLSQLBoolean.equals(collection.nestedType)) {
                sb.append("SYS.SQLJUTL.BOOL2INT");
                sb.append("(aPlsqlItem(I));");
            } else {
                sb.append("aPlsqlItem(I);");
            }
            sb.append("\n");
            sb.append("  ");
            sb.append("  ");
            sb.append("  ");
            sb.append("END LOOP;");
            sb.append("\n");
            sb.append("  ");
            sb.append("  ");
            sb.append("END IF;");
            sb.append("\n");
            sb.append("  ");
            sb.append("  ");
            sb.append(RTURN);
            sb.append("aSqlItem;");
            sb.append("\n");
            sb.append("  ");
            sb.append("END ");
            sb.append(info.pl2SqlName);
            sb.append(";");
            sb.append("\n");
            info.pl2SqlConv = sb.toString();
            sb = new StringBuilder();
            sb.append("  ");
            sb.append(BEGIN_DECLARE_FUNCTION);
            sb.append(info.sql2PlName);
            sb.append("(aSqlItem ");
            sb.append(collection.getCompatibleType());
            sb.append(")");
            sb.append("\n");
            sb.append("  ");
            sb.append(RTURN);
            sb.append(collection.getTypeName());
            sb.append(" IS");
            sb.append("\n");
            sb.append("  ");
            sb.append("  ");
            sb.append("aPlsqlItem ");
            sb.append(collection.getTypeName());
            sb.append(";");
            sb.append("\n");
            sb.append("  ");
            sb.append(BEGIN_BEGIN_BLOCK);
            sb.append("  ");
            sb.append("  ");
            if (isNonAssociativeCollection) {
                sb.append("aPlsqlItem := ");
                sb.append(collection.getTypeName());
                sb.append("();");
                sb.append("\n");
                sb.append("  ");
                sb.append("  ");
                sb.append("aPlsqlItem.EXTEND(aSqlItem.COUNT);");
                sb.append("\n");
                sb.append("  ");
                sb.append("  ");
            }
            sb.append("IF aSqlItem.COUNT > 0 THEN");
            sb.append("\n");
            sb.append("  ");
            sb.append("  ");
            sb.append("  ");
            sb.append("FOR I IN 1..aSqlItem.COUNT LOOP");
            sb.append("\n");
            sb.append("  ");
            sb.append("  ");
            sb.append("  ");
            sb.append("  ");
            if (collection.nestedType != null && collection.nestedType.isComplexDatabaseType()) {
                sb.append("aPlsqlItem(I) := ");
                sb.append(this.getSQL2PlName((ComplexDatabaseType)collection.nestedType));
                sb.append("(aSqlItem(I));");
            } else if (OraclePLSQLTypes.PLSQLBoolean.equals(collection.nestedType)) {
                sb.append("aPlsqlItem(I + 1 - aSqlItem.FIRST) := ");
                sb.append("SYS.SQLJUTL.INT2BOOL");
                sb.append("(aSqlItem(I));");
            } else {
                sb.append("aPlsqlItem(I) := aSqlItem(I);");
            }
            sb.append("\n");
            sb.append("  ");
            sb.append("  ");
            sb.append("  ");
            sb.append("END LOOP;");
            sb.append("\n");
            sb.append("  ");
            sb.append("  ");
            sb.append("END IF;");
            sb.append("\n");
            sb.append("  ");
            sb.append("  ");
            sb.append(RTURN);
            sb.append("aPlsqlItem;");
            sb.append("\n");
            sb.append("  ");
            sb.append("END ");
            sb.append(info.sql2PlName);
            sb.append(";");
            sb.append("\n");
            info.sql2PlConv = sb.toString();
        }
        this.typesInfo.put(type.getTypeName(), info);
        return info;
    }

    protected void buildNestedFunctions(StringBuilder stream, List<PLSQLargument> arguments) {
        ArrayList nestedFunctions = new ArrayList();
        HashSet<DatabaseType> processed = new HashSet<DatabaseType>();
        for (PLSQLargument arg : arguments) {
            DatabaseType type = arg.databaseType;
            this.addNestedFunctionsForArgument(nestedFunctions, arg, type, processed);
        }
        if (!nestedFunctions.isEmpty()) {
            for (String function : nestedFunctions) {
                stream.append(function);
            }
        }
    }

    protected void buildBeginBlock(StringBuilder sb, List<PLSQLargument> arguments) {
        List<PLSQLargument> inArguments = PLSQLStoredProcedureCall.getArguments(arguments, IN);
        inArguments.addAll(PLSQLStoredProcedureCall.getArguments(arguments, INOUT));
        for (PLSQLargument arg : inArguments) {
            arg.databaseType.buildBeginBlock(sb, arg, this);
        }
    }

    protected void buildProcedureInvocation(StringBuilder sb, List<PLSQLargument> arguments) {
        sb.append("  ");
        sb.append(this.getProcedureName());
        sb.append("(");
        int size = arguments.size();
        int idx = 1;
        for (PLSQLargument argument : arguments) {
            sb.append(argument.name);
            sb.append("=>");
            sb.append(DatabaseType.DatabaseTypeHelper.databaseTypeHelper.buildTarget(argument));
            if (idx >= size) continue;
            sb.append(", ");
            ++idx;
        }
        sb.append(");");
        sb.append("\n");
    }

    protected void buildOutAssignments(StringBuilder sb, List<PLSQLargument> arguments) {
        List<PLSQLargument> outArguments = PLSQLStoredProcedureCall.getArguments(arguments, OUT);
        outArguments.addAll(PLSQLStoredProcedureCall.getArguments(arguments, INOUT));
        for (PLSQLargument arg : outArguments) {
            arg.databaseType.buildOutAssignment(sb, arg, this);
        }
    }

    @Override
    protected void prepareInternal(AbstractSession session) {
        this.typesInfo = new HashMap<String, TypeInfo>();
        this.parameters = null;
        this.assignIndices();
        List<PLSQLargument> specifiedArguments = this.arguments;
        AbstractRecord row = this.getQuery().getTranslationRow();
        if (row != null && this.hasOptionalArguments()) {
            for (PLSQLargument argument : this.arguments) {
                DatabaseField queryArgument = new DatabaseField(argument.name);
                if (!this.optionalArguments.contains(queryArgument) || row.get(queryArgument) != null) continue;
                if (specifiedArguments == this.arguments) {
                    specifiedArguments = new ArrayList<PLSQLargument>(this.arguments);
                }
                specifiedArguments.remove(argument);
            }
        }
        StringBuilder sb = new StringBuilder();
        if (!specifiedArguments.isEmpty()) {
            sb.append(BEGIN_DECLARE_BLOCK);
            this.buildDeclareBlock(sb, specifiedArguments);
            this.buildNestedFunctions(sb, specifiedArguments);
        }
        sb.append(BEGIN_BEGIN_BLOCK);
        this.buildBeginBlock(sb, specifiedArguments);
        this.buildProcedureInvocation(sb, specifiedArguments);
        this.buildOutAssignments(sb, specifiedArguments);
        sb.append(END_BEGIN_BLOCK);
        this.setSQLStringInternal(sb.toString());
        super.prepareInternalParameters(session);
    }

    @Override
    public Statement prepareStatement(DatabaseAccessor accessor, AbstractRecord translationRow, AbstractSession session) throws SQLException {
        Statement statement = accessor.prepareStatement(this, session);
        if (this.queryTimeout > 0 && this.queryTimeoutUnit != null) {
            long timeout = TimeUnit.SECONDS.convert(this.queryTimeout, this.queryTimeoutUnit);
            if (timeout > Integer.MAX_VALUE) {
                timeout = Integer.MAX_VALUE;
            }
            if (TimeUnit.SECONDS.compareTo(this.queryTimeoutUnit) > 0 && this.queryTimeout % 1000 > 0) {
                ++timeout;
            }
            statement.setQueryTimeout((int)timeout);
        }
        if (!this.ignoreMaxResultsSetting && this.maxRows > 0) {
            statement.setMaxRows(this.maxRows);
        }
        if (this.resultSetFetchSize > 0) {
            statement.setFetchSize(this.resultSetFetchSize);
        }
        if (this.parameters == null) {
            return statement;
        }
        List parameters = this.getParameters();
        int size = parameters.size();
        for (int index = 0; index < size; ++index) {
            session.getPlatform().setParameterValueInDatabaseCall(parameters.get(index), (PreparedStatement)statement, index + 1, session);
        }
        return statement;
    }

    @Override
    public void translate(AbstractRecord translationRow, AbstractRecord modifyRow, AbstractSession session) {
        AbstractRecord copyOfTranslationRow = translationRow.clone();
        int len = copyOfTranslationRow.size();
        Vector<DatabaseField> copyOfTranslationFields = copyOfTranslationRow.getFields();
        translationRow.clear();
        Vector<DatabaseField> translationRowFields = translationRow.getFields();
        translationRowFields.setSize(len);
        Vector translationRowValues = translationRow.getValues();
        translationRowValues.setSize(len);
        for (PLSQLargument arg : this.arguments) {
            if (arg.direction != IN && arg.direction != INOUT) continue;
            arg.databaseType.translate(arg, translationRow, copyOfTranslationRow, copyOfTranslationFields, translationRowFields, translationRowValues, this);
        }
        this.translationRow = translationRow;
        super.translate(translationRow, modifyRow, session);
    }

    @Override
    public AbstractRecord buildOutputRow(CallableStatement statement, DatabaseAccessor accessor, AbstractSession session) throws SQLException {
        AbstractRecord outputRow = super.buildOutputRow(statement, accessor, session);
        if (!this.shouldBuildOutputRow) {
            outputRow.put("", (Object)1);
            return outputRow;
        }
        Vector<DatabaseField> outputRowFields = outputRow.getFields();
        Vector outputRowValues = outputRow.getValues();
        DatabaseRecord newOutputRow = new DatabaseRecord();
        List<PLSQLargument> outArguments = PLSQLStoredProcedureCall.getArguments(this.arguments, OUT);
        outArguments.addAll(PLSQLStoredProcedureCall.getArguments(this.arguments, INOUT));
        Collections.sort(outArguments, new Comparator<PLSQLargument>(){

            @Override
            public int compare(PLSQLargument o1, PLSQLargument o2) {
                return o1.originalIndex - o2.originalIndex;
            }
        });
        for (PLSQLargument outArg : outArguments) {
            outArg.databaseType.buildOutputRow(outArg, outputRow, newOutputRow, outputRowFields, outputRowValues);
        }
        return newOutputRow;
    }

    @Override
    public String getLogString(Accessor accessor) {
        StringBuilder sb = new StringBuilder(this.getSQLString());
        sb.append(Helper.cr());
        sb.append("  ");
        sb.append("bind => [");
        List<PLSQLargument> specifiedArguments = this.arguments;
        AbstractRecord row = this.getQuery().getTranslationRow();
        if (row != null && this.hasOptionalArguments()) {
            for (PLSQLargument argument : this.arguments) {
                DatabaseField queryArgument = new DatabaseField(argument.name);
                if (!this.optionalArguments.contains(queryArgument) || row.get(queryArgument) != null) continue;
                if (specifiedArguments == this.arguments) {
                    specifiedArguments = new ArrayList<PLSQLargument>(this.arguments);
                }
                specifiedArguments.remove(argument);
            }
        }
        List<PLSQLargument> inArguments = PLSQLStoredProcedureCall.getArguments(specifiedArguments, IN);
        inArguments.addAll(PLSQLStoredProcedureCall.getArguments(specifiedArguments, INOUT));
        Collections.sort(inArguments, new Comparator<PLSQLargument>(){

            @Override
            public int compare(PLSQLargument o1, PLSQLargument o2) {
                return o1.inIndex - o2.inIndex;
            }
        });
        Iterator<PLSQLargument> i = inArguments.iterator();
        while (i.hasNext()) {
            PLSQLargument inArg = i.next();
            inArg.databaseType.logParameter(sb, IN, inArg, this.translationRow, this.getQuery().getSession().getPlatform());
            if (!i.hasNext()) continue;
            sb.append(", ");
        }
        List<PLSQLargument> outArguments = PLSQLStoredProcedureCall.getArguments(specifiedArguments, OUT);
        outArguments.addAll(PLSQLStoredProcedureCall.getArguments(specifiedArguments, INOUT));
        Collections.sort(outArguments, new Comparator<PLSQLargument>(){

            @Override
            public int compare(PLSQLargument o1, PLSQLargument o2) {
                return o1.outIndex - o2.outIndex;
            }
        });
        if (!inArguments.isEmpty() && !outArguments.isEmpty()) {
            sb.append(", ");
        }
        Iterator<PLSQLargument> i2 = outArguments.iterator();
        while (i2.hasNext()) {
            PLSQLargument outArg = i2.next();
            outArg.databaseType.logParameter(sb, OUT, outArg, this.translationRow, this.getQuery().getSession().getPlatform());
            if (!i2.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }

    protected static List<PLSQLargument> getArguments(List<PLSQLargument> args, Integer direction) {
        ArrayList<PLSQLargument> inArgs = new ArrayList<PLSQLargument>();
        for (PLSQLargument arg : args) {
            if (arg.direction != direction) continue;
            inArgs.add(arg);
        }
        return inArgs;
    }

    public String getSQL2PlName(ComplexDatabaseType type) {
        if (this.typesInfo == null) {
            return null;
        }
        TypeInfo info = this.typesInfo.get(type.getTypeName());
        if (info == null) {
            info = this.generateNestedFunction(type);
        }
        return info.sql2PlName;
    }

    @Override
    public boolean isStoredPLSQLProcedureCall() {
        return true;
    }

    public String getPl2SQLName(ComplexDatabaseType type) {
        if (this.typesInfo == null) {
            return null;
        }
        TypeInfo info = this.typesInfo.get(type.getTypeName());
        if (info == null) {
            info = this.generateNestedFunction(type);
        }
        return info.pl2SqlName;
    }

    @Override
    public Object getOutputParameterValue(CallableStatement statement, int index, AbstractSession session) throws SQLException {
        return session.getPlatform().getParameterValueFromDatabaseCall(statement, index + 1, session);
    }

    public List<PLSQLargument> getArguments() {
        return this.arguments;
    }

    public void setArguments(List<PLSQLargument> arguments) {
        this.arguments = arguments;
    }

    static final class OutArgComparer
    implements Comparator<PLSQLargument>,
    Serializable {
        private static final long serialVersionUID = -4182293492217092689L;

        OutArgComparer() {
        }

        @Override
        public int compare(PLSQLargument arg0, PLSQLargument arg1) {
            if (arg0.inIndex < arg1.outIndex) {
                return -1;
            }
            if (arg0.inIndex > arg1.outIndex) {
                return 1;
            }
            return 0;
        }
    }

    static final class InArgComparer
    implements Comparator<PLSQLargument>,
    Serializable {
        private static final long serialVersionUID = -4182293492217092689L;

        InArgComparer() {
        }

        @Override
        public int compare(PLSQLargument arg0, PLSQLargument arg1) {
            if (arg0.inIndex < arg1.inIndex) {
                return -1;
            }
            if (arg0.inIndex > arg1.inIndex) {
                return 1;
            }
            return 0;
        }
    }

    static final class TypeInfo {
        String sql2PlName;
        String sql2PlConv;
        String pl2SqlName;
        String pl2SqlConv;

        TypeInfo() {
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("\n");
            sb.append(this.sql2PlName == null ? "" : this.sql2PlConv);
            sb.append(this.pl2SqlName == null ? "" : this.pl2SqlConv);
            return sb.toString();
        }
    }
}

