/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.parsing;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.exceptions.JPQLException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.expressions.ConstantExpression;
import org.eclipse.persistence.internal.jpa.parsing.AliasableNode;
import org.eclipse.persistence.internal.jpa.parsing.DotNode;
import org.eclipse.persistence.internal.jpa.parsing.GenerationContext;
import org.eclipse.persistence.internal.jpa.parsing.IdentificationVariableDeclNode;
import org.eclipse.persistence.internal.jpa.parsing.Node;
import org.eclipse.persistence.internal.jpa.parsing.ParseTreeContext;
import org.eclipse.persistence.internal.jpa.parsing.SelectNode;
import org.eclipse.persistence.internal.jpa.parsing.TypeHelper;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReportQuery;

public class VariableNode
extends Node
implements AliasableNode {
    private String variableName;
    private String canonicalName;
    private Object classConstant = null;

    public VariableNode() {
    }

    public VariableNode(String newVariableName) {
        this.setVariableName(newVariableName);
    }

    public String getVariableName() {
        return this.variableName;
    }

    public void setVariableName(String newVariableName) {
        this.variableName = newVariableName;
        this.canonicalName = IdentificationVariableDeclNode.calculateCanonicalName(newVariableName);
    }

    public String getCanonicalVariableName() {
        return this.canonicalName;
    }

    @Override
    public boolean isVariableNode() {
        return true;
    }

    @Override
    public void applyToQuery(ObjectLevelReadQuery theQuery, GenerationContext generationContext) {
        String name = this.getCanonicalVariableName();
        if (theQuery instanceof ReportQuery) {
            ReportQuery reportQuery = (ReportQuery)theQuery;
            Expression expression = generationContext.expressionFor(name);
            if (expression == null) {
                expression = this.generateExpression(generationContext);
            }
            this.addAttributeWithFetchJoins(reportQuery, expression, generationContext);
        } else {
            this.addFetchJoins(theQuery, generationContext);
        }
    }

    private void addAttributeWithFetchJoins(ReportQuery reportQuery, Expression expression, GenerationContext context) {
        String name = this.getCanonicalVariableName();
        List fetchJoinNodes = context.getParseTreeContext().getFetchJoins(name);
        if (fetchJoinNodes == null) {
            reportQuery.addAttribute(name, expression);
        } else {
            ArrayList<Expression> fetchJoinExprs = new ArrayList<Expression>(fetchJoinNodes.size());
            for (Node node : fetchJoinNodes) {
                fetchJoinExprs.add(node.generateExpression(context));
            }
            reportQuery.addItem(name, expression, fetchJoinExprs);
        }
    }

    private void addFetchJoins(ObjectLevelReadQuery theQuery, GenerationContext context) {
        String name = this.getCanonicalVariableName();
        List fetchJoinNodes = context.getParseTreeContext().getFetchJoins(name);
        if (fetchJoinNodes != null) {
            for (Node node : fetchJoinNodes) {
                theQuery.addJoinedAttribute(node.generateExpression(context));
            }
        }
    }

    @Override
    public Node qualifyAttributeAccess(ParseTreeContext context) {
        return context.isVariable(this.variableName) ? this : (Node)context.getNodeFactory().newQualifiedAttribute(this.getLine(), this.getColumn(), context.getBaseVariable(), this.variableName);
    }

    @Override
    public void validate(ParseTreeContext context) {
        TypeHelper typeHelper = context.getTypeHelper();
        this.classConstant = typeHelper.resolveSchema(this.variableName);
        if (this.classConstant != null) {
            this.setType(Class.class);
            return;
        }
        String name = this.getCanonicalVariableName();
        if (context.isRangeVariable(name)) {
            String schema = context.schemaForVariable(name);
            this.setType(typeHelper.resolveSchema(schema));
        } else {
            Node path = context.pathForVariable(name);
            if (path == null) {
                throw JPQLException.aliasResolutionException(context.getQueryInfo(), this.getLine(), this.getColumn(), name);
            }
            this.setType(path.getType());
        }
        context.usedVariable(name);
        if (context.isDeclaredInOuterScope(name)) {
            context.registerOuterScopeVariable(name);
        }
    }

    public Expression generateBaseBuilderExpression(GenerationContext context) {
        return new ExpressionBuilder(this.resolveClass(context));
    }

    @Override
    public Expression generateExpression(GenerationContext generationContext) {
        Expression myExpression = null;
        String name = this.getCanonicalVariableName();
        myExpression = generationContext.expressionFor(name);
        if (myExpression != null) {
            return myExpression;
        }
        myExpression = this.classConstant != null ? new ConstantExpression(this.classConstant, generationContext.getBaseExpression()) : (generationContext.getParseTreeContext().isRangeVariable(name) ? this.generateBaseBuilderExpression(generationContext) : this.generateExpressionForAlias(generationContext));
        generationContext.addExpression(myExpression, name);
        return myExpression;
    }

    public Expression generateExpressionForAlias(GenerationContext context) {
        if (context.getParseTree().getQueryNode().isSelectNode() && context.shouldCheckSelectNodeBeforeResolving() && ((SelectNode)context.getParseTree().getQueryNode()).isSelected(this.getCanonicalVariableName())) {
            return new ExpressionBuilder();
        }
        Node nodeForAlias = this.getNodeForAlias(context);
        if (nodeForAlias == null) {
            throw JPQLException.aliasResolutionException(context.getParseTreeContext().getQueryInfo(), this.getLine(), this.getColumn(), this.getVariableName());
        }
        return nodeForAlias.generateExpression(context);
    }

    public Node getNodeForAlias(GenerationContext context) {
        return context.getParseTreeContext().pathForVariable(this.getCanonicalVariableName());
    }

    public boolean isAlias(GenerationContext context) {
        return this.isAlias(context.getParseTreeContext());
    }

    public boolean isAlias(ParseTreeContext context) {
        String classNameForAlias = context.schemaForVariable(this.getCanonicalVariableName());
        return classNameForAlias != null;
    }

    @Override
    public Class resolveClass(GenerationContext generationContext) {
        Class clazz = null;
        String name = this.getCanonicalVariableName();
        ParseTreeContext context = generationContext.getParseTreeContext();
        if (context.isRangeVariable(name)) {
            String schema = context.schemaForVariable(name);
            clazz = context.classForSchemaName(schema, generationContext);
        } else {
            DotNode path = (DotNode)context.pathForVariable(name);
            if (path == null) {
                throw JPQLException.aliasResolutionException(context.getQueryInfo(), this.getLine(), this.getColumn(), name);
            }
            clazz = path.resolveClass(generationContext);
        }
        return clazz;
    }

    @Override
    public String toString(int indent) {
        StringBuilder buffer = new StringBuilder();
        this.toStringIndent(indent, buffer);
        buffer.append(this.toStringDisplayName() + "[" + this.getVariableName() + "]");
        return buffer.toString();
    }

    @Override
    public String getAsString() {
        return this.getVariableName();
    }

    public Object getTypeForMapKey(ParseTreeContext context) {
        String name = this.getCanonicalVariableName();
        if (context.isRangeVariable(name)) {
            throw JPQLException.variableCannotHaveMapKey(context.getQueryInfo(), this.getLine(), this.getColumn(), name);
        }
        DotNode path = (DotNode)context.pathForVariable(name);
        if (path == null) {
            throw JPQLException.aliasResolutionException(context.getQueryInfo(), this.getLine(), this.getColumn(), name);
        }
        return path.getTypeForMapKey(context);
    }

    @Override
    public boolean isAliasableNode() {
        return true;
    }
}

