/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import com.sleepycat.bind.tuple.TupleOutput;
import com.sleepycat.je.tree.Key;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import oracle.kv.Direction;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.IndexImpl;
import oracle.kv.impl.api.table.IndexKeyImpl;
import oracle.kv.impl.util.FastExternalizable;
import oracle.kv.impl.util.SerializationUtil;
import oracle.kv.table.FieldDef;
import oracle.kv.table.FieldRange;
import oracle.kv.table.MultiRowOptions;
import oracle.kv.table.TableIteratorOptions;

public class IndexRange
implements FastExternalizable {
    public static final int FLAG_FORWARD = 1;
    public static final int FLAG_REVERSE = 2;
    public static final int FLAG_UNORDERED = 4;
    public static final int FLAG_EXACT = 8;
    private byte[] prefixKey;
    private byte[] startKey;
    private byte[] endKey;
    private final boolean exactMatch;
    private final Direction direction;

    IndexRange(IndexKeyImpl indexKey, MultiRowOptions getOptions, TableIteratorOptions iterateOptions) {
        this(indexKey, getOptions != null ? getOptions.getFieldRange() : null, iterateOptions == null ? Direction.FORWARD : iterateOptions.getDirection());
    }

    public IndexRange(IndexKeyImpl indexKey, FieldRange range, Direction direction) {
        this(indexKey, range, direction, false);
    }

    public IndexRange(IndexKeyImpl indexKey, FieldRange range, Direction direction, boolean geomRange) {
        boolean prefixScan;
        IndexKeyImpl startTarget = indexKey;
        IndexKeyImpl endTarget = null;
        boolean startInclusive = true;
        this.direction = direction;
        boolean isRangeFieldJson = false;
        boolean bl = prefixScan = geomRange && range.getStart().equals(range.getEnd());
        if (indexKey.isComplete()) {
            if (range != null) {
                throw new IllegalArgumentException("FieldRange may not be used with a fully specified IndexKey");
            }
            this.exactMatch = true;
        } else if (range != null) {
            if (range.getStart() != null) {
                startTarget = indexKey.clone();
                startTarget.put(range.getFieldName(), range.getStart());
                startInclusive = range.getStartInclusive();
            }
            if (range.getEnd() != null) {
                endTarget = indexKey.clone();
                endTarget.put(range.getFieldName(), range.getEnd());
                endTarget.validate();
            }
            this.exactMatch = false;
        } else {
            this.exactMatch = false;
        }
        if (startTarget.size() != 0) {
            startTarget.validate();
            if (!startInclusive && !startTarget.incrementIndexKey()) {
                throw new IllegalArgumentException("Exclusive start value on an indexed field cannot be its maximum value");
            }
            byte[] start = startTarget.getIndexImpl().serializeIndexKey(startTarget);
            if (startTarget == indexKey) {
                this.prefixKey = start;
                this.startKey = start;
            } else if (prefixScan) {
                this.prefixKey = Arrays.copyOf(start, start.length - 1);
                this.startKey = start;
                endTarget = null;
            } else {
                this.startKey = start;
                this.prefixKey = indexKey.size() > 0 ? indexKey.getIndexImpl().serializeIndexKey(indexKey) : null;
            }
        } else {
            this.prefixKey = null;
            this.startKey = null;
        }
        if (endTarget != null) {
            if (range != null && range.getEndInclusive() && !endTarget.incrementIndexKey()) {
                this.endKey = null;
                return;
            }
            this.endKey = endTarget.getIndexImpl().serializeIndexKey(endTarget);
        } else if (!(range == null || prefixScan || !indexKey.getIndexImpl().fieldMayHaveSpecialValue(indexKey.size()) || range.getStart() == null || ((FieldValueImpl)range.getStart()).isEMPTY() || ((FieldValueImpl)range.getStart()).isJsonNull() || ((FieldValueImpl)range.getStart()).isNull() || isRangeFieldJson)) {
            endTarget = indexKey.clone();
            endTarget.putEMPTY(range.getFieldName());
            this.endKey = endTarget.getIndexImpl().serializeIndexKey(endTarget);
        } else {
            this.endKey = null;
        }
        if (range != null && isRangeFieldJson) {
            if (this.endKey == null && (this.startKey != null || this.prefixKey != null)) {
                this.endKey = this.getJsonFieldRangeBytes(range.getField().getType(), true);
            }
            if (this.startKey == null && this.endKey != null) {
                this.startKey = this.getJsonFieldRangeBytes(range.getField().getType(), false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getJsonFieldRangeBytes(FieldDef.Type type, boolean end) {
        TupleOutput out = new TupleOutput();
        try {
            if (end) {
                out.writeByte(125);
                out.writeByte(type.ordinal() + 1);
            } else {
                out.writeByte(0);
                out.writeByte(type.ordinal());
            }
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        finally {
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
    }

    public IndexRange(DataInput in, short serialVersion) throws IOException {
        int flags = in.readUnsignedByte();
        boolean bl = this.exactMatch = (flags & 8) != 0;
        if ((flags & 1) != 0) {
            this.direction = Direction.FORWARD;
        } else if ((flags & 2) != 0) {
            this.direction = Direction.REVERSE;
        } else if ((flags & 4) != 0) {
            this.direction = Direction.UNORDERED;
        } else {
            throw new AssertionError((Object)"Flags must have a direction");
        }
        this.prefixKey = SerializationUtil.readByteArrayOldShortLength(in, serialVersion);
        this.startKey = SerializationUtil.readByteArrayOldShortLength(in, serialVersion);
        this.endKey = SerializationUtil.readByteArrayOldShortLength(in, serialVersion);
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        int flags = 0;
        if (this.exactMatch) {
            flags |= 8;
        }
        if (this.direction == Direction.FORWARD) {
            flags |= 1;
        } else if (this.direction == Direction.REVERSE) {
            flags |= 2;
        } else if (this.direction == Direction.UNORDERED) {
            flags |= 4;
        } else {
            throw new AssertionError((Object)"Direction must be set");
        }
        out.writeByte(flags);
        SerializationUtil.writeByteArrayOldShortLength(out, serialVersion, this.prefixKey);
        SerializationUtil.writeByteArrayOldShortLength(out, serialVersion, this.startKey);
        SerializationUtil.writeByteArrayOldShortLength(out, serialVersion, this.endKey);
    }

    public byte[] getPrefixKey() {
        return this.prefixKey;
    }

    public byte[] getStartKey() {
        return this.startKey;
    }

    public byte[] getEndKey() {
        return this.endKey;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public boolean isForward() {
        return this.direction == Direction.FORWARD;
    }

    public boolean isReverse() {
        return this.direction == Direction.REVERSE;
    }

    public boolean isUnordered() {
        return this.direction == Direction.UNORDERED;
    }

    public boolean getExactMatch() {
        return this.exactMatch;
    }

    public boolean inRange(byte[] checkKey) {
        return this.inRange(checkKey, this.direction);
    }

    private boolean inRange(byte[] checkKey, Direction dir) {
        if (this.exactMatch && dir != Direction.REVERSE) {
            return true;
        }
        boolean in = true;
        if (this.prefixKey != null) {
            if (checkKey.length < this.prefixKey.length) {
                in = false;
            } else {
                boolean bl = in = IndexImpl.compareUnsignedBytes(checkKey, 0, this.prefixKey.length, this.prefixKey, 0, this.prefixKey.length) == 0;
            }
        }
        if (in && this.endKey != null && (dir == Direction.FORWARD || dir == Direction.UNORDERED)) {
            boolean bl = in = IndexImpl.compareUnsignedBytes(checkKey, 0, Math.min(this.endKey.length, checkKey.length), this.endKey, 0, this.endKey.length) < 0;
        }
        if (in && this.startKey != null && dir == Direction.REVERSE) {
            in = IndexImpl.compareUnsignedBytes(checkKey, this.startKey) >= 0;
        }
        return in;
    }

    boolean inRange(IndexKeyImpl key) {
        byte[] bytes = key.getIndexImpl().serializeIndexKey(key);
        return this.inRange(bytes, Direction.FORWARD) && this.inRange(bytes, Direction.REVERSE);
    }

    private String format(byte[] bytes) {
        return Key.getNoFormatString((byte[])bytes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("prefix key:");
        sb.append(this.prefixKey != null ? this.format(this.prefixKey) : "null");
        sb.append(", start key:");
        sb.append(this.startKey != null ? this.format(this.startKey) : "null");
        sb.append(", end key:");
        sb.append(this.endKey != null ? this.format(this.endKey) : "null");
        sb.append(", direction:" + this.direction);
        sb.append(", exactMatch:" + this.exactMatch);
        return sb.toString();
    }

    public void reserializeOldKeys(IndexImpl index, short opVersion) {
        if (this.prefixKey != null) {
            this.prefixKey = index.reserializeOldKey(this.prefixKey, opVersion);
        }
        if (this.startKey != null) {
            this.startKey = index.reserializeOldKey(this.startKey, opVersion);
        }
        if (this.endKey != null) {
            this.endKey = index.reserializeOldKey(this.endKey, opVersion);
        }
    }
}

