/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import oracle.kv.impl.api.table.TableImpl;
import oracle.kv.impl.util.FastExternalizable;
import oracle.kv.impl.util.SerializationUtil;
import oracle.kv.table.Table;

public class TargetTables
implements FastExternalizable {
    private final long[] targetAndChildIds;
    private final long[] ancestorTableIds;
    private final boolean includeTarget;

    public TargetTables(Table targetTable, List<Table> childTables, List<Table> ancestorTables) {
        if (targetTable == null) {
            throw new IllegalArgumentException("Missing target table");
        }
        int arraySize = childTables != null ? childTables.size() + 1 : 1;
        this.targetAndChildIds = new long[arraySize];
        this.targetAndChildIds[0] = ((TableImpl)targetTable).getId();
        if (childTables != null) {
            int i = 1;
            for (Table table : childTables) {
                this.targetAndChildIds[i++] = ((TableImpl)table).getId();
            }
        }
        this.ancestorTableIds = this.makeIdArray(ancestorTables);
        this.includeTarget = true;
    }

    public TargetTables(TableImpl[] tables, int numAncestors) {
        int i;
        this.includeTarget = true;
        this.ancestorTableIds = new long[numAncestors];
        for (i = 0; i < numAncestors; ++i) {
            this.ancestorTableIds[i] = tables[i].getId();
        }
        this.targetAndChildIds = new long[tables.length - numAncestors];
        this.targetAndChildIds[0] = tables[numAncestors].getId();
        for (i = numAncestors + 1; i < tables.length; ++i) {
            this.targetAndChildIds[i - numAncestors] = tables[i].getId();
        }
    }

    public TargetTables(long tableId) {
        this.targetAndChildIds = new long[1];
        this.targetAndChildIds[0] = tableId;
        this.ancestorTableIds = new long[0];
        this.includeTarget = true;
    }

    public TargetTables(DataInput in, short serialVersion) throws IOException {
        int i;
        int len = serialVersion >= 14 ? SerializationUtil.readNonNullSequenceLength(in) : (int)in.readShort();
        this.targetAndChildIds = new long[len];
        for (i = 0; i < len; ++i) {
            this.targetAndChildIds[i] = in.readLong();
        }
        len = serialVersion >= 14 ? SerializationUtil.readNonNullSequenceLength(in) : (int)in.readShort();
        this.ancestorTableIds = new long[len];
        for (i = 0; i < len; ++i) {
            this.ancestorTableIds[i] = in.readLong();
        }
        this.includeTarget = in.readBoolean();
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        if (serialVersion >= 14) {
            SerializationUtil.writeNonNullSequenceLength(out, this.targetAndChildIds.length);
        } else {
            out.writeShort(this.targetAndChildIds.length);
        }
        for (long l : this.targetAndChildIds) {
            out.writeLong(l);
        }
        if (serialVersion >= 14) {
            SerializationUtil.writeNonNullSequenceLength(out, this.ancestorTableIds.length);
        } else {
            out.writeShort(this.ancestorTableIds.length);
        }
        for (long l : this.ancestorTableIds) {
            out.writeLong(l);
        }
        out.writeBoolean(this.includeTarget);
    }

    public long getTargetTableId() {
        return this.targetAndChildIds[0];
    }

    public long[] getTargetAndChildIds() {
        return this.targetAndChildIds;
    }

    public long[] getAncestorTableIds() {
        return this.ancestorTableIds;
    }

    public boolean getIncludeTarget() {
        return this.includeTarget;
    }

    public boolean hasAncestorTables() {
        return this.ancestorTableIds.length > 0;
    }

    public boolean hasChildTables() {
        return this.targetAndChildIds.length > 1;
    }

    private long[] makeIdArray(List<Table> tables) {
        if (tables == null) {
            return new long[0];
        }
        long[] ids = new long[tables.size()];
        int i = 0;
        for (Table table : tables) {
            ids[i++] = ((TableImpl)table).getId();
        }
        return ids;
    }
}

