/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.compiler;

import java.lang.reflect.InvocationTargetException;
import java.util.logging.Logger;
import oracle.kv.FaultException;
import oracle.kv.KVSecurityException;
import oracle.kv.impl.api.query.PreparedDdlStatementImpl;
import oracle.kv.impl.api.query.PreparedStatementImpl;
import oracle.kv.impl.api.table.GeometryUtils;
import oracle.kv.impl.api.table.TableAPIImpl;
import oracle.kv.impl.api.table.TableMetadataHelper;
import oracle.kv.impl.query.QueryException;
import oracle.kv.impl.query.QueryStateException;
import oracle.kv.impl.query.compiler.DdlException;
import oracle.kv.impl.query.compiler.FunctionLib;
import oracle.kv.impl.query.compiler.QueryControlBlock;
import oracle.kv.impl.query.compiler.StatementFactory;
import oracle.kv.impl.query.compiler.StaticContext;
import oracle.kv.query.ExecuteOptions;
import oracle.kv.query.PrepareCallback;
import oracle.kv.query.PreparedStatement;

public class CompilerAPI {
    static StaticContext theRootSctx = new StaticContext(null);
    static volatile GeometryUtils theGeomUtils;
    static FunctionLib theFunctionLib;

    public static GeometryUtils getGeoUtils() {
        if (theGeomUtils == null) {
            Class<?> geomUtilsClass;
            try {
                geomUtilsClass = Class.forName("oracle.kv.impl.api.table.GeometryUtilsImpl");
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Support for GeoJson data is not available in the Community Edition of Oracle NoSQL");
            }
            try {
                theGeomUtils = (GeometryUtils)geomUtilsClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (InstantiationException ie) {
                throw new IllegalArgumentException(ie);
            }
            catch (IllegalAccessException iae) {
                throw new IllegalArgumentException(iae);
            }
            catch (NoSuchMethodException nsme) {
                throw new IllegalArgumentException(nsme);
            }
            catch (InvocationTargetException ite) {
                throw new IllegalArgumentException(ite);
            }
        }
        return theGeomUtils;
    }

    static FunctionLib getFuncLib() {
        return theFunctionLib;
    }

    public static PreparedStatement prepare(TableAPIImpl tableAPI, char[] queryString, ExecuteOptions options) {
        if (options == null) {
            options = new ExecuteOptions();
        }
        String namespace = options.getNamespace();
        PrepareCallback prepareCallback = options.getPrepareCallback();
        try {
            StaticContext querySctx = new StaticContext(theRootSctx);
            QueryControlBlock qcb = new QueryControlBlock(tableAPI, options, queryString, querySctx, namespace, prepareCallback);
            qcb.compile();
            if (qcb.succeeded()) {
                if (prepareCallback != null && !prepareCallback.prepareNeeded()) {
                    return null;
                }
                return new PreparedStatementImpl(qcb.getQueryPlan(), qcb.getResultDef(), qcb.getNumRegs(), qcb.getNumIterators(), qcb.getInitSctx().getExternalVars(), qcb);
            }
            if (qcb.getException() instanceof QueryStateException) {
                Logger logger = tableAPI.getStore().getLogger();
                if (logger != null) {
                    logger.warning(qcb.getException().toString());
                }
                throw qcb.getException();
            }
            if (qcb.getException() instanceof FaultException) {
                throw qcb.getException();
            }
            if (qcb.getException() instanceof QueryException) {
                throw qcb.getException();
            }
            if (qcb.getException() instanceof IllegalArgumentException) {
                throw qcb.getException();
            }
            if (qcb.getException() instanceof KVSecurityException) {
                throw qcb.getException();
            }
            throw new IllegalArgumentException(qcb.getErrorMessage());
        }
        catch (DdlException ddle) {
            return new PreparedDdlStatementImpl(queryString, namespace, options);
        }
    }

    public static QueryControlBlock compile(char[] queryString, TableMetadataHelper metadataHelper, StatementFactory statementFactory, String namespace, PrepareCallback prepareCallback) {
        StaticContext querySctx = new StaticContext(theRootSctx);
        QueryControlBlock qcb = new QueryControlBlock(metadataHelper, statementFactory, queryString, querySctx, namespace, prepareCallback);
        qcb.compile();
        return qcb;
    }

    static {
        theFunctionLib = new FunctionLib(theRootSctx);
    }
}

