/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.topo;

import com.sleepycat.persist.model.Persistent;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import oracle.kv.impl.topo.PartitionId;
import oracle.kv.impl.topo.RepGroup;
import oracle.kv.impl.topo.RepGroupId;
import oracle.kv.impl.topo.ResourceId;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.util.JsonUtils;
import oracle.kv.impl.util.SerializationUtil;
import org.codehaus.jackson.node.ObjectNode;

@Persistent
public class Partition
extends Topology.Component<PartitionId> {
    private static final long serialVersionUID = 1L;
    private RepGroupId repGroupId;

    public Partition(RepGroup repGroup) {
        this((RepGroupId)repGroup.getResourceId());
    }

    public Partition(RepGroupId repGroupId) {
        this.repGroupId = repGroupId;
    }

    private Partition() {
    }

    private Partition(Partition partition) {
        super(partition);
        this.repGroupId = partition.repGroupId.clone();
    }

    Partition(Topology topology, PartitionId partitionId, DataInput in, short serialVersion) throws IOException {
        super(topology, partitionId, in, serialVersion);
        if (in.readBoolean()) {
            ResourceId rId = ResourceId.readFastExternal(in, serialVersion);
            if (!(rId instanceof RepGroupId)) {
                throw new IOException("Expected RepGroupId: " + rId);
            }
            this.repGroupId = (RepGroupId)rId;
        } else {
            this.repGroupId = null;
        }
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        SerializationUtil.writeFastExternalOrNull(out, serialVersion, this.repGroupId);
    }

    @Override
    public ResourceId.ResourceType getResourceType() {
        return ResourceId.ResourceType.PARTITION;
    }

    @Override
    public Topology.Component<?> clone() {
        return new Partition(this);
    }

    public RepGroupId getRepGroupId() {
        return this.repGroupId;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.repGroupId == null ? 0 : this.repGroupId.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        Partition other = (Partition)obj;
        return this.propertiesEqual(other);
    }

    public boolean propertiesEqual(Partition other) {
        return !(this.repGroupId == null ? other.repGroupId != null : !this.repGroupId.equals(other.repGroupId));
    }

    public String toString() {
        return "[" + this.getResourceId() + "]  shard=" + this.repGroupId;
    }

    @Override
    public ObjectNode toJson() {
        ObjectNode top = JsonUtils.createObjectNode();
        top.put("resourceId", ((PartitionId)this.getResourceId()).toString());
        top.put("shardId", this.repGroupId.toString());
        return top;
    }
}

