/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.framework;

import java.net.InetAddress;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.persistence.Version;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.testing.framework.TestResult;
import org.eclipse.persistence.testing.framework.TestResultsSummary;

public class LoadBuildSummary {
    public long id;
    public String userName;
    public String loginChoice;
    public String os;
    public String jvm;
    public String machine;
    public String toplinkVersion;
    public int numberOfTests;
    public int errors;
    public int fatalErrors;
    public DatabaseLogin databaseLogin;
    public Timestamp timestamp;
    protected ValueHolderInterface<Vector<TestResultsSummary>> summaries = new ValueHolder();
    protected ValueHolderInterface<Vector<TestResult>> results = new ValueHolder();

    public LoadBuildSummary() {
        try {
            this.os = System.getProperty("os.name");
            this.jvm = System.getProperty("java.vm.version");
            this.toplinkVersion = Version.getVersion() + " :" + Version.getBuildNumber();
            this.machine = InetAddress.getLocalHost().getHostName();
            if (this.machine.indexOf(".") != -1) {
                this.machine = this.machine.substring(0, this.machine.indexOf("."));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getMachine() {
        return this.machine;
    }

    public String getToplinkVersion() {
        return this.toplinkVersion;
    }

    public String getJVM() {
        return this.jvm;
    }

    public String getOS() {
        return this.os;
    }

    public String getLoginChoice() {
        return this.loginChoice;
    }

    public void addResult(TestResult result) {
        if (this.results == null) {
            this.results = new ValueHolder(new Vector());
        } else if (this.results.getValue() == null) {
            this.results.setValue(new Vector());
        }
        this.getResults().addElement(result);
    }

    public void addSummary(TestResultsSummary summary) {
        if (this.summaries == null) {
            this.summaries = new ValueHolder(new Vector());
        } else if (this.summaries.getValue() == null) {
            this.summaries.setValue(new Vector());
        }
        Enumeration<TestResultsSummary> enumtr = this.getSummaries().elements();
        while (enumtr.hasMoreElements()) {
            TestResultsSummary element = enumtr.nextElement();
            if (!element.getName().equals(summary.getName())) continue;
            this.getSummaries().removeElement(element);
        }
        this.getSummaries().addElement(summary);
    }

    public void computeNumberOfTestsAndErrors() {
        TestResultsSummary summary;
        Vector<TestResultsSummary> rootSummaries = new Vector<TestResultsSummary>();
        this.numberOfTests = 0;
        this.errors = 0;
        this.fatalErrors = 0;
        Enumeration<Comparable> enumtr = this.getSummaries().elements();
        while (enumtr.hasMoreElements()) {
            summary = enumtr.nextElement();
            if (summary.getParent() != null) continue;
            rootSummaries.addElement(summary);
        }
        enumtr = rootSummaries.elements();
        while (enumtr.hasMoreElements()) {
            summary = enumtr.nextElement();
            this.numberOfTests += summary.getTotalTests();
            this.errors += summary.getErrors();
            this.fatalErrors += summary.getFatalErrors();
        }
        enumtr = this.getResults().elements();
        while (enumtr.hasMoreElements()) {
            TestResult result = (TestResult)enumtr.nextElement();
            if (result.hasError()) {
                ++this.errors;
                continue;
            }
            if (!result.hasFatalError()) continue;
            ++this.fatalErrors;
        }
        this.numberOfTests += this.getResults().size();
    }

    public Vector<TestResult> getResults() {
        if (this.results == null) {
            this.results = new ValueHolder(new Vector());
        } else if (this.results.getValue() == null) {
            this.results.setValue(new Vector());
        }
        return (Vector)this.results.getValue();
    }

    public ValueHolderInterface<? extends Vector<TestResult>> getResultsHolder() {
        return this.results;
    }

    public Vector<TestResultsSummary> getSummaries() {
        if (this.summaries == null) {
            this.summaries = new ValueHolder(new Vector());
        } else if (this.summaries.getValue() == null) {
            this.summaries.setValue(new Vector());
        }
        return (Vector)this.summaries.getValue();
    }

    public ValueHolderInterface<? extends Vector<TestResultsSummary>> getSummariesHolder() {
        return this.summaries;
    }

    public void initializeLoadBuild() {
        if (this.getResults() != null) {
            Enumeration<TestResult> enumtr = this.getResults().elements();
            while (enumtr.hasMoreElements()) {
                TestResult result = enumtr.nextElement();
                result.setLoadBuildSummary(this);
            }
        }
        if (this.getSummaries() != null) {
            Enumeration<TestResultsSummary> enum1 = this.getSummaries().elements();
            while (enum1.hasMoreElements()) {
                TestResultsSummary summary = enum1.nextElement();
                summary.setLoadBuildSummary(this);
                Enumeration enum2 = summary.getResults().elements();
                while (enum2.hasMoreElements()) {
                    TestResult result = (TestResult)enum2.nextElement();
                    result.setLoadBuildSummary(this);
                }
            }
        }
        for (int i = 0; i < this.getResults().size(); ++i) {
            if (this.getResults().elementAt(i).getSummary() == null) continue;
            this.getResults().removeElementAt(i);
            --i;
        }
    }

    public boolean isEmpty() {
        return this.getSummaries().size() == 0 && this.getResults().size() == 0;
    }

    public void setLoadBuildSummaryForTests() {
        if (this.getResults() != null) {
            Enumeration<TestResult> enumtr = this.getResults().elements();
            while (enumtr.hasMoreElements()) {
                TestResult result = enumtr.nextElement();
                result.setLoadBuildSummary(this);
            }
        }
        if (this.getSummaries() != null) {
            Enumeration<TestResultsSummary> enum1 = this.getSummaries().elements();
            while (enum1.hasMoreElements()) {
                TestResultsSummary summary = enum1.nextElement();
                summary.setLoadBuildSummary(this);
                Enumeration enum2 = summary.getResults().elements();
                while (enum2.hasMoreElements()) {
                    TestResult result = (TestResult)enum2.nextElement();
                    result.setLoadBuildSummary(this);
                }
            }
        }
        for (int i = 0; i < this.getResults().size(); ++i) {
            if (this.getResults().elementAt(i).getSummary() == null) continue;
            this.getResults().removeElementAt(i);
            --i;
        }
    }

    public void setResults(Vector<TestResult> theResults) {
        this.results.setValue(theResults);
    }

    public void setResultsHolder(ValueHolderInterface<Vector<TestResult>> holder) {
        this.results = holder;
    }

    public void setSummaries(Vector<TestResultsSummary> theSummaries) {
        this.summaries.setValue(theSummaries);
    }

    public void setSummariesHolder(ValueHolderInterface<Vector<TestResultsSummary>> holder) {
        this.summaries = holder;
    }
}

