/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.conversion;

import junit.framework.Test;
import org.eclipse.persistence.testing.framework.DeleteObjectTest;
import org.eclipse.persistence.testing.framework.InsertObjectTest;
import org.eclipse.persistence.testing.framework.ReadAllTest;
import org.eclipse.persistence.testing.framework.ReadObjectTest;
import org.eclipse.persistence.testing.framework.TestModel;
import org.eclipse.persistence.testing.framework.TestSuite;
import org.eclipse.persistence.testing.framework.UnitOfWorkBasicUpdateObjectTest;
import org.eclipse.persistence.testing.framework.WriteObjectTest;
import org.eclipse.persistence.testing.models.conversion.ConversionDataObject;
import org.eclipse.persistence.testing.models.conversion.ConversionManagerSystem;
import org.eclipse.persistence.tools.schemaframework.PopulationManager;

public class ConversionManagerTestModelWithoutBinding
extends TestModel {
    public boolean originalBindingState;
    public boolean originalStatementCachingState;

    public ConversionManagerTestModelWithoutBinding() {
        this.setDescription("This suite tests all possible conversions through direct field mapping.");
    }

    public void addForcedRequiredSystems() {
        this.originalBindingState = this.getSession().getLogin().getPlatform().shouldBindAllParameters();
        this.originalStatementCachingState = this.getSession().getLogin().getPlatform().shouldCacheAllStatements();
        this.getSession().getLogin().getPlatform().setShouldBindAllParameters(false);
        this.getSession().getLogin().getPlatform().setShouldCacheAllStatements(false);
        this.addForcedRequiredSystem(new ConversionManagerSystem());
    }

    public void addTests() {
        this.addTest((Test)this.getReadObjectTestSuite());
        this.addTest((Test)this.getReadAllTestSuite());
        this.addTest((Test)this.getDeleteObjectTestSuite());
        this.addTest((Test)this.getInsertObjectTestSuite());
        this.addTest((Test)this.getUpdateObjectTestSuite());
    }

    public TestSuite getDeleteObjectTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("ConversionManagerDeleteObjectTestSuite");
        suite.setDescription("This suite tests the deletion of each object in the conversion manager model.");
        PopulationManager manager = PopulationManager.getDefaultManager();
        suite.addTest((Test)new DeleteObjectTest(manager.getObject(ConversionDataObject.class, "example1")));
        suite.addTest((Test)new DeleteObjectTest(manager.getObject(ConversionDataObject.class, "example2")));
        suite.addTest((Test)new DeleteObjectTest(manager.getObject(ConversionDataObject.class, "example3")));
        return suite;
    }

    public TestSuite getInsertObjectTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("ConversionManagerInsertObjectTestSuite");
        suite.setDescription("This suite tests the insertion of each object in the conversion manager model.");
        suite.addTest((Test)new InsertObjectTest((Object)ConversionDataObject.example1()));
        suite.addTest((Test)new InsertObjectTest((Object)ConversionDataObject.example2()));
        suite.addTest((Test)new InsertObjectTest((Object)ConversionDataObject.example3()));
        return suite;
    }

    public TestSuite getReadAllTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("ConversionManagerReadAllTestSuite");
        suite.setDescription("This suite tests the reading of all the objects of each class in the conversion manager model.");
        suite.addTest((Test)new ReadAllTest(ConversionDataObject.class, 3));
        return suite;
    }

    public TestSuite getReadObjectTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("ConversionManagerReadObjectTestSuite");
        suite.setDescription("This suite test the reading of each object in the conversion manager model.");
        PopulationManager manager = PopulationManager.getDefaultManager();
        suite.addTest((Test)new ReadObjectTest(manager.getObject(ConversionDataObject.class, "example1")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(ConversionDataObject.class, "example2")));
        suite.addTest((Test)new ReadObjectTest(manager.getObject(ConversionDataObject.class, "example3")));
        return suite;
    }

    public TestSuite getUpdateObjectTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("ConversionManagerUpdateObjectTestSuite");
        suite.setDescription("This suite tests the updating of each object in the conversion manager model.");
        PopulationManager manager = PopulationManager.getDefaultManager();
        suite.addTest((Test)new WriteObjectTest(manager.getObject(ConversionDataObject.class, "example1")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(ConversionDataObject.class, "example1")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(ConversionDataObject.class, "example2")));
        suite.addTest((Test)new UnitOfWorkBasicUpdateObjectTest(manager.getObject(ConversionDataObject.class, "example3")));
        return suite;
    }

    public void reset() {
        this.getSession().getLogin().getPlatform().setShouldCacheAllStatements(this.originalStatementCachingState);
        this.getSession().getLogin().getPlatform().setShouldBindAllParameters(this.originalBindingState);
    }
}

