/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.customsqlstoredprocedures;

import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DirectCollectionMapping;
import org.eclipse.persistence.mappings.ManyToManyMapping;
import org.eclipse.persistence.mappings.OneToManyMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.platform.database.DatabasePlatform;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DataModifyQuery;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.DeleteObjectQuery;
import org.eclipse.persistence.queries.InsertObjectQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.queries.SQLCall;
import org.eclipse.persistence.queries.StoredProcedureCall;
import org.eclipse.persistence.queries.UpdateObjectQuery;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.domain.LargeProject;
import org.eclipse.persistence.testing.models.employee.domain.Project;
import org.eclipse.persistence.testing.models.employee.domain.SmallProject;
import org.eclipse.persistence.testing.models.employee.relational.EmployeeSystem;
import org.eclipse.persistence.tools.schemaframework.DatabaseObjectDefinition;
import org.eclipse.persistence.tools.schemaframework.FieldDefinition;
import org.eclipse.persistence.tools.schemaframework.NestedTableDefinition;
import org.eclipse.persistence.tools.schemaframework.PackageDefinition;
import org.eclipse.persistence.tools.schemaframework.SchemaManager;
import org.eclipse.persistence.tools.schemaframework.StoredFunctionDefinition;
import org.eclipse.persistence.tools.schemaframework.StoredProcedureDefinition;
import org.eclipse.persistence.tools.schemaframework.TypeDefinition;
import org.eclipse.persistence.tools.schemaframework.VarrayDefinition;

public class EmployeeCustomSQLSystem
extends EmployeeSystem {
    @Override
    public void addDescriptors(DatabaseSession session) {
        session.logout();
        super.addDescriptors(session);
        this.setCustomSQL((Session)session);
        session.login();
    }

    public StoredProcedureDefinition buildOracleDeleteProcedure() {
        StoredProcedureDefinition proc = new StoredProcedureDefinition();
        proc.setName("Delete_Employee");
        proc.addArgument("P_EMP_ID", Long.class);
        proc.addStatement("Delete FROM SALARY where EMP_ID = P_EMP_ID");
        proc.addStatement("Delete FROM EMPLOYEE where EMP_ID = P_EMP_ID");
        return proc;
    }

    public StoredProcedureDefinition buildOracleInsertProcedure() {
        StoredProcedureDefinition proc = new StoredProcedureDefinition();
        proc.setName("Insert_Employee");
        proc.addArgument("P_EMP_ID", Long.class);
        proc.addArgument("P_SALARY", Integer.class);
        proc.addArgument("P_END_DATE", Date.class);
        proc.addArgument("P_MANAGER_ID", Long.class);
        proc.addArgument("P_START_DATE", Date.class);
        proc.addArgument("P_F_NAME", String.class, 40);
        proc.addArgument("P_L_NAME", String.class, 40);
        proc.addArgument("P_GENDER", String.class, 1);
        proc.addArgument("P_ADDR_ID", Long.class);
        proc.addArgument("P_VERSION", Long.class);
        proc.addArgument("P_START_TIME", Time.class);
        proc.addArgument("P_END_TIME", Time.class);
        proc.addStatement("Insert INTO EMPLOYEE (EMP_ID, END_DATE, MANAGER_ID, START_DATE, F_NAME, L_NAME, GENDER, ADDR_ID, VERSION, START_TIME, END_TIME) VALUES (P_EMP_ID, P_END_DATE, P_MANAGER_ID, P_START_DATE, P_F_NAME, P_L_NAME, P_GENDER, P_ADDR_ID, P_VERSION, P_START_TIME, P_END_TIME)");
        proc.addStatement("Insert INTO SALARY (SALARY, EMP_ID) VALUES (P_SALARY, P_EMP_ID)");
        return proc;
    }

    public PackageDefinition buildOraclePackage() {
        PackageDefinition types = new PackageDefinition();
        types.setName("Cursor_Type");
        types.addStatement("Type Any_Cursor is REF CURSOR");
        return types;
    }

    public StoredProcedureDefinition buildOracleReadAllProcedure() {
        StoredProcedureDefinition proc = new StoredProcedureDefinition();
        proc.setName("Read_All_Employees");
        proc.addOutputArgument("RESULT_CURSOR", "CURSOR_TYPE.ANY_CURSOR");
        proc.addStatement("OPEN RESULT_CURSOR FOR Select E.*, S.* from EMPLOYEE E, SALARY S WHERE E.EMP_ID = S.EMP_ID");
        return proc;
    }

    public StoredProcedureDefinition buildOracle2OutCursorsProcedure() {
        StoredProcedureDefinition proc = new StoredProcedureDefinition();
        proc.setName("Read_Emp_Add");
        proc.addOutputArgument("CUR1", "CURSOR_TYPE.ANY_CURSOR");
        proc.addOutputArgument("CUR2", "CURSOR_TYPE.ANY_CURSOR");
        proc.addStatement("OPEN CUR1 FOR Select E.*, S.* from EMPLOYEE E, SALARY S WHERE E.EMP_ID = S.EMP_ID");
        proc.addStatement("OPEN CUR2 FOR Select a.* from ADDRESS a");
        return proc;
    }

    public StoredProcedureDefinition buildOracleReadObjectProcedure() {
        StoredProcedureDefinition proc = new StoredProcedureDefinition();
        proc.setName("Read_Employee");
        proc.addArgument("P_EMP_ID", Long.class);
        proc.addOutputArgument("RESULT_CURSOR", "CURSOR_TYPE.ANY_CURSOR");
        proc.addStatement("OPEN RESULT_CURSOR FOR Select E.*, S.* from EMPLOYEE E, SALARY S where E.EMP_ID = S.EMP_ID AND E.EMP_ID = P_EMP_ID");
        return proc;
    }

    public StoredProcedureDefinition buildOracleStoredProcedureInOutPut() {
        StoredProcedureDefinition proc = new StoredProcedureDefinition();
        proc.setName("StoredProcedure_InOutput");
        proc.addInOutputArgument("P_EMP_ID", Long.class);
        proc.addInOutputArgument("P_F_NAME", String.class);
        proc.addStatement("P_EMP_ID := P_EMP_ID");
        proc.addStatement("P_F_NAME := P_F_NAME");
        return proc;
    }

    public StoredProcedureDefinition buildOracleStoredProcedureTimestamp() {
        StoredProcedureDefinition proc = new StoredProcedureDefinition();
        proc.setName("StoredProcedure_Timestamp");
        proc.addInOutputArgument("CURRENT_DATE", Timestamp.class);
        proc.addStatement("CURRENT_DATE := CURRENT_DATE");
        return proc;
    }

    public StoredProcedureDefinition buildOracleStoredProcedureInOutOutIn() {
        StoredProcedureDefinition proc = new StoredProcedureDefinition();
        proc.setName("StoredProcedure_InOut_Out_In");
        proc.addInOutputArgument("P_INOUT", Long.class);
        proc.addOutputArgument("P_OUT", Long.class);
        proc.addArgument("P_IN", Long.class);
        proc.addStatement("P_OUT := P_INOUT");
        proc.addStatement("P_INOUT := P_IN");
        return proc;
    }

    public StoredProcedureDefinition buildOracleStoredProcedureARRAY() {
        StoredProcedureDefinition proc = new StoredProcedureDefinition();
        proc.setName("StoredProcedure_ARRAY");
        proc.addOutputArgument("P_OUT", "TEST_STRING_ARRAY");
        proc.addStatement("P_OUT := TEST_STRING_ARRAY(10)");
        return proc;
    }

    public static VarrayDefinition buildVARRAYTypeDefinition() {
        VarrayDefinition definition = new VarrayDefinition();
        definition.setName("TEST_STRING_ARRAY");
        definition.setSize(20);
        definition.setType(String.class);
        definition.setTypeSize(30);
        return definition;
    }

    public StoredFunctionDefinition buildOracleStoredFunctionInOutOutIn() {
        StoredFunctionDefinition func = new StoredFunctionDefinition();
        func.setName("StoredFunction_InOut_Out_In");
        func.addInOutputArgument("P_INOUT", Long.class);
        func.addOutputArgument("P_OUT", Long.class);
        func.addArgument("P_IN", Long.class);
        func.setReturnType(Long.class);
        func.addStatement("P_OUT := P_INOUT");
        func.addStatement("P_INOUT := P_IN");
        func.addStatement("RETURN P_OUT");
        return func;
    }

    public NestedTableDefinition buildOracleLOOKUPTABLETYPE() {
        NestedTableDefinition ntd = new NestedTableDefinition();
        ntd.setName("SF_LOOKUP_TBL");
        ntd.setTypeName("SF_LOOKUP_RECORD");
        return ntd;
    }

    public TypeDefinition buildOracleLOOKUPRECORDTYPE() {
        TypeDefinition td = new TypeDefinition();
        td.setName("SF_LOOKUP_RECORD");
        FieldDefinition fd1 = new FieldDefinition();
        fd1.setName("ATTR_1");
        fd1.setTypeName("VARCHAR2");
        fd1.setSize(200);
        td.addField(fd1);
        FieldDefinition fd2 = new FieldDefinition();
        fd2.setName("ATTR_2");
        fd2.setTypeName("VARCHAR2");
        fd2.setSize(200);
        td.addField(fd2);
        return td;
    }

    public PackageDefinition buildOraclePackageStoredFunctionResultCursor() {
        PackageDefinition pkgd = new PackageDefinition();
        pkgd.setName("PackageFunction_ResultCursor");
        pkgd.addStatement("TYPE REF_CURSOR IS REF CURSOR");
        pkgd.addStatement("FUNCTION BUSINESS_DATE (P_CODE IN VARCHAR2, P_LOOKUP_TBL IN SF_LOOKUP_TBL) RETURN REF_CURSOR");
        return pkgd;
    }

    public StoredProcedureDefinition buildOracleUpdateProcedure() {
        StoredProcedureDefinition proc = new StoredProcedureDefinition();
        proc.setName("Update_Employee");
        proc.addArgument("P_EMP_ID", Long.class);
        proc.addArgument("P_SALARY", Integer.class);
        proc.addArgument("P_END_DATE", Date.class);
        proc.addArgument("P_MANAGER_ID", Long.class);
        proc.addArgument("P_START_DATE", Date.class);
        proc.addArgument("P_F_NAME", String.class, 40);
        proc.addArgument("P_L_NAME", String.class, 40);
        proc.addArgument("P_GENDER", String.class, 1);
        proc.addArgument("P_ADDR_ID", Long.class);
        proc.addArgument("P_START_TIME", Time.class);
        proc.addArgument("P_END_TIME", Time.class);
        proc.addOutputArgument("O_ERROR_CODE", Long.class);
        proc.addStatement("Update SALARY set SALARY = P_SALARY WHERE (EMP_ID = P_EMP_ID)");
        proc.addStatement("Update EMPLOYEE set END_DATE = P_END_DATE, MANAGER_ID = P_MANAGER_ID, START_DATE = P_START_DATE, F_NAME = P_F_NAME, L_NAME = P_L_NAME, GENDER = P_GENDER, ADDR_ID = P_ADDR_ID WHERE (EMP_ID = P_EMP_ID)");
        return proc;
    }

    public StoredProcedureDefinition buildSQLServerDeleteProcedure() {
        StoredProcedureDefinition proc = new StoredProcedureDefinition();
        proc.setName("Delete_Employee");
        proc.addArgument("EMP_ID", Long.class);
        proc.addStatement("Delete FROM SALARY where EMP_ID = @EMP_ID");
        proc.addStatement("Delete FROM EMPLOYEE where EMP_ID = @EMP_ID");
        return proc;
    }

    public StoredProcedureDefinition buildSQLServerInsertProcedure() {
        StoredProcedureDefinition proc = new StoredProcedureDefinition();
        proc.setName("Insert_Employee");
        proc.addArgument("EMP_ID", Long.class);
        proc.addArgument("SALARY", Integer.class);
        proc.addArgument("END_DATE", Date.class);
        proc.addArgument("MANAGER_ID", Long.class);
        proc.addArgument("START_DATE", Date.class);
        proc.addArgument("F_NAME", String.class, 40);
        proc.addArgument("L_NAME", String.class, 40);
        proc.addArgument("GENDER", String.class, 1);
        proc.addArgument("ADDR_ID", Long.class);
        proc.addOutputArgument("VERSION", Long.class);
        proc.addArgument("START_TIME", Time.class);
        proc.addArgument("END_TIME", Time.class);
        proc.addStatement("Insert INTO EMPLOYEE (EMP_ID, END_DATE, MANAGER_ID, START_DATE, F_NAME, L_NAME, GENDER, ADDR_ID, VERSION, START_TIME, END_TIME) VALUES (@EMP_ID, @END_DATE, @MANAGER_ID, @START_DATE, @F_NAME, @L_NAME, @GENDER, @ADDR_ID, @VERSION, @START_TIME, @END_TIME)");
        proc.addStatement("Insert INTO SALARY (SALARY, EMP_ID) VALUES (@SALARY, @EMP_ID)");
        proc.addStatement("SELECT @VERSION = 952");
        return proc;
    }

    public StoredProcedureDefinition buildSQLServerReadAllProcedure() {
        StoredProcedureDefinition proc = new StoredProcedureDefinition();
        proc.setName("Read_All_Employees");
        proc.addStatement("Select E.*, S.* from EMPLOYEE E, SALARY S WHERE E.EMP_ID = S.EMP_ID");
        return proc;
    }

    public StoredProcedureDefinition buildSQLServerReadObjectProcedure() {
        StoredProcedureDefinition proc = new StoredProcedureDefinition();
        proc.setName("Read_Employee");
        proc.addArgument("EMP_ID", Long.class);
        proc.addStatement("Select E.*, S.* from EMPLOYEE E, SALARY S where E.EMP_ID = S.EMP_ID AND E.EMP_ID = @EMP_ID");
        return proc;
    }

    public StoredProcedureDefinition buildSQLServerSelectWithOutputAndResultSetProcedure() {
        StoredProcedureDefinition proc = new StoredProcedureDefinition();
        proc.setName("Select_Output_and_ResultSet");
        proc.addArgument("ARG1", Long.class);
        proc.addOutputArgument("VERSION", Long.class);
        proc.addStatement("SELECT @VERSION = 23");
        proc.addStatement("Select E.*, S.* from EMPLOYEE E, SALARY S where E.EMP_ID = S.EMP_ID AND E.F_NAME = 'Bob'");
        return proc;
    }

    public StoredProcedureDefinition buildSQLServerSelectWithOutputProcedure() {
        StoredProcedureDefinition proc = new StoredProcedureDefinition();
        proc.setName("Select_Employee_using_Output");
        proc.addArgument("ARG1", Long.class);
        proc.addOutputArgument("VERSION", Long.class);
        proc.addStatement("SELECT @VERSION = 23");
        return proc;
    }

    public StoredProcedureDefinition buildSQLServerUpdateProcedure() {
        StoredProcedureDefinition proc = new StoredProcedureDefinition();
        proc.setName("Update_Employee");
        proc.addArgument("EMP_ID", Long.class);
        proc.addArgument("SALARY", Integer.class);
        proc.addArgument("END_DATE", Date.class);
        proc.addArgument("MANAGER_ID", Long.class);
        proc.addArgument("START_DATE", Date.class);
        proc.addArgument("F_NAME", String.class, 40);
        proc.addArgument("L_NAME", String.class, 40);
        proc.addArgument("GENDER", String.class, 1);
        proc.addArgument("ADDR_ID", Long.class);
        proc.addArgument("START_TIME", Time.class);
        proc.addArgument("END_TIME", Time.class);
        proc.addStatement("Update SALARY set SALARY = @SALARY WHERE (EMP_ID = @EMP_ID)");
        proc.addStatement("Update EMPLOYEE set END_DATE = @END_DATE, MANAGER_ID = @MANAGER_ID, START_DATE = @START_DATE, F_NAME = @F_NAME, L_NAME = @L_NAME, GENDER = @GENDER, ADDR_ID = @ADDR_ID  WHERE (EMP_ID = @EMP_ID)");
        return proc;
    }

    public StoredProcedureDefinition buildSybaseDeleteProcedure() {
        StoredProcedureDefinition proc = new StoredProcedureDefinition();
        proc.setName("Delete_Employee");
        proc.addArgument("EMP_ID", Long.class);
        proc.addStatement("Delete FROM SALARY where EMP_ID = @EMP_ID");
        proc.addStatement("Delete FROM EMPLOYEE where EMP_ID = @EMP_ID");
        return proc;
    }

    public StoredProcedureDefinition buildSybaseInsertProcedure() {
        StoredProcedureDefinition proc = new StoredProcedureDefinition();
        proc.setName("Insert_Employee");
        proc.addArgument("EMP_ID", Long.class);
        proc.addArgument("SALARY", Integer.class);
        proc.addArgument("END_DATE", Date.class);
        proc.addArgument("MANAGER_ID", Long.class);
        proc.addArgument("START_DATE", Date.class);
        proc.addArgument("F_NAME", String.class, 40);
        proc.addArgument("L_NAME", String.class, 40);
        proc.addArgument("GENDER", String.class, 1);
        proc.addArgument("ADDR_ID", Long.class);
        proc.addArgument("START_TIME", Time.class);
        proc.addArgument("END_TIME", Time.class);
        proc.addArgument("VERSION", Long.class);
        proc.addOutputArgument("OUT_VERSION", Long.class);
        proc.addStatement("Insert INTO EMPLOYEE (EMP_ID, END_DATE, MANAGER_ID, START_DATE, F_NAME, L_NAME, GENDER, ADDR_ID, VERSION, START_TIME, END_TIME) VALUES (@EMP_ID, @END_DATE, @MANAGER_ID, @START_DATE, @F_NAME, @L_NAME, @GENDER, @ADDR_ID, @VERSION, @START_TIME, @END_TIME)");
        proc.addStatement("Insert INTO SALARY (SALARY, EMP_ID) VALUES (@SALARY, @EMP_ID)");
        proc.addStatement("Select @OUT_VERSION = 952");
        return proc;
    }

    public StoredProcedureDefinition buildSybaseReadAllProcedure() {
        StoredProcedureDefinition proc = new StoredProcedureDefinition();
        proc.setName("Read_All_Employees");
        proc.addStatement("Select E.*, S.* from EMPLOYEE E, SALARY S WHERE E.EMP_ID = S.EMP_ID");
        return proc;
    }

    public StoredProcedureDefinition buildMySQL2ResultSetProcedure() {
        StoredProcedureDefinition proc = new StoredProcedureDefinition();
        proc.setName("Read_Emp_Add");
        proc.addStatement("Select E.*, S.* from EMPLOYEE E, SALARY S WHERE E.EMP_ID = S.EMP_ID");
        proc.addStatement("Select a.* from ADDRESS a");
        return proc;
    }

    public StoredProcedureDefinition buildSybaseReadObjectProcedure() {
        StoredProcedureDefinition proc = new StoredProcedureDefinition();
        proc.setName("Read_Employee");
        proc.addArgument("EMP_ID", Long.class);
        proc.addStatement("Select E.*, S.* from EMPLOYEE E, SALARY S where E.EMP_ID = S.EMP_ID AND E.EMP_ID = @EMP_ID");
        return proc;
    }

    public StoredProcedureDefinition buildSybaseSelectWithOutputAndResultSetProcedure() {
        StoredProcedureDefinition proc = new StoredProcedureDefinition();
        proc.setName("Select_Output_and_ResultSet");
        proc.addArgument("ARG1", Long.class);
        proc.addOutputArgument("VERSION", Long.class);
        proc.addStatement("SELECT @VERSION = 23");
        proc.addStatement("Select E.*, S.* from EMPLOYEE E, SALARY S where E.EMP_ID = S.EMP_ID AND E.F_NAME = 'Bob'");
        return proc;
    }

    public StoredProcedureDefinition buildSybaseWithoutParametersProcedure() {
        StoredProcedureDefinition proc = new StoredProcedureDefinition();
        proc.setName("Rise_All_Salaries");
        proc.addStatement("Update SALARY set SALARY = SALARY * 1.1");
        return proc;
    }

    public StoredProcedureDefinition buildSybaseUpdateProcedure() {
        StoredProcedureDefinition proc = new StoredProcedureDefinition();
        proc.setName("Update_Employee");
        proc.addArgument("EMP_ID", Long.class);
        proc.addArgument("SALARY", Integer.class);
        proc.addArgument("END_DATE", Date.class);
        proc.addArgument("MANAGER_ID", Long.class);
        proc.addArgument("START_DATE", Date.class);
        proc.addArgument("F_NAME", String.class, 40);
        proc.addArgument("L_NAME", String.class, 40);
        proc.addArgument("GENDER", String.class, 1);
        proc.addArgument("ADDR_ID", Long.class);
        proc.addArgument("VERSION", Long.class);
        proc.addArgument("START_TIME", Time.class);
        proc.addArgument("END_TIME", Time.class);
        proc.addStatement("Update SALARY set SALARY = @SALARY WHERE (EMP_ID = @EMP_ID)");
        proc.addStatement("Update EMPLOYEE set END_DATE = @END_DATE, MANAGER_ID = @MANAGER_ID, START_DATE = @START_DATE, F_NAME = @F_NAME, L_NAME = @L_NAME, GENDER = @GENDER, ADDR_ID = @ADDR_ID, VERSION = @VERSION + 1 WHERE ((EMP_ID = @EMP_ID) AND (VERSION = @VERSION))");
        return proc;
    }

    private static StoredProcedureDefinition buildSQLAnywhereDeleteProcedure() {
        StoredProcedureDefinition procedure = new StoredProcedureDefinition();
        procedure.setName("Delete_Employee");
        procedure.addArgument("_EMP_ID", Long.class);
        procedure.addStatement("DELETE FROM SALARY WHERE EMP_ID = _EMP_ID");
        procedure.addStatement("DELETE FROM EMPLOYEE WHERE EMP_ID = _EMP_ID");
        return procedure;
    }

    private static StoredProcedureDefinition buildSQLAnywhereInsertProcedure() {
        StoredProcedureDefinition procedure = new StoredProcedureDefinition();
        procedure.setName("Insert_Employee");
        procedure.addArgument("_EMP_ID", Long.class);
        procedure.addArgument("_SALARY", Integer.class);
        procedure.addArgument("_END_DATE", Date.class);
        procedure.addArgument("_MANAGER_ID", Long.class);
        procedure.addArgument("_START_DATE", Date.class);
        procedure.addArgument("_F_NAME", String.class, 40);
        procedure.addArgument("_L_NAME", String.class, 40);
        procedure.addArgument("_GENDER", String.class, 1);
        procedure.addArgument("_ADDR_ID", Long.class);
        procedure.addArgument("_START_TIME", Time.class);
        procedure.addArgument("_END_TIME", Time.class);
        procedure.addArgument("_VERSION", Long.class);
        procedure.addOutputArgument("_OUT_VERSION", Long.class);
        procedure.addStatement("INSERT INTO EMPLOYEE (EMP_ID, END_DATE, MANAGER_ID, START_DATE, F_NAME, L_NAME, GENDER, ADDR_ID, VERSION, START_TIME, END_TIME) VALUES (_EMP_ID, _END_DATE, _MANAGER_ID, _START_DATE, _F_NAME, _L_NAME, _GENDER, _ADDR_ID, _VERSION, _START_TIME, _END_TIME)");
        procedure.addStatement("INSERT INTO SALARY (SALARY, EMP_ID) VALUES (_SALARY, _EMP_ID)");
        procedure.addStatement("SET _OUT_VERSION = 952");
        return procedure;
    }

    private static StoredProcedureDefinition buildSQLAnywhereReadAllProcedure() {
        StoredProcedureDefinition procedure = new StoredProcedureDefinition();
        procedure.setName("Read_All_Employees");
        procedure.addStatement("SELECT E.*, S.* FROM EMPLOYEE E JOIN SALARY S ON E.EMP_ID = S.EMP_ID");
        return procedure;
    }

    private static StoredProcedureDefinition buildSQLAnywhereReadObjectProcedure() {
        StoredProcedureDefinition procedure = new StoredProcedureDefinition();
        procedure.setName("Read_Employee");
        procedure.addArgument("_EMP_ID", Long.class);
        procedure.addStatement("SELECT E.*, S.* FROM EMPLOYEE E JOIN SALARY S ON E.EMP_ID = S.EMP_ID WHERE E.EMP_ID = _EMP_ID");
        return procedure;
    }

    private static StoredProcedureDefinition buildSQLAnywhereSelectWithOutputAndResultSetProcedure() {
        StoredProcedureDefinition procedure = new StoredProcedureDefinition();
        procedure.setName("Select_Output_and_ResultSet");
        procedure.addArgument("ARG1", Long.class);
        procedure.addOutputArgument("VERSION", Long.class);
        procedure.addStatement("SET VERSION = 23");
        procedure.addStatement("SELECT E.*, S.* FROM EMPLOYEE E JOIN SALARY S ON E.EMP_ID = S.EMP_ID WHERE E.F_NAME = 'Bob'");
        return procedure;
    }

    private static StoredProcedureDefinition buildSQLAnywhereWithoutParametersProcedure() {
        StoredProcedureDefinition procedure = new StoredProcedureDefinition();
        procedure.setName("Rise_All_Salaries");
        procedure.addStatement("UPDATE SALARY SET SALARY = SALARY * 1.1");
        return procedure;
    }

    private static StoredProcedureDefinition buildSQLAnywhereUpdateProcedure() {
        StoredProcedureDefinition procedure = new StoredProcedureDefinition();
        procedure.setName("Update_Employee");
        procedure.addArgument("_EMP_ID", Long.class);
        procedure.addArgument("_SALARY", Integer.class);
        procedure.addArgument("_END_DATE", Date.class);
        procedure.addArgument("_MANAGER_ID", Long.class);
        procedure.addArgument("_START_DATE", Date.class);
        procedure.addArgument("_F_NAME", String.class, 40);
        procedure.addArgument("_L_NAME", String.class, 40);
        procedure.addArgument("_GENDER", String.class, 1);
        procedure.addArgument("_ADDR_ID", Long.class);
        procedure.addArgument("_VERSION", Long.class);
        procedure.addArgument("_START_TIME", Time.class);
        procedure.addArgument("_END_TIME", Time.class);
        procedure.addStatement("UPDATE SALARY SET SALARY = _SALARY WHERE EMP_ID = _EMP_ID");
        procedure.addStatement("UPDATE EMPLOYEE SET END_DATE = _END_DATE, MANAGER_ID = _MANAGER_ID, START_DATE = _START_DATE, F_NAME = _F_NAME, L_NAME = _L_NAME, GENDER = _GENDER, ADDR_ID = _ADDR_ID, VERSION = _VERSION + 1 WHERE EMP_ID = _EMP_ID AND VERSION = _VERSION");
        return procedure;
    }

    public StoredProcedureDefinition buildDB2SelectWithOutputAndResultSetProcedure() {
        StoredProcedureDefinition proc = new StoredProcedureDefinition();
        proc.setName("OUT_RES_TEST");
        proc.addOutputArgument("OUT1", Integer.class);
        proc.addOutputArgument("OUT2", Integer.class);
        proc.addOutputArgument("OUT3", Integer.class);
        proc.addStatement("DECLARE C2 CURSOR WITH RETURN FOR SELECT F_NAME FROM EMPLOYEE");
        proc.addStatement("OPEN C2");
        return proc;
    }

    public StoredProcedureDefinition buildPervasiveDeleteProcedure() {
        StoredProcedureDefinition proc = new StoredProcedureDefinition();
        proc.setName("Delete_Employee");
        proc.addArgument("EMP_ID", Long.class);
        proc.addStatement("Delete FROM SALARY where EMP_ID = :EMP_ID");
        proc.addStatement("Delete FROM EMPLOYEE where EMP_ID = :EMP_ID");
        return proc;
    }

    public StoredProcedureDefinition buildPervasiveInsertProcedure() {
        StoredProcedureDefinition proc = new StoredProcedureDefinition();
        proc.setName("Insert_Employee");
        proc.addArgument("EMP_ID", Long.class);
        proc.addArgument("SALARY", Integer.class);
        proc.addArgument("END_DATE", Date.class);
        proc.addArgument("MANAGER_ID", Long.class);
        proc.addArgument("START_DATE", Date.class);
        proc.addArgument("F_NAME", String.class, 40);
        proc.addArgument("L_NAME", String.class, 40);
        proc.addArgument("GENDER", String.class, 1);
        proc.addArgument("ADDR_ID", Long.class);
        proc.addArgument("START_TIME", Time.class);
        proc.addArgument("END_TIME", Time.class);
        proc.addStatement("Insert INTO EMPLOYEE (EMP_ID, END_DATE, MANAGER_ID, START_DATE, F_NAME, L_NAME, GENDER, ADDR_ID, START_TIME, END_TIME) VALUES (:EMP_ID, :END_DATE, :MANAGER_ID, :START_DATE, :F_NAME, :L_NAME, :GENDER, :ADDR_ID, :START_TIME, :END_TIME)");
        proc.addStatement("Insert INTO SALARY (SALARY, EMP_ID) VALUES (:SALARY, :EMP_ID)");
        return proc;
    }

    public StoredProcedureDefinition buildPervasiveReadAllProcedure() {
        PervasiveStoredProcedureDefinition proc = new PervasiveStoredProcedureDefinition();
        proc.setReturnString(" RETURNS (EMP_ID BIGINT, F_NAME CHAR(40), L_NAME CHAR(40), START_DATE DATE, END_DATE DATE, START_TIME TIME, END_TIME TIME, GENDER CHAR(1), ADDR_ID BIGINT, MANAGER_ID BIGINT, VERSION BIGINT, EMP_ID BIGINT, SALARY INTEGER )");
        proc.setName("Read_All_Employees");
        proc.addStatement("Select E.*, S.* from EMPLOYEE E, SALARY S WHERE E.EMP_ID = S.EMP_ID");
        return proc;
    }

    public StoredProcedureDefinition buildPervasiveReadObjectProcedure() {
        PervasiveStoredProcedureDefinition proc = new PervasiveStoredProcedureDefinition();
        proc.setReturnString(" RETURNS (EMP_ID BIGINT, F_NAME CHAR(40), L_NAME CHAR(40), START_DATE DATE, END_DATE DATE, START_TIME TIME, END_TIME TIME, GENDER CHAR(1), ADDR_ID BIGINT, MANAGER_ID BIGINT, VERSION BIGINT, EMP_ID BIGINT, SALARY INTEGER )");
        proc.setName("Read_Employee");
        proc.addArgument("EMP_ID", Long.class);
        proc.addStatement("Select E.*, S.* from EMPLOYEE E, SALARY S where E.EMP_ID = S.EMP_ID AND E.EMP_ID = :EMP_ID");
        return proc;
    }

    public StoredProcedureDefinition buildPervasiveStoredProcedureInOutPut() {
        StoredProcedureDefinition proc = new StoredProcedureDefinition();
        proc.setName("StoredProcedure_InOutput");
        proc.addInOutputArgument("EMP_ID", Long.class);
        proc.addInOutputArgument("F_NAME", String.class);
        proc.addStatement("SET :EMP_ID = :EMP_ID");
        proc.addStatement("SET :F_NAME = :F_NAME");
        return proc;
    }

    public StoredProcedureDefinition buildPervasiveSelectWithOutputAndResultSetProcedure() {
        PervasiveStoredProcedureDefinition proc = new PervasiveStoredProcedureDefinition();
        proc.setReturnString(" RETURNS (EMP_ID BIGINT, F_NAME CHAR(40), L_NAME CHAR(40), START_DATE DATE, END_DATE DATE, START_TIME TIME, END_TIME TIME, GENDER CHAR(1), ADDR_ID BIGINT, MANAGER_ID BIGINT, VERSION BIGINT, EMP_ID BIGINT, SALARY INTEGER )");
        proc.setName("Select_Output_and_ResultSet");
        proc.addArgument("ARG1", Long.class);
        proc.addOutputArgument("VERSION", Long.class);
        proc.addStatement("SET :VERSION = 23");
        proc.addStatement("Select E.*, S.* from EMPLOYEE E, SALARY S where E.EMP_ID = S.EMP_ID AND E.F_NAME = 'Bob'");
        return proc;
    }

    public StoredProcedureDefinition buildPervasiveSelectWithOutputProcedure() {
        StoredProcedureDefinition proc = new StoredProcedureDefinition();
        proc.setName("Select_Employee_using_Output");
        proc.addArgument("ARG1", Long.class);
        proc.addOutputArgument("VERSION", Long.class);
        proc.addStatement("SET :VERSION = 23");
        return proc;
    }

    public StoredProcedureDefinition buildPervasiveUpdateProcedure() {
        StoredProcedureDefinition proc = new StoredProcedureDefinition();
        proc.setName("Update_Employee");
        proc.addArgument("EMP_ID", Long.class);
        proc.addArgument("SALARY", Integer.class);
        proc.addArgument("END_DATE", Date.class);
        proc.addArgument("MANAGER_ID", Long.class);
        proc.addArgument("START_DATE", Date.class);
        proc.addArgument("F_NAME", String.class, 40);
        proc.addArgument("L_NAME", String.class, 40);
        proc.addArgument("GENDER", String.class, 1);
        proc.addArgument("ADDR_ID", Long.class);
        proc.addArgument("START_TIME", Time.class);
        proc.addArgument("END_TIME", Time.class);
        proc.addStatement("Update SALARY set SALARY = :SALARY WHERE (EMP_ID = :EMP_ID)");
        proc.addStatement("Update EMPLOYEE set END_DATE = :END_DATE, MANAGER_ID = :MANAGER_ID, START_DATE = :START_DATE, F_NAME = :F_NAME, L_NAME = :L_NAME, GENDER = :GENDER, ADDR_ID = :ADDR_ID  WHERE (EMP_ID = :EMP_ID)");
        return proc;
    }

    @Override
    public void createTables(DatabaseSession session) {
        super.createTables(session);
        DatabasePlatform platform = session.getLogin().getPlatform();
        SchemaManager schema = new SchemaManager(session);
        if (platform.isSQLServer()) {
            schema.replaceObject((DatabaseObjectDefinition)this.buildSQLServerDeleteProcedure());
            schema.replaceObject((DatabaseObjectDefinition)this.buildSQLServerReadAllProcedure());
            schema.replaceObject((DatabaseObjectDefinition)this.buildSQLServerReadObjectProcedure());
            schema.replaceObject((DatabaseObjectDefinition)this.buildSQLServerInsertProcedure());
            schema.replaceObject((DatabaseObjectDefinition)this.buildSQLServerUpdateProcedure());
            schema.replaceObject((DatabaseObjectDefinition)this.buildSQLServerSelectWithOutputProcedure());
            schema.replaceObject((DatabaseObjectDefinition)this.buildSQLServerSelectWithOutputAndResultSetProcedure());
        }
        if (platform.isSybase()) {
            session.getLogin().handleTransactionsManuallyForSybaseJConnect();
            schema.replaceObject((DatabaseObjectDefinition)this.buildSybaseDeleteProcedure());
            schema.replaceObject((DatabaseObjectDefinition)this.buildSybaseReadAllProcedure());
            schema.replaceObject((DatabaseObjectDefinition)this.buildSybaseReadObjectProcedure());
            schema.replaceObject((DatabaseObjectDefinition)this.buildSybaseInsertProcedure());
            schema.replaceObject((DatabaseObjectDefinition)this.buildSybaseUpdateProcedure());
            schema.replaceObject((DatabaseObjectDefinition)this.buildSybaseSelectWithOutputAndResultSetProcedure());
            schema.replaceObject((DatabaseObjectDefinition)this.buildSybaseWithoutParametersProcedure());
        }
        if (platform.isMySQL()) {
            schema.replaceObject((DatabaseObjectDefinition)this.buildMySQL2ResultSetProcedure());
        }
        if (platform.isSQLAnywhere()) {
            schema.replaceObject((DatabaseObjectDefinition)EmployeeCustomSQLSystem.buildSQLAnywhereDeleteProcedure());
            schema.replaceObject((DatabaseObjectDefinition)EmployeeCustomSQLSystem.buildSQLAnywhereReadAllProcedure());
            schema.replaceObject((DatabaseObjectDefinition)EmployeeCustomSQLSystem.buildSQLAnywhereReadObjectProcedure());
            schema.replaceObject((DatabaseObjectDefinition)EmployeeCustomSQLSystem.buildSQLAnywhereInsertProcedure());
            schema.replaceObject((DatabaseObjectDefinition)EmployeeCustomSQLSystem.buildSQLAnywhereUpdateProcedure());
            schema.replaceObject((DatabaseObjectDefinition)EmployeeCustomSQLSystem.buildSQLAnywhereSelectWithOutputAndResultSetProcedure());
            schema.replaceObject((DatabaseObjectDefinition)EmployeeCustomSQLSystem.buildSQLAnywhereWithoutParametersProcedure());
        }
        if (platform.isOracle()) {
            try {
                session.executeQuery((DatabaseQuery)new DataModifyQuery("DROP TYPE SF_LOOKUP_TBL FORCE"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                session.executeQuery((DatabaseQuery)new DataModifyQuery("DROP TYPE SF_LOOKUP_RECORD FORCE"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            schema.replaceObject((DatabaseObjectDefinition)this.buildOracleStoredProcedureInOutPut());
            schema.replaceObject((DatabaseObjectDefinition)this.buildOracleStoredProcedureInOutOutIn());
            schema.replaceObject((DatabaseObjectDefinition)this.buildOracleStoredProcedureTimestamp());
            schema.replaceObject((DatabaseObjectDefinition)this.buildOracleStoredProcedureARRAY());
            schema.replaceObject((DatabaseObjectDefinition)EmployeeCustomSQLSystem.buildVARRAYTypeDefinition());
            schema.replaceObject((DatabaseObjectDefinition)this.buildOracleStoredFunctionInOutOutIn());
            schema.replaceObject((DatabaseObjectDefinition)this.buildOraclePackage());
            schema.replaceObject((DatabaseObjectDefinition)this.buildOracleDeleteProcedure());
            schema.replaceObject((DatabaseObjectDefinition)this.buildOracleReadAllProcedure());
            schema.replaceObject((DatabaseObjectDefinition)this.buildOracleReadObjectProcedure());
            schema.replaceObject((DatabaseObjectDefinition)this.buildOracleInsertProcedure());
            schema.replaceObject((DatabaseObjectDefinition)this.buildOracleUpdateProcedure());
            schema.replaceObject((DatabaseObjectDefinition)this.buildOracle2OutCursorsProcedure());
            schema.replaceObject((DatabaseObjectDefinition)this.buildOracleLOOKUPRECORDTYPE());
            schema.replaceObject((DatabaseObjectDefinition)this.buildOracleLOOKUPTABLETYPE());
            schema.replaceObject((DatabaseObjectDefinition)this.buildOraclePackageStoredFunctionResultCursor());
            try {
                session.executeNonSelectingCall((Call)new SQLCall("CREATE OR REPLACE PACKAGE BODY PackageFunction_ResultCursor IS FUNCTION BUSINESS_DATE (P_CODE IN VARCHAR2, P_LOOKUP_TBL IN SF_LOOKUP_TBL) RETURN REF_CURSOR IS L_CURSOR REF_CURSOR; BEGIN OPEN L_CURSOR FOR SELECT SYSDATE FROM DUAL; RETURN L_CURSOR; END BUSINESS_DATE; END PackageFunction_ResultCursor;"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (platform.isDB2()) {
            schema.replaceObject((DatabaseObjectDefinition)this.buildDB2SelectWithOutputAndResultSetProcedure());
        }
        if (platform.isPervasive()) {
            schema.replaceObject((DatabaseObjectDefinition)this.buildPervasiveReadAllProcedure());
            schema.replaceObject((DatabaseObjectDefinition)this.buildPervasiveInsertProcedure());
            schema.replaceObject((DatabaseObjectDefinition)this.buildPervasiveDeleteProcedure());
            schema.replaceObject((DatabaseObjectDefinition)this.buildPervasiveInsertProcedure());
            schema.replaceObject((DatabaseObjectDefinition)this.buildPervasiveReadAllProcedure());
            schema.replaceObject((DatabaseObjectDefinition)this.buildPervasiveReadObjectProcedure());
            schema.replaceObject((DatabaseObjectDefinition)this.buildPervasiveStoredProcedureInOutPut());
            schema.replaceObject((DatabaseObjectDefinition)this.buildPervasiveSelectWithOutputAndResultSetProcedure());
            schema.replaceObject((DatabaseObjectDefinition)this.buildPervasiveSelectWithOutputProcedure());
            schema.replaceObject((DatabaseObjectDefinition)this.buildPervasiveUpdateProcedure());
        }
    }

    protected void setCommonSQL(Session session) {
        ClassDescriptor empDescriptor = session.getDescriptor(Employee.class);
        empDescriptor.getQueryManager().setDoesExistSQLString("select EMP_ID FROM EMPLOYEE WHERE EMP_ID = #EMP_ID");
        OneToOneMapping managerMapping = (OneToOneMapping)empDescriptor.getMappingForAttributeName("manager");
        managerMapping.setSelectionSQLString("select * FROM EMPLOYEE WHERE EMP_ID = #MANAGER_ID");
        OneToOneMapping oneToOne = (OneToOneMapping)empDescriptor.getMappingForAttributeName("address");
        oneToOne.setSelectionSQLString("select * FROM ADDRESS WHERE ADDRESS_ID = #ADDR_ID");
        OneToManyMapping oneToMany = (OneToManyMapping)empDescriptor.getMappingForAttributeName("managedEmployees");
        oneToMany.setSelectionSQLString("select E.*, S.* FROM EMPLOYEE E, SALARY S WHERE E.EMP_ID = S.EMP_ID AND E.MANAGER_ID = #EMP_ID");
        DirectCollectionMapping directCollection = (DirectCollectionMapping)empDescriptor.getMappingForAttributeName("responsibilitiesList");
        directCollection.setSelectionSQLString("select DESCRIP FROM RESPONS WHERE EMP_ID = #EMP_ID");
        directCollection.setDeleteAllSQLString("delete FROM RESPONS WHERE EMP_ID = #EMP_ID");
        directCollection.setInsertSQLString("insert into RESPONS (EMP_ID, DESCRIP) values (#EMP_ID, #DESCRIP)");
        ManyToManyMapping manyToMany = (ManyToManyMapping)empDescriptor.getMappingForAttributeName("projects");
        manyToMany.setDeleteAllSQLString("delete FROM PROJ_EMP WHERE EMP_ID = #EMP_ID");
        manyToMany.setDeleteSQLString("delete FROM PROJ_EMP WHERE EMP_ID = #EMP_ID AND PROJ_ID = #PROJ_ID");
        manyToMany.setInsertSQLString("insert into PROJ_EMP (EMP_ID, PROJ_ID) values (#EMP_ID, #PROJ_ID)");
        ClassDescriptor projectDescriptor = session.getDescriptor(Project.class);
        projectDescriptor.getQueryManager().setDoesExistSQLString("select PROJ_ID FROM PROJECT WHERE PROJ_ID = #PROJ_ID");
        DeleteObjectQuery deleteQuery = new DeleteObjectQuery();
        deleteQuery.addCall((Call)new SQLCall("delete FROM PROJECT WHERE PROJ_ID = #PROJ_ID"));
        deleteQuery.addCall((Call)new SQLCall("delete FROM LPROJECT WHERE PROJ_ID = #PROJ_ID"));
        projectDescriptor.getQueryManager().setDeleteQuery(deleteQuery);
        projectDescriptor.setOptimisticLockingPolicy(null);
        ClassDescriptor smallProjectDescriptor = session.getDescriptor(SmallProject.class);
        smallProjectDescriptor.setOptimisticLockingPolicy(null);
        ClassDescriptor largeProjectDescriptor = session.getDescriptor(LargeProject.class);
        largeProjectDescriptor.setOptimisticLockingPolicy(null);
    }

    protected void setCustomSQL(Session session) {
        this.setCommonSQL(session);
        if (session.getLogin().getPlatform().isSybase()) {
            this.setSybaseSQL(session);
        } else if (session.getLogin().getPlatform().isSQLAnywhere()) {
            EmployeeCustomSQLSystem.setSQLAnywhereSQL(session);
        } else if (session.getLogin().getPlatform().isSQLServer()) {
            this.setSQLServerSQL(session);
        } else if (session.getLogin().isAnyOracleJDBCDriver()) {
            this.setOracleSQL(session);
        } else if (session.getLogin().getPlatform().isPervasive()) {
            this.setPervasiveSQL(session);
        } else {
            ClassDescriptor empDescriptor = session.getDescriptor((Object)new Employee());
            empDescriptor.getQueryManager().setReadObjectSQLString("select E.*, S.* FROM EMPLOYEE E, SALARY S WHERE E.EMP_ID = S.EMP_ID AND E.EMP_ID = #EMP_ID");
            empDescriptor.getQueryManager().setReadAllSQLString("select E.*, S.* FROM EMPLOYEE E, SALARY S WHERE E.EMP_ID = S.EMP_ID");
            ManyToManyMapping manyToMany = (ManyToManyMapping)empDescriptor.getMappingForAttributeName("projects");
            ReadAllQuery readQuery = new ReadAllQuery();
            readQuery.addCall((Call)new SQLCall("select P.*, L.* FROM LPROJECT L, PROJECT P, PROJ_EMP PE WHERE ((P.PROJ_ID = L.PROJ_ID) AND (PE.EMP_ID = #EMP_ID) AND (P.PROJ_ID = PE.PROJ_ID))"));
            readQuery.addCall((Call)new SQLCall("select P.* FROM PROJECT P, PROJ_EMP PE WHERE (PE.EMP_ID = #EMP_ID) AND (P.PROJ_ID = PE.PROJ_ID) AND (P.PROJ_TYPE = 'S')"));
            manyToMany.setCustomSelectionQuery((ReadQuery)readQuery);
            UpdateObjectQuery updateQuery = new UpdateObjectQuery();
            updateQuery.addCall((Call)new SQLCall("update EMPLOYEE SET END_DATE = #END_DATE, MANAGER_ID = #MANAGER_ID, START_DATE = #START_DATE, F_NAME = #F_NAME, L_NAME = #L_NAME, GENDER = #GENDER, ADDR_ID = #ADDR_ID, VERSION = ##VERSION WHERE ((EMP_ID = #EMP_ID) AND (VERSION = #VERSION))"));
            updateQuery.addCall((Call)new SQLCall("update SALARY SET SALARY = #SALARY WHERE (EMP_ID = #EMP_ID)"));
            empDescriptor.getQueryManager().setUpdateQuery(updateQuery);
            InsertObjectQuery insertQuery = new InsertObjectQuery();
            insertQuery.addCall((Call)new SQLCall("insert INTO EMPLOYEE (END_DATE, EMP_ID, MANAGER_ID, START_DATE, F_NAME, L_NAME, GENDER, ADDR_ID, VERSION, START_TIME, END_TIME) VALUES (#END_DATE, #EMP_ID, #MANAGER_ID, #START_DATE, #F_NAME, #L_NAME, #GENDER, #ADDR_ID, #VERSION, #START_TIME, #END_TIME)"));
            insertQuery.addCall((Call)new SQLCall("insert INTO SALARY (SALARY, EMP_ID) VALUES (#SALARY, #EMP_ID)"));
            empDescriptor.getQueryManager().setInsertQuery(insertQuery);
            DeleteObjectQuery deleteQuery = new DeleteObjectQuery();
            deleteQuery.addCall((Call)new SQLCall("delete FROM EMPLOYEE WHERE EMP_ID = #EMP_ID"));
            deleteQuery.addCall((Call)new SQLCall("delete FROM SALARY WHERE EMP_ID = #EMP_ID"));
            empDescriptor.getQueryManager().setDeleteQuery(deleteQuery);
        }
    }

    protected void setOracleSQL(Session session) {
        ClassDescriptor empDescriptor = session.getDescriptor((Object)new Employee());
        empDescriptor.setOptimisticLockingPolicy(null);
        ReadObjectQuery readQuery = new ReadObjectQuery();
        StoredProcedureCall call = new StoredProcedureCall();
        call.setProcedureName("Read_Employee");
        call.addNamedArgument("P_EMP_ID", "EMP_ID");
        call.useNamedCursorOutputAsResultSet("RESULT_CURSOR");
        readQuery.setCall((Call)call);
        empDescriptor.getQueryManager().setReadObjectQuery(readQuery);
        ReadAllQuery readAllQuery = new ReadAllQuery();
        call = new StoredProcedureCall();
        call.setProcedureName("Read_All_Employees");
        call.useNamedCursorOutputAsResultSet("RESULT_CURSOR");
        readAllQuery.setCall((Call)call);
        empDescriptor.getQueryManager().setReadAllQuery(readAllQuery);
        DeleteObjectQuery deleteQuery = new DeleteObjectQuery();
        call = new StoredProcedureCall();
        call.setProcedureName("Delete_Employee");
        call.addNamedArgument("P_EMP_ID", "EMP_ID");
        deleteQuery.setCall((Call)call);
        empDescriptor.getQueryManager().setDeleteQuery(deleteQuery);
        InsertObjectQuery insertQuery = new InsertObjectQuery();
        call = new StoredProcedureCall();
        call.setProcedureName("Insert_Employee");
        call.addNamedArgument("P_EMP_ID", "EMP_ID");
        call.addNamedArgument("P_SALARY", "SALARY");
        call.addNamedArgument("P_END_DATE", "END_DATE");
        call.addNamedArgument("P_MANAGER_ID", "MANAGER_ID");
        call.addNamedArgument("P_START_DATE", "START_DATE");
        call.addNamedArgument("P_F_NAME", "F_NAME");
        call.addNamedArgument("P_L_NAME", "L_NAME");
        call.addNamedArgument("P_GENDER", "GENDER");
        call.addNamedArgument("P_ADDR_ID", "ADDR_ID");
        call.addNamedArgument("P_VERSION", "VERSION");
        call.addNamedArgument("P_START_TIME", "START_TIME");
        call.addNamedArgument("P_END_TIME", "END_TIME");
        insertQuery.setCall((Call)call);
        empDescriptor.getQueryManager().setInsertQuery(insertQuery);
        UpdateObjectQuery updateQuery = new UpdateObjectQuery();
        call = new StoredProcedureCall();
        call.setUsesBinding(true);
        call.setShouldCacheStatement(true);
        call.setProcedureName("Update_Employee");
        call.addNamedArgument("P_EMP_ID", "EMP_ID");
        call.addNamedArgument("P_SALARY", "SALARY");
        call.addNamedArgument("P_END_DATE", "END_DATE");
        call.addNamedArgument("P_MANAGER_ID", "MANAGER_ID");
        call.addNamedArgument("P_START_DATE", "START_DATE");
        call.addNamedArgument("P_F_NAME", "F_NAME");
        call.addNamedArgument("P_L_NAME", "L_NAME");
        call.addNamedArgument("P_GENDER", "GENDER");
        call.addNamedArgument("P_ADDR_ID", "ADDR_ID");
        call.addNamedArgument("P_START_TIME", "START_TIME");
        call.addNamedArgument("P_END_TIME", "END_TIME");
        call.addNamedOutputArgument("O_ERROR_CODE", "O_ERROR_CODE", Long.class);
        updateQuery.setCall((Call)call);
        empDescriptor.getQueryManager().setUpdateQuery(updateQuery);
        ManyToManyMapping manyToMany = (ManyToManyMapping)empDescriptor.getMappingForAttributeName("projects");
        manyToMany.setSelectionSQLString("select P.*, L.* FROM LPROJECT L, PROJECT P, PROJ_EMP PE WHERE ((P.PROJ_ID = L.PROJ_ID (+)) AND (PE.EMP_ID = #EMP_ID) AND (P.PROJ_ID = PE.PROJ_ID))");
    }

    protected void setPervasiveSQL(Session session) {
        ClassDescriptor empDescriptor = session.getDescriptor((Object)new Employee());
        empDescriptor.setOptimisticLockingPolicy(null);
        session.getLogin().getPlatform().setUsesNativeSQL(true);
        ReadObjectQuery readQuery = new ReadObjectQuery();
        StoredProcedureCall call = new StoredProcedureCall();
        call.setProcedureName("Read_Employee");
        call.addNamedArgument("EMP_ID");
        call.setReturnsResultSet(true);
        readQuery.setCall((Call)call);
        empDescriptor.getQueryManager().setReadObjectQuery(readQuery);
        ReadAllQuery readAllQuery = new ReadAllQuery();
        call = new StoredProcedureCall();
        call.setProcedureName("Read_All_Employees");
        call.setReturnsResultSet(true);
        readAllQuery.setCall((Call)call);
        empDescriptor.getQueryManager().setReadAllQuery(readAllQuery);
        DeleteObjectQuery deleteQuery = new DeleteObjectQuery();
        call = new StoredProcedureCall();
        call.setProcedureName("Delete_Employee");
        call.addNamedArgument("EMP_ID");
        deleteQuery.setCall((Call)call);
        empDescriptor.getQueryManager().setDeleteQuery(deleteQuery);
        InsertObjectQuery insertQuery = new InsertObjectQuery();
        call = new StoredProcedureCall();
        call.setProcedureName("Insert_Employee");
        call.setUsesBinding(true);
        call.setShouldCacheStatement(true);
        call.addNamedArgument("EMP_ID");
        call.addNamedArgument("SALARY");
        call.addNamedArgument("END_DATE");
        call.addNamedArgument("MANAGER_ID");
        call.addNamedArgument("START_DATE");
        call.addNamedArgument("F_NAME");
        call.addNamedArgument("L_NAME");
        call.addNamedArgument("GENDER");
        call.addNamedArgument("ADDR_ID");
        call.addNamedArgument("START_TIME");
        call.addNamedArgument("END_TIME");
        insertQuery.setCall((Call)call);
        empDescriptor.getQueryManager().setInsertQuery(insertQuery);
        UpdateObjectQuery updateQuery = new UpdateObjectQuery();
        call = new StoredProcedureCall();
        call.setProcedureName("Update_Employee");
        call.addNamedArgument("EMP_ID");
        call.addNamedArgument("SALARY");
        call.addNamedArgument("END_DATE");
        call.addNamedArgument("MANAGER_ID");
        call.addNamedArgument("START_DATE");
        call.addNamedArgument("F_NAME");
        call.addNamedArgument("L_NAME");
        call.addNamedArgument("GENDER");
        call.addNamedArgument("ADDR_ID");
        call.addNamedArgument("START_TIME");
        call.addNamedArgument("END_TIME");
        updateQuery.setCall((Call)call);
        empDescriptor.getQueryManager().setUpdateQuery(updateQuery);
        ManyToManyMapping manyToMany = (ManyToManyMapping)empDescriptor.getMappingForAttributeName("projects");
        manyToMany.setSelectionSQLString("select P.*, L.* FROM PROJ_EMP PE, PROJECT P LEFT OUTER JOIN LPROJECT L ON (L.PROJ_ID = P.PROJ_ID) WHERE ((PE.EMP_ID = #EMP_ID) AND (P.PROJ_ID = PE.PROJ_ID))");
    }

    protected void setSQLServerSQL(Session session) {
        ClassDescriptor empDescriptor = session.getDescriptor((Object)new Employee());
        empDescriptor.setOptimisticLockingPolicy(null);
        session.getLogin().getPlatform().setUsesNativeSQL(true);
        ReadObjectQuery readQuery = new ReadObjectQuery();
        StoredProcedureCall call = new StoredProcedureCall();
        call.setProcedureName("Read_Employee");
        call.addNamedArgument("EMP_ID");
        call.setReturnsResultSet(true);
        readQuery.setCall((Call)call);
        empDescriptor.getQueryManager().setReadObjectQuery(readQuery);
        ReadAllQuery readAllQuery = new ReadAllQuery();
        call = new StoredProcedureCall();
        call.setProcedureName("Read_All_Employees");
        call.setReturnsResultSet(true);
        readAllQuery.setCall((Call)call);
        empDescriptor.getQueryManager().setReadAllQuery(readAllQuery);
        DeleteObjectQuery deleteQuery = new DeleteObjectQuery();
        call = new StoredProcedureCall();
        call.setProcedureName("Delete_Employee");
        call.addNamedArgument("EMP_ID");
        deleteQuery.setCall((Call)call);
        empDescriptor.getQueryManager().setDeleteQuery(deleteQuery);
        InsertObjectQuery insertQuery = new InsertObjectQuery();
        call = new StoredProcedureCall();
        call.setProcedureName("Insert_Employee");
        call.setUsesBinding(true);
        call.setShouldCacheStatement(true);
        call.addNamedArgument("EMP_ID");
        call.addNamedArgument("SALARY");
        call.addNamedArgument("END_DATE");
        call.addNamedArgument("MANAGER_ID");
        call.addNamedArgument("START_DATE");
        call.addNamedArgument("F_NAME");
        call.addNamedArgument("L_NAME");
        call.addNamedArgument("GENDER");
        call.addNamedArgument("ADDR_ID");
        call.addNamedOutputArgument("VERSION", "EMPLOYEE.VERSION", BigDecimal.class);
        call.addNamedArgument("START_TIME");
        call.addNamedArgument("END_TIME");
        insertQuery.setCall((Call)call);
        empDescriptor.getQueryManager().setInsertQuery(insertQuery);
        UpdateObjectQuery updateQuery = new UpdateObjectQuery();
        call = new StoredProcedureCall();
        call.setProcedureName("Update_Employee");
        call.addNamedArgument("EMP_ID");
        call.addNamedArgument("SALARY");
        call.addNamedArgument("END_DATE");
        call.addNamedArgument("MANAGER_ID");
        call.addNamedArgument("START_DATE");
        call.addNamedArgument("F_NAME");
        call.addNamedArgument("L_NAME");
        call.addNamedArgument("GENDER");
        call.addNamedArgument("ADDR_ID");
        call.addNamedArgument("START_TIME");
        call.addNamedArgument("END_TIME");
        updateQuery.setCall((Call)call);
        empDescriptor.getQueryManager().setUpdateQuery(updateQuery);
        ManyToManyMapping manyToMany = (ManyToManyMapping)empDescriptor.getMappingForAttributeName("projects");
        manyToMany.setSelectionSQLString("select P.*, L.* FROM PROJ_EMP PE, PROJECT P LEFT OUTER JOIN LPROJECT L ON (L.PROJ_ID = P.PROJ_ID) WHERE ((PE.EMP_ID = #EMP_ID) AND (P.PROJ_ID = PE.PROJ_ID))");
    }

    protected void setSybaseSQL(Session session) {
        ClassDescriptor empDescriptor = session.getDescriptor((Object)new Employee());
        ReadObjectQuery readQuery = new ReadObjectQuery();
        StoredProcedureCall call = new StoredProcedureCall();
        call.setProcedureName("Read_Employee");
        call.addNamedArgument("EMP_ID");
        call.setReturnsResultSet(true);
        readQuery.setCall((Call)call);
        empDescriptor.getQueryManager().setReadObjectQuery(readQuery);
        ReadAllQuery readAllQuery = new ReadAllQuery();
        call = new StoredProcedureCall();
        call.setProcedureName("Read_All_Employees");
        call.setReturnsResultSet(true);
        readAllQuery.setCall((Call)call);
        empDescriptor.getQueryManager().setReadAllQuery(readAllQuery);
        DeleteObjectQuery deleteQuery = new DeleteObjectQuery();
        call = new StoredProcedureCall();
        call.setProcedureName("Delete_Employee");
        call.addNamedArgument("EMP_ID");
        deleteQuery.setCall((Call)call);
        empDescriptor.getQueryManager().setDeleteQuery(deleteQuery);
        InsertObjectQuery insertQuery = new InsertObjectQuery();
        call = new StoredProcedureCall();
        call.setProcedureName("Insert_Employee");
        call.setUsesBinding(true);
        call.setShouldCacheStatement(true);
        call.addNamedArgument("EMP_ID");
        call.addNamedArgument("SALARY");
        call.addNamedArgument("END_DATE");
        call.addNamedArgument("MANAGER_ID");
        call.addNamedArgument("START_DATE");
        call.addNamedArgument("F_NAME");
        call.addNamedArgument("L_NAME");
        call.addNamedArgument("GENDER");
        call.addNamedArgument("ADDR_ID");
        call.addNamedArgument("VERSION");
        call.addNamedArgument("START_TIME");
        call.addNamedArgument("END_TIME");
        call.addNamedInOutputArgumentValue("OUT_VERSION", (Object)new Long(0L), "EMPLOYEE.VERSION", Long.class);
        insertQuery.setCall((Call)call);
        empDescriptor.getQueryManager().setInsertQuery(insertQuery);
        UpdateObjectQuery updateQuery = new UpdateObjectQuery();
        call = new StoredProcedureCall();
        call.setProcedureName("Update_Employee");
        call.addNamedArgument("EMP_ID");
        call.addNamedArgument("SALARY");
        call.addNamedArgument("END_DATE");
        call.addNamedArgument("MANAGER_ID");
        call.addNamedArgument("START_DATE");
        call.addNamedArgument("F_NAME");
        call.addNamedArgument("L_NAME");
        call.addNamedArgument("GENDER");
        call.addNamedArgument("ADDR_ID");
        call.addNamedArgument("VERSION");
        call.addNamedArgument("START_TIME");
        call.addNamedArgument("END_TIME");
        updateQuery.setCall((Call)call);
        empDescriptor.getQueryManager().setUpdateQuery(updateQuery);
        ManyToManyMapping manyToMany = (ManyToManyMapping)empDescriptor.getMappingForAttributeName("projects");
        manyToMany.setSelectionSQLString("select P.*, L.* FROM PROJ_EMP PE, PROJECT P LEFT OUTER JOIN LPROJECT L ON (L.PROJ_ID = P.PROJ_ID) WHERE ((PE.EMP_ID = #EMP_ID) AND (P.PROJ_ID = PE.PROJ_ID))");
    }

    private static void setSQLAnywhereSQL(Session session) {
        ClassDescriptor employeeDescriptor = session.getDescriptor((Object)new Employee());
        StoredProcedureCall readEmployeeCall = new StoredProcedureCall();
        readEmployeeCall.setProcedureName("Read_Employee");
        readEmployeeCall.addNamedArgument("_EMP_ID", "EMP_ID");
        readEmployeeCall.setReturnsResultSet(true);
        employeeDescriptor.getQueryManager().setReadObjectQuery(new ReadObjectQuery((Call)readEmployeeCall));
        StoredProcedureCall readAllEmployeesCall = new StoredProcedureCall();
        readAllEmployeesCall.setProcedureName("Read_All_Employees");
        readAllEmployeesCall.setReturnsResultSet(true);
        employeeDescriptor.getQueryManager().setReadAllQuery(new ReadAllQuery((Call)readAllEmployeesCall));
        StoredProcedureCall deleteEmployeeCall = new StoredProcedureCall();
        deleteEmployeeCall.setProcedureName("Delete_Employee");
        deleteEmployeeCall.addNamedArgument("_EMP_ID", "EMP_ID");
        employeeDescriptor.getQueryManager().setDeleteQuery(new DeleteObjectQuery((Call)deleteEmployeeCall));
        StoredProcedureCall insertEmployeeCall = new StoredProcedureCall();
        insertEmployeeCall.setProcedureName("Insert_Employee");
        insertEmployeeCall.setUsesBinding(true);
        insertEmployeeCall.setShouldCacheStatement(true);
        insertEmployeeCall.addNamedArgument("_EMP_ID", "EMP_ID");
        insertEmployeeCall.addNamedArgument("_SALARY", "SALARY");
        insertEmployeeCall.addNamedArgument("_END_DATE", "END_DATE");
        insertEmployeeCall.addNamedArgument("_MANAGER_ID", "MANAGER_ID");
        insertEmployeeCall.addNamedArgument("_START_DATE", "START_DATE");
        insertEmployeeCall.addNamedArgument("_F_NAME", "F_NAME");
        insertEmployeeCall.addNamedArgument("_L_NAME", "L_NAME");
        insertEmployeeCall.addNamedArgument("_GENDER", "GENDER");
        insertEmployeeCall.addNamedArgument("_ADDR_ID", "ADDR_ID");
        insertEmployeeCall.addNamedArgument("_START_TIME", "START_TIME");
        insertEmployeeCall.addNamedArgument("_END_TIME", "END_TIME");
        insertEmployeeCall.addNamedArgument("_VERSION", "VERSION");
        insertEmployeeCall.addNamedInOutputArgumentValue("_OUT_VERSION", (Object)new Long(0L), "EMPLOYEE.VERSION", Long.class);
        employeeDescriptor.getQueryManager().setInsertQuery(new InsertObjectQuery((Call)insertEmployeeCall));
        StoredProcedureCall updateEmployeeCall = new StoredProcedureCall();
        updateEmployeeCall.setProcedureName("Update_Employee");
        updateEmployeeCall.addNamedArgument("_EMP_ID", "EMP_ID");
        updateEmployeeCall.addNamedArgument("_SALARY", "SALARY");
        updateEmployeeCall.addNamedArgument("_END_DATE", "END_DATE");
        updateEmployeeCall.addNamedArgument("_MANAGER_ID", "MANAGER_ID");
        updateEmployeeCall.addNamedArgument("_START_DATE", "START_DATE");
        updateEmployeeCall.addNamedArgument("_F_NAME", "F_NAME");
        updateEmployeeCall.addNamedArgument("_L_NAME", "L_NAME");
        updateEmployeeCall.addNamedArgument("_GENDER", "GENDER");
        updateEmployeeCall.addNamedArgument("_ADDR_ID", "ADDR_ID");
        updateEmployeeCall.addNamedArgument("_VERSION", "VERSION");
        updateEmployeeCall.addNamedArgument("_START_TIME", "START_TIME");
        updateEmployeeCall.addNamedArgument("_END_TIME", "END_TIME");
        employeeDescriptor.getQueryManager().setUpdateQuery(new UpdateObjectQuery((Call)updateEmployeeCall));
        ManyToManyMapping manyToMany = (ManyToManyMapping)employeeDescriptor.getMappingForAttributeName("projects");
        manyToMany.setSelectionSQLString("SELECT P.*, L.* FROM PROJ_EMP PE JOIN PROJECT P ON PE.PROJ_ID = P.PROJ_ID LEFT OUTER JOIN LPROJECT L ON P.PROJ_ID = L.PROJ_ID WHERE PE.EMP_ID = #EMP_ID");
    }

    class PervasiveStoredProcedureDefinition
    extends StoredProcedureDefinition {
        protected String returnString = "";

        public void setReturnString(String theString) {
            this.returnString = theString;
        }

        protected void printReturn(Writer writer, AbstractSession session) throws ValidationException {
            try {
                writer.write(this.returnString);
            }
            catch (IOException ioException) {
                throw ValidationException.fileError((IOException)ioException);
            }
        }
    }
}

