/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.dynamic.dynamicclassloader;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import org.eclipse.persistence.dynamic.DynamicClassLoader;
import org.eclipse.persistence.dynamic.DynamicClassWriter;
import org.eclipse.persistence.dynamic.EclipseLinkClassWriter;
import org.eclipse.persistence.exceptions.DynamicException;
import org.eclipse.persistence.internal.dynamic.DynamicEntityImpl;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.helper.SerializationHelper;
import org.eclipse.persistence.testing.tests.dynamic.dynamicclassloader.Compatible;
import org.eclipse.persistence.testing.tests.dynamic.dynamicclassloader.Incompatible;
import org.junit.Assert;
import org.junit.Test;

public class DynamicClassLoaderTestSuite {
    public static final String PACKAGE_PREFIX = DynamicClassLoaderTestSuite.class.getPackage().getName();
    static final String INCOMPATIBLE_CLASSNAME = Incompatible.class.getSimpleName();
    static final String COMPATIBLE_CLASSNAME = Compatible.class.getSimpleName();
    static final String MY_CLASSNAME = PACKAGE_PREFIX + ".MyClass";

    @Test
    public void noParentLoader() throws Exception {
        DynamicClassLoader dcl = new DynamicClassLoader(null);
        Assert.assertNull((Object)dcl.getParent());
    }

    @Test
    public void loadCoreClass() throws Exception {
        DynamicClassLoader dcl = new DynamicClassLoader(null);
        Class stringClass = dcl.loadClass("java.lang.String");
        Assert.assertTrue((String)"core class java.lang.String not found", (String.class == stringClass ? 1 : 0) != 0);
    }

    @Test(expected=NoClassDefFoundError.class)
    public void createDynamicClassWithNoParentLoader() {
        DynamicClassLoader dcl = new DynamicClassLoader(null);
        dcl.createDynamicClass(MY_CLASSNAME);
    }

    @Test(expected=IllegalArgumentException.class)
    public void createIncompatibleClass() {
        DynamicClassLoader dcl = new DynamicClassLoader(DynamicClassLoaderTestSuite.class.getClassLoader());
        dcl.createDynamicClass(PACKAGE_PREFIX + "." + INCOMPATIBLE_CLASSNAME);
    }

    @Test
    public void createCompatibleClass() {
        DynamicClassLoader dcl = new DynamicClassLoader(DynamicClassLoaderTestSuite.class.getClassLoader());
        Class dynamicClass = dcl.createDynamicClass(PACKAGE_PREFIX + "." + COMPATIBLE_CLASSNAME);
        Assert.assertNotNull((Object)dynamicClass);
        Assert.assertSame(Compatible.class, (Object)dynamicClass);
    }

    @Test
    public void loadClass_DynamicEntityImpl() throws Exception {
        DynamicClassLoader dcl = new DynamicClassLoader(DynamicClassLoaderTestSuite.class.getClassLoader());
        dcl.addClass(MY_CLASSNAME);
        Class myDynamicClass = dcl.loadClass(MY_CLASSNAME);
        this.checkMyClass(dcl, myDynamicClass);
    }

    protected void checkMyClass(DynamicClassLoader dcl, Class<?> myDynamicClass) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Assert.assertNotNull(myDynamicClass);
        Assert.assertEquals((Object)MY_CLASSNAME, (Object)myDynamicClass.getName());
        Assert.assertSame(DynamicEntityImpl.class, myDynamicClass.getSuperclass());
        Assert.assertSame(myDynamicClass, (Object)dcl.loadClass(MY_CLASSNAME));
        ConversionManager.setDefaultLoader((ClassLoader)dcl);
        ConversionManager.getDefaultManager().setLoader((ClassLoader)dcl);
        Assert.assertSame(myDynamicClass, (Object)ConversionManager.getDefaultManager().convertClassNameToClass(MY_CLASSNAME));
        Assert.assertSame(myDynamicClass, (Object)ConversionManager.getDefaultManager().convertObject((Object)MY_CLASSNAME, Class.class));
        Assert.assertSame(myDynamicClass, ConversionManager.getDefaultLoader().loadClass(MY_CLASSNAME));
        Assert.assertSame(myDynamicClass, (Object)ConversionManager.loadClass((String)MY_CLASSNAME));
        Object newInstance = myDynamicClass.newInstance();
        Assert.assertNotNull((String)"newInstance is null", newInstance);
        Constructor<?>[] constructors = myDynamicClass.getConstructors();
        Assert.assertEquals((long)1L, (long)constructors.length);
        Assert.assertEquals((long)0L, (long)constructors[0].getParameterTypes().length);
    }

    @Test
    public void createDynamicClass_DynamicEntityImpl() throws Exception {
        DynamicClassLoader dcl = new DynamicClassLoader(DynamicClassLoaderTestSuite.class.getClassLoader());
        Class myDynamicClass = dcl.createDynamicClass(MY_CLASSNAME);
        this.checkMyClass(dcl, myDynamicClass);
    }

    @Test
    public void createDynamicClass_Twice() throws Exception {
        DynamicClassLoader dcl = new DynamicClassLoader(DynamicClassLoaderTestSuite.class.getClassLoader());
        Assert.assertNull((Object)dcl.getClassWriter(MY_CLASSNAME));
        Class dynamicClass = dcl.createDynamicClass(MY_CLASSNAME);
        Assert.assertNotNull((Object)dynamicClass);
        Assert.assertEquals((Object)MY_CLASSNAME, (Object)dynamicClass.getName());
        EclipseLinkClassWriter writer = dcl.getClassWriter(MY_CLASSNAME);
        Assert.assertNotNull((Object)writer);
        Class dynamicClass2 = dcl.createDynamicClass(MY_CLASSNAME);
        Assert.assertSame((Object)dynamicClass, (Object)dynamicClass2);
        EclipseLinkClassWriter writer2 = dcl.getClassWriter(MY_CLASSNAME);
        Assert.assertNotNull((Object)writer);
        Assert.assertSame((Object)writer, (Object)writer2);
    }

    @Test
    public void defaultWriter() throws Exception {
        DynamicClassLoader dcl = new DynamicClassLoader(DynamicClassLoaderTestSuite.class.getClassLoader());
        Assert.assertEquals(DynamicClassWriter.class, dcl.getDefaultWriter().getClass());
    }

    @Test
    public void loadClass_DefaultConstructor() throws Exception {
        DynamicClassLoader dcl = new DynamicClassLoader(DynamicClassLoaderTestSuite.class.getClassLoader());
        dcl.addClass(MY_CLASSNAME, DefaultConstructor.class);
        Class dynamicClass = dcl.loadClass(MY_CLASSNAME);
        Assert.assertNotNull((Object)dynamicClass);
        Assert.assertSame((Object)dynamicClass, (Object)dcl.loadClass(MY_CLASSNAME));
        Assert.assertSame(DefaultConstructor.class, dynamicClass.getSuperclass());
        DefaultConstructor entity = (DefaultConstructor)dynamicClass.newInstance();
        Assert.assertNotNull((Object)entity);
    }

    @Test
    public void loadClass_WriteReplace() throws Exception {
        DynamicClassLoader dcl = new DynamicClassLoader(DynamicClassLoaderTestSuite.class.getClassLoader());
        dcl.addClass(MY_CLASSNAME, WriteReplace.class);
        Class dynamicClass = dcl.loadClass(MY_CLASSNAME);
        Assert.assertNotNull((Object)dynamicClass);
        Assert.assertEquals((Object)MY_CLASSNAME, (Object)dynamicClass.getName());
        Assert.assertSame(WriteReplace.class, dynamicClass.getSuperclass());
        Assert.assertSame((Object)dynamicClass, (Object)dcl.loadClass(MY_CLASSNAME));
        WriteReplace entity = (WriteReplace)dynamicClass.newInstance();
        Assert.assertNotNull((Object)entity);
        byte[] entityBytes = SerializationHelper.serialize((Serializable)entity);
        byte[] stringBytes = SerializationHelper.serialize((Serializable)((Object)entity.getClass().getName()));
        Assert.assertEquals((long)stringBytes.length, (long)entityBytes.length);
        for (int index = 0; index < stringBytes.length; ++index) {
            Assert.assertEquals((long)stringBytes[index], (long)entityBytes[index]);
        }
        Object deserializedValue = SerializationHelper.deserialize((byte[])entityBytes);
        Assert.assertNotNull((Object)deserializedValue);
        Assert.assertEquals(String.class, deserializedValue.getClass());
        Assert.assertEquals((Object)dynamicClass.getName(), (Object)deserializedValue);
    }

    @Test
    public void createDynamicClass_WriteReplace() throws Exception {
        DynamicClassLoader dcl = new DynamicClassLoader(DynamicClassLoaderTestSuite.class.getClassLoader());
        Class dynamicClass = dcl.createDynamicClass(MY_CLASSNAME, WriteReplace.class);
        Assert.assertNotNull((Object)dynamicClass);
        Assert.assertEquals((Object)MY_CLASSNAME, (Object)dynamicClass.getName());
        Assert.assertSame(WriteReplace.class, dynamicClass.getSuperclass());
        Assert.assertSame((Object)dynamicClass, (Object)dcl.loadClass(MY_CLASSNAME));
        WriteReplace entity = (WriteReplace)dynamicClass.newInstance();
        Assert.assertNotNull((Object)entity);
        byte[] entityBytes = SerializationHelper.serialize((Serializable)entity);
        byte[] stringBytes = SerializationHelper.serialize((Serializable)((Object)entity.getClass().getName()));
        Assert.assertEquals((long)stringBytes.length, (long)entityBytes.length);
        for (int index = 0; index < stringBytes.length; ++index) {
            Assert.assertEquals((long)stringBytes[index], (long)entityBytes[index]);
        }
        Object deserializedValue = SerializationHelper.deserialize((byte[])entityBytes);
        Assert.assertNotNull((Object)deserializedValue);
        Assert.assertEquals(String.class, deserializedValue.getClass());
        Assert.assertEquals((Object)dynamicClass.getName(), (Object)deserializedValue);
    }

    @Test
    public void duplicateAddClassWithSameParent() throws Exception {
        DynamicClassLoader dcl = new DynamicClassLoader(Thread.currentThread().getContextClassLoader());
        dcl.addClass(MY_CLASSNAME, DefaultConstructor.class);
        Class dynamicClass = dcl.loadClass(MY_CLASSNAME);
        Assert.assertNotNull((Object)dynamicClass);
        Assert.assertSame((Object)dynamicClass, (Object)dcl.loadClass(MY_CLASSNAME));
        Assert.assertSame(DefaultConstructor.class, dynamicClass.getSuperclass());
        EclipseLinkClassWriter firstWriter = dcl.getClassWriter(MY_CLASSNAME);
        DefaultConstructor entity = (DefaultConstructor)dynamicClass.newInstance();
        Assert.assertNotNull((Object)entity);
        Assert.assertNotNull((String)"DCL does not contain expected writer", (Object)dcl.getClassWriter(MY_CLASSNAME));
        dcl.addClass(MY_CLASSNAME, DefaultConstructor.class);
        EclipseLinkClassWriter secondWriter = dcl.getClassWriter(MY_CLASSNAME);
        Assert.assertSame((Object)firstWriter, (Object)secondWriter);
    }

    @Test
    public void duplicateAddClassWithDifferentParent() throws Exception {
        DynamicClassLoader dcl = new DynamicClassLoader(Thread.currentThread().getContextClassLoader());
        dcl.addClass(MY_CLASSNAME, DefaultConstructor.class);
        Class dynamicClass = dcl.loadClass(MY_CLASSNAME);
        Assert.assertNotNull((Object)dynamicClass);
        Assert.assertSame((Object)dynamicClass, (Object)dcl.loadClass(MY_CLASSNAME));
        Assert.assertSame(DefaultConstructor.class, dynamicClass.getSuperclass());
        DefaultConstructor entity = (DefaultConstructor)dynamicClass.newInstance();
        Assert.assertNotNull((Object)entity);
        Assert.assertNotNull((String)"DCL does not contain expected writer", (Object)dcl.getClassWriter(MY_CLASSNAME));
        try {
            dcl.addClass(MY_CLASSNAME, WriteReplace.class);
        }
        catch (DynamicException de) {
            String errorMessage = de.getMessage();
            int errorCode = de.getErrorCode();
            Assert.assertTrue((String)"Incorrect dynamic exception", (boolean)errorMessage.startsWith("\r\nException Description: Duplicate addClass request with incompatible writer:"));
            Assert.assertEquals((String)"Unexpected error code", (long)51008L, (long)errorCode);
            return;
        }
        Assert.fail((String)"No DynamicException thrown for duplicate addClass with different parent");
    }

    public static class WriteReplace
    implements Serializable {
        protected Object writeReplace() throws ObjectStreamException {
            return this.getClass().getName();
        }
    }

    public static class StringConstructor {
        public StringConstructor(String arg) {
        }
    }

    public static class DefaultConstructor {
    }
}

