/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.dynamic.entitytype;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.dynamic.DynamicClassLoader;
import org.eclipse.persistence.dynamic.DynamicEntity;
import org.eclipse.persistence.dynamic.DynamicType;
import org.eclipse.persistence.dynamic.DynamicTypeBuilder;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.IntegrityException;
import org.eclipse.persistence.mappings.foundation.AbstractDirectMapping;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.testing.tests.dynamic.DynamicTestingHelper;
import org.eclipse.persistence.testing.tests.dynamic.entitytype.MyEntity;
import org.eclipse.persistence.tools.schemaframework.SchemaManager;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;

public class EntityTypeFromDescriptor {
    static final String TABLE_NAME = "MY_ENTITY";

    @AfterClass
    public static void tearDown() {
        DatabaseSession ds = DynamicTestingHelper.createSession();
        ds.login();
        ds.executeNonSelectingSQL("DROP TABLE MY_ENTITY");
        ds.logout();
    }

    @Test
    public void entityTypeFromDescriptor() throws Exception {
        DatabaseSession session = DynamicTestingHelper.createSession();
        session.login();
        DynamicClassLoader dcl = DynamicClassLoader.lookup((Session)session);
        RelationalDescriptor descriptor = this.buildMyEntityDescriptor();
        Assert.assertFalse((boolean)descriptor.isAggregateDescriptor());
        DynamicType entityType = new DynamicTypeBuilder(dcl, (ClassDescriptor)descriptor, null).getType();
        MyEntity.DPM.setType(entityType);
        Assert.assertFalse((boolean)descriptor.isAggregateDescriptor());
        Assert.assertEquals(MyEntity.class, (Object)entityType.getJavaClass());
        session.addDescriptor(entityType.getDescriptor());
        new SchemaManager(session).replaceDefaultTables();
        DynamicEntity entity = entityType.newDynamicEntity();
        entity.set("id", (Object)1);
        entity.set("name", (Object)"Name");
        session.insertObject((Object)entity);
        session.logout();
    }

    @Test
    public void invalidDescriptorWithoutEntityType() throws Exception {
        RelationalDescriptor descriptor = this.buildMyEntityDescriptor();
        DatabaseSession session = DynamicTestingHelper.createSession();
        session.addDescriptor((ClassDescriptor)descriptor);
        try {
            session.login();
        }
        catch (IntegrityException ie) {
            Assert.assertEquals((long)descriptor.getMappings().size(), (long)ie.getIntegrityChecker().getCaughtExceptions().size());
            for (int index = 0; index < descriptor.getMappings().size(); ++index) {
                DescriptorException ex = (DescriptorException)((Object)ie.getIntegrityChecker().getCaughtExceptions().get(index));
                Assert.assertEquals((long)59L, (long)ex.getErrorCode());
            }
            return;
        }
        Assert.fail((String)"Expected IntegrityException not thrown");
    }

    private RelationalDescriptor buildMyEntityDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(MyEntity.class);
        descriptor.setTableName(TABLE_NAME);
        descriptor.addPrimaryKeyFieldName("ID");
        AbstractDirectMapping mapping = (AbstractDirectMapping)descriptor.addDirectMapping("id", "ID");
        mapping.setAttributeClassification(Integer.TYPE);
        mapping = (AbstractDirectMapping)descriptor.addDirectMapping("name", "NAME");
        mapping.setAttributeClassification(String.class);
        return descriptor;
    }
}

