/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries.report;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.domain.PhoneNumber;
import org.eclipse.persistence.testing.tests.queries.report.ReportQueryTestCase;

public class ReportQueryAndExistsSubQueryWithWhereClause
extends ReportQueryTestCase {
    public ReportQueryAndExistsSubQueryWithWhereClause() {
        this.setDescription("ReportQuery and exists subQuery with selection criteria");
    }

    @Override
    protected void buildExpectedResults() {
        Vector employees = this.getSession().readAllObjects(Employee.class);
        Enumeration e = employees.elements();
        block0: while (e.hasMoreElements()) {
            Employee emp = (Employee)e.nextElement();
            Enumeration pe = emp.getPhoneNumbers().elements();
            while (pe.hasMoreElements()) {
                PhoneNumber phone = (PhoneNumber)pe.nextElement();
                if (!phone.getAreaCode().equals("613")) continue;
                Object[] result = new Object[]{emp};
                this.addResult(result, null);
                continue block0;
            }
        }
    }

    @Override
    protected void setup() throws Exception {
        if (this.getSession().isRemoteSession()) {
            this.throwWarning("Report queries with objects are not supported on remote session.");
        }
        super.setup();
        this.reportQuery = new ReportQuery(Employee.class, new ExpressionBuilder());
        ExpressionBuilder builder = this.reportQuery.getExpressionBuilder();
        this.reportQuery.addAttribute("employee", (Expression)builder);
        ReportQuery innerQuery = new ReportQuery(Employee.class, new ExpressionBuilder());
        innerQuery.addAttribute("areaCode", builder.anyOf("phoneNumbers").get("areaCode"));
        Expression innerExp = builder.anyOf("phoneNumbers").get("areaCode").like("613");
        innerQuery.setSelectionCriteria(innerExp);
        Expression exists = builder.exists(innerQuery);
        this.reportQuery.setSelectionCriteria(exists);
    }
}

