/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.relationshipmaintenance;

import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.relationshipmaintenance.FieldOffice;
import org.eclipse.persistence.testing.models.relationshipmaintenance.SalesPerson;

public class AddUnReferencedObjectTest
extends AutoVerifyTestCase {
    public FieldOffice fieldOfficeClone;
    public SalesPerson sales = null;

    public void setup() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        this.beginTransaction();
    }

    public void reset() {
        this.rollbackTransaction();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public void test() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        this.sales = SalesPerson.example1();
        uow.registerObject((Object)this.sales);
        uow.commit();
        uow = this.getSession().acquireUnitOfWork();
        this.fieldOfficeClone = (FieldOffice)uow.readObject(FieldOffice.class);
        this.sales = (SalesPerson)uow.readObject((Object)this.sales);
        this.fieldOfficeClone.getSalespeople().add(this.sales);
        uow.commit();
    }

    public void verify() {
        if (!this.fieldOfficeClone.getSalespeople().contains(this.sales) || this.sales.getFieldOffice() == null) {
            throw new TestErrorException("Failed to set the backPointer information");
        }
    }
}

