/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.unitofwork;

import java.sql.Time;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.SessionEventListener;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.sessions.remote.RemoteSession;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.models.employee.domain.Address;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.domain.EmploymentPeriod;
import org.eclipse.persistence.testing.models.employee.domain.LargeProject;
import org.eclipse.persistence.testing.models.employee.domain.PhoneNumber;
import org.eclipse.persistence.testing.models.employee.domain.Project;
import org.eclipse.persistence.testing.models.employee.domain.SmallProject;
import org.eclipse.persistence.testing.tests.remote.RemoteModel;

public class ComplexMultipleUnitOfWorkTest
extends AutoVerifyTestCase {
    public Employee readInSession;
    public Employee readInUow;
    public Employee newEmployeeInUow;
    public Employee readInFirstNestedUow;
    public UnitOfWork firstUnitOfWork;
    public UnitOfWork secondUnitOfWork;
    public UnitOfWork thirdUnitOfWork;
    SessionEventListener listener;

    public Address addressExample1() {
        Address address = new Address();
        address.setCity("Toronto");
        address.setPostalCode("L5J2B5");
        address.setProvince("ONT");
        address.setStreet("1450 Acme Cr., suite 4");
        address.setCountry("Canada");
        return address;
    }

    public Address addressExample2() {
        Address address = new Address();
        address.setCity("Ottawa");
        address.setPostalCode("K5J2B5");
        address.setProvince("ONT");
        address.setStreet("1450 Acme Cr., suite 4");
        address.setCountry("Canada");
        return address;
    }

    public Address addressExample3() {
        Address address = new Address();
        address.setCity("Sudbury");
        address.setPostalCode("L5J2B5");
        address.setProvince("ONT");
        address.setStreet("1450 Acme Cr., suite 4");
        address.setCountry("Canada");
        return address;
    }

    public Address addressExample4() {
        Address address = new Address();
        address.setCity("Niagra");
        address.setPostalCode("L5J2B5");
        address.setProvince("ONT");
        address.setStreet("1450 Acme Cr., suite 4");
        address.setCountry("Canada");
        return address;
    }

    protected void changeObject(Employee employee, UnitOfWork unitOfWork) {
        employee.setNormalHours(new Time[2]);
        employee.setStartTime(Helper.timeFromHourMinuteSecond((int)1, (int)1, (int)1));
        employee.setEndTime(Helper.timeFromHourMinuteSecond((int)1, (int)1, (int)1));
        employee.setPeriod(new EmploymentPeriod(Helper.dateFromYearMonthDate((int)1901, (int)1, (int)1), Helper.dateFromYearMonthDate((int)1902, (int)2, (int)2)));
        employee.setPhoneNumbers(new Vector());
        employee.addPhoneNumber(new PhoneNumber("home", "613", "2263374"));
        employee.addPhoneNumber(new PhoneNumber("office", "416", "8224599"));
        employee.setProjects(new Vector());
        employee.addProject((Project)unitOfWork.readObject(SmallProject.class));
        employee.addProject((Project)unitOfWork.readObject(LargeProject.class));
        employee.setResponsibilitiesList(new Vector());
        employee.addResponsibility("make coffee");
        employee.addResponsibility("buy donuts");
        employee.setAddress(this.addressExample4());
        ((Employee)unitOfWork.readObject(Employee.class, new ExpressionBuilder().get("firstName").equal((Object)"Marcus"))).addManagedEmployee(employee);
    }

    public Employee createNewEmployeeObject() {
        Employee employee = new Employee();
        employee.setFirstName("Judy");
        employee.setLastName("Barney");
        employee.setMale();
        employee.setSalary(35000);
        employee.setPeriod(this.employmentPeriodExample());
        employee.setAddress(this.addressExample1());
        employee.addResponsibility("Make the coffee.");
        employee.addResponsibility("Clean the kitchen.");
        employee.addPhoneNumber(new PhoneNumber("Work", "613", "2258812"));
        employee.addProject(this.smallProjectExample());
        return employee;
    }

    public EmploymentPeriod employmentPeriodExample() {
        EmploymentPeriod employmentPeriod = new EmploymentPeriod();
        employmentPeriod.setEndDate(Helper.dateFromYearMonthDate((int)1996, (int)0, (int)1));
        employmentPeriod.setStartDate(Helper.dateFromYearMonthDate((int)1993, (int)0, (int)1));
        return employmentPeriod;
    }

    public void processFirstUnitOfWork() throws Exception {
        Expression firstNameExpression = new ExpressionBuilder().get("firstName").equal((Object)"Bob");
        this.readInSession = (Employee)this.getSession().readObject(Employee.class, firstNameExpression);
        this.firstUnitOfWork = this.getSession().acquireUnitOfWork();
        firstNameExpression = new ExpressionBuilder().get("firstName").equal((Object)"John");
        this.readInUow = (Employee)this.firstUnitOfWork.readObject(Employee.class, firstNameExpression);
        Employee regDel = (Employee)this.firstUnitOfWork.registerObject((Object)this.readInSession);
        if (regDel.getManager() != null) {
            regDel.getManager().removeManagedEmployee(regDel);
        }
        Enumeration mgdEnum = regDel.getManagedEmployees().elements();
        while (mgdEnum.hasMoreElements()) {
            ((Employee)mgdEnum.nextElement()).setManager(null);
        }
        Enumeration mgdProjEnum = this.firstUnitOfWork.readAllObjects(Project.class).elements();
        while (mgdProjEnum.hasMoreElements()) {
            ((Project)mgdProjEnum.nextElement()).setTeamLeader(null);
        }
        this.firstUnitOfWork.deleteObject((Object)this.readInSession);
        this.newEmployeeInUow = this.createNewEmployeeObject();
        Employee newEmployeeInFirstUow = (Employee)this.firstUnitOfWork.registerObject((Object)this.newEmployeeInUow);
        if (this.readInUow.getManager() != null) {
            this.readInUow.getManager().removeManagedEmployee(this.readInUow);
        }
        Enumeration mgdEnum2 = this.readInUow.getManagedEmployees().elements();
        while (mgdEnum2.hasMoreElements()) {
            ((Employee)mgdEnum2.nextElement()).setManager(null);
        }
        UnitOfWork firstNestedUow = this.firstUnitOfWork.acquireUnitOfWork();
        firstNestedUow.deleteObject((Object)this.readInUow);
        Employee workingCopyOfNewEmployeeInSecondNestedUow = (Employee)firstNestedUow.registerObject((Object)newEmployeeInFirstUow);
        workingCopyOfNewEmployeeInSecondNestedUow.setAddress(this.addressExample2());
        firstNestedUow.commit();
        UnitOfWork secondNestedUow = this.firstUnitOfWork.acquireUnitOfWork();
        firstNameExpression = new ExpressionBuilder().get("firstName").equal((Object)"Marcus");
        this.readInFirstNestedUow = (Employee)secondNestedUow.readObject(Employee.class, firstNameExpression);
        this.readInFirstNestedUow.setAddress(this.addressExample3());
        secondNestedUow.commit();
        this.readInFirstNestedUow = (Employee)secondNestedUow.getOriginalVersionOfObject((Object)this.readInFirstNestedUow);
        this.firstUnitOfWork.commit();
    }

    public void processSecondUnitOfWork() {
        this.secondUnitOfWork = this.getSession().acquireUnitOfWork();
        ReadObjectQuery query = new ReadObjectQuery();
        query.setSelectionObject((Object)this.newEmployeeInUow);
        Employee objectFromDatabase = (Employee)this.secondUnitOfWork.executeQuery((DatabaseQuery)query);
        if (!((AbstractSession)this.getSession()).compareObjects((Object)this.newEmployeeInUow, (Object)objectFromDatabase)) {
            throw new TestErrorException("The object read from the database, '" + this.newEmployeeInUow + "' does not match the originial, '" + objectFromDatabase + ".");
        }
        query = new ReadObjectQuery();
        query.setSelectionObject((Object)this.readInFirstNestedUow);
        objectFromDatabase = (Employee)this.secondUnitOfWork.executeQuery((DatabaseQuery)query);
        if (!((AbstractSession)this.getSession()).compareObjects((Object)this.readInFirstNestedUow, (Object)objectFromDatabase)) {
            throw new TestErrorException("The object read from the database, '" + this.readInFirstNestedUow + "' does not match the originial, '" + objectFromDatabase + ".");
        }
        Employee workingCopy = (Employee)this.secondUnitOfWork.registerObject((Object)this.newEmployeeInUow);
        this.changeObject(workingCopy, this.secondUnitOfWork);
        this.secondUnitOfWork.release();
        if (!((AbstractSession)this.getSession()).compareObjectsDontMatch((Object)this.newEmployeeInUow, (Object)workingCopy)) {
            throw new TestErrorException("The original object was changed through changing the clone.");
        }
    }

    public void processThirdUnitOfWork() {
        this.thirdUnitOfWork = this.getSession().acquireUnitOfWork();
        Employee workingCopy = (Employee)this.thirdUnitOfWork.registerObject((Object)this.newEmployeeInUow);
        this.changeObject(workingCopy, this.thirdUnitOfWork);
        if (!((AbstractSession)this.getSession()).compareObjectsDontMatch((Object)this.newEmployeeInUow, (Object)workingCopy)) {
            throw new TestErrorException("The original object was changed through changing the clone.");
        }
        this.thirdUnitOfWork.commit();
    }

    public void reset() {
        if (this.getAbstractSession().isInTransaction()) {
            this.getAbstractSession().rollbackTransaction();
        }
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        if (this.listener != null) {
            this.getAbstractSession().getParent().getEventManager().removeListener(this.listener);
            this.listener = null;
        }
    }

    public void setup() {
        if (this.getSession().isClientSession()) {
            this.listener = this.checkTransactionIsolation();
        }
        if (this.getSession().isRemoteSession() && this.getSession().getDatasourcePlatform().isDerby()) {
            throw new TestWarningException("This test uses functionality that does not work over remote sessions in Apache Derby.");
        }
        this.getAbstractSession().beginTransaction();
    }

    public SmallProject smallProjectExample() {
        SmallProject smallProject = new SmallProject();
        smallProject.setName("Enterprise");
        smallProject.setDescription("A enterprise wide application using Visual J++ to report on the corporations Sybase and DB/2 database through TopLink.");
        return smallProject;
    }

    public void test() throws Exception {
        this.processFirstUnitOfWork();
        this.processSecondUnitOfWork();
        this.processThirdUnitOfWork();
    }

    public void verify() {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        Session sessionToVerifyDelete = this.getSession() instanceof RemoteSession ? RemoteModel.getServerSession() : this.getSession();
        if (!((AbstractSession)sessionToVerifyDelete).verifyDelete((Object)this.readInSession)) {
            throw new TestErrorException("The object '" + this.readInSession + "'deleted in the uow was not completely deleted from the database.");
        }
        if (!((AbstractSession)sessionToVerifyDelete).verifyDelete((Object)this.readInUow)) {
            throw new TestErrorException("The object '" + this.readInUow + "'deleted in the nested uow was not completely deleted from the database.");
        }
        ReadObjectQuery query = new ReadObjectQuery();
        query.setSelectionObject((Object)this.newEmployeeInUow);
        Employee objectFromDatabase = (Employee)this.getSession().executeQuery((DatabaseQuery)query);
        if (!((AbstractSession)this.getSession()).compareObjects((Object)this.newEmployeeInUow, (Object)objectFromDatabase)) {
            throw new TestErrorException("The object read from the database, '" + this.newEmployeeInUow + "' does not match the originial, '" + objectFromDatabase + ".");
        }
    }
}

