/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.unitofwork;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Date;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.sessions.remote.RemoteSession;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.models.employee.domain.Address;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.domain.EmploymentPeriod;

public class DeepMergeCloneSerializedObjectReferenceChangesTest
extends AutoVerifyTestCase {
    public Employee original;
    public Employee mergedClone;
    public Employee deserialEmp;
    public Address firstAddress;
    public EmploymentPeriod originalEmployment;

    public DeepMergeCloneSerializedObjectReferenceChangesTest() {
        this.setDescription("This test verifies that deepMergeClone works after a serialized transaction");
    }

    public void reset() {
        if (this.getAbstractSession().isInTransaction()) {
            this.getAbstractSession().rollbackTransaction();
            this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        }
    }

    public void setup() {
        if (this.getSession() instanceof RemoteSession) {
            throw new TestWarningException("This test cannot be run through the remote.");
        }
        this.getAbstractSession().beginTransaction();
    }

    public void test() {
        try {
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            ObjectOutputStream stream = new ObjectOutputStream(byteStream);
            Session session = this.getSession();
            UnitOfWork uow = session.acquireUnitOfWork();
            this.original = (Employee)session.readObject(Employee.class, new ExpressionBuilder().get("firstName").equal((Object)"Bob"));
            this.firstAddress = this.original.getAddress();
            this.originalEmployment = new EmploymentPeriod();
            this.originalEmployment.setStartDate(this.original.getPeriod().getStartDate());
            this.originalEmployment.setEndDate(this.original.getPeriod().getEndDate());
            stream.writeObject(this.original);
            stream.flush();
            byte[] arr = byteStream.toByteArray();
            ByteArrayInputStream inByteStream = new ByteArrayInputStream(arr);
            ObjectInputStream inObjStream = new ObjectInputStream(inByteStream);
            try {
                this.deserialEmp = (Employee)inObjStream.readObject();
            }
            catch (ClassNotFoundException e) {
                throw new TestErrorException("Could not deserialize object " + e.toString());
            }
            Address newAddress = new Address();
            newAddress.city = "CITY";
            newAddress.province = "PROV";
            newAddress.postalCode = "K9K0K0";
            newAddress.street = "STREET";
            newAddress.country = "COUNTRY";
            this.deserialEmp.setAddress(newAddress);
            EmploymentPeriod employment = new EmploymentPeriod();
            employment.setStartDate(new Date(194560000L));
            employment.setEndDate(new Date(1999000000L));
            this.deserialEmp.setPeriod(employment);
            byteStream = new ByteArrayOutputStream();
            stream = new ObjectOutputStream(byteStream);
            stream.writeObject(this.deserialEmp);
            stream.flush();
            arr = byteStream.toByteArray();
            inByteStream = new ByteArrayInputStream(arr);
            inObjStream = new ObjectInputStream(inByteStream);
            try {
                this.deserialEmp = (Employee)inObjStream.readObject();
            }
            catch (ClassNotFoundException e) {
                throw new TestErrorException("Could not deserialize object " + e.toString());
            }
            Employee empClone = (Employee)uow.deepMergeClone((Object)this.deserialEmp);
            uow.commit();
        }
        catch (IOException e) {
            throw new TestErrorException("Error running Test " + e.toString());
        }
    }

    public void verify() {
        Employee cachedEmp = (Employee)this.getSession().readObject((Object)this.original);
        if (cachedEmp.getPeriod().getEndDate().equals(this.originalEmployment.getEndDate())) {
            throw new TestErrorException("Failed to update the aggregate");
        }
        if (cachedEmp.getPeriod().getStartDate().equals(this.originalEmployment.getStartDate())) {
            throw new TestErrorException("Failed to update the aggregate");
        }
        if (!cachedEmp.getPeriod().getEndDate().equals(new Date(1999000000L))) {
            throw new TestErrorException("Failed to update the aggregate with new values");
        }
        if (!cachedEmp.getPeriod().getStartDate().equals(new Date(194560000L))) {
            throw new TestErrorException("Failed to update the aggregate with new values");
        }
        if (this.getAbstractSession().compareObjects((Object)this.firstAddress, (Object)cachedEmp.getAddress())) {
            throw new TestErrorException("Failed to update address correctly");
        }
    }
}

