/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.unitofwork.transactionisolation;

import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class TransactionIsolationMergeCircularIndirectionTest
extends AutoVerifyTestCase {
    UnitOfWork unitOfWork;
    Employee teamLead;
    Employee freelance;
    String teamLeadFirstName;
    String freelanceFirstName;

    protected void setup() throws Exception {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        this.unitOfWork = this.getSession().acquireUnitOfWork();
    }

    public void reset() throws Exception {
        if (this.unitOfWork != null) {
            this.unitOfWork.release();
            this.unitOfWork = null;
        }
        if (this.teamLead != null) {
            this.unitOfWork = this.getSession().acquireUnitOfWork();
            Employee clone = (Employee)this.unitOfWork.readObject((Object)this.teamLead);
            clone.setFirstName(this.teamLeadFirstName);
            Employee clone2 = (Employee)this.unitOfWork.readObject((Object)this.freelance);
            clone2.setFirstName(this.freelanceFirstName);
            clone2.setManager(null);
            this.unitOfWork.commit();
            this.unitOfWork = null;
            this.teamLeadFirstName = null;
            this.teamLead = null;
            this.freelance = null;
            this.freelanceFirstName = null;
            this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        }
    }

    public void test() {
        this.unitOfWork.beginEarlyTransaction();
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression expression = builder.get("gender").equal((Object)"Male");
        Employee teamLeadClone = (Employee)this.unitOfWork.readObject(Employee.class, expression);
        teamLeadClone.setFirstName("Bill");
        builder = new ExpressionBuilder();
        expression = builder.get("manager").isNull().and(builder.get("gender").equal((Object)"Female"));
        Employee freelanceClone = (Employee)this.unitOfWork.readObject(Employee.class, expression);
        freelanceClone.setFirstName("Beatrix");
        teamLeadClone.addManagedEmployee(freelanceClone);
        this.teamLead = (Employee)this.getSession().readObject((Object)teamLeadClone);
        this.teamLeadFirstName = this.teamLead.getFirstName();
        this.freelance = (Employee)this.getSession().readObject((Object)freelanceClone);
        this.freelanceFirstName = this.freelance.getFirstName();
        this.unitOfWork.commit();
        this.unitOfWork = null;
        Employee newTeamLead = (Employee)this.getSession().getIdentityMapAccessor().getFromIdentityMap((Object)teamLeadClone);
        this.strongAssert(newTeamLead == this.teamLead, "The previous original should have been merged into the shared cache.");
        this.strongAssert(newTeamLead.managedEmployees.isInstantiated(), "The valueholder [managedEmployees] in the shared cache should be triggered now.");
        Employee newFreelance = (Employee)this.getSession().getIdentityMapAccessor().getFromIdentityMap((Object)freelanceClone);
        this.strongAssert(newFreelance == this.freelance, "Identity was lost on managed employees accross the 1-1");
        this.strongAssert(newTeamLead.getManagedEmployees().contains(this.freelance), "teamLead is not pointing to the shared cache version of its new employee.");
        this.strongAssert(newFreelance.manager.isInstantiated(), "The valueholder [manager] in the shared cache should be triggered now.");
        this.strongAssert(newFreelance.getManager() == newTeamLead, "freelance is not pointing to the shared cache version of its new manager.");
    }
}

