/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.validation;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.IntegrityChecker;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.testing.models.employee.domain.LargeProject;
import org.eclipse.persistence.testing.tests.validation.ExceptionTest;

public class ParentClassIsSelfTest
extends ExceptionTest {
    ClassDescriptor orgDescriptor;
    IntegrityChecker orgIntegrityChecker;

    public ParentClassIsSelfTest() {
        this.setDescription("This tests Parent Class Is Self (TL-ERROR 158)");
    }

    protected void setup() {
        this.expectedException = DescriptorException.parentClassIsSelf(null);
        this.orgDescriptor = ((DatabaseSession)this.getSession()).getDescriptor(LargeProject.class);
        this.orgIntegrityChecker = this.getSession().getIntegrityChecker();
    }

    @Override
    public void reset() {
        ((DatabaseSession)this.getSession()).getDescriptors().remove(LargeProject.class);
        if (this.orgDescriptor != null) {
            ((DatabaseSession)this.getSession()).addDescriptor(this.orgDescriptor);
        }
        if (this.orgIntegrityChecker != null) {
            this.getSession().setIntegrityChecker(this.orgIntegrityChecker);
        }
    }

    public void test() {
        try {
            this.getSession().setIntegrityChecker(new IntegrityChecker());
            this.getSession().getIntegrityChecker().dontCatchExceptions();
            ((DatabaseSession)this.getSession()).addDescriptor((ClassDescriptor)this.descriptorChild());
        }
        catch (EclipseLinkException exception) {
            this.caughtException = exception;
        }
    }

    public RelationalDescriptor descriptorChild() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(LargeProject.class);
        descriptor.addTableName("LPROJECT");
        descriptor.getInheritancePolicy().setParentClass(LargeProject.class);
        descriptor.getInheritancePolicy().dontReadSubclassesOnQueries();
        return descriptor;
    }
}

