/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.advanced;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.HashMap;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.deployment.ArchiveFactoryImpl;
import org.eclipse.persistence.internal.jpa.deployment.PersistenceUnitProcessor;
import org.eclipse.persistence.jpa.ArchiveFactory;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.junit.Assert;

public class PersistenceUnitProcessorTest
extends JUnitTestCase {
    private static URLStreamHandler dummyHandler = new URLStreamHandler(){

        @Override
        protected URLConnection openConnection(URL u) throws IOException {
            return null;
        }
    };

    public static Test suite() {
        return new TestSuite(PersistenceUnitProcessorTest.class);
    }

    private static void checkPURootSimple(String inputUrl, String expectedOutput) throws Exception {
        Assert.assertEquals((Object)expectedOutput, (Object)PersistenceUnitProcessor.computePURootURL((URL)new URL(inputUrl), (String)"META-INF/persistence.xml").toString());
    }

    private static void checkPURootCustom(String inputScheme, String inputFile, String expectedOutput) throws Exception {
        Assert.assertEquals((Object)expectedOutput, (Object)PersistenceUnitProcessor.computePURootURL((URL)new URL(inputScheme, "", -1, inputFile, dummyHandler), (String)"META-INF/persistence.xml").toString());
    }

    private static void checkPURootFailsCustom(String inputScheme, String inputFile) throws Exception {
        try {
            PersistenceUnitProcessor.computePURootURL((URL)new URL(inputScheme, "", -1, inputFile, dummyHandler), (String)"META-INF/persistence.xml");
            PersistenceUnitProcessorTest.fail((String)"ValidationException should be thrown.");
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }

    private static void checkPURootFailsSimple(String input) throws Exception {
        try {
            PersistenceUnitProcessor.computePURootURL((URL)new URL(input), (String)"META-INF/persistence.xml");
            PersistenceUnitProcessorTest.fail((String)"ValidationException should be thrown.");
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }

    public void testComputePURootURLForZipFile() throws Exception {
        PersistenceUnitProcessorTest.checkPURootCustom("zip", "/foo/bar.jar!/META-INF/persistence.xml", "file:/foo/bar.jar");
        PersistenceUnitProcessorTest.checkPURootCustom("zip", "/foo/bar.war!/WEB-INF/classes/META-INF/persistence.xml", "jar:file:/foo/bar.war!/WEB-INF/classes/");
        PersistenceUnitProcessorTest.checkPURootFailsCustom("zip", "/foo/bar.jar!/WEB-INF/classes/META-INF/persistence.xml");
        PersistenceUnitProcessorTest.checkPURootFailsCustom("zip", "/foo/bar.jar!/foo/META-INF/persistence.xml");
        PersistenceUnitProcessorTest.checkPURootCustom("zip", "/C:/Oracle/Middleware/Oracle_Home/wlserver/samples/domains/mydomain/servers/myserver/tmp/_WL_user/eclipselink-advanced-model/y986my/eclipselink-advanced-model_ejb.jar!/META-INF/persistence.xml", "file:/C:/Oracle/Middleware/Oracle_Home/wlserver/samples/domains/mydomain/servers/myserver/tmp/_WL_user/eclipselink-advanced-model/y986my/eclipselink-advanced-model_ejb.jar");
        PersistenceUnitProcessorTest.checkPURootCustom("zip", "/C:/Program Files/Middleware/Oracle_Home/wlserver/samples/domains/mydomain/servers/myserver/tmp/_WL_user/eclipselink-advanced-model/y986my/eclipselink-advanced-model_ejb.jar!/META-INF/persistence.xml", "file:/C:/Program Files/Middleware/Oracle_Home/wlserver/samples/domains/mydomain/servers/myserver/tmp/_WL_user/eclipselink-advanced-model/y986my/eclipselink-advanced-model_ejb.jar");
        PersistenceUnitProcessorTest.checkPURootCustom("zip", "/C:/Program.Files/Middleware/Oracle_Home/wlserver/samples/domains/mydomain/servers/myserver/tmp/_WL_user/eclipselink-advanced-model/y986my/eclipselink-advanced-model_ejb.jar!/META-INF/persistence.xml", "file:/C:/Program.Files/Middleware/Oracle_Home/wlserver/samples/domains/mydomain/servers/myserver/tmp/_WL_user/eclipselink-advanced-model/y986my/eclipselink-advanced-model_ejb.jar");
    }

    public void testComputePURootURLForJarFile() throws Exception {
        PersistenceUnitProcessorTest.checkPURootSimple("jar:file:/foo/bar.jar!/META-INF/persistence.xml", "file:/foo/bar.jar");
        PersistenceUnitProcessorTest.checkPURootSimple("jar:file:/foo/bar.war!/WEB-INF/classes/META-INF/persistence.xml", "jar:file:/foo/bar.war!/WEB-INF/classes/");
        PersistenceUnitProcessorTest.checkPURootFailsSimple("jar:file:/foo/bar.jar!/WEB-INF/classes/META-INF/persistence.xml");
        PersistenceUnitProcessorTest.checkPURootFailsSimple("jar:file:/foo/bar.jar!/foo/META-INF/persistence.xml");
    }

    public void testComputePURootURLForWsjarFile() throws Exception {
        PersistenceUnitProcessorTest.checkPURootCustom("wsjar", "file:/foo/bar.jar!/META-INF/persistence.xml", "jar:file:/foo/bar.jar!/");
        PersistenceUnitProcessorTest.checkPURootCustom("wsjar", "file:/foo/bar.war!/WEB-INF/classes/META-INF/persistence.xml", "jar:file:/foo/bar.war!/WEB-INF/classes/");
        PersistenceUnitProcessorTest.checkPURootFailsCustom("wsjar", "file:/foo/bar.jar!/WEB-INF/classes/META-INF/persistence.xml");
        PersistenceUnitProcessorTest.checkPURootFailsCustom("wsjar", "file:/foo/bar.jar!/foo/META-INF/persistence.xml");
    }

    public void testGetArchiveFactory() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("eclipselink.archive.factory", AF1.class.getName());
        ArchiveFactory af = PersistenceUnitProcessor.getArchiveFactory((ClassLoader)PersistenceUnitProcessorTest.class.getClassLoader(), props);
        Assert.assertTrue((String)"Property should be used", (boolean)(af instanceof AF1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetArchiveFactoryOverride() {
        Object emf = null;
        String orig = System.getProperty("eclipselink.archive.factory", "--noval--");
        try {
            System.setProperty("eclipselink.archive.factory", AF2.class.getName());
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("eclipselink.archive.factory", AF1.class.getName());
            ArchiveFactory af = PersistenceUnitProcessor.getArchiveFactory((ClassLoader)PersistenceUnitProcessorTest.class.getClassLoader(), props);
            Assert.assertTrue((String)"System property should be used", (boolean)(af instanceof AF2));
        }
        finally {
            if ("--noval--".equals(orig)) {
                System.clearProperty("eclipselink.archive.factory");
            } else {
                System.setProperty("eclipselink.archive.factory", orig);
            }
        }
    }

    public static class AF2
    extends ArchiveFactoryImpl {
    }

    public static class AF1
    extends ArchiveFactoryImpl {
    }
}

