/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.datatypes.arraypks;

import jakarta.persistence.EntityManager;
import java.util.UUID;
import junit.extensions.TestSetup;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.server.ServerSession;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.datatypes.arraypks.PrimByteArrayPKType;
import org.eclipse.persistence.testing.models.jpa.datatypes.arraypks.PrimitiveArraysAsPrimaryKeyTableCreator;

public class PrimitiveArrayPKCachingJUnitTestCase
extends JUnitTestCase {
    public PrimitiveArrayPKCachingJUnitTestCase() {
    }

    public PrimitiveArrayPKCachingJUnitTestCase(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("Caching Primitive Array pk types");
        suite.addTest((Test)new PrimitiveArrayPKCachingJUnitTestCase("testPrimitiveByteArrayPK"));
        return new TestSetup((Test)suite){

            protected void setUp() {
                ServerSession session = JUnitTestCase.getServerSession();
                if (!JUnitTestCase.getServerSession().getPlatform().isOracle()) {
                    session.logMessage("Warning, RAW type used for Primary keys only supported on Oracle");
                    return;
                }
                new PrimitiveArraysAsPrimaryKeyTableCreator().replaceTables((DatabaseSession)session);
            }

            protected void tearDown() {
                new PrimitiveArrayPKCachingJUnitTestCase().clearCache();
            }
        };
    }

    public void testPrimitiveByteArrayPK() {
        if (!JUnitTestCase.getServerSession().getPlatform().isOracle()) {
            JUnitTestCase.getServerSession().logMessage("Warning, RAW type used for Primary keys only supported on Oracle");
            return;
        }
        EntityManager em = this.createEntityManager();
        UUID uuid = UUID.randomUUID();
        PrimByteArrayPKType originalEntity = new PrimByteArrayPKType(PrimByteArrayPKType.getBytes((UUID)uuid));
        try {
            this.beginTransaction(em);
            em.persist((Object)originalEntity);
            em.flush();
            PrimByteArrayPKType objectReadIn = (PrimByteArrayPKType)em.find(PrimByteArrayPKType.class, (Object)PrimByteArrayPKType.getBytes((UUID)uuid));
            this.rollbackTransaction(em);
            PrimitiveArrayPKCachingJUnitTestCase.assertTrue((String)"Different instances of the same PrimByteArrayPKType object was returned", (originalEntity == objectReadIn ? 1 : 0) != 0);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
    }
}

