/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.orphanremoval;

import jakarta.persistence.EntityManager;
import java.util.HashSet;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.orphanremoval.Chassis;
import org.eclipse.persistence.testing.models.jpa.orphanremoval.Engine;
import org.eclipse.persistence.testing.models.jpa.orphanremoval.OrphanRemovalModelTableCreator;
import org.eclipse.persistence.testing.models.jpa.orphanremoval.SparkPlug;
import org.eclipse.persistence.testing.models.jpa.orphanremoval.Tire;
import org.eclipse.persistence.testing.models.jpa.orphanremoval.TireDetail;
import org.eclipse.persistence.testing.models.jpa.orphanremoval.Vehicle;
import org.eclipse.persistence.testing.models.jpa.orphanremoval.Wheel;
import org.eclipse.persistence.testing.models.jpa.orphanremoval.WheelNut;
import org.eclipse.persistence.testing.models.jpa.orphanremoval.WheelRim;

public class OrphanRemovalJUnitTestCase
extends JUnitTestCase {
    public OrphanRemovalJUnitTestCase(String name) {
        super(name);
    }

    public void compareObjects(Object obj, Object objRead) {
        OrphanRemovalJUnitTestCase.assertTrue((String)("The object [" + obj + "] when read back did not match the original"), (boolean)OrphanRemovalJUnitTestCase.getServerSession().compareObjects(obj, objRead));
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("Orphan removal suite");
        if (!JUnitTestCase.isJPA10()) {
            suite.addTest((Test)new OrphanRemovalJUnitTestCase("testSetup"));
            suite.addTest((Test)new OrphanRemovalJUnitTestCase("test12M"));
            suite.addTest((Test)new OrphanRemovalJUnitTestCase("test12MWithCascade"));
            suite.addTest((Test)new OrphanRemovalJUnitTestCase("test12MWithCascadeFromOR"));
            suite.addTest((Test)new OrphanRemovalJUnitTestCase("test12MFromExistingObject"));
            suite.addTest((Test)new OrphanRemovalJUnitTestCase("test12MFromExistingObjectModification"));
            suite.addTest((Test)new OrphanRemovalJUnitTestCase("test121WithCascade"));
            suite.addTest((Test)new OrphanRemovalJUnitTestCase("test121WithCascadeFromOR"));
            suite.addTest((Test)new OrphanRemovalJUnitTestCase("test121FromExistingObject"));
            suite.addTest((Test)new OrphanRemovalJUnitTestCase("test121FromExistingObjectModification"));
            suite.addTest((Test)new OrphanRemovalJUnitTestCase("test121IgnoredFromRemovedExistingObject"));
            suite.addTest((Test)new OrphanRemovalJUnitTestCase("testEmbeddedWithCascadeFromOR"));
            suite.addTest((Test)new OrphanRemovalJUnitTestCase("test121ChangeFromExistingObject"));
            suite.addTest((Test)new OrphanRemovalJUnitTestCase("test121WithCascadeRemoveFromOR"));
            suite.addTest((Test)new OrphanRemovalJUnitTestCase("test121WithNoCascadePersist"));
            suite.addTest((Test)new OrphanRemovalJUnitTestCase("test121WithNoCascadeMerge1"));
            suite.addTest((Test)new OrphanRemovalJUnitTestCase("test121WithNoCascadeMerge2"));
            suite.addTest((Test)new OrphanRemovalJUnitTestCase("test121WithNoCascadeMerge3"));
            suite.addTest((Test)new OrphanRemovalJUnitTestCase("testORInEmbeddedEntityWithToMany"));
        }
        return suite;
    }

    public void testEmbeddedWithCascadeFromOR() {
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            Vehicle vehicle = new Vehicle("GT-X");
            Chassis chassis1 = new Chassis(1L);
            vehicle.setChassis(chassis1);
            Wheel wheel1 = new Wheel(1L);
            chassis1.addWheel(wheel1);
            Tire tire1 = new Tire();
            tire1.setManufacturer("ACME");
            tire1.setType("Radial");
            wheel1.setTire(tire1);
            em.persist((Object)vehicle);
            Chassis chassis2 = new Chassis(2L);
            vehicle.setChassis(chassis2);
            this.commitTransaction(em);
            this.closeEntityManager(em);
            this.clearCache();
            em = this.createEntityManager();
            this.beginTransaction(em);
            Vehicle vehicleRead = (Vehicle)em.find(Vehicle.class, (Object)vehicle.getId());
            this.compareObjects(vehicle, vehicleRead);
            Chassis chassis2Read = (Chassis)em.find(Chassis.class, (Object)chassis2.getId());
            this.compareObjects(chassis2, chassis2Read);
            OrphanRemovalJUnitTestCase.assertNull((String)"Chassis 1 should not have been inserted", (Object)em.find(Chassis.class, (Object)chassis1.getId()));
            OrphanRemovalJUnitTestCase.assertNull((String)"Wheel 1 should not have been inserted", (Object)em.find(Wheel.class, (Object)wheel1.getId()));
            em.remove((Object)vehicleRead);
            em.remove((Object)chassis2Read);
            this.commitTransaction(em);
            this.closeEntityManager(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
    }

    public void test12M() {
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            Vehicle vehicle = new Vehicle("GT-X");
            Chassis chassis = new Chassis(1L);
            vehicle.setChassis(chassis);
            Wheel wheel1 = new Wheel(1L);
            Wheel wheel2 = new Wheel(2L);
            Wheel wheel3 = new Wheel(3L);
            Wheel wheel4 = new Wheel(4L);
            Wheel wheel5 = new Wheel(5L);
            wheel1.setTire(new Tire());
            wheel2.setTire(new Tire());
            wheel3.setTire(new Tire());
            wheel4.setTire(new Tire());
            wheel5.setTire(new Tire());
            chassis.addWheel(wheel1);
            chassis.addWheel(wheel2);
            chassis.addWheel(wheel3);
            chassis.addWheel(wheel4);
            chassis.addWheel(wheel5);
            em.persist((Object)vehicle);
            chassis.removeWheel(wheel5);
            this.commitTransaction(em);
            this.closeEntityManager(em);
            this.clearCache();
            em = this.createEntityManager();
            this.beginTransaction(em);
            Vehicle vehicleRead = (Vehicle)em.find(Vehicle.class, (Object)vehicle.getId());
            this.compareObjects(vehicle, vehicleRead);
            Chassis chassisRead = (Chassis)em.find(Chassis.class, (Object)chassis.getId());
            this.compareObjects(chassis, chassisRead);
            Wheel wheel1Read = (Wheel)em.find(Wheel.class, (Object)wheel1.getId());
            this.compareObjects(wheel1, wheel1Read);
            Wheel wheel2Read = (Wheel)em.find(Wheel.class, (Object)wheel2.getId());
            this.compareObjects(wheel2, wheel2Read);
            Wheel wheel3Read = (Wheel)em.find(Wheel.class, (Object)wheel3.getId());
            this.compareObjects(wheel3, wheel3Read);
            Wheel wheel4Read = (Wheel)em.find(Wheel.class, (Object)wheel4.getId());
            this.compareObjects(wheel4, wheel4Read);
            OrphanRemovalJUnitTestCase.assertNull((String)"Wheel5 should not be inserted", (Object)em.find(Wheel.class, (Object)wheel5.getId()));
            em.remove((Object)vehicleRead);
            em.remove((Object)chassisRead);
            em.remove((Object)wheel1Read);
            em.remove((Object)wheel2Read);
            em.remove((Object)wheel3Read);
            em.remove((Object)wheel4Read);
            this.commitTransaction(em);
            this.closeEntityManager(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
    }

    public void test12MFromExistingObject() {
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            Vehicle vehicle = new Vehicle("GT-X");
            Chassis chassis1 = new Chassis(1L);
            vehicle.setChassis(chassis1);
            Wheel wheel1 = new Wheel(1L);
            wheel1.setTire(new Tire());
            chassis1.addWheel(wheel1);
            Wheel wheel2 = new Wheel(2L);
            wheel2.setTire(new Tire());
            chassis1.addWheel(wheel2);
            em.persist((Object)vehicle);
            this.commitTransaction(em);
            this.closeEntityManager(em);
            this.clearCache();
            em = this.createEntityManager();
            this.beginTransaction(em);
            Vehicle vehicleRead = (Vehicle)em.find(Vehicle.class, (Object)vehicle.getId());
            this.compareObjects(vehicle, vehicleRead);
            Chassis chassisRead = vehicleRead.getChassis();
            chassisRead.setSerialNumber(74923402L);
            chassisRead.removeWheel(wheel1);
            chassisRead.removeWheel(wheel2);
            chassisRead.setWheels(null);
            this.commitTransaction(em);
            this.closeEntityManager(em);
            this.clearCache();
            em = this.createEntityManager();
            this.beginTransaction(em);
            Vehicle vehicleReadAgain = (Vehicle)em.find(Vehicle.class, (Object)vehicle.getId());
            OrphanRemovalJUnitTestCase.assertNull((String)"Wheel1 should have been removed", (Object)em.find(Wheel.class, (Object)wheel1.getId()));
            OrphanRemovalJUnitTestCase.assertNull((String)"Wheel2 should have been removed", (Object)em.find(Wheel.class, (Object)wheel2.getId()));
            em.remove((Object)vehicleReadAgain);
            this.commitTransaction(em);
            this.closeEntityManager(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
    }

    public void test12MFromExistingObjectModification() {
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            Vehicle vehicle = new Vehicle("GT-X");
            Chassis chassis1 = new Chassis(1L);
            vehicle.setChassis(chassis1);
            Wheel wheel1 = new Wheel(1L);
            Wheel wheel2 = new Wheel(2L);
            wheel1.setTire(new Tire());
            wheel2.setTire(new Tire());
            chassis1.addWheel(wheel1);
            chassis1.addWheel(wheel2);
            em.persist((Object)vehicle);
            this.commitTransaction(em);
            this.closeEntityManager(em);
            this.clearCache();
            em = this.createEntityManager();
            this.beginTransaction(em);
            Vehicle vehicleRead = (Vehicle)em.find(Vehicle.class, (Object)vehicle.getId());
            this.compareObjects(vehicle, vehicleRead);
            Chassis chassis = vehicleRead.getChassis();
            for (Wheel wheel : chassis.getWheels()) {
                wheel.setSerialNumber(wheel.getSerialNumber() + 10L);
            }
            this.commitTransaction(em);
            this.closeEntityManager(em);
            this.clearCache();
            em = this.createEntityManager();
            this.beginTransaction(em);
            Vehicle vehicleReadAgain = (Vehicle)em.find(Vehicle.class, (Object)vehicle.getId());
            this.compareObjects(vehicleRead, vehicleReadAgain);
            em.remove((Object)vehicleReadAgain);
            this.commitTransaction(em);
            this.closeEntityManager(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
    }

    public void test12MWithCascade() {
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            Vehicle vehicle = new Vehicle("GT-X");
            Engine engine = new Engine(123456789L);
            SparkPlug plug1 = new SparkPlug(1L);
            SparkPlug plug2 = new SparkPlug(2L);
            SparkPlug plug3 = new SparkPlug(3L);
            SparkPlug plug4 = new SparkPlug(4L);
            SparkPlug plug5 = new SparkPlug(5L);
            SparkPlug plug6 = new SparkPlug(6L);
            vehicle.setEngine(engine);
            engine.addSparkPlug(plug1);
            engine.addSparkPlug(plug2);
            engine.addSparkPlug(plug3);
            engine.addSparkPlug(plug4);
            engine.addSparkPlug(plug5);
            engine.addSparkPlug(plug6);
            em.persist((Object)engine);
            em.persist((Object)vehicle);
            engine.removeSparkPlug(plug3);
            engine.removeSparkPlug(plug5);
            this.commitTransaction(em);
            this.closeEntityManager(em);
            this.clearCache();
            em = this.createEntityManager();
            this.beginTransaction(em);
            Engine engineRead = (Engine)em.find(Engine.class, (Object)engine.getId());
            this.compareObjects(engine, engineRead);
            SparkPlug plug1Read = (SparkPlug)em.find(SparkPlug.class, (Object)plug1.getId());
            this.compareObjects(plug1, plug1Read);
            SparkPlug plug2Read = (SparkPlug)em.find(SparkPlug.class, (Object)plug2.getId());
            this.compareObjects(plug2, plug2Read);
            SparkPlug plug4Read = (SparkPlug)em.find(SparkPlug.class, (Object)plug4.getId());
            this.compareObjects(plug4, plug4Read);
            SparkPlug plug6Read = (SparkPlug)em.find(SparkPlug.class, (Object)plug6.getId());
            this.compareObjects(plug6, plug6Read);
            OrphanRemovalJUnitTestCase.assertNull((String)"SparkPlug3 should not be inserted", (Object)em.find(SparkPlug.class, (Object)plug3.getId()));
            OrphanRemovalJUnitTestCase.assertNull((String)"SparkPlug5 should not be inserted", (Object)em.find(SparkPlug.class, (Object)plug5.getId()));
            em.remove(em.find(Vehicle.class, (Object)vehicle.getId()));
            em.remove((Object)engineRead);
            em.remove((Object)plug1Read);
            em.remove((Object)plug2Read);
            em.remove((Object)plug4Read);
            em.remove((Object)plug6Read);
            this.commitTransaction(em);
            this.closeEntityManager(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
    }

    public void test12MWithCascadeFromOR() {
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            Vehicle vehicle = new Vehicle("GT-X");
            Chassis chassis = new Chassis(1L);
            vehicle.setChassis(chassis);
            Wheel wheel1 = new Wheel(1L);
            wheel1.setTire(new Tire());
            chassis.addWheel(wheel1);
            WheelNut wheelNut1 = new WheelNut();
            WheelNut wheelNut2 = new WheelNut();
            WheelNut wheelNut3 = new WheelNut();
            WheelNut wheelNut4 = new WheelNut();
            wheel1.addWheelNut(wheelNut1);
            wheel1.addWheelNut(wheelNut2);
            wheel1.addWheelNut(wheelNut3);
            wheel1.addWheelNut(wheelNut4);
            em.persist((Object)vehicle);
            WheelNut wheelNut5 = new WheelNut();
            WheelNut wheelNut6 = new WheelNut();
            wheel1.removeWheelNut(wheelNut3);
            wheel1.removeWheelNut(wheelNut4);
            wheel1.addWheelNut(wheelNut5);
            wheel1.addWheelNut(wheelNut6);
            Wheel wheel2 = new Wheel(2L);
            wheel2.setTire(new Tire());
            chassis.addWheel(wheel2);
            em.persist((Object)vehicle);
            wheel2.addWheelNut(wheelNut3);
            wheel2.addWheelNut(wheelNut4);
            this.commitTransaction(em);
            this.closeEntityManager(em);
            this.clearCache();
            em = this.createEntityManager();
            this.beginTransaction(em);
            WheelNut wheelNut3Read = (WheelNut)em.find(WheelNut.class, (Object)wheelNut3.getId());
            this.compareObjects(wheelNut3, wheelNut3Read);
            WheelNut wheelNut4Read = (WheelNut)em.find(WheelNut.class, (Object)wheelNut4.getId());
            this.compareObjects(wheelNut4, wheelNut4Read);
            Wheel wheel1Read = (Wheel)em.find(Wheel.class, (Object)wheel1.getId());
            this.compareObjects(wheel1, wheel1);
            Wheel wheel2Read = (Wheel)em.find(Wheel.class, (Object)wheel2.getId());
            this.compareObjects(wheel2, wheel2);
            em.remove(em.find(Vehicle.class, (Object)vehicle.getId()));
            for (WheelNut wheelNut : wheel1Read.getWheelNuts()) {
                em.remove((Object)wheelNut);
            }
            for (WheelNut wheelNut : wheel2Read.getWheelNuts()) {
                em.remove((Object)wheelNut);
            }
            this.commitTransaction(em);
            this.closeEntityManager(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
    }

    public void test121FromExistingObject() {
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            Vehicle vehicle = new Vehicle("GT-X");
            Chassis chassis1 = new Chassis(1L);
            vehicle.setChassis(chassis1);
            em.persist((Object)vehicle);
            this.commitTransaction(em);
            this.clearCache();
            this.beginTransaction(em);
            Vehicle vehicleToModify = (Vehicle)em.find(Vehicle.class, (Object)vehicle.getId());
            vehicleToModify.setModel("GT-X2");
            vehicleToModify.setChassis(null);
            this.commitTransaction(em);
            this.closeEntityManager(em);
            this.clearCache();
            em = this.createEntityManager();
            this.beginTransaction(em);
            Vehicle vehicleRead = (Vehicle)em.find(Vehicle.class, (Object)vehicle.getId());
            this.compareObjects(vehicleToModify, vehicleRead);
            OrphanRemovalJUnitTestCase.assertNull((String)"Chassis1 should have been removed", (Object)em.find(Chassis.class, (Object)chassis1.getId()));
            em.remove((Object)vehicleRead);
            this.commitTransaction(em);
            this.closeEntityManager(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
    }

    public void test121FromExistingObjectModification() {
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            Vehicle vehicle = new Vehicle("GT-X");
            Chassis chassis1 = new Chassis(1L);
            vehicle.setChassis(chassis1);
            em.persist((Object)vehicle);
            this.commitTransaction(em);
            this.beginTransaction(em);
            Vehicle vehicleToModify = (Vehicle)em.find(Vehicle.class, (Object)vehicle.getId());
            vehicleToModify.setModel("GT-X2");
            em.persist((Object)vehicleToModify);
            Chassis chassis2 = new Chassis(2L);
            vehicleToModify.setChassis(chassis2);
            this.commitTransaction(em);
            this.closeEntityManager(em);
            this.clearCache();
            em = this.createEntityManager();
            this.beginTransaction(em);
            Vehicle vehicleRead = (Vehicle)em.find(Vehicle.class, (Object)vehicle.getId());
            this.compareObjects(vehicleToModify, vehicleRead);
            Chassis chassis2Read = (Chassis)em.find(Chassis.class, (Object)chassis2.getId());
            this.compareObjects(chassis2, chassis2Read);
            OrphanRemovalJUnitTestCase.assertNull((String)"Chassis1 should have been removed", (Object)em.find(Chassis.class, (Object)chassis1.getId()));
            em.remove((Object)vehicleRead);
            em.remove((Object)chassis2Read);
            this.commitTransaction(em);
            this.closeEntityManager(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
    }

    public void test121IgnoredFromRemovedExistingObject() {
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            Vehicle vehicle = new Vehicle("GT-X");
            em.persist((Object)vehicle);
            Chassis chassis = new Chassis(1L);
            em.persist((Object)chassis);
            this.commitTransaction(em);
            this.clearCache();
            this.beginTransaction(em);
            Vehicle vehicleToRemove = (Vehicle)em.find(Vehicle.class, (Object)vehicle.getId());
            em.remove((Object)vehicleToRemove);
            em.flush();
            vehicleToRemove.setChassis((Chassis)em.find(Chassis.class, (Object)chassis.getId()));
            this.commitTransaction(em);
            this.closeEntityManager(em);
            this.clearCache();
            em = this.createEntityManager();
            this.beginTransaction(em);
            Chassis chassisRead = (Chassis)em.find(Chassis.class, (Object)chassis.getId());
            OrphanRemovalJUnitTestCase.assertNotNull((String)"Chassis should not have been removed", (Object)chassisRead);
            OrphanRemovalJUnitTestCase.assertNull((String)"Vehicle should have been removed", (Object)em.find(Vehicle.class, (Object)vehicle.getId()));
            em.remove((Object)chassisRead);
            this.commitTransaction(em);
            this.closeEntityManager(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
    }

    public void test121WithCascade() {
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            Vehicle vehicle = new Vehicle("GT-X");
            Chassis chassis1 = new Chassis(1L);
            vehicle.setChassis(chassis1);
            em.persist((Object)vehicle);
            Chassis chassis2 = new Chassis(2L);
            vehicle.setChassis(chassis2);
            this.commitTransaction(em);
            this.closeEntityManager(em);
            this.clearCache();
            em = this.createEntityManager();
            this.beginTransaction(em);
            Vehicle vehicleRead = (Vehicle)em.find(Vehicle.class, (Object)vehicle.getId());
            this.compareObjects(vehicle, vehicleRead);
            Chassis chassis2Read = (Chassis)em.find(Chassis.class, (Object)chassis2.getId());
            this.compareObjects(chassis2, chassis2Read);
            OrphanRemovalJUnitTestCase.assertNull((String)"Chassis1 should not be inserted", (Object)em.find(Chassis.class, (Object)chassis1.getId()));
            em.remove((Object)vehicleRead);
            em.remove((Object)chassis2Read);
            this.commitTransaction(em);
            this.closeEntityManager(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
    }

    public void test121WithCascadeRemoveFromOR() {
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            Vehicle vehicle = new Vehicle("GT-X");
            Engine engine = new Engine(123456789L);
            em.persist((Object)vehicle);
            em.persist((Object)engine);
            vehicle.setEngine(engine);
            em.remove((Object)vehicle);
            OrphanRemovalJUnitTestCase.assertFalse((boolean)em.contains((Object)engine));
            this.commitTransaction(em);
            this.closeEntityManager(em);
            this.clearCache();
            em = this.createEntityManager();
            OrphanRemovalJUnitTestCase.assertNull((String)"Vehicle should not be inserted", (Object)em.find(Vehicle.class, (Object)vehicle.getId()));
            OrphanRemovalJUnitTestCase.assertNull((String)"Engine should not be inserted", (Object)em.find(Engine.class, (Object)engine.getId()));
            this.closeEntityManager(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
    }

    public void test121WithNoCascadeMerge1() {
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            Vehicle vehicle = new Vehicle("GT-X");
            Engine engine = new Engine(123456789L);
            vehicle.setEngine(engine);
            vehicle = (Vehicle)em.merge((Object)vehicle);
            engine = vehicle.getEngine();
            this.commitTransaction(em);
            this.closeEntityManager(em);
            this.clearCache();
            em = this.createEntityManager();
            this.beginTransaction(em);
            Vehicle vehicleRead = (Vehicle)em.find(Vehicle.class, (Object)vehicle.getId());
            this.compareObjects(vehicle, vehicleRead);
            Engine engineRead = (Engine)em.find(Engine.class, (Object)engine.getId());
            this.compareObjects(engine, engineRead);
            em.remove((Object)vehicleRead);
            em.remove((Object)engineRead);
            this.commitTransaction(em);
            this.closeEntityManager(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
    }

    public void test121WithNoCascadeMerge2() {
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            Vehicle vehicle = new Vehicle("GT-X");
            em.persist((Object)vehicle);
            this.commitTransaction(em);
            this.closeEntityManager(em);
            this.clearCache();
            em = this.createEntityManager();
            this.beginTransaction(em);
            Engine engine = new Engine(123456789L);
            vehicle.setEngine(engine);
            vehicle = (Vehicle)em.merge((Object)vehicle);
            engine = vehicle.getEngine();
            this.commitTransaction(em);
            this.closeEntityManager(em);
            this.clearCache();
            em = this.createEntityManager();
            this.beginTransaction(em);
            Vehicle vehicleRead = (Vehicle)em.find(Vehicle.class, (Object)vehicle.getId());
            this.compareObjects(vehicle, vehicleRead);
            Engine engineRead = (Engine)em.find(Engine.class, (Object)engine.getId());
            this.compareObjects(engine, engineRead);
            em.remove((Object)vehicleRead);
            em.remove((Object)engineRead);
            this.commitTransaction(em);
            this.closeEntityManager(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
    }

    public void test121WithNoCascadeMerge3() {
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            Vehicle vehicle = new Vehicle("GT-X");
            Engine engine = new Engine(123456789L);
            vehicle.setEngine(engine);
            em.persist((Object)vehicle);
            em.persist((Object)engine);
            this.commitTransaction(em);
            this.closeEntityManager(em);
            this.clearCache();
            em = this.createEntityManager();
            this.beginTransaction(em);
            vehicle.setModel("GT-Z");
            engine.setSerialNumber(123456789L);
            em.merge((Object)vehicle);
            this.commitTransaction(em);
            this.closeEntityManager(em);
            this.clearCache();
            em = this.createEntityManager();
            this.beginTransaction(em);
            Vehicle vehicleRead = (Vehicle)em.find(Vehicle.class, (Object)vehicle.getId());
            OrphanRemovalJUnitTestCase.assertTrue((String)"The vehicle had the wrong model number", (boolean)vehicleRead.getModel().equals("GT-Z"));
            Engine engineRead = (Engine)em.find(Engine.class, (Object)engine.getId());
            OrphanRemovalJUnitTestCase.assertTrue((String)"The engine had the wrong serial number", (engine.getSerialNumber() == 123456789L ? 1 : 0) != 0);
            em.remove((Object)vehicleRead);
            em.remove((Object)engineRead);
            this.commitTransaction(em);
            this.closeEntityManager(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test121WithNoCascadePersist() {
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            Vehicle vehicle = new Vehicle("GT-X");
            Engine engine = new Engine(123456789L);
            vehicle.setEngine(engine);
            Exception exception = null;
            try {
                em.persist((Object)vehicle);
                this.commitTransaction(em);
            }
            catch (Exception e) {
                exception = e;
            }
            finally {
                this.closeEntityManager(em);
            }
            OrphanRemovalJUnitTestCase.assertNotNull((String)"No exception was caught when one was expected", (Object)exception);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
    }

    public void test121WithCascadeFromOR() {
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            Vehicle vehicle = new Vehicle("GT-X");
            Chassis chassis = new Chassis(1L);
            vehicle.setChassis(chassis);
            Wheel wheel1 = new Wheel(1L);
            WheelRim wheelRim1 = new WheelRim();
            wheel1.setWheelRim(wheelRim1);
            chassis.addWheel(wheel1);
            Wheel wheel2 = new Wheel(2L);
            WheelRim wheelRim2 = new WheelRim();
            wheel2.setWheelRim(wheelRim2);
            chassis.addWheel(wheel2);
            Wheel wheel3 = new Wheel(3L);
            WheelRim wheelRim3 = new WheelRim();
            wheel3.setWheelRim(wheelRim3);
            chassis.addWheel(wheel3);
            Wheel wheel4 = new Wheel(4L);
            WheelRim wheelRim4 = new WheelRim();
            wheel4.setWheelRim(wheelRim4);
            chassis.addWheel(wheel4);
            em.persist((Object)vehicle);
            vehicle.setChassis(null);
            this.commitTransaction(em);
            this.closeEntityManager(em);
            this.clearCache();
            em = this.createEntityManager();
            this.beginTransaction(em);
            Object wheelRim1Read = em.find(WheelRim.class, (Object)wheelRim1.getId());
            this.compareObjects(wheelRim1, wheelRim1Read);
            Object wheelRim2Read = em.find(WheelRim.class, (Object)wheelRim2.getId());
            this.compareObjects(wheelRim2, wheelRim2Read);
            Object wheelRim3Read = em.find(WheelRim.class, (Object)wheelRim3.getId());
            this.compareObjects(wheelRim3, wheelRim3Read);
            Object wheelRim4Read = em.find(WheelRim.class, (Object)wheelRim4.getId());
            this.compareObjects(wheelRim4, wheelRim4Read);
            Vehicle vehicleRead = (Vehicle)em.find(Vehicle.class, (Object)vehicle.getId());
            this.compareObjects(vehicle, vehicleRead);
            OrphanRemovalJUnitTestCase.assertNull((String)"Wheel1 should not be inserted", (Object)em.find(Wheel.class, (Object)wheel1.getId()));
            OrphanRemovalJUnitTestCase.assertNull((String)"Wheel2 should not be inserted", (Object)em.find(Wheel.class, (Object)wheel2.getId()));
            OrphanRemovalJUnitTestCase.assertNull((String)"Wheel3 should not be inserted", (Object)em.find(Wheel.class, (Object)wheel3.getId()));
            OrphanRemovalJUnitTestCase.assertNull((String)"Wheel4 should not be inserted", (Object)em.find(Wheel.class, (Object)wheel4.getId()));
            OrphanRemovalJUnitTestCase.assertNull((String)"Chassis should not be inserted", (Object)em.find(Chassis.class, (Object)chassis.getId()));
            em.remove((Object)vehicleRead);
            em.remove(wheelRim1Read);
            em.remove(wheelRim2Read);
            em.remove(wheelRim3Read);
            em.remove(wheelRim4Read);
            this.commitTransaction(em);
            this.closeEntityManager(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test121ChangeFromExistingObject() {
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            Vehicle vehicle = new Vehicle("GT-X7");
            Chassis chassis = new Chassis(1234567L);
            vehicle.setChassis(chassis);
            em.persist((Object)vehicle);
            this.commitTransaction(em);
            this.closeEntityManager(em);
            em = this.createEntityManager();
            this.beginTransaction(em);
            Vehicle vehicleRead = (Vehicle)em.find(Vehicle.class, (Object)vehicle.getId());
            long newSerialNumber = 7654321L;
            vehicleRead.getChassis().setSerialNumber(newSerialNumber);
            em.persist((Object)vehicleRead);
            this.commitTransaction(em);
            this.closeEntityManager(em);
            this.clearCache();
            em = this.createEntityManager();
            this.beginTransaction(em);
            Vehicle vehicleReadAgain = (Vehicle)em.find(Vehicle.class, (Object)vehicle.getId());
            try {
                OrphanRemovalJUnitTestCase.assertNotNull((String)"Vehicle should have been inserted", (Object)vehicleReadAgain);
                long serialNumberFromDatabase = vehicleReadAgain.getChassis().getSerialNumber();
                OrphanRemovalJUnitTestCase.assertEquals((String)"Chassis serial number should have been changed on the DB", (long)newSerialNumber, (long)serialNumberFromDatabase);
            }
            finally {
                em.remove((Object)vehicleReadAgain.getChassis());
                em.remove((Object)vehicleReadAgain);
                this.commitTransaction(em);
                this.closeEntityManager(em);
            }
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testORInEmbeddedEntityWithToMany() {
        EntityManager em = this.createEntityManager();
        Wheel wheel1 = new Wheel();
        TireDetail detail = new TireDetail();
        try {
            this.beginTransaction(em);
            Tire tire1 = new Tire();
            tire1.setManufacturer("ACME");
            tire1.setType("Radial");
            wheel1.setTire(tire1);
            detail.setTireId(1);
            detail.setDetail("Width:215");
            HashSet<TireDetail> list = new HashSet<TireDetail>();
            list.add(detail);
            tire1.setTireDetails(list);
            wheel1.setTire(tire1);
            em.persist((Object)wheel1);
            this.commitTransaction(em);
            em.clear();
            this.beginTransaction(em);
            wheel1 = (Wheel)em.getReference(Wheel.class, (Object)wheel1.getId());
            OrphanRemovalJUnitTestCase.assertNotNull((Object)wheel1);
            wheel1.setTire(new Tire());
            em.merge((Object)wheel1);
            this.commitTransaction(em);
        }
        catch (Throwable t) {
            OrphanRemovalJUnitTestCase.fail((String)t.getMessage());
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.beginTransaction(em);
            wheel1 = (Wheel)em.find(Wheel.class, (Object)wheel1.getId());
            if (wheel1 != null) {
                em.remove((Object)wheel1);
            }
            this.commitTransaction(em);
            this.closeEntityManager(em);
        }
    }

    public void testSetup() {
        new OrphanRemovalModelTableCreator().replaceTables((DatabaseSession)JUnitTestCase.getServerSession());
        this.clearCache();
    }
}

