/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.xml.advanced.fetchgroup;

import jakarta.persistence.EntityManager;
import java.lang.reflect.Field;
import java.util.HashMap;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.FetchGroupManager;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.xml.advanced.fetchgroup.AdvancedFetchGroupTableCreator;
import org.eclipse.persistence.testing.models.jpa.xml.advanced.fetchgroup.ChestProtector;
import org.eclipse.persistence.testing.models.jpa.xml.advanced.fetchgroup.GoalieGear;
import org.eclipse.persistence.testing.models.jpa.xml.advanced.fetchgroup.HockeyGear;
import org.eclipse.persistence.testing.models.jpa.xml.advanced.fetchgroup.Pads;

public class EntityMappingsFetchGroupJunitTest
extends JUnitTestCase {
    private String m_persistenceUnit;
    private static Integer padsId;
    private static Integer chestProtectorId;

    public EntityMappingsFetchGroupJunitTest() {
    }

    public EntityMappingsFetchGroupJunitTest(String name) {
        super(name);
    }

    public EntityMappingsFetchGroupJunitTest(String name, String persistenceUnit) {
        super(name);
        this.m_persistenceUnit = persistenceUnit;
    }

    public void setUp() {
        EntityMappingsFetchGroupJunitTest.clearCache((String)this.m_persistenceUnit);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("EntityMappingsFetchGroupJunitTest");
        suite.addTest((Test)new EntityMappingsFetchGroupJunitTest("testSetup", "extended-advanced"));
        suite.addTest((Test)new EntityMappingsFetchGroupJunitTest("testVerifyFetchGroups", "extended-advanced"));
        suite.addTest((Test)new EntityMappingsFetchGroupJunitTest("testCreateHockeyGear", "extended-advanced"));
        suite.addTest((Test)new EntityMappingsFetchGroupJunitTest("testFetchGroupOnPads", "extended-advanced"));
        suite.addTest((Test)new EntityMappingsFetchGroupJunitTest("testFetchGroupOnChestProtector", "extended-advanced"));
        suite.addTest((Test)new EntityMappingsFetchGroupJunitTest("testFetchGroupOnPadsFromInheritanceParent", "extended-advanced"));
        return suite;
    }

    public void testSetup() {
        new AdvancedFetchGroupTableCreator().replaceTables((DatabaseSession)JUnitTestCase.getServerSession((String)this.m_persistenceUnit));
        EntityMappingsFetchGroupJunitTest.clearCache((String)this.m_persistenceUnit);
    }

    public void testVerifyFetchGroups() {
        if (EntityMappingsFetchGroupJunitTest.isWeavingEnabled((String)this.m_persistenceUnit)) {
            ClassDescriptor hockeyGearDescriptor = EntityMappingsFetchGroupJunitTest.getServerSession((String)this.m_persistenceUnit).getDescriptor(HockeyGear.class);
            FetchGroupManager hockeyGearFetchGroupManager = hockeyGearDescriptor.getFetchGroupManager();
            EntityMappingsFetchGroupJunitTest.assertTrue((String)"Wrong number of fetch groups for HockeyGear", (hockeyGearFetchGroupManager.getFetchGroups().size() == 1 ? 1 : 0) != 0);
            EntityMappingsFetchGroupJunitTest.assertNotNull((String)"The 'MSRP' fetch group was not found for HockeyGear", (Object)hockeyGearFetchGroupManager.getFetchGroup("MSRP"));
            ClassDescriptor padsDescriptor = EntityMappingsFetchGroupJunitTest.getServerSession((String)this.m_persistenceUnit).getDescriptor(Pads.class);
            FetchGroupManager padsFetchGroupManager = padsDescriptor.getFetchGroupManager();
            EntityMappingsFetchGroupJunitTest.assertTrue((String)"Wrong number of fetch groups for Pads", (padsFetchGroupManager.getFetchGroups().size() == 3 ? 1 : 0) != 0);
            EntityMappingsFetchGroupJunitTest.assertNotNull((String)"The 'HeightAndWidth' fetch group was not found for Pads", (Object)padsFetchGroupManager.getFetchGroup("HeightAndWidth"));
            EntityMappingsFetchGroupJunitTest.assertNotNull((String)"The 'Weight' fetch group was not found for Pads", (Object)padsFetchGroupManager.getFetchGroup("Weight"));
            EntityMappingsFetchGroupJunitTest.assertNotNull((String)"The 'AgeGroup' fetch group was not found for Pads", (Object)padsFetchGroupManager.getFetchGroup("AgeGroup"));
            ClassDescriptor chestProtectorDescriptor = EntityMappingsFetchGroupJunitTest.getServerSession((String)this.m_persistenceUnit).getDescriptor(ChestProtector.class);
            FetchGroupManager chestProtectorFetchGroupManager = chestProtectorDescriptor.getFetchGroupManager();
            EntityMappingsFetchGroupJunitTest.assertTrue((String)"Wrong number of fetch groups for ChestProtector", (chestProtectorFetchGroupManager.getFetchGroups().size() == 1 ? 1 : 0) != 0);
            EntityMappingsFetchGroupJunitTest.assertNotNull((String)"The 'AgeGroup' fetch group was not found for ChestProtector", (Object)chestProtectorFetchGroupManager.getFetchGroup("AgeGroup"));
        }
    }

    public void testCreateHockeyGear() {
        if (EntityMappingsFetchGroupJunitTest.isWeavingEnabled((String)this.m_persistenceUnit)) {
            EntityManager em = EntityMappingsFetchGroupJunitTest.createEntityManager((String)this.m_persistenceUnit);
            this.beginTransaction(em);
            try {
                Pads pads = new Pads();
                pads.setAgeGroup(GoalieGear.AgeGroup.SENIOR);
                pads.setDescription("Louisville TPS");
                pads.setHeight(Double.valueOf(35.5));
                pads.setMsrp(Double.valueOf(999.99));
                pads.setWeight(Double.valueOf(4.9));
                pads.setWidth(Double.valueOf(11.0));
                em.persist((Object)pads);
                ChestProtector chestProtector = new ChestProtector();
                chestProtector.setAgeGroup(GoalieGear.AgeGroup.INTERMEDIATE);
                chestProtector.setDescription("RBK Premier");
                chestProtector.setMsrp(Double.valueOf(599.99));
                chestProtector.setSize("Large");
                em.persist((Object)chestProtector);
                this.commitTransaction(em);
                padsId = pads.getSerialNumber();
                chestProtectorId = chestProtector.getSerialNumber();
            }
            catch (RuntimeException e) {
                if (this.isTransactionActive(em)) {
                    this.rollbackTransaction(em);
                }
                this.closeEntityManager(em);
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFetchGroupOnPads() {
        if (EntityMappingsFetchGroupJunitTest.isWeavingEnabled((String)this.m_persistenceUnit)) {
            EntityManager em = EntityMappingsFetchGroupJunitTest.createEntityManager((String)this.m_persistenceUnit);
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("eclipselink.fetch-group.name", "HeightAndWidth");
            Class<Pads> PadsClass = Pads.class;
            Pads pads = (Pads)em.find(PadsClass, (Object)padsId, properties);
            try {
                this.verifyFetchedField(PadsClass.getDeclaredField("height"), pads, 35.5);
                this.verifyFetchedField(PadsClass.getDeclaredField("width"), pads, 11.0);
                this.verifyNonFetchedField(PadsClass.getDeclaredField("weight"), pads);
                this.verifyNonFetchedField(PadsClass.getField("ageGroup"), pads);
                this.verifyNonFetchedField(PadsClass.getField("description"), pads);
                this.verifyNonFetchedField(PadsClass.getField("msrp"), pads);
            }
            catch (Exception e) {
                EntityMappingsFetchGroupJunitTest.fail((String)("Error verifying field content: " + e.getMessage()));
            }
            finally {
                this.closeEntityManager(em);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFetchGroupOnChestProtector() {
        if (EntityMappingsFetchGroupJunitTest.isWeavingEnabled((String)this.m_persistenceUnit)) {
            EntityManager em = EntityMappingsFetchGroupJunitTest.createEntityManager((String)this.m_persistenceUnit);
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("eclipselink.fetch-group.name", "AgeGroup");
            Class<ChestProtector> ChestProtecterClass = ChestProtector.class;
            ChestProtector chestProtector = (ChestProtector)em.find(ChestProtecterClass, (Object)chestProtectorId, properties);
            try {
                this.verifyFetchedField(ChestProtecterClass.getField("ageGroup"), chestProtector, GoalieGear.AgeGroup.INTERMEDIATE);
                this.verifyNonFetchedField(ChestProtecterClass.getField("description"), chestProtector);
                this.verifyNonFetchedField(ChestProtecterClass.getField("msrp"), chestProtector);
                this.verifyNonFetchedField(ChestProtecterClass.getDeclaredField("size"), chestProtector);
            }
            catch (Exception e) {
                EntityMappingsFetchGroupJunitTest.fail((String)("Error verifying field content: " + e.getMessage()));
            }
            finally {
                this.closeEntityManager(em);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFetchGroupOnPadsFromInheritanceParent() {
        if (EntityMappingsFetchGroupJunitTest.isWeavingEnabled((String)this.m_persistenceUnit)) {
            EntityManager em = EntityMappingsFetchGroupJunitTest.createEntityManager((String)this.m_persistenceUnit);
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("eclipselink.fetch-group.name", "MSRP");
            Class<Pads> PadsClass = Pads.class;
            Pads pads = (Pads)em.find(PadsClass, (Object)padsId, properties);
            try {
                this.verifyFetchedField(PadsClass.getField("msrp"), pads, 999.99);
                this.verifyNonFetchedField(PadsClass.getDeclaredField("height"), pads);
                this.verifyNonFetchedField(PadsClass.getDeclaredField("width"), pads);
                this.verifyNonFetchedField(PadsClass.getDeclaredField("weight"), pads);
                this.verifyNonFetchedField(PadsClass.getField("ageGroup"), pads);
                this.verifyNonFetchedField(PadsClass.getField("description"), pads);
            }
            catch (Exception e) {
                EntityMappingsFetchGroupJunitTest.fail((String)("Error verifying field content: " + e.getMessage()));
            }
            finally {
                this.closeEntityManager(em);
            }
        }
    }

    protected void verifyFetchedField(Field field, Object obj, Object value) {
        try {
            field.setAccessible(true);
            EntityMappingsFetchGroupJunitTest.assertTrue((String)("The field [" + field.getName() + "] was not fetched"), (boolean)field.get(obj).equals(value));
        }
        catch (IllegalAccessException e) {
            EntityMappingsFetchGroupJunitTest.fail((String)("Error verifying field content: " + e.getMessage()));
        }
    }

    protected void verifyNonFetchedField(Field field, Object obj) {
        try {
            field.setAccessible(true);
            EntityMappingsFetchGroupJunitTest.assertTrue((String)("The field [" + field.getName() + "] was fetched"), (field.get(obj) == null ? 1 : 0) != 0);
        }
        catch (IllegalAccessException e) {
            EntityMappingsFetchGroupJunitTest.fail((String)("Error verifying field content: " + e.getMessage()));
        }
    }
}

