/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.xml.metadatacomplete;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.sessions.server.ServerSession;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.xml.metadatacomplete.Drywall;
import org.eclipse.persistence.testing.models.jpa.xml.metadatacomplete.Hammer;
import org.eclipse.persistence.testing.models.jpa.xml.metadatacomplete.Screwdriver;

public class EntityMappingsMetadataCompleteJUnitTestCase
extends JUnitTestCase {
    private String m_persistenceUnit;

    public EntityMappingsMetadataCompleteJUnitTestCase() {
    }

    public EntityMappingsMetadataCompleteJUnitTestCase(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("Metadata complete model");
        suite.addTest((Test)new EntityMappingsMetadataCompleteJUnitTestCase("testMetadataComplete"));
        suite.addTest((Test)new EntityMappingsMetadataCompleteJUnitTestCase("testXMLMappingMetadataComplete"));
        return suite;
    }

    public void testMetadataComplete() {
        ServerSession session = EntityMappingsMetadataCompleteJUnitTestCase.getServerSession((String)"METADATA_COMPLETE");
        ClassDescriptor descriptor = session.getDescriptor(Hammer.class);
        EntityMappingsMetadataCompleteJUnitTestCase.assertFalse((String)"The table annotation from the Hammer class was used.", (boolean)descriptor.getTableName().equals("IGNORE_HAMMER_TABLE"));
        EntityMappingsMetadataCompleteJUnitTestCase.assertNotNull((String)"The 'weight' attribute from the Hammer class was NOT mapped.", (Object)descriptor.getMappingForAttributeName("weight"));
        EntityMappingsMetadataCompleteJUnitTestCase.assertNotNull((String)"The 'color' attribute from the Hammer class was NOT mapped", (Object)descriptor.getMappingForAttributeName("color"));
        EntityMappingsMetadataCompleteJUnitTestCase.assertFalse((String)"The 'color' attribute used a @Column specification despite a metadata-complete setting of true.", (boolean)descriptor.getMappingForAttributeName("color").getField().getName().equals("IGNORED_COLOR"));
        EntityMappingsMetadataCompleteJUnitTestCase.assertNotNull((String)"The 'id' attribute from the Tool class was NOT mapped.", (Object)descriptor.getMappingForAttributeName("id"));
        EntityMappingsMetadataCompleteJUnitTestCase.assertNotNull((String)"The 'brand' attribute from the Tool class was NOT mapped.", (Object)descriptor.getMappingForAttributeName("brand"));
        EntityMappingsMetadataCompleteJUnitTestCase.assertFalse((String)"The 'brand' attribute used a @Column specification despite a metadata-complete setting of true.", (boolean)descriptor.getMappingForAttributeName("brand").getField().getName().equals("IGNORED_BRAND"));
        descriptor = session.getDescriptor(Screwdriver.class);
        EntityMappingsMetadataCompleteJUnitTestCase.assertNotNull((String)"The 'type' attribute from the Screwdriver class was NOT mapped.", (Object)descriptor.getMappingForAttributeName("type"));
        EntityMappingsMetadataCompleteJUnitTestCase.assertNotNull((String)"The 'style' attribute from the Screwdriver class was NOT mapped.", (Object)descriptor.getMappingForAttributeName("style"));
        EntityMappingsMetadataCompleteJUnitTestCase.assertTrue((String)"The 'style' attribute did NOT used a @Column specification.", (boolean)descriptor.getMappingForAttributeName("style").getField().getName().equals("IN_STYLE"));
        EntityMappingsMetadataCompleteJUnitTestCase.assertNotNull((String)"The 'id' attribute from the Tool class was NOT mapped.", (Object)descriptor.getMappingForAttributeName("id"));
        EntityMappingsMetadataCompleteJUnitTestCase.assertNotNull((String)"The 'brand' attribute from the Tool class was NOT mapped.", (Object)descriptor.getMappingForAttributeName("brand"));
        EntityMappingsMetadataCompleteJUnitTestCase.assertFalse((String)"The 'brand' attribute used a @Column specification despite a metadata-complete setting of true.", (boolean)descriptor.getMappingForAttributeName("brand").getField().getName().equals("IGNORED_BRAND"));
        descriptor = session.getDescriptor(Drywall.class);
        EntityMappingsMetadataCompleteJUnitTestCase.assertNotNull((String)"The 'length' attribute from the Drywall class was NOT mapped", (Object)descriptor.getMappingForAttributeName("length"));
        EntityMappingsMetadataCompleteJUnitTestCase.assertFalse((String)"The 'length' attribute used a @Column specification despite a metadata-complete setting of true.", (boolean)descriptor.getMappingForAttributeName("length").getField().getName().equals("IGNORED_LENGTH"));
        EntityMappingsMetadataCompleteJUnitTestCase.assertNotNull((String)"The 'width' attribute from the Drywall class was NOT mapped", (Object)descriptor.getMappingForAttributeName("width"));
        EntityMappingsMetadataCompleteJUnitTestCase.assertFalse((String)"The 'width' attribute used a @Column specification despite a metadata-complete setting of true.", (boolean)descriptor.getMappingForAttributeName("width").getField().getName().equals("IGNORED_WIDTH"));
        EntityMappingsMetadataCompleteJUnitTestCase.assertNotNull((String)"The 'id' attribute from the Material class was NOT mapped.", (Object)descriptor.getMappingForAttributeName("id"));
        EntityMappingsMetadataCompleteJUnitTestCase.assertNotNull((String)"The 'cost' attribute from the Meterial class was NOT mapped.", (Object)descriptor.getMappingForAttributeName("cost"));
        EntityMappingsMetadataCompleteJUnitTestCase.assertTrue((String)"The 'cost' attribute did NOT used a @Column specification.", (boolean)descriptor.getMappingForAttributeName("cost").getField().getName().equals("MUCHO_EXPENSIVE"));
    }

    public void testXMLMappingMetadataComplete() {
        ServerSession session = EntityMappingsMetadataCompleteJUnitTestCase.getServerSession((String)"XML_MAPPING_METADATA_COMPLETE");
        ClassDescriptor descriptor = session.getDescriptor(Hammer.class);
        EntityMappingsMetadataCompleteJUnitTestCase.assertFalse((String)"The table annotation from the Hammer class was used.", (boolean)descriptor.getTableName().equals("IGNORE_HAMMER_TABLE"));
        EntityMappingsMetadataCompleteJUnitTestCase.assertNotNull((String)"The 'weight' attribute from the Hammer class was NOT mapped.", (Object)descriptor.getMappingForAttributeName("weight"));
        EntityMappingsMetadataCompleteJUnitTestCase.assertNotNull((String)"The 'color' attribute from the Hammer class was NOT mapped.", (Object)descriptor.getMappingForAttributeName("color"));
        EntityMappingsMetadataCompleteJUnitTestCase.assertFalse((String)"The 'color' mapping used a @Column specification despite an xml-mapping-metadata-complete setting.", (boolean)descriptor.getMappingForAttributeName("color").getField().getName().equals("IGNORED_COLOR"));
        EntityMappingsMetadataCompleteJUnitTestCase.assertNotNull((String)"The 'id' attribute from the Tool class was NOT mapped.", (Object)descriptor.getMappingForAttributeName("id"));
        EntityMappingsMetadataCompleteJUnitTestCase.assertNotNull((String)"The 'brand' attribute from the Tool class was NOT mapped.", (Object)descriptor.getMappingForAttributeName("brand"));
        EntityMappingsMetadataCompleteJUnitTestCase.assertFalse((String)"The 'brand' attribute used a @Column specification despite an xml-mapping-metadata-complete setting.", (boolean)descriptor.getMappingForAttributeName("brand").getField().getName().equals("IGNORED_BRAND"));
        descriptor = session.getDescriptor(Screwdriver.class);
        EntityMappingsMetadataCompleteJUnitTestCase.assertNotNull((String)"The 'type' attribute from the Screwdriver class was NOT mapped.", (Object)descriptor.getMappingForAttributeName("type"));
        EntityMappingsMetadataCompleteJUnitTestCase.assertNotNull((String)"The 'style' attribute from the Screwdriver class was NOT mapped.", (Object)descriptor.getMappingForAttributeName("style"));
        EntityMappingsMetadataCompleteJUnitTestCase.assertFalse((String)"The 'style' attribute used a @Column specification despite an xml-mapping-metadata-complete setting.", (boolean)descriptor.getMappingForAttributeName("style").getField().getName().equals("IN_STYLE"));
        EntityMappingsMetadataCompleteJUnitTestCase.assertNotNull((String)"The 'id' attribute from the Tool class was NOT mapped.", (Object)descriptor.getMappingForAttributeName("id"));
        EntityMappingsMetadataCompleteJUnitTestCase.assertNotNull((String)"The 'brand' attribute from the Tool class was NOT mapped.", (Object)descriptor.getMappingForAttributeName("brand"));
        EntityMappingsMetadataCompleteJUnitTestCase.assertFalse((String)"The 'brand' attribute used a @Column specification despite an xml-mapping-metadata-complete setting.", (boolean)descriptor.getMappingForAttributeName("brand").getField().getName().equals("IGNORED_BRAND"));
        descriptor = session.getDescriptor(Drywall.class);
        EntityMappingsMetadataCompleteJUnitTestCase.assertNotNull((String)"The 'length' attribute from the Drywall class was NOT mapped", (Object)descriptor.getMappingForAttributeName("length"));
        EntityMappingsMetadataCompleteJUnitTestCase.assertFalse((String)"The 'length' attribute used a @Column specification despite an xml-mapping-metadata-complete setting.", (boolean)descriptor.getMappingForAttributeName("length").getField().getName().equals("IGNORED_LENGTH"));
        EntityMappingsMetadataCompleteJUnitTestCase.assertNotNull((String)"The 'width' attribute from the Drywall class was NOT mapped", (Object)descriptor.getMappingForAttributeName("width"));
        EntityMappingsMetadataCompleteJUnitTestCase.assertFalse((String)"The 'width' attribute used a @Column specification despite an xml-mapping-metadata-complete setting.", (boolean)descriptor.getMappingForAttributeName("width").getField().getName().equals("IGNORED_WIDTH"));
        EntityMappingsMetadataCompleteJUnitTestCase.assertNotNull((String)"The 'id' attribute from the Material class was NOT mapped.", (Object)descriptor.getMappingForAttributeName("id"));
        EntityMappingsMetadataCompleteJUnitTestCase.assertNotNull((String)"The 'cost' attribute from the Meterial class was NOT mapped.", (Object)descriptor.getMappingForAttributeName("cost"));
        EntityMappingsMetadataCompleteJUnitTestCase.assertFalse((String)"The 'cost' attribute did used a @Column specification despite an xml-mapping-metadata-complete setting.", (boolean)descriptor.getMappingForAttributeName("cost").getField().getName().equals("MUCHO_EXPENSIVE"));
    }
}

