/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.xml.relationships.unidirectional;

import jakarta.persistence.EntityManager;
import java.util.Collection;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.server.ServerSession;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.xml.relationships.unidirectional.Address;
import org.eclipse.persistence.testing.models.jpa.xml.relationships.unidirectional.AdvancedTableCreator;
import org.eclipse.persistence.testing.models.jpa.xml.relationships.unidirectional.Employee;
import org.eclipse.persistence.testing.models.jpa.xml.relationships.unidirectional.ModelExamples;
import org.eclipse.persistence.testing.models.jpa.xml.relationships.unidirectional.PhoneNumber;
import org.eclipse.persistence.testing.models.jpa.xml.relationships.unidirectional.Project;

public class EntityMappingsUnidirectionalRelationshipsJUnitTestCase
extends JUnitTestCase {
    protected static Integer otoEmployeeId;
    protected static Integer otoProjectId;
    protected static Integer otmEmployeeId;
    protected static Integer otmPhone1Id;
    protected static Integer otmPhone2Id;
    protected static Integer mtoEmployee1Id;
    protected static Integer mtoEmployee2Id;
    protected static Integer mtoAddressId;
    protected static Integer mtmEmployeeId;
    protected static Integer mtmProject1Id;
    protected static Integer mtmProject2Id;

    public EntityMappingsUnidirectionalRelationshipsJUnitTestCase() {
    }

    public EntityMappingsUnidirectionalRelationshipsJUnitTestCase(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("Unidirectional Relationships Model");
        suite.addTest((Test)new EntityMappingsUnidirectionalRelationshipsJUnitTestCase("testSetup"));
        suite.addTest((Test)new EntityMappingsUnidirectionalRelationshipsJUnitTestCase("testUnidirectionalOneToOneCreate"));
        suite.addTest((Test)new EntityMappingsUnidirectionalRelationshipsJUnitTestCase("testUnidirectionalOneToOneRead"));
        suite.addTest((Test)new EntityMappingsUnidirectionalRelationshipsJUnitTestCase("testUnidirectionalOneToOneDeleteNonowning"));
        suite.addTest((Test)new EntityMappingsUnidirectionalRelationshipsJUnitTestCase("testUnidirectionalOneToOneDeleteOwning"));
        suite.addTest((Test)new EntityMappingsUnidirectionalRelationshipsJUnitTestCase("testUnidirectionalOneToManyCreate"));
        suite.addTest((Test)new EntityMappingsUnidirectionalRelationshipsJUnitTestCase("testUnidirectionalOneToManyRead"));
        suite.addTest((Test)new EntityMappingsUnidirectionalRelationshipsJUnitTestCase("testUnidirectionalOneToManyDeleteNonowning"));
        suite.addTest((Test)new EntityMappingsUnidirectionalRelationshipsJUnitTestCase("testUnidirectionalOneToManyDeleteOwning"));
        suite.addTest((Test)new EntityMappingsUnidirectionalRelationshipsJUnitTestCase("testUnidirectionalManyToOneCreate"));
        suite.addTest((Test)new EntityMappingsUnidirectionalRelationshipsJUnitTestCase("testUnidirectionalManyToOneRead"));
        suite.addTest((Test)new EntityMappingsUnidirectionalRelationshipsJUnitTestCase("testUnidirectionalManyToOneDeleteNonowning"));
        suite.addTest((Test)new EntityMappingsUnidirectionalRelationshipsJUnitTestCase("testUnidirectionalManyToOneDeleteOwning"));
        suite.addTest((Test)new EntityMappingsUnidirectionalRelationshipsJUnitTestCase("testUnidirectionalManyToManyCreate"));
        suite.addTest((Test)new EntityMappingsUnidirectionalRelationshipsJUnitTestCase("testUnidirectionalManyToManyRead"));
        suite.addTest((Test)new EntityMappingsUnidirectionalRelationshipsJUnitTestCase("testUnidirectionalManyToManyDeleteNonowning"));
        suite.addTest((Test)new EntityMappingsUnidirectionalRelationshipsJUnitTestCase("testUnidirectionalManyToManyDeleteOwning"));
        return suite;
    }

    public void testSetup() {
        ServerSession session = JUnitTestCase.getServerSession();
        new AdvancedTableCreator().replaceTables((DatabaseSession)session);
        this.clearCache();
    }

    public void testUnidirectionalOneToOneCreate() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Employee employee = ModelExamples.employeeExample1();
            Project project = ModelExamples.projectExample1();
            project.setTeamLeader(employee);
            em.persist((Object)employee);
            em.persist((Object)project);
            otoEmployeeId = employee.getId();
            otoProjectId = project.getId();
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
    }

    public void testUnidirectionalOneToOneRead() {
        EntityManager em = this.createEntityManager();
        Project project = (Project)em.find(Project.class, (Object)otoProjectId);
        EntityMappingsUnidirectionalRelationshipsJUnitTestCase.assertTrue((String)"Error reading Project", (project.getId() == otoProjectId ? 1 : 0) != 0);
        EntityMappingsUnidirectionalRelationshipsJUnitTestCase.assertTrue((String)"Error reading TeamLeader of Project", (project.getTeamLeader().getId() == otoEmployeeId ? 1 : 0) != 0);
    }

    public void testUnidirectionalOneToOneDeleteNonowning() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Employee employee = (Employee)em.find(Employee.class, (Object)otoEmployeeId);
            Project project = (Project)em.find(Project.class, (Object)otoProjectId);
            EntityMappingsUnidirectionalRelationshipsJUnitTestCase.assertTrue((employee != null ? 1 : 0) != 0);
            EntityMappingsUnidirectionalRelationshipsJUnitTestCase.assertTrue((project != null ? 1 : 0) != 0);
            project.setTeamLeader(null);
            em.remove((Object)employee);
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        EntityMappingsUnidirectionalRelationshipsJUnitTestCase.assertTrue((String)"Error deleting Employee", (em.find(Employee.class, (Object)otoEmployeeId) == null ? 1 : 0) != 0);
    }

    public void testUnidirectionalOneToOneDeleteOwning() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Project project = (Project)em.find(Project.class, (Object)otoProjectId);
            EntityMappingsUnidirectionalRelationshipsJUnitTestCase.assertTrue((project != null ? 1 : 0) != 0);
            em.remove((Object)project);
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        EntityMappingsUnidirectionalRelationshipsJUnitTestCase.assertTrue((String)"Error deleting Project", (em.find(Project.class, (Object)otoProjectId) == null ? 1 : 0) != 0);
    }

    public void testUnidirectionalOneToManyCreate() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Employee employee = ModelExamples.employeeExample1();
            PhoneNumber phone1 = ModelExamples.phoneExample1();
            PhoneNumber phone2 = ModelExamples.phoneExample2();
            employee.addPhoneNumber(phone1);
            employee.addPhoneNumber(phone2);
            em.persist((Object)employee);
            otmEmployeeId = employee.getId();
            otmPhone1Id = phone1.getId();
            otmPhone2Id = phone2.getId();
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
    }

    public void testUnidirectionalOneToManyRead() {
        EntityManager em = this.createEntityManager();
        Employee employee = (Employee)em.find(Employee.class, (Object)otmEmployeeId);
        EntityMappingsUnidirectionalRelationshipsJUnitTestCase.assertTrue((String)"Error reading Employee", (employee.getId() == otmEmployeeId ? 1 : 0) != 0);
        Collection phones = employee.getPhoneNumbers();
        EntityMappingsUnidirectionalRelationshipsJUnitTestCase.assertTrue((String)"Employee didn't have correct number of phone numbers", (phones.size() == 2 ? 1 : 0) != 0);
        boolean phonesMatched = true;
        for (PhoneNumber phone : phones) {
            if (phone.getId() == otmPhone1Id || phone.getId() == otmPhone2Id) continue;
            phonesMatched = false;
        }
        EntityMappingsUnidirectionalRelationshipsJUnitTestCase.assertTrue((String)"Employee didn't have correct phones", (boolean)phonesMatched);
    }

    public void testUnidirectionalOneToManyDeleteNonowning() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Employee employee = (Employee)em.find(Employee.class, (Object)otmEmployeeId);
            PhoneNumber phone = (PhoneNumber)em.find(PhoneNumber.class, (Object)otmPhone1Id);
            employee.removePhoneNumber(phone);
            em.remove((Object)phone);
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        EntityMappingsUnidirectionalRelationshipsJUnitTestCase.assertTrue((String)"Error deleting PhoneNumber", (em.find(PhoneNumber.class, (Object)otmPhone1Id) == null ? 1 : 0) != 0);
    }

    public void testUnidirectionalOneToManyDeleteOwning() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Employee employee = (Employee)em.find(Employee.class, (Object)otmEmployeeId);
            employee.setPhoneNumbers(null);
            em.remove((Object)employee);
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        EntityMappingsUnidirectionalRelationshipsJUnitTestCase.assertTrue((String)"Error deleting Employee", (em.find(Employee.class, (Object)otmEmployeeId) == null ? 1 : 0) != 0);
    }

    public void testUnidirectionalManyToOneCreate() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Employee employee1 = ModelExamples.employeeExample1();
            Employee employee2 = ModelExamples.employeeExample2();
            Address address = ModelExamples.addressExample1();
            employee1.setAddress(address);
            employee2.setAddress(address);
            em.persist((Object)employee1);
            em.persist((Object)employee2);
            mtoEmployee1Id = employee1.getId();
            mtoEmployee2Id = employee2.getId();
            mtoAddressId = address.getId();
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
    }

    public void testUnidirectionalManyToOneRead() {
        EntityManager em = this.createEntityManager();
        Employee employee = (Employee)em.find(Employee.class, (Object)mtoEmployee1Id);
        EntityMappingsUnidirectionalRelationshipsJUnitTestCase.assertTrue((String)"Error reading Employee", (employee.getId() == mtoEmployee1Id ? 1 : 0) != 0);
        EntityMappingsUnidirectionalRelationshipsJUnitTestCase.assertTrue((String)"Error reading Address", (employee.getAddress().getId() == mtoAddressId ? 1 : 0) != 0);
    }

    public void testUnidirectionalManyToOneDeleteNonowning() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Employee employee1 = (Employee)em.find(Employee.class, (Object)mtoEmployee1Id);
            Employee employee2 = (Employee)em.find(Employee.class, (Object)mtoEmployee2Id);
            Address address = (Address)em.find(Address.class, (Object)mtoAddressId);
            employee1.setAddress(null);
            employee2.setAddress(null);
            em.remove((Object)address);
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        EntityMappingsUnidirectionalRelationshipsJUnitTestCase.assertTrue((String)"Error deleting Address", (em.find(Address.class, (Object)mtoAddressId) == null ? 1 : 0) != 0);
    }

    public void testUnidirectionalManyToOneDeleteOwning() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Employee employee1 = (Employee)em.find(Employee.class, (Object)mtoEmployee1Id);
            Employee employee2 = (Employee)em.find(Employee.class, (Object)mtoEmployee2Id);
            em.remove((Object)employee1);
            em.remove((Object)employee2);
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        EntityMappingsUnidirectionalRelationshipsJUnitTestCase.assertTrue((String)"Error deleting Employee", (em.find(Employee.class, (Object)mtoEmployee1Id) == null ? 1 : 0) != 0);
        EntityMappingsUnidirectionalRelationshipsJUnitTestCase.assertTrue((String)"Error deleting Employee", (em.find(Employee.class, (Object)mtoEmployee2Id) == null ? 1 : 0) != 0);
    }

    public void testUnidirectionalManyToManyCreate() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Employee employee = ModelExamples.employeeExample1();
            Project project1 = ModelExamples.projectExample1();
            Project project2 = ModelExamples.projectExample2();
            employee.addProject(project1);
            employee.addProject(project2);
            em.persist((Object)employee);
            mtmEmployeeId = employee.getId();
            mtmProject1Id = project1.getId();
            mtmProject2Id = project2.getId();
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
    }

    public void testUnidirectionalManyToManyRead() {
        EntityManager em = this.createEntityManager();
        Employee employee = (Employee)em.find(Employee.class, (Object)mtmEmployeeId);
        EntityMappingsUnidirectionalRelationshipsJUnitTestCase.assertTrue((String)"Error reading Employee", (employee.getId() == mtmEmployeeId ? 1 : 0) != 0);
        Collection projects = employee.getProjects();
        EntityMappingsUnidirectionalRelationshipsJUnitTestCase.assertTrue((String)"Employee didn't have correct number of projects", (projects.size() == 2 ? 1 : 0) != 0);
        boolean projectsMatched = true;
        for (Project project : projects) {
            if (project.getId() == mtmProject1Id || project.getId() == mtmProject2Id) continue;
            projectsMatched = false;
        }
        EntityMappingsUnidirectionalRelationshipsJUnitTestCase.assertTrue((String)"Employee didn't have correct projects", (boolean)projectsMatched);
    }

    public void testUnidirectionalManyToManyDeleteNonowning() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Employee employee = (Employee)em.find(Employee.class, (Object)mtmEmployeeId);
            Project project1 = (Project)em.find(Project.class, (Object)mtmProject1Id);
            employee.removeProject(project1);
            em.remove((Object)project1);
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        EntityMappingsUnidirectionalRelationshipsJUnitTestCase.assertTrue((String)"Error deleting Project", (em.find(Project.class, (Object)mtmProject1Id) == null ? 1 : 0) != 0);
    }

    public void testUnidirectionalManyToManyDeleteOwning() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Employee employee = (Employee)em.find(Employee.class, (Object)mtmEmployeeId);
            employee.setProjects(null);
            em.remove((Object)employee);
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        EntityMappingsUnidirectionalRelationshipsJUnitTestCase.assertTrue((String)"Error deleting Employee", (em.find(Employee.class, (Object)mtmEmployeeId) == null ? 1 : 0) != 0);
        EntityMappingsUnidirectionalRelationshipsJUnitTestCase.assertTrue((String)"The project shouldn't have been deleted.", (em.find(Project.class, (Object)mtmProject2Id) != null ? 1 : 0) != 0);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)EntityMappingsUnidirectionalRelationshipsJUnitTestCase.suite());
    }
}

