/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.modelgen.objects;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.jpa.deployment.SEPersistenceUnitInfo;
import org.eclipse.persistence.internal.jpa.deployment.SEPersistenceUnitProperty;
import org.eclipse.persistence.internal.jpa.metadata.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.MetadataProject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.EmbeddableAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.EntityAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.MappedSuperclassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataFactory;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappingsReader;
import org.eclipse.persistence.internal.jpa.modelgen.MetadataMirrorFactory;
import org.eclipse.persistence.internal.jpa.modelgen.objects.PersistenceUnitReader;
import org.eclipse.persistence.oxm.XMLContext;

public class PersistenceUnit {
    protected List<XMLEntityMappings> xmlEntityMappings;
    protected MetadataProject project;
    protected MetadataMirrorFactory factory;
    protected PersistenceUnitReader persistenceUnitReader;
    protected ProcessingEnvironment processingEnv;
    protected SEPersistenceUnitInfo persistenceUnitInfo;
    protected HashMap<String, Object> persistenceUnitProperties;

    public PersistenceUnit(SEPersistenceUnitInfo puInfo, MetadataMirrorFactory mirrorFactory, PersistenceUnitReader reader) {
        this.factory = mirrorFactory;
        this.persistenceUnitInfo = puInfo;
        this.persistenceUnitReader = reader;
        this.processingEnv = this.factory.getProcessingEnvironment();
        this.project = this.factory.getMetadataProject(this.persistenceUnitInfo);
        this.initPersistenceUnitProperties();
        this.initXMLEntityMappings();
    }

    public void addEmbeddableAccessor(Element element) {
        MetadataClass metadataClass = this.factory.getMetadataClass(element);
        this.removeEntityAccessor(metadataClass);
        this.removeMappedSuperclassAccessor(metadataClass);
        if (this.project.hasEmbeddable(metadataClass)) {
            EmbeddableAccessor embeddableAccessor = this.project.getEmbeddableAccessor(metadataClass);
            if (embeddableAccessor.loadedFromXML()) {
                embeddableAccessor.clearPreProcessed();
            } else if (this.excludeUnlistedClasses(metadataClass)) {
                this.removeEmbeddableAccessor(metadataClass);
            } else {
                this.addEmbeddableAccessor(new EmbeddableAccessor(metadataClass.getAnnotation("jakarta.persistence.Embeddable"), metadataClass, this.project));
            }
        } else if (!this.excludeUnlistedClasses(metadataClass)) {
            this.addEmbeddableAccessor(new EmbeddableAccessor(metadataClass.getAnnotation("jakarta.persistence.Embeddable"), metadataClass, this.project));
        }
    }

    protected void addEmbeddableAccessor(EmbeddableAccessor embeddableAccessor) {
        if (this.project.hasEmbeddable(embeddableAccessor.getJavaClass())) {
            EmbeddableAccessor existingEmbeddableAccessor = this.project.getEmbeddableAccessor(embeddableAccessor.getJavaClass());
            embeddableAccessor.addEmbeddingAccessors(existingEmbeddableAccessor.getEmbeddingAccessors());
            embeddableAccessor.addOwningDescriptors(existingEmbeddableAccessor.getOwningDescriptors());
        }
        this.project.addEmbeddableAccessor(embeddableAccessor);
    }

    public void addEntityAccessor(Element element) {
        MetadataClass metadataClass = this.factory.getMetadataClass(element);
        this.removeEmbeddableAccessor(metadataClass);
        this.removeMappedSuperclassAccessor(metadataClass);
        if (this.project.hasEntity(metadataClass)) {
            EntityAccessor entityAccessor = this.project.getEntityAccessor(metadataClass);
            if (entityAccessor.loadedFromXML()) {
                entityAccessor.clearPreProcessed();
            } else if (this.excludeUnlistedClasses(metadataClass)) {
                this.removeEntityAccessor(metadataClass);
            } else {
                this.project.addEntityAccessor(new EntityAccessor(metadataClass.getAnnotation("jakarta.persistence.Entity"), metadataClass, this.project));
            }
        } else if (!this.excludeUnlistedClasses(metadataClass)) {
            this.project.addEntityAccessor(new EntityAccessor(metadataClass.getAnnotation("jakarta.persistence.Entity"), metadataClass, this.project));
        }
    }

    public void addMappedSuperclassAccessor(Element element) {
        MetadataClass metadataClass = this.factory.getMetadataClass(element);
        this.removeEntityAccessor(metadataClass);
        this.removeEmbeddableAccessor(metadataClass);
        if (this.project.hasMappedSuperclass(metadataClass)) {
            MappedSuperclassAccessor mappedSuperclassAccessor = this.project.getMappedSuperclassAccessor(metadataClass);
            if (mappedSuperclassAccessor.loadedFromXML()) {
                mappedSuperclassAccessor.clearPreProcessed();
            } else if (this.excludeUnlistedClasses(metadataClass)) {
                this.project.removeMappedSuperclassAccessor(metadataClass);
            } else {
                this.project.addMappedSuperclass(new MappedSuperclassAccessor(metadataClass.getAnnotation("jakarta.persistence.MappedSuperclass"), metadataClass, this.project));
            }
        } else if (!this.excludeUnlistedClasses(metadataClass)) {
            this.project.addMappedSuperclass(new MappedSuperclassAccessor(metadataClass.getAnnotation("jakarta.persistence.MappedSuperclass"), metadataClass, this.project));
        }
    }

    protected void addPropertyFromOptions(String propertyName) {
        if (!this.persistenceUnitProperties.containsKey(propertyName) || this.persistenceUnitProperties.get(propertyName) == null) {
            this.persistenceUnitProperties.put(propertyName, this.processingEnv.getOptions().get(propertyName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addXMLEntityMappings(String mappingFile, XMLContext context) {
        InputStream inputStream = this.persistenceUnitReader.getInputStream(mappingFile, false);
        if (inputStream != null) {
            try {
                XMLEntityMappings entityMappings = (XMLEntityMappings)context.createUnmarshaller().unmarshal(inputStream);
                entityMappings.setIsEclipseLinkORMFile(mappingFile.equals("META-INF/eclipselink-orm.xml"));
                entityMappings.setMappingFile(mappingFile);
                this.factory.getLogger().getSession().getSessionLog().log(5, "processor", "File loaded : {0}, is eclipselink-orm file: {1}", new Object[]{mappingFile, entityMappings.isEclipseLinkORMFile()}, false);
                this.xmlEntityMappings.add(entityMappings);
            }
            finally {
                this.persistenceUnitReader.closeInputStream(inputStream);
            }
        }
    }

    protected void addXMLEntityMappings(String mappingFile) {
        try {
            this.addXMLEntityMappings(mappingFile, XMLEntityMappingsReader.getEclipseLinkOrmProject());
        }
        catch (XMLMarshalException e) {
            try {
                this.addXMLEntityMappings(mappingFile, XMLEntityMappingsReader.getOrm3_1Project());
            }
            catch (XMLMarshalException e31) {
                try {
                    this.addXMLEntityMappings(mappingFile, XMLEntityMappingsReader.getOrm3_0Project());
                }
                catch (XMLMarshalException e30) {
                    try {
                        this.addXMLEntityMappings(mappingFile, XMLEntityMappingsReader.getOrm2_2Project());
                    }
                    catch (XMLMarshalException e22) {
                        try {
                            this.addXMLEntityMappings(mappingFile, XMLEntityMappingsReader.getOrm2_1Project());
                        }
                        catch (XMLMarshalException e21) {
                            try {
                                this.addXMLEntityMappings(mappingFile, XMLEntityMappingsReader.getOrm2_0Project());
                            }
                            catch (XMLMarshalException e20) {
                                this.addXMLEntityMappings(mappingFile, XMLEntityMappingsReader.getOrm1_0Project());
                            }
                        }
                    }
                }
            }
        }
    }

    public boolean containsClass(MetadataClass metadataClass) {
        if (this.project.hasEntity(metadataClass)) {
            return this.isValidAccessor((ClassAccessor)this.project.getEntityAccessor(metadataClass), metadataClass.getAnnotation("jakarta.persistence.Entity"));
        }
        if (this.project.hasEmbeddable(metadataClass)) {
            return this.isValidAccessor((ClassAccessor)this.project.getEmbeddableAccessor(metadataClass), metadataClass.getAnnotation("jakarta.persistence.Embeddable"));
        }
        if (this.project.hasMappedSuperclass(metadataClass)) {
            return this.isValidAccessor((ClassAccessor)this.project.getMappedSuperclassAccessor(metadataClass), metadataClass.getAnnotation("jakarta.persistence.MappedSuperclass"));
        }
        return false;
    }

    protected boolean excludeUnlistedClasses(MetadataClass cls) {
        return !this.persistenceUnitInfo.getManagedClassNames().contains(cls.getName()) && this.persistenceUnitInfo.excludeUnlistedClasses();
    }

    public ClassAccessor getClassAccessor(MetadataClass metadataClass) {
        if (this.project.hasEntity(metadataClass)) {
            return this.project.getEntityAccessor(metadataClass);
        }
        if (this.project.hasEmbeddable(metadataClass)) {
            return this.project.getEmbeddableAccessor(metadataClass);
        }
        if (this.project.hasMappedSuperclass(metadataClass)) {
            return this.project.getMappedSuperclassAccessor(metadataClass);
        }
        return null;
    }

    public String getQualifiedCanonicalName(String qualifiedName) {
        return MetadataHelper.getQualifiedCanonicalName((String)qualifiedName, this.persistenceUnitProperties);
    }

    public String getPersistenceUnitProperty(String name) {
        Object objVal = this.persistenceUnitProperties.get(name);
        if (objVal instanceof String) {
            return (String)objVal;
        }
        return objVal != null ? objVal.toString() : null;
    }

    public void initPersistenceUnitProperties() {
        this.persistenceUnitProperties = new HashMap();
        for (SEPersistenceUnitProperty property : this.persistenceUnitInfo.getPersistenceUnitProperties()) {
            if (property.getName() == null) continue;
            this.factory.getLogger().getSession().getSessionLog().log(3, "processor", "Key: {0} , value: {1}", new Object[]{property.getName(), property.getValue()}, false);
            this.persistenceUnitProperties.put(property.getName(), property.getValue());
        }
        this.addPropertyFromOptions("eclipselink.canonicalmodel.prefix");
        this.addPropertyFromOptions("eclipselink.canonicalmodel.suffix");
        this.addPropertyFromOptions("eclipselink.canonicalmodel.subpackage");
    }

    protected void initXMLEntityMappings() {
        this.xmlEntityMappings = new ArrayList<XMLEntityMappings>();
        this.addXMLEntityMappings("META-INF/orm.xml");
        Boolean excludeEclipseLinkORM = false;
        if (this.persistenceUnitProperties.containsKey("eclipselink.exclude-eclipselink-orm")) {
            excludeEclipseLinkORM = Boolean.valueOf((String)this.persistenceUnitProperties.get("eclipselink.exclude-eclipselink-orm"));
        }
        if (!excludeEclipseLinkORM.booleanValue()) {
            this.addXMLEntityMappings("META-INF/eclipselink-orm.xml");
        }
        for (String mappingFile : this.persistenceUnitInfo.getMappingFileNames()) {
            if (mappingFile.equals("META-INF/orm.xml") || mappingFile.equals("META-INF/eclipselink-orm.xml")) continue;
            this.addXMLEntityMappings(mappingFile);
        }
        for (XMLEntityMappings entityMappings : this.xmlEntityMappings) {
            entityMappings.setLoader(this.factory.getLoader());
            entityMappings.setProject(this.project);
            entityMappings.setMetadataFactory((MetadataFactory)this.factory);
            entityMappings.setLoadedForCanonicalModel(true);
            entityMappings.processPersistenceUnitMetadata();
        }
        HashMap entities = new HashMap();
        HashMap embeddables = new HashMap();
        for (XMLEntityMappings entityMappings : this.xmlEntityMappings) {
            entityMappings.initPersistenceUnitClasses(entities, embeddables);
        }
        for (EntityAccessor entity : entities.values()) {
            this.project.addEntityAccessor(entity);
            entity.getEntityMappings().processEntityMappingsDefaults((ClassAccessor)entity);
        }
        for (EmbeddableAccessor embeddable : embeddables.values()) {
            this.addEmbeddableAccessor(embeddable);
            embeddable.getEntityMappings().processEntityMappingsDefaults((ClassAccessor)embeddable);
        }
    }

    protected boolean isValidAccessor(ClassAccessor accessor, MetadataAnnotation annotation) {
        if (!accessor.loadedFromXML()) {
            return annotation != null;
        }
        return true;
    }

    public void preProcessForCanonicalModel() {
        for (EntityAccessor entityAccessor : this.project.getEntityAccessors()) {
            if (!this.shouldPreProcess((ClassAccessor)entityAccessor)) continue;
            entityAccessor.setAccessibleObject((MetadataAccessibleObject)this.factory.getMetadataClass(entityAccessor.getAccessibleObjectName()));
            entityAccessor.preProcessForCanonicalModel();
        }
        for (MappedSuperclassAccessor mappedSuperclassAccessor : this.project.getMappedSuperclasses()) {
            if (!this.shouldPreProcess((ClassAccessor)mappedSuperclassAccessor)) continue;
            mappedSuperclassAccessor.setAccessibleObject((MetadataAccessibleObject)this.factory.getMetadataClass(mappedSuperclassAccessor.getAccessibleObjectName()));
            mappedSuperclassAccessor.preProcessForCanonicalModel();
        }
        for (EmbeddableAccessor embeddableAccessor : this.project.getRootEmbeddableAccessors()) {
            if (!this.shouldPreProcess((ClassAccessor)embeddableAccessor)) continue;
            embeddableAccessor.setAccessibleObject((MetadataAccessibleObject)this.factory.getMetadataClass(embeddableAccessor.getAccessibleObjectName()));
            embeddableAccessor.preProcessForCanonicalModel();
        }
        for (EmbeddableAccessor embeddableAccessor : this.project.getEmbeddableAccessors()) {
            if (!this.shouldPreProcess((ClassAccessor)embeddableAccessor)) continue;
            embeddableAccessor.setAccessibleObject((MetadataAccessibleObject)this.factory.getMetadataClass(embeddableAccessor.getAccessibleObjectName()));
            embeddableAccessor.preProcessForCanonicalModel();
        }
    }

    protected boolean shouldPreProcess(ClassAccessor accessor) {
        MetadataClass cls = (MetadataClass)accessor.getAccessibleObject();
        if (accessor.isPreProcessed() && this.factory.isRoundElement(cls)) {
            accessor.clearPreProcessed();
        }
        return !accessor.isPreProcessed();
    }

    protected void removeEntityAccessor(MetadataClass metadataClass) {
        if (this.project.hasEntity(metadataClass)) {
            this.project.removeEntityAccessor(metadataClass);
        }
    }

    protected void removeEmbeddableAccessor(MetadataClass metadataClass) {
        if (this.project.hasEmbeddable(metadataClass)) {
            this.project.removeEmbeddableAccessor(metadataClass);
        }
    }

    protected void removeMappedSuperclassAccessor(MetadataClass metadataClass) {
        if (this.project.hasMappedSuperclass(metadataClass)) {
            this.project.removeMappedSuperclassAccessor(metadataClass);
        }
    }

    public String toString() {
        return this.persistenceUnitInfo.getPersistenceUnitName();
    }
}

