/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.sessionconsole;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.lang.reflect.Constructor;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.UIManager;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.tools.beans.MessageDialog;
import org.eclipse.persistence.tools.sessionconsole.SessionConsolePanel;

public class SessionConsole
extends JFrame {
    private JMenuItem ivjBrowseProfileMenuItem = null;
    private JMenu ivjCacheMenu = null;
    private JMenuItem ivjClearCacheMenuItem = null;
    private JMenuItem ivjClearDescriptorsMenuItem = null;
    private JMenuItem ivjClearLogMenuItem = null;
    private JMenuItem ivjClearResultsMenuItem = null;
    private JMenuItem ivjClearSQLMenuItem = null;
    private JMenuItem ivjCloseMenuItem = null;
    private JMenuItem ivjCopySQLMenuItem = null;
    private JMenuItem ivjCutSQLMenuItem = null;
    private JMenuItem ivjDeleteSQLMenuItem = null;
    private JMenu ivjDescriptorsMenu = null;
    private JMenuItem ivjExecuteQueryMenuItem = null;
    private JMenuItem ivjExitMenuItem = null;
    private JMenu ivjFileMenu = null;
    private JMenuItem ivjInsertSQLMenuItem = null;
    private JMenuItem ivjInspectCacheMenuItem = null;
    private JMenuItem ivjInspectDescriptorMenuItem = null;
    private JMenuItem ivjInspectResultMenuItem = null;
    private JMenuItem ivjInspectSessionMenuItem1 = null;
    private JSeparator ivjJSeparator1 = null;
    private JSeparator ivjJSeparator3 = null;
    private JSeparator ivjJSeparator4 = null;
    private JSeparator ivjJSeparator5 = null;
    private JSeparator ivjJSeparator6 = null;
    private JSeparator ivjJSeparator7 = null;
    private JMenuItem ivjLoadProjectMenuItem = null;
    private JMenu ivjLoginMenu = null;
    private JMenuItem ivjLoginMenuItem = null;
    private JMenu ivjLogMenu = null;
    private JMenuItem ivjLogoutMenuItem = null;
    private JCheckBoxMenuItem ivjLogProfileMenuItem = null;
    private JCheckBoxMenuItem ivjLogProfileMenuItem1 = null;
    private JCheckBoxMenuItem ivjLogSQLMenuItem = null;
    private JPanel ivjMainPanel = null;
    private JMenuItem ivjPasteSQLMenuItem = null;
    private JMenu ivjQueryMenu = null;
    private JMenuItem ivjResetDescriptorsMenuItem = null;
    private JMenu ivjResultsMenu = null;
    private JMenuItem ivjSelectSQLMenuItem = null;
    private JMenuBar ivjSessionInspectorFrameJMenuBar = null;
    private SessionConsolePanel ivjSessionInspectorPanel = null;
    private JMenu ivjSQLMenu = null;
    private JMenuItem ivjSQLSelectMenuItem = null;
    private JMenu ivjSQLTemplateMenu = null;
    private JMenuItem ivjSQLUpdateMenuItem = null;
    private JMenuItem ivjUpdateSQLMenuItem = null;
    private boolean shouldCallSystemExit = true;
    IvjEventHandler ivjEventHandler = new IvjEventHandler();

    public SessionConsole() {
        this.initialize();
    }

    public SessionConsole(String title) {
        super(title);
    }

    public void browseProfile() {
        this.getSessionInspectorPanel().browseProfile();
    }

    public static void browseSession(Session session) {
        SessionConsole.browseSession(session, true);
    }

    public static void browseSession(Session session, boolean shouldCallSystemExit) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            SessionConsole aSessionInspectorFrame = new SessionConsole();
            aSessionInspectorFrame.shouldCallSystemExit = shouldCallSystemExit;
            aSessionInspectorFrame.setVisible(true);
            aSessionInspectorFrame.setSession(session);
        }
        catch (Throwable exception) {
            System.err.println("Exception occurred in main() of javax.swing.JFrame");
            exception.printStackTrace(System.out);
        }
    }

    public static void centerComponent(Component component) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension size = component.getSize();
        screenSize.height /= 2;
        screenSize.width /= 2;
        size.height /= 2;
        size.width /= 2;
        component.setLocation(screenSize.width - size.width, screenSize.height - size.height);
    }

    public void clearCache() {
        this.getSessionInspectorPanel().clearCache();
    }

    public void clearDescriptors() {
        this.getSessionInspectorPanel().clearDescriptors();
    }

    public void clearLog() {
        this.getSessionInspectorPanel().clearLog();
    }

    public void clearResults() {
        this.getSessionInspectorPanel().clearResults();
    }

    public void clearSQL() {
        this.getSessionInspectorPanel().clearSQL();
    }

    private void connEtoC1(ActionEvent arg1) {
        try {
            this.loadProject();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC10(ActionEvent arg1) {
        try {
            this.clearSQL();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC11(ActionEvent arg1) {
        try {
            this.login();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC12(ActionEvent arg1) {
        try {
            this.logout();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC13(ActionEvent arg1) {
        try {
            this.inspectSession();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC14(ActionEvent arg1) {
        try {
            this.executeQuery();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC15(ActionEvent arg1) {
        try {
            this.cutSQL();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC16(ActionEvent arg1) {
        try {
            this.copySQL();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC17(ActionEvent arg1) {
        try {
            this.pasteSQL();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC18(ActionEvent arg1) {
        try {
            this.clearLog();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC19(ActionEvent arg1) {
        try {
            this.clearResults();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC2(ActionEvent arg1) {
        try {
            this.exit();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC20(ActionEvent arg1) {
        try {
            this.inspectResult();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC21(ActionEvent arg1) {
        try {
            this.templateSQLInsert();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC22(ActionEvent arg1) {
        try {
            this.templateSQLUpdate();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC23(ActionEvent arg1) {
        try {
            this.templateSQLDelete();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC24(ActionEvent arg1) {
        try {
            this.templateSQLSelect();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC25(ActionEvent arg1) {
        try {
            this.browseProfile();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC28(WindowEvent arg1) {
        try {
            this.exit();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC3(ActionEvent arg1) {
        try {
            this.resetDescriptors();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC4(ActionEvent arg1) {
        try {
            this.clearDescriptors();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC5(ActionEvent arg1) {
        try {
            this.inspectDescriptor();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC6(ActionEvent arg1) {
        try {
            this.clearCache();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC7(ActionEvent arg1) {
        try {
            this.inspectCache();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC8(ActionEvent arg1) {
        try {
            this.executeSQLUpdate();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC9(ActionEvent arg1) {
        try {
            this.executeSQLSelect();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoM1(ActionEvent arg1) {
        try {
            this.dispose();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    public void copySQL() {
        this.getSessionInspectorPanel().copySQL();
    }

    public void createTables() {
        this.getSessionInspectorPanel().createTables();
    }

    public void cutSQL() {
        this.getSessionInspectorPanel().cutSQL();
    }

    public void executeQuery() {
        this.getSessionInspectorPanel().executeQuery();
    }

    public void executeSQLSelect() {
        this.getSessionInspectorPanel().selectSQL();
    }

    public void executeSQLUpdate() {
        this.getSessionInspectorPanel().executeSQL();
    }

    public void exit() {
        if (this.shouldCallSystemExit) {
            System.exit(0);
        }
    }

    private JMenuItem getBrowseProfileMenuItem() {
        if (this.ivjBrowseProfileMenuItem == null) {
            try {
                this.ivjBrowseProfileMenuItem = new JMenuItem();
                this.ivjBrowseProfileMenuItem.setName("BrowseProfileMenuItem");
                this.ivjBrowseProfileMenuItem.setText("Browse Profile");
                this.ivjBrowseProfileMenuItem.setBackground(SystemColor.menu);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjBrowseProfileMenuItem;
    }

    private JMenu getCacheMenu() {
        if (this.ivjCacheMenu == null) {
            try {
                this.ivjCacheMenu = new JMenu();
                this.ivjCacheMenu.setName("CacheMenu");
                this.ivjCacheMenu.setText("Cache");
                this.ivjCacheMenu.setBackground(SystemColor.menu);
                this.ivjCacheMenu.add(this.getClearCacheMenuItem());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjCacheMenu;
    }

    private JMenuItem getClearCacheMenuItem() {
        if (this.ivjClearCacheMenuItem == null) {
            try {
                this.ivjClearCacheMenuItem = new JMenuItem();
                this.ivjClearCacheMenuItem.setName("ClearCacheMenuItem");
                this.ivjClearCacheMenuItem.setText("Clear Cache");
                this.ivjClearCacheMenuItem.setBackground(SystemColor.menu);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjClearCacheMenuItem;
    }

    private JMenuItem getClearDescriptorsMenuItem() {
        if (this.ivjClearDescriptorsMenuItem == null) {
            try {
                this.ivjClearDescriptorsMenuItem = new JMenuItem();
                this.ivjClearDescriptorsMenuItem.setName("ClearDescriptorsMenuItem");
                this.ivjClearDescriptorsMenuItem.setText("Clear Descriptors");
                this.ivjClearDescriptorsMenuItem.setBackground(SystemColor.menu);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjClearDescriptorsMenuItem;
    }

    private JMenuItem getClearLogMenuItem() {
        if (this.ivjClearLogMenuItem == null) {
            try {
                this.ivjClearLogMenuItem = new JMenuItem();
                this.ivjClearLogMenuItem.setName("ClearLogMenuItem");
                this.ivjClearLogMenuItem.setText("Clear Log");
                this.ivjClearLogMenuItem.setBackground(SystemColor.menu);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjClearLogMenuItem;
    }

    private JMenuItem getClearResultsMenuItem() {
        if (this.ivjClearResultsMenuItem == null) {
            try {
                this.ivjClearResultsMenuItem = new JMenuItem();
                this.ivjClearResultsMenuItem.setName("ClearResultsMenuItem");
                this.ivjClearResultsMenuItem.setText("Clear Results");
                this.ivjClearResultsMenuItem.setBackground(SystemColor.menu);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjClearResultsMenuItem;
    }

    private JMenuItem getClearSQLMenuItem() {
        if (this.ivjClearSQLMenuItem == null) {
            try {
                this.ivjClearSQLMenuItem = new JMenuItem();
                this.ivjClearSQLMenuItem.setName("ClearSQLMenuItem");
                this.ivjClearSQLMenuItem.setText("Clear SQL");
                this.ivjClearSQLMenuItem.setBackground(SystemColor.menu);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjClearSQLMenuItem;
    }

    private JMenuItem getCloseMenuItem() {
        if (this.ivjCloseMenuItem == null) {
            try {
                this.ivjCloseMenuItem = new JMenuItem();
                this.ivjCloseMenuItem.setName("CloseMenuItem");
                this.ivjCloseMenuItem.setText("Close");
                this.ivjCloseMenuItem.setBackground(SystemColor.menu);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjCloseMenuItem;
    }

    private JMenuItem getCopySQLMenuItem() {
        if (this.ivjCopySQLMenuItem == null) {
            try {
                this.ivjCopySQLMenuItem = new JMenuItem();
                this.ivjCopySQLMenuItem.setName("CopySQLMenuItem");
                this.ivjCopySQLMenuItem.setText("Copy");
                this.ivjCopySQLMenuItem.setBackground(SystemColor.menu);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjCopySQLMenuItem;
    }

    private JMenuItem getCutSQLMenuItem() {
        if (this.ivjCutSQLMenuItem == null) {
            try {
                this.ivjCutSQLMenuItem = new JMenuItem();
                this.ivjCutSQLMenuItem.setName("CutSQLMenuItem");
                this.ivjCutSQLMenuItem.setText("Cut");
                this.ivjCutSQLMenuItem.setBackground(SystemColor.menu);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjCutSQLMenuItem;
    }

    private JMenuItem getDeleteSQLMenuItem() {
        if (this.ivjDeleteSQLMenuItem == null) {
            try {
                this.ivjDeleteSQLMenuItem = new JMenuItem();
                this.ivjDeleteSQLMenuItem.setName("DeleteSQLMenuItem");
                this.ivjDeleteSQLMenuItem.setText("Delete SQL");
                this.ivjDeleteSQLMenuItem.setBackground(SystemColor.menu);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjDeleteSQLMenuItem;
    }

    private JMenu getDescriptorsMenu() {
        if (this.ivjDescriptorsMenu == null) {
            try {
                this.ivjDescriptorsMenu = new JMenu();
                this.ivjDescriptorsMenu.setName("DescriptorsMenu");
                this.ivjDescriptorsMenu.setText("Descriptors");
                this.ivjDescriptorsMenu.setBackground(SystemColor.menu);
                this.ivjDescriptorsMenu.add(this.getResetDescriptorsMenuItem());
                this.ivjDescriptorsMenu.add(this.getClearDescriptorsMenuItem());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjDescriptorsMenu;
    }

    private JMenuItem getExecuteQueryMenuItem() {
        if (this.ivjExecuteQueryMenuItem == null) {
            try {
                this.ivjExecuteQueryMenuItem = new JMenuItem();
                this.ivjExecuteQueryMenuItem.setName("ExecuteQueryMenuItem");
                this.ivjExecuteQueryMenuItem.setText("Execute Query");
                this.ivjExecuteQueryMenuItem.setBackground(SystemColor.menu);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjExecuteQueryMenuItem;
    }

    private JMenuItem getExitMenuItem() {
        if (this.ivjExitMenuItem == null) {
            try {
                this.ivjExitMenuItem = new JMenuItem();
                this.ivjExitMenuItem.setName("ExitMenuItem");
                this.ivjExitMenuItem.setText("Exit");
                this.ivjExitMenuItem.setBackground(SystemColor.menu);
                this.ivjExitMenuItem.setActionCommand("ExitMenuItem");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjExitMenuItem;
    }

    private JMenu getFileMenu() {
        if (this.ivjFileMenu == null) {
            try {
                this.ivjFileMenu = new JMenu();
                this.ivjFileMenu.setName("FileMenu");
                this.ivjFileMenu.setText("File");
                this.ivjFileMenu.setBackground(SystemColor.menu);
                this.ivjFileMenu.add(this.getLoadProjectMenuItem());
                this.ivjFileMenu.add(this.getJSeparator3());
                this.ivjFileMenu.add(this.getCloseMenuItem());
                this.ivjFileMenu.add(this.getJSeparator1());
                this.ivjFileMenu.add(this.getExitMenuItem());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjFileMenu;
    }

    private JMenuItem getInsertSQLMenuItem() {
        if (this.ivjInsertSQLMenuItem == null) {
            try {
                this.ivjInsertSQLMenuItem = new JMenuItem();
                this.ivjInsertSQLMenuItem.setName("InsertSQLMenuItem");
                this.ivjInsertSQLMenuItem.setText("Insert SQL");
                this.ivjInsertSQLMenuItem.setBackground(SystemColor.menu);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjInsertSQLMenuItem;
    }

    private JMenuItem getInspectCacheMenuItem() {
        if (this.ivjInspectCacheMenuItem == null) {
            try {
                this.ivjInspectCacheMenuItem = new JMenuItem();
                this.ivjInspectCacheMenuItem.setName("InspectCacheMenuItem");
                this.ivjInspectCacheMenuItem.setText("Inspect Cache (VA)");
                this.ivjInspectCacheMenuItem.setBackground(SystemColor.menu);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjInspectCacheMenuItem;
    }

    private JMenuItem getInspectDescriptorMenuItem() {
        if (this.ivjInspectDescriptorMenuItem == null) {
            try {
                this.ivjInspectDescriptorMenuItem = new JMenuItem();
                this.ivjInspectDescriptorMenuItem.setName("InspectDescriptorMenuItem");
                this.ivjInspectDescriptorMenuItem.setText("Inspect Descriptor (VA)");
                this.ivjInspectDescriptorMenuItem.setBackground(SystemColor.menu);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjInspectDescriptorMenuItem;
    }

    private JMenuItem getInspectResultMenuItem() {
        if (this.ivjInspectResultMenuItem == null) {
            try {
                this.ivjInspectResultMenuItem = new JMenuItem();
                this.ivjInspectResultMenuItem.setName("InspectResultMenuItem");
                this.ivjInspectResultMenuItem.setText("Inspect Result (VA)");
                this.ivjInspectResultMenuItem.setBackground(SystemColor.menu);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjInspectResultMenuItem;
    }

    private JMenuItem getInspectSessionMenuItem1() {
        if (this.ivjInspectSessionMenuItem1 == null) {
            try {
                this.ivjInspectSessionMenuItem1 = new JMenuItem();
                this.ivjInspectSessionMenuItem1.setName("InspectSessionMenuItem1");
                this.ivjInspectSessionMenuItem1.setText("Inspect Session (VA)");
                this.ivjInspectSessionMenuItem1.setBackground(SystemColor.menu);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjInspectSessionMenuItem1;
    }

    private JSeparator getJSeparator1() {
        if (this.ivjJSeparator1 == null) {
            try {
                this.ivjJSeparator1 = new JSeparator();
                this.ivjJSeparator1.setName("JSeparator1");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJSeparator1;
    }

    private JSeparator getJSeparator3() {
        if (this.ivjJSeparator3 == null) {
            try {
                this.ivjJSeparator3 = new JSeparator();
                this.ivjJSeparator3.setName("JSeparator3");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJSeparator3;
    }

    private JSeparator getJSeparator4() {
        if (this.ivjJSeparator4 == null) {
            try {
                this.ivjJSeparator4 = new JSeparator();
                this.ivjJSeparator4.setName("JSeparator4");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJSeparator4;
    }

    private JSeparator getJSeparator5() {
        if (this.ivjJSeparator5 == null) {
            try {
                this.ivjJSeparator5 = new JSeparator();
                this.ivjJSeparator5.setName("JSeparator5");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJSeparator5;
    }

    private JSeparator getJSeparator6() {
        if (this.ivjJSeparator6 == null) {
            try {
                this.ivjJSeparator6 = new JSeparator();
                this.ivjJSeparator6.setName("JSeparator6");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJSeparator6;
    }

    private JSeparator getJSeparator7() {
        if (this.ivjJSeparator7 == null) {
            try {
                this.ivjJSeparator7 = new JSeparator();
                this.ivjJSeparator7.setName("JSeparator7");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJSeparator7;
    }

    private JMenuItem getLoadProjectMenuItem() {
        if (this.ivjLoadProjectMenuItem == null) {
            try {
                this.ivjLoadProjectMenuItem = new JMenuItem();
                this.ivjLoadProjectMenuItem.setName("LoadProjectMenuItem");
                this.ivjLoadProjectMenuItem.setText("Load Project...");
                this.ivjLoadProjectMenuItem.setBackground(SystemColor.menu);
                this.ivjLoadProjectMenuItem.setForeground(Color.black);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjLoadProjectMenuItem;
    }

    private JMenu getLoginMenu() {
        if (this.ivjLoginMenu == null) {
            try {
                this.ivjLoginMenu = new JMenu();
                this.ivjLoginMenu.setName("LoginMenu");
                this.ivjLoginMenu.setText("Login");
                this.ivjLoginMenu.setBackground(SystemColor.menu);
                this.ivjLoginMenu.add(this.getLoginMenuItem());
                this.ivjLoginMenu.add(this.getLogoutMenuItem());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjLoginMenu;
    }

    private JMenuItem getLoginMenuItem() {
        if (this.ivjLoginMenuItem == null) {
            try {
                this.ivjLoginMenuItem = new JMenuItem();
                this.ivjLoginMenuItem.setName("LoginMenuItem");
                this.ivjLoginMenuItem.setText("Login");
                this.ivjLoginMenuItem.setBackground(SystemColor.menu);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjLoginMenuItem;
    }

    private JMenu getLogMenu() {
        if (this.ivjLogMenu == null) {
            try {
                this.ivjLogMenu = new JMenu();
                this.ivjLogMenu.setName("LogMenu");
                this.ivjLogMenu.setText("Log");
                this.ivjLogMenu.setBackground(SystemColor.menu);
                this.ivjLogMenu.add(this.getClearLogMenuItem());
                this.ivjLogMenu.add(this.getLogSQLMenuItem());
                this.ivjLogMenu.add(this.getJSeparator7());
                this.ivjLogMenu.add(this.getLogProfileMenuItem1());
                this.ivjLogMenu.add(this.getLogProfileMenuItem());
                this.ivjLogMenu.add(this.getBrowseProfileMenuItem());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjLogMenu;
    }

    private JMenuItem getLogoutMenuItem() {
        if (this.ivjLogoutMenuItem == null) {
            try {
                this.ivjLogoutMenuItem = new JMenuItem();
                this.ivjLogoutMenuItem.setName("LogoutMenuItem");
                this.ivjLogoutMenuItem.setText("Logout");
                this.ivjLogoutMenuItem.setBackground(SystemColor.menu);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjLogoutMenuItem;
    }

    private JCheckBoxMenuItem getLogProfileMenuItem() {
        if (this.ivjLogProfileMenuItem == null) {
            try {
                this.ivjLogProfileMenuItem = new JCheckBoxMenuItem();
                this.ivjLogProfileMenuItem.setName("LogProfileMenuItem");
                this.ivjLogProfileMenuItem.setText("Log Profile");
                this.ivjLogProfileMenuItem.setBackground(SystemColor.menu);
                this.ivjLogProfileMenuItem.setActionCommand("LogSQLMenuItem");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjLogProfileMenuItem;
    }

    private JCheckBoxMenuItem getLogProfileMenuItem1() {
        if (this.ivjLogProfileMenuItem1 == null) {
            try {
                this.ivjLogProfileMenuItem1 = new JCheckBoxMenuItem();
                this.ivjLogProfileMenuItem1.setName("LogProfileMenuItem1");
                this.ivjLogProfileMenuItem1.setText("Profile");
                this.ivjLogProfileMenuItem1.setBackground(SystemColor.menu);
                this.ivjLogProfileMenuItem1.setActionCommand("ProfileMenuItem");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjLogProfileMenuItem1;
    }

    private JCheckBoxMenuItem getLogSQLMenuItem() {
        if (this.ivjLogSQLMenuItem == null) {
            try {
                this.ivjLogSQLMenuItem = new JCheckBoxMenuItem();
                this.ivjLogSQLMenuItem.setName("LogSQLMenuItem");
                this.ivjLogSQLMenuItem.setText("Log SQL");
                this.ivjLogSQLMenuItem.setBackground(SystemColor.menu);
                this.ivjLogSQLMenuItem.setActionCommand("LogSQLMenuItem");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjLogSQLMenuItem;
    }

    private JPanel getMainPanel() {
        if (this.ivjMainPanel == null) {
            try {
                this.ivjMainPanel = new JPanel();
                this.ivjMainPanel.setName("MainPanel");
                this.ivjMainPanel.setLayout(new GridBagLayout());
                this.ivjMainPanel.setBackground(SystemColor.control);
                GridBagConstraints constraintsSessionInspectorPanel = new GridBagConstraints();
                constraintsSessionInspectorPanel.gridx = 0;
                constraintsSessionInspectorPanel.gridy = 0;
                constraintsSessionInspectorPanel.fill = 1;
                constraintsSessionInspectorPanel.weightx = 1.0;
                constraintsSessionInspectorPanel.weighty = 1.0;
                constraintsSessionInspectorPanel.insets = new Insets(2, 2, 2, 2);
                this.getMainPanel().add((Component)this.getSessionInspectorPanel(), constraintsSessionInspectorPanel);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjMainPanel;
    }

    private JMenuItem getPasteSQLMenuItem() {
        if (this.ivjPasteSQLMenuItem == null) {
            try {
                this.ivjPasteSQLMenuItem = new JMenuItem();
                this.ivjPasteSQLMenuItem.setName("PasteSQLMenuItem");
                this.ivjPasteSQLMenuItem.setText("Paste");
                this.ivjPasteSQLMenuItem.setBackground(SystemColor.menu);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjPasteSQLMenuItem;
    }

    private JMenu getQueryMenu() {
        if (this.ivjQueryMenu == null) {
            try {
                this.ivjQueryMenu = new JMenu();
                this.ivjQueryMenu.setName("QueryMenu");
                this.ivjQueryMenu.setText("Query");
                this.ivjQueryMenu.setBackground(SystemColor.menu);
                this.ivjQueryMenu.add(this.getExecuteQueryMenuItem());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjQueryMenu;
    }

    private JMenuItem getResetDescriptorsMenuItem() {
        if (this.ivjResetDescriptorsMenuItem == null) {
            try {
                this.ivjResetDescriptorsMenuItem = new JMenuItem();
                this.ivjResetDescriptorsMenuItem.setName("ResetDescriptorsMenuItem");
                this.ivjResetDescriptorsMenuItem.setText("Reset Descriptors");
                this.ivjResetDescriptorsMenuItem.setBackground(SystemColor.menu);
                this.ivjResetDescriptorsMenuItem.setForeground(Color.black);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjResetDescriptorsMenuItem;
    }

    private JMenu getResultsMenu() {
        if (this.ivjResultsMenu == null) {
            try {
                this.ivjResultsMenu = new JMenu();
                this.ivjResultsMenu.setName("ResultsMenu");
                this.ivjResultsMenu.setText("Results");
                this.ivjResultsMenu.setBackground(SystemColor.menu);
                this.ivjResultsMenu.add(this.getClearResultsMenuItem());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjResultsMenu;
    }

    private JMenuItem getSelectSQLMenuItem() {
        if (this.ivjSelectSQLMenuItem == null) {
            try {
                this.ivjSelectSQLMenuItem = new JMenuItem();
                this.ivjSelectSQLMenuItem.setName("SelectSQLMenuItem");
                this.ivjSelectSQLMenuItem.setText("Select SQL");
                this.ivjSelectSQLMenuItem.setBackground(SystemColor.menu);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjSelectSQLMenuItem;
    }

    private JMenuBar getSessionInspectorFrameJMenuBar() {
        if (this.ivjSessionInspectorFrameJMenuBar == null) {
            try {
                this.ivjSessionInspectorFrameJMenuBar = new JMenuBar();
                this.ivjSessionInspectorFrameJMenuBar.setName("SessionInspectorFrameJMenuBar");
                this.ivjSessionInspectorFrameJMenuBar.setBackground(SystemColor.menu);
                this.ivjSessionInspectorFrameJMenuBar.add(this.getFileMenu());
                this.ivjSessionInspectorFrameJMenuBar.add(this.getDescriptorsMenu());
                this.ivjSessionInspectorFrameJMenuBar.add(this.getCacheMenu());
                this.ivjSessionInspectorFrameJMenuBar.add(this.getQueryMenu());
                this.ivjSessionInspectorFrameJMenuBar.add(this.getSQLMenu());
                this.ivjSessionInspectorFrameJMenuBar.add(this.getLoginMenu());
                this.ivjSessionInspectorFrameJMenuBar.add(this.getLogMenu());
                this.ivjSessionInspectorFrameJMenuBar.add(this.getResultsMenu());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjSessionInspectorFrameJMenuBar;
    }

    private SessionConsolePanel getSessionInspectorPanel() {
        if (this.ivjSessionInspectorPanel == null) {
            try {
                this.ivjSessionInspectorPanel = new SessionConsolePanel();
                this.ivjSessionInspectorPanel.setName("SessionInspectorPanel");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjSessionInspectorPanel;
    }

    private JMenu getSQLMenu() {
        if (this.ivjSQLMenu == null) {
            try {
                this.ivjSQLMenu = new JMenu();
                this.ivjSQLMenu.setName("SQLMenu");
                this.ivjSQLMenu.setText("SQL");
                this.ivjSQLMenu.setBackground(SystemColor.menu);
                this.ivjSQLMenu.add(this.getSQLUpdateMenuItem());
                this.ivjSQLMenu.add(this.getSQLSelectMenuItem());
                this.ivjSQLMenu.add(this.getJSeparator4());
                this.ivjSQLMenu.add(this.getClearSQLMenuItem());
                this.ivjSQLMenu.add(this.getJSeparator6());
                this.ivjSQLMenu.add(this.getCutSQLMenuItem());
                this.ivjSQLMenu.add(this.getCopySQLMenuItem());
                this.ivjSQLMenu.add(this.getPasteSQLMenuItem());
                this.ivjSQLMenu.add(this.getJSeparator5());
                this.ivjSQLMenu.add(this.getSQLTemplateMenu());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjSQLMenu;
    }

    private JMenuItem getSQLSelectMenuItem() {
        if (this.ivjSQLSelectMenuItem == null) {
            try {
                this.ivjSQLSelectMenuItem = new JMenuItem();
                this.ivjSQLSelectMenuItem.setName("SQLSelectMenuItem");
                this.ivjSQLSelectMenuItem.setText("Execute SQL Select");
                this.ivjSQLSelectMenuItem.setBackground(SystemColor.menu);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjSQLSelectMenuItem;
    }

    private JMenu getSQLTemplateMenu() {
        if (this.ivjSQLTemplateMenu == null) {
            try {
                this.ivjSQLTemplateMenu = new JMenu();
                this.ivjSQLTemplateMenu.setName("SQLTemplateMenu");
                this.ivjSQLTemplateMenu.setText("SQL");
                this.ivjSQLTemplateMenu.setBackground(SystemColor.menu);
                this.ivjSQLTemplateMenu.add(this.getInsertSQLMenuItem());
                this.ivjSQLTemplateMenu.add(this.getUpdateSQLMenuItem());
                this.ivjSQLTemplateMenu.add(this.getDeleteSQLMenuItem());
                this.ivjSQLTemplateMenu.add(this.getSelectSQLMenuItem());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjSQLTemplateMenu;
    }

    private JMenuItem getSQLUpdateMenuItem() {
        if (this.ivjSQLUpdateMenuItem == null) {
            try {
                this.ivjSQLUpdateMenuItem = new JMenuItem();
                this.ivjSQLUpdateMenuItem.setName("SQLUpdateMenuItem");
                this.ivjSQLUpdateMenuItem.setText("Execute SQL Update");
                this.ivjSQLUpdateMenuItem.setBackground(SystemColor.menu);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjSQLUpdateMenuItem;
    }

    private JMenuItem getUpdateSQLMenuItem() {
        if (this.ivjUpdateSQLMenuItem == null) {
            try {
                this.ivjUpdateSQLMenuItem = new JMenuItem();
                this.ivjUpdateSQLMenuItem.setName("UpdateSQLMenuItem");
                this.ivjUpdateSQLMenuItem.setText("Update SQL");
                this.ivjUpdateSQLMenuItem.setBackground(SystemColor.menu);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjUpdateSQLMenuItem;
    }

    private void handleException(Throwable exception) {
        MessageDialog.displayException(exception, this);
    }

    private void initConnections() {
        this.getCloseMenuItem().addActionListener(this.ivjEventHandler);
        this.getLoadProjectMenuItem().addActionListener(this.ivjEventHandler);
        this.getExitMenuItem().addActionListener(this.ivjEventHandler);
        this.getResetDescriptorsMenuItem().addActionListener(this.ivjEventHandler);
        this.getClearDescriptorsMenuItem().addActionListener(this.ivjEventHandler);
        this.getInspectDescriptorMenuItem().addActionListener(this.ivjEventHandler);
        this.getClearCacheMenuItem().addActionListener(this.ivjEventHandler);
        this.getInspectCacheMenuItem().addActionListener(this.ivjEventHandler);
        this.getSQLUpdateMenuItem().addActionListener(this.ivjEventHandler);
        this.getSQLSelectMenuItem().addActionListener(this.ivjEventHandler);
        this.getClearSQLMenuItem().addActionListener(this.ivjEventHandler);
        this.getLoginMenuItem().addActionListener(this.ivjEventHandler);
        this.getLogoutMenuItem().addActionListener(this.ivjEventHandler);
        this.getInspectSessionMenuItem1().addActionListener(this.ivjEventHandler);
        this.getExecuteQueryMenuItem().addActionListener(this.ivjEventHandler);
        this.getCutSQLMenuItem().addActionListener(this.ivjEventHandler);
        this.getCopySQLMenuItem().addActionListener(this.ivjEventHandler);
        this.getPasteSQLMenuItem().addActionListener(this.ivjEventHandler);
        this.getClearLogMenuItem().addActionListener(this.ivjEventHandler);
        this.getClearResultsMenuItem().addActionListener(this.ivjEventHandler);
        this.getInspectResultMenuItem().addActionListener(this.ivjEventHandler);
        this.getInsertSQLMenuItem().addActionListener(this.ivjEventHandler);
        this.getUpdateSQLMenuItem().addActionListener(this.ivjEventHandler);
        this.getDeleteSQLMenuItem().addActionListener(this.ivjEventHandler);
        this.getSelectSQLMenuItem().addActionListener(this.ivjEventHandler);
        this.getBrowseProfileMenuItem().addActionListener(this.ivjEventHandler);
        this.addWindowListener(this.ivjEventHandler);
    }

    private void initialize() {
        try {
            this.setName("SessionInspectorFrame");
            this.setDefaultCloseOperation(2);
            this.setJMenuBar(this.getSessionInspectorFrameJMenuBar());
            this.setSize(800, 600);
            this.setTitle("TopLink Session Console");
            URL iconURL = this.getClass().getResource("/tl_icon16.gif");
            if (iconURL != null) {
                this.setIconImage(new ImageIcon(iconURL).getImage());
            }
            this.setContentPane(this.getMainPanel());
            this.initConnections();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
        SessionConsole.centerComponent(this);
    }

    public void inspectCache() {
        this.getSessionInspectorPanel().inspectFromCache();
    }

    public void inspectDescriptor() {
        this.getSessionInspectorPanel().inspectDescriptor();
    }

    public void inspectResult() {
        this.getSessionInspectorPanel().inspectResult();
    }

    public void inspectSession() {
        this.getSessionInspectorPanel().inspectSession();
    }

    public void loadProject() {
        this.getSessionInspectorPanel().loadProject();
    }

    public void login() {
        this.getSessionInspectorPanel().setup();
        this.getSessionInspectorPanel().login();
    }

    public void logout() {
        this.getSessionInspectorPanel().logout();
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            SessionConsole aSessionInspectorFrame = new SessionConsole();
            try {
                Class<?> aCloserClass = Class.forName("com.ibm.uvm.abt.edit.WindowCloser");
                Class[] parmTypes = new Class[]{Window.class};
                Object[] parms = new Object[]{aSessionInspectorFrame};
                Constructor<?> aCtor = aCloserClass.getConstructor(parmTypes);
                aCtor.newInstance(parms);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            aSessionInspectorFrame.setVisible(true);
        }
        catch (Throwable exception) {
            System.err.println("Exception occurred in main() of javax.swing.JFrame");
            exception.printStackTrace(System.out);
        }
    }

    public void pasteSQL() {
        this.getSessionInspectorPanel().pasteSQL();
    }

    public void resetDescriptors() {
        this.getSessionInspectorPanel().resetDescriptors();
    }

    public void setSession(Session session) {
        this.getSessionInspectorPanel().setSession(session);
    }

    public void templateSQLDelete() {
        this.getSessionInspectorPanel().templateSQLDelete();
    }

    public void templateSQLInsert() {
        this.getSessionInspectorPanel().templateSQLInsert();
    }

    public void templateSQLSelect() {
        this.getSessionInspectorPanel().templateSQLSelect();
    }

    public void templateSQLUpdate() {
        this.getSessionInspectorPanel().templateSQLUpdate();
    }

    class IvjEventHandler
    implements ActionListener,
    WindowListener {
        IvjEventHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == SessionConsole.this.getCloseMenuItem()) {
                SessionConsole.this.connEtoM1(e);
            }
            if (e.getSource() == SessionConsole.this.getLoadProjectMenuItem()) {
                SessionConsole.this.connEtoC1(e);
            }
            if (e.getSource() == SessionConsole.this.getExitMenuItem()) {
                SessionConsole.this.connEtoC2(e);
            }
            if (e.getSource() == SessionConsole.this.getResetDescriptorsMenuItem()) {
                SessionConsole.this.connEtoC3(e);
            }
            if (e.getSource() == SessionConsole.this.getClearDescriptorsMenuItem()) {
                SessionConsole.this.connEtoC4(e);
            }
            if (e.getSource() == SessionConsole.this.getInspectDescriptorMenuItem()) {
                SessionConsole.this.connEtoC5(e);
            }
            if (e.getSource() == SessionConsole.this.getClearCacheMenuItem()) {
                SessionConsole.this.connEtoC6(e);
            }
            if (e.getSource() == SessionConsole.this.getInspectCacheMenuItem()) {
                SessionConsole.this.connEtoC7(e);
            }
            if (e.getSource() == SessionConsole.this.getSQLUpdateMenuItem()) {
                SessionConsole.this.connEtoC8(e);
            }
            if (e.getSource() == SessionConsole.this.getSQLSelectMenuItem()) {
                SessionConsole.this.connEtoC9(e);
            }
            if (e.getSource() == SessionConsole.this.getClearSQLMenuItem()) {
                SessionConsole.this.connEtoC10(e);
            }
            if (e.getSource() == SessionConsole.this.getLoginMenuItem()) {
                SessionConsole.this.connEtoC11(e);
            }
            if (e.getSource() == SessionConsole.this.getLogoutMenuItem()) {
                SessionConsole.this.connEtoC12(e);
            }
            if (e.getSource() == SessionConsole.this.getInspectSessionMenuItem1()) {
                SessionConsole.this.connEtoC13(e);
            }
            if (e.getSource() == SessionConsole.this.getExecuteQueryMenuItem()) {
                SessionConsole.this.connEtoC14(e);
            }
            if (e.getSource() == SessionConsole.this.getCutSQLMenuItem()) {
                SessionConsole.this.connEtoC15(e);
            }
            if (e.getSource() == SessionConsole.this.getCopySQLMenuItem()) {
                SessionConsole.this.connEtoC16(e);
            }
            if (e.getSource() == SessionConsole.this.getPasteSQLMenuItem()) {
                SessionConsole.this.connEtoC17(e);
            }
            if (e.getSource() == SessionConsole.this.getClearLogMenuItem()) {
                SessionConsole.this.connEtoC18(e);
            }
            if (e.getSource() == SessionConsole.this.getClearResultsMenuItem()) {
                SessionConsole.this.connEtoC19(e);
            }
            if (e.getSource() == SessionConsole.this.getInspectResultMenuItem()) {
                SessionConsole.this.connEtoC20(e);
            }
            if (e.getSource() == SessionConsole.this.getInsertSQLMenuItem()) {
                SessionConsole.this.connEtoC21(e);
            }
            if (e.getSource() == SessionConsole.this.getUpdateSQLMenuItem()) {
                SessionConsole.this.connEtoC22(e);
            }
            if (e.getSource() == SessionConsole.this.getDeleteSQLMenuItem()) {
                SessionConsole.this.connEtoC23(e);
            }
            if (e.getSource() == SessionConsole.this.getSelectSQLMenuItem()) {
                SessionConsole.this.connEtoC24(e);
            }
            if (e.getSource() == SessionConsole.this.getBrowseProfileMenuItem()) {
                SessionConsole.this.connEtoC25(e);
            }
        }

        @Override
        public void windowActivated(WindowEvent e) {
        }

        @Override
        public void windowClosed(WindowEvent e) {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            if (e.getSource() == SessionConsole.this) {
                SessionConsole.this.connEtoC28(e);
            }
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
        }

        @Override
        public void windowDeiconified(WindowEvent e) {
        }

        @Override
        public void windowIconified(WindowEvent e) {
        }

        @Override
        public void windowOpened(WindowEvent e) {
        }
    }
}

