/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import oracle.kv.impl.metadata.Metadata;
import oracle.kv.impl.metadata.MetadataInfo;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.topo.change.TopologyChange;
import oracle.kv.impl.util.FastExternalizable;
import oracle.kv.impl.util.SerializationUtil;

public class TopologyInfo
implements FastExternalizable,
MetadataInfo,
Serializable {
    private static final long serialVersionUID = 1L;
    private final long topoId;
    private final int respSeqNum;
    private final List<TopologyChange> changes;
    private final byte[] topoSignature;
    public static TopologyInfo EMPTY_TOPO_INFO = new TopologyInfo(-1L, 0, null, null);

    public TopologyInfo(Topology topo, List<TopologyChange> changes) {
        this(topo.getId(), topo.getSequenceNumber(), changes, topo.getSignature());
    }

    public TopologyInfo(long topoId, int respSeqNum, List<TopologyChange> changes, byte[] topoSignature) {
        this.topoId = topoId;
        this.respSeqNum = respSeqNum;
        this.changes = changes;
        this.topoSignature = topoSignature;
    }

    public TopologyInfo(DataInput in, short serialVersion) throws IOException {
        this.topoId = in.readLong();
        this.respSeqNum = SerializationUtil.readPackedInt(in);
        int numChanges = SerializationUtil.readSequenceLength(in);
        if (numChanges == -1) {
            this.changes = null;
        } else {
            this.changes = new ArrayList<TopologyChange>(numChanges);
            for (int i = 0; i < numChanges; ++i) {
                this.changes.add(TopologyChange.readFastExternal(in, serialVersion));
            }
        }
        this.topoSignature = SerializationUtil.readByteArray(in);
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        out.writeLong(this.topoId);
        SerializationUtil.writePackedInt(out, this.respSeqNum);
        if (this.changes == null) {
            SerializationUtil.writeCollectionLength(out, this.changes);
        } else {
            SerializationUtil.writeNonNullCollection(out, serialVersion, this.changes);
        }
        SerializationUtil.writeByteArray(out, this.topoSignature);
    }

    @Override
    public Metadata.MetadataType getType() {
        return Metadata.MetadataType.TOPOLOGY;
    }

    @Override
    public int getSourceSeqNum() {
        return this.respSeqNum;
    }

    @Override
    public boolean isEmpty() {
        return this.changes == null || this.changes.isEmpty();
    }

    public long getTopoId() {
        return this.topoId;
    }

    public byte[] getTopoSignature() {
        if (this.topoSignature == null) {
            return null;
        }
        return Arrays.copyOf(this.topoSignature, this.topoSignature.length);
    }

    public List<TopologyChange> getChanges() {
        return this.changes;
    }
}

