/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.runtime;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import oracle.kv.impl.api.table.BooleanValueImpl;
import oracle.kv.impl.api.table.DoubleValueImpl;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.Geometry;
import oracle.kv.impl.api.table.NullValueImpl;
import oracle.kv.impl.query.QueryStateException;
import oracle.kv.impl.query.compiler.CompilerAPI;
import oracle.kv.impl.query.compiler.Expr;
import oracle.kv.impl.query.compiler.ExprFuncCall;
import oracle.kv.impl.query.compiler.FunctionLib;
import oracle.kv.impl.query.compiler.QueryFormatter;
import oracle.kv.impl.query.runtime.PlanIter;
import oracle.kv.impl.query.runtime.PlanIterState;
import oracle.kv.impl.query.runtime.RuntimeControlBlock;

public class FuncGeoSearchIter
extends PlanIter {
    private final FunctionLib.FuncCode theCode;
    private final PlanIter theLeftOp;
    private final PlanIter theRightOp;
    private final PlanIter theDistanceOp;
    private final boolean theIsLeftConst;
    private final boolean theIsRightConst;
    private final boolean theIsDistanceConst;

    public FuncGeoSearchIter(Expr e, FunctionLib.FuncCode code, int resultReg, PlanIter[] argIters) {
        super(e, resultReg);
        this.theCode = code;
        this.theLeftOp = argIters[0];
        this.theRightOp = argIters[1];
        ExprFuncCall fncall = (ExprFuncCall)e;
        Expr larg = fncall.getArg(0);
        Expr rarg = fncall.getArg(1);
        this.theIsLeftConst = Expr.ConstKind.isConst(larg);
        this.theIsRightConst = Expr.ConstKind.isConst(rarg);
        if (this.theCode == FunctionLib.FuncCode.FN_GEO_WITHIN_DISTANCE) {
            this.theDistanceOp = argIters[2];
            this.theIsDistanceConst = Expr.ConstKind.isConst(fncall.getArg(2));
        } else {
            this.theDistanceOp = null;
            this.theIsDistanceConst = false;
        }
    }

    FuncGeoSearchIter(DataInput in, short serialVersion) throws IOException {
        super(in, serialVersion);
        short ordinal = FuncGeoSearchIter.readOrdinal(in, FunctionLib.FuncCode.values().length);
        this.theCode = FunctionLib.FuncCode.values()[ordinal];
        this.theLeftOp = FuncGeoSearchIter.deserializeIter(in, serialVersion);
        this.theRightOp = FuncGeoSearchIter.deserializeIter(in, serialVersion);
        this.theDistanceOp = FuncGeoSearchIter.deserializeIter(in, serialVersion);
        this.theIsLeftConst = in.readBoolean();
        this.theIsRightConst = in.readBoolean();
        this.theIsDistanceConst = in.readBoolean();
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        out.writeShort(this.theCode.ordinal());
        FuncGeoSearchIter.serializeIter(this.theLeftOp, out, serialVersion);
        FuncGeoSearchIter.serializeIter(this.theRightOp, out, serialVersion);
        FuncGeoSearchIter.serializeIter(this.theDistanceOp, out, serialVersion);
        out.writeBoolean(this.theIsLeftConst);
        out.writeBoolean(this.theIsRightConst);
        out.writeBoolean(this.theIsDistanceConst);
    }

    @Override
    public PlanIter.PlanIterKind getKind() {
        return PlanIter.PlanIterKind.GEO_SEARCH;
    }

    @Override
    FunctionLib.FuncCode getFuncCode() {
        return this.theCode;
    }

    @Override
    public void open(RuntimeControlBlock rcb) {
        rcb.setState(this.theStatePos, new FuncGeoSearchState());
        this.theLeftOp.open(rcb);
        this.theRightOp.open(rcb);
        if (this.theDistanceOp != null) {
            this.theDistanceOp.open(rcb);
        }
    }

    @Override
    public void reset(RuntimeControlBlock rcb) {
        this.theLeftOp.reset(rcb);
        this.theRightOp.reset(rcb);
        if (this.theDistanceOp != null) {
            this.theDistanceOp.reset(rcb);
        }
        PlanIterState state = rcb.getState(this.theStatePos);
        state.reset(this);
    }

    @Override
    public void close(RuntimeControlBlock rcb) {
        PlanIterState state = rcb.getState(this.theStatePos);
        if (state == null) {
            return;
        }
        this.theLeftOp.close(rcb);
        this.theRightOp.close(rcb);
        if (this.theDistanceOp != null) {
            this.theDistanceOp.close(rcb);
        }
        state.close();
    }

    @Override
    public boolean next(RuntimeControlBlock rcb) {
        boolean res;
        FuncGeoSearchState state = (FuncGeoSearchState)rcb.getState(this.theStatePos);
        if (state.isDone()) {
            return false;
        }
        Geometry lgeom = null;
        Geometry rgeom = null;
        Geometry bgeom = null;
        FieldValueImpl lvalue = null;
        FieldValueImpl rvalue = null;
        boolean haveNULL = false;
        if (state.theLeftGeom == null) {
            boolean leftOpNext = this.theLeftOp.next(rcb);
            if (leftOpNext) {
                lvalue = rcb.getRegVal(this.theLeftOp.getResultReg());
                if (lvalue.isNull()) {
                    haveNULL = true;
                } else {
                    lgeom = CompilerAPI.getGeoUtils().castAsGeometry(lvalue, state.sb);
                    if (this.theLeftOp.next(rcb)) {
                        lgeom = null;
                    }
                    if (this.theIsLeftConst) {
                        state.theLeftGeom = lgeom;
                    }
                }
            }
        } else {
            lgeom = state.theLeftGeom;
        }
        if (state.theRightGeom == null) {
            boolean rightOpNext = this.theRightOp.next(rcb);
            if (rightOpNext) {
                rvalue = rcb.getRegVal(this.theRightOp.getResultReg());
                if (rvalue.isNull()) {
                    haveNULL = true;
                } else {
                    rgeom = CompilerAPI.getGeoUtils().castAsGeometry(rvalue, state.sb);
                    if (this.theRightOp.next(rcb)) {
                        rgeom = null;
                    }
                    if (this.theIsRightConst) {
                        state.theRightGeom = rgeom;
                    }
                }
            }
        } else {
            rgeom = state.theRightGeom;
        }
        if (lgeom == null || rgeom == null) {
            rcb.setRegVal(this.theResultReg, BooleanValueImpl.falseValue);
            state.done();
            return true;
        }
        if (haveNULL) {
            rcb.setRegVal(this.theResultReg, NullValueImpl.getInstance());
            state.done();
            return true;
        }
        if (state.theBufferedGeom == null && this.theCode == FunctionLib.FuncCode.FN_GEO_WITHIN_DISTANCE) {
            this.theDistanceOp.next(rcb);
            double dist = ((DoubleValueImpl)rcb.getRegVal(this.theDistanceOp.getResultReg())).get();
            bgeom = rgeom.buffer(dist, this.theLocation);
            if (this.theIsDistanceConst) {
                state.theBufferedGeom = bgeom;
            }
        } else {
            bgeom = state.theBufferedGeom;
        }
        switch (this.theCode) {
            case FN_GEO_INTERSECT: {
                res = lgeom.interact(rgeom, this.theLocation);
                break;
            }
            case FN_GEO_INSIDE: {
                if (!rgeom.isPolygon()) {
                    res = false;
                    break;
                }
                res = lgeom.inside(rgeom, this.theLocation);
                break;
            }
            case FN_GEO_WITHIN_DISTANCE: {
                res = lgeom.interact(bgeom, this.theLocation);
                if (rcb.getTraceLevel() < 2 || res) break;
                double dist = lgeom.distance(rgeom, this.theLocation);
                rcb.trace("Distance = " + dist + "\nBuffered Geometry = " + bgeom.toGeoJson());
                break;
            }
            default: {
                throw new QueryStateException("Unexpected geo search function " + (Object)((Object)this.theCode));
            }
        }
        if (rcb.getTraceLevel() >= 2 && !res) {
            rcb.trace((Object)((Object)this.theCode) + ": Eliminated false positive for geom: " + lvalue);
        }
        if (res) {
            rcb.setRegVal(this.theResultReg, BooleanValueImpl.trueValue);
        } else {
            rcb.setRegVal(this.theResultReg, BooleanValueImpl.falseValue);
        }
        state.done();
        return true;
    }

    @Override
    protected void displayContent(StringBuilder sb, QueryFormatter formatter) {
        this.theLeftOp.display(sb, formatter);
        sb.append(",\n");
        this.theRightOp.display(sb, formatter);
        if (this.theDistanceOp != null) {
            sb.append(",\n");
            this.theDistanceOp.display(sb, formatter);
        }
    }

    private static class FuncGeoSearchState
    extends PlanIterState {
        Geometry theLeftGeom;
        Geometry theRightGeom;
        Geometry theBufferedGeom;
        StringBuilder sb = new StringBuilder(256);

        private FuncGeoSearchState() {
        }
    }
}

