/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.beans;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;

public class MessageDialog
extends JDialog {
    private JPanel ivjJDialogContentPane = null;
    private JScrollPane ivjMessageScrollPane = null;
    private JTextPane ivjMessageTextPane = null;
    private JButton ivjOKButton = null;
    IvjEventHandler ivjEventHandler = new IvjEventHandler();

    public MessageDialog() {
        this.initialize();
    }

    public MessageDialog(Frame owner) {
        super(owner);
    }

    public MessageDialog(Frame owner, String title) {
        super(owner, title);
    }

    public MessageDialog(Frame owner, String title, boolean modal) {
        super(owner, title, modal);
    }

    public MessageDialog(Frame owner, boolean modal) {
        super(owner, modal);
    }

    public static void centerComponent(Component component, Component parent) {
        while (parent.getParent() != null) {
            parent = parent.getParent();
        }
        Dimension parentSize = parent.getSize();
        Dimension size = component.getSize();
        int xOffset = parent.getLocation().x;
        int yOffset = parent.getLocation().y;
        parentSize.height /= 2;
        parentSize.width /= 2;
        size.height /= 2;
        size.width /= 2;
        component.setLocation(parentSize.width - size.width + xOffset, parentSize.height - size.height + yOffset);
    }

    private void connEtoM1(ActionEvent arg1) {
        try {
            this.dispose();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    public static void displayException(Throwable exception) {
        MessageDialog.displayMessage(exception.toString());
    }

    public static void displayException(Throwable exception, Container parent) {
        MessageDialog.displayMessage(exception.toString(), parent);
    }

    public static void displayMessage(String message) {
        try {
            MessageDialog aMessageDialog = new MessageDialog();
            aMessageDialog.setVisible(true);
            aMessageDialog.setMessage(message);
        }
        catch (Throwable exception) {
            System.err.println("Exception occurred in main() of javax.swing.JDialog");
            exception.printStackTrace(System.out);
        }
    }

    public static void displayMessage(String message, Container parent) {
        try {
            MessageDialog aMessageDialog = new MessageDialog();
            MessageDialog.centerComponent(aMessageDialog, parent);
            aMessageDialog.setVisible(true);
            aMessageDialog.setMessage(message);
        }
        catch (Throwable exception) {
            System.err.println("Exception occurred in main() of javax.swing.JDialog");
            exception.printStackTrace(System.out);
        }
    }

    private JPanel getJDialogContentPane() {
        if (this.ivjJDialogContentPane == null) {
            try {
                this.ivjJDialogContentPane = new JPanel();
                this.ivjJDialogContentPane.setName("JDialogContentPane");
                this.ivjJDialogContentPane.setLayout(new GridBagLayout());
                this.ivjJDialogContentPane.setBackground(SystemColor.control);
                GridBagConstraints constraintsOKButton = new GridBagConstraints();
                constraintsOKButton.gridx = 0;
                constraintsOKButton.gridy = 1;
                constraintsOKButton.weightx = 1.0;
                constraintsOKButton.ipadx = 20;
                constraintsOKButton.insets = new Insets(0, 0, 4, 0);
                this.getJDialogContentPane().add((Component)this.getOKButton(), constraintsOKButton);
                GridBagConstraints constraintsMessageScrollPane = new GridBagConstraints();
                constraintsMessageScrollPane.gridx = 0;
                constraintsMessageScrollPane.gridy = 0;
                constraintsMessageScrollPane.fill = 1;
                constraintsMessageScrollPane.weightx = 1.0;
                constraintsMessageScrollPane.weighty = 1.0;
                constraintsMessageScrollPane.insets = new Insets(4, 4, 4, 4);
                this.getJDialogContentPane().add((Component)this.getMessageScrollPane(), constraintsMessageScrollPane);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjJDialogContentPane;
    }

    public String getMessage() {
        return this.getMessageTextPane().getText();
    }

    private JScrollPane getMessageScrollPane() {
        if (this.ivjMessageScrollPane == null) {
            try {
                this.ivjMessageScrollPane = new JScrollPane();
                this.ivjMessageScrollPane.setName("MessageScrollPane");
                this.getMessageScrollPane().setViewportView(this.getMessageTextPane());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjMessageScrollPane;
    }

    private JTextPane getMessageTextPane() {
        if (this.ivjMessageTextPane == null) {
            try {
                this.ivjMessageTextPane = new JTextPane();
                this.ivjMessageTextPane.setName("MessageTextPane");
                this.ivjMessageTextPane.setBounds(0, 0, 10, 10);
                this.ivjMessageTextPane.setEnabled(false);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjMessageTextPane;
    }

    private JButton getOKButton() {
        if (this.ivjOKButton == null) {
            try {
                this.ivjOKButton = new JButton();
                this.ivjOKButton.setName("OKButton");
                this.ivjOKButton.setText("OK");
                this.ivjOKButton.setBackground(SystemColor.control);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjOKButton;
    }

    private void handleException(Throwable exception) {
        exception.printStackTrace();
    }

    private void initConnections() {
        this.getOKButton().addActionListener(this.ivjEventHandler);
    }

    private void initialize() {
        try {
            this.setName("MessageDialog");
            this.setDefaultCloseOperation(2);
            this.setSize(500, 300);
            this.setTitle("Message");
            this.setContentPane(this.getJDialogContentPane());
            this.initConnections();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    public void setMessage(String message) {
        this.getMessageTextPane().setText(message);
    }

    class IvjEventHandler
    implements ActionListener {
        IvjEventHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == MessageDialog.this.getOKButton()) {
                MessageDialog.this.connEtoM1(e);
            }
        }
    }
}

