/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.rep.admin;

import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import oracle.kv.impl.api.TopologyInfo;
import oracle.kv.impl.metadata.Metadata;
import oracle.kv.impl.metadata.MetadataInfo;
import oracle.kv.impl.metadata.MetadataKey;
import oracle.kv.impl.mgmt.RepNodeStatusReceiver;
import oracle.kv.impl.param.LoadParameters;
import oracle.kv.impl.rep.NetworkRestoreStatus;
import oracle.kv.impl.rep.RepNodeStatus;
import oracle.kv.impl.rep.admin.RepNodeAdmin;
import oracle.kv.impl.rep.admin.RepNodeInfo;
import oracle.kv.impl.rep.admin.ResourceInfo;
import oracle.kv.impl.rep.migration.PartitionMigrationStatus;
import oracle.kv.impl.security.AuthContext;
import oracle.kv.impl.security.ContextProxy;
import oracle.kv.impl.security.login.LoginHandle;
import oracle.kv.impl.security.util.KerberosPrincipals;
import oracle.kv.impl.topo.PartitionId;
import oracle.kv.impl.topo.RepGroupId;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.util.registry.RemoteAPI;

public class RepNodeAdminAPI
extends RemoteAPI {
    private static final AuthContext NULL_CTX = null;
    private static final short KERBEROS_AUTHENTICATION_SERIAL_VERSION = 9;
    private static final short DELETE_MEMBER_VERSION = 10;
    private static final short NEW_MIGRATION_STATE_VERSION = 16;
    private final RepNodeAdmin proxyRemote;

    private RepNodeAdminAPI(RepNodeAdmin remote, LoginHandle loginHdl) throws RemoteException {
        super(remote);
        this.proxyRemote = ContextProxy.create(remote, loginHdl, this.getSerialVersion());
    }

    public static RepNodeAdminAPI wrap(RepNodeAdmin remote, LoginHandle loginHdl) throws RemoteException {
        return new RepNodeAdminAPI(remote, loginHdl);
    }

    public void configure(Set<Metadata<? extends MetadataInfo>> metadataSet) throws RemoteException {
        this.proxyRemote.configure(metadataSet, NULL_CTX, this.getSerialVersion());
    }

    public void newParameters() throws RemoteException {
        this.proxyRemote.newParameters(NULL_CTX, this.getSerialVersion());
    }

    public void newGlobalParameters() throws RemoteException {
        this.proxyRemote.newGlobalParameters(NULL_CTX, this.getSerialVersion());
    }

    @Deprecated
    public void updateTopology(Topology newTopology) throws RemoteException {
        this.proxyRemote.updateMetadata(newTopology, NULL_CTX, this.getSerialVersion());
    }

    @Deprecated
    public int updateTopology(TopologyInfo topoInfo) throws RemoteException {
        return this.proxyRemote.updateMetadata(topoInfo, NULL_CTX, this.getSerialVersion());
    }

    public Topology getTopology() throws RemoteException {
        return this.proxyRemote.getTopology(NULL_CTX, this.getSerialVersion());
    }

    public int getTopoSeqNum() throws RemoteException {
        return this.proxyRemote.getTopoSeqNum(NULL_CTX, this.getSerialVersion());
    }

    public LoadParameters getParams() throws RemoteException {
        return this.proxyRemote.getParams(NULL_CTX, this.getSerialVersion());
    }

    public void shutdown(boolean force) throws RemoteException {
        this.proxyRemote.shutdown(force, NULL_CTX, this.getSerialVersion());
    }

    public RepNodeStatus ping() throws RemoteException {
        return this.proxyRemote.ping(NULL_CTX, this.getSerialVersion());
    }

    public RepNodeInfo getInfo() throws RemoteException {
        return this.proxyRemote.getInfo(NULL_CTX, this.getSerialVersion());
    }

    public String[] startBackup() throws RemoteException {
        return this.proxyRemote.startBackup(NULL_CTX, this.getSerialVersion());
    }

    public long stopBackup() throws RemoteException {
        return this.proxyRemote.stopBackup(NULL_CTX, this.getSerialVersion());
    }

    public boolean updateMemberHAAddress(String groupName, String targetNodeName, String targetHelperHosts, String newNodeHostPort) throws RemoteException {
        if (this.getSerialVersion() < 2) {
            throw new UnsupportedOperationException("There was an attempt update the HA address on a RepNode that is running an earlier, incompatible release.  Please upgrade all components of the store before attempting to change the store's configuration.");
        }
        return this.proxyRemote.updateMemberHAAddress(groupName, targetNodeName, targetHelperHosts, newNodeHostPort, NULL_CTX, this.getSerialVersion());
    }

    public boolean deleteMember(String groupName, String targetNodeName, String targetHelperHosts) throws RemoteException {
        if (this.getSerialVersion() < 10) {
            throw new UnsupportedOperationException("There was an attempt to delete JE HA node for a RepNode that is running an earlier, incompatible release.  Please upgrade all components of the store before attempting to change the store's configuration.");
        }
        return this.proxyRemote.deleteMember(groupName, targetNodeName, targetHelperHosts, NULL_CTX, this.getSerialVersion());
    }

    @Deprecated
    public RepNodeAdmin.PartitionMigrationState migratePartition(PartitionId partitionId, RepGroupId sourceRGId) throws RemoteException {
        return this.migratePartitionV2(partitionId, sourceRGId).getPartitionMigrationState();
    }

    public RepNodeAdmin.MigrationState migratePartitionV2(PartitionId partitionId, RepGroupId sourceRGId) throws RemoteException {
        if (this.getSerialVersion() < 16) {
            RepNodeAdmin.PartitionMigrationState mstate = this.proxyRemote.migratePartition(partitionId, sourceRGId, NULL_CTX, this.getSerialVersion());
            return new RepNodeAdmin.MigrationState(mstate);
        }
        return this.proxyRemote.migratePartitionV2(partitionId, sourceRGId, NULL_CTX, this.getSerialVersion());
    }

    @Deprecated
    public RepNodeAdmin.PartitionMigrationState getMigrationState(PartitionId partitionId) throws RemoteException {
        return this.getMigrationStateV2(partitionId).getPartitionMigrationState();
    }

    public RepNodeAdmin.MigrationState getMigrationStateV2(PartitionId partitionId) throws RemoteException {
        if (this.getSerialVersion() < 16) {
            RepNodeAdmin.PartitionMigrationState mstate = this.proxyRemote.getMigrationState(partitionId, NULL_CTX, this.getSerialVersion());
            return new RepNodeAdmin.MigrationState(mstate);
        }
        return this.proxyRemote.getMigrationStateV2(partitionId, NULL_CTX, this.getSerialVersion());
    }

    @Deprecated
    public RepNodeAdmin.PartitionMigrationState canCancel(PartitionId partitionId) throws RemoteException {
        return this.canCancelV2(partitionId).getPartitionMigrationState();
    }

    public RepNodeAdmin.MigrationState canCancelV2(PartitionId partitionId) throws RemoteException {
        if (this.getSerialVersion() < 16) {
            RepNodeAdmin.PartitionMigrationState mstate = this.proxyRemote.canCancel(partitionId, NULL_CTX, this.getSerialVersion());
            return new RepNodeAdmin.MigrationState(mstate);
        }
        return this.proxyRemote.canCancelV2(partitionId, NULL_CTX, this.getSerialVersion());
    }

    public boolean canceled(PartitionId partitionId, RepGroupId targetRGId) throws RemoteException {
        return this.proxyRemote.canceled(partitionId, targetRGId, NULL_CTX, this.getSerialVersion());
    }

    public PartitionMigrationStatus getMigrationStatus(PartitionId partitionId) throws RemoteException {
        return this.proxyRemote.getMigrationStatus(partitionId, NULL_CTX, this.getSerialVersion());
    }

    public boolean initiateMasterTransfer(RepNodeId replicaId, int timeout, TimeUnit timeUnit) throws RemoteException {
        return this.proxyRemote.initiateMasterTransfer(replicaId, timeout, timeUnit, NULL_CTX, this.getSerialVersion());
    }

    public void installStatusReceiver(RepNodeStatusReceiver receiver) throws RemoteException {
        this.proxyRemote.installStatusReceiver(receiver, NULL_CTX, this.getSerialVersion());
    }

    public boolean awaitConsistency(long stopTime, int timeout, TimeUnit unit) throws RemoteException {
        return this.proxyRemote.awaitConsistency(stopTime, timeout, unit, NULL_CTX, this.getSerialVersion());
    }

    public int getMetadataSeqNum(Metadata.MetadataType type) throws RemoteException {
        return this.proxyRemote.getMetadataSeqNum(type, NULL_CTX, this.getSerialVersion());
    }

    public Metadata<?> getMetadata(Metadata.MetadataType type) throws RemoteException {
        return this.proxyRemote.getMetadata(type, NULL_CTX, this.getSerialVersion());
    }

    public MetadataInfo getMetadata(Metadata.MetadataType type, int seqNum) throws RemoteException {
        return this.proxyRemote.getMetadata(type, seqNum, NULL_CTX, this.getSerialVersion());
    }

    public MetadataInfo getMetadata(Metadata.MetadataType type, MetadataKey key, int seqNum) throws RemoteException {
        return this.proxyRemote.getMetadata(type, key, seqNum, NULL_CTX, this.getSerialVersion());
    }

    public int updateMetadata(MetadataInfo metadataInfo) throws RemoteException {
        return this.proxyRemote.updateMetadata(metadataInfo, NULL_CTX, this.getSerialVersion());
    }

    public void updateMetadata(Metadata<?> newMetadata) throws RemoteException {
        this.proxyRemote.updateMetadata(newMetadata, NULL_CTX, this.getSerialVersion());
    }

    public boolean addIndexComplete(String namespace, String indexId, String tableName) throws RemoteException {
        if (this.getSerialVersion() < 14) {
            return this.proxyRemote.addIndexComplete(indexId, tableName, NULL_CTX, this.getSerialVersion());
        }
        return this.proxyRemote.addIndexComplete(namespace, indexId, tableName, NULL_CTX, this.getSerialVersion());
    }

    public boolean removeTableDataComplete(String namespace, String tableName) throws RemoteException {
        if (this.getSerialVersion() < 14) {
            return this.proxyRemote.removeTableDataComplete(tableName, NULL_CTX, this.getSerialVersion());
        }
        return this.proxyRemote.removeTableDataComplete(namespace, tableName, NULL_CTX, this.getSerialVersion());
    }

    public KerberosPrincipals getKerberosPrincipals() throws RemoteException {
        this.checkVersion((short)9);
        return this.proxyRemote.getKerberosPrincipals(NULL_CTX, this.getSerialVersion());
    }

    public boolean startNetworkRestore(RepNodeId sourceNode, boolean retainOriginalLogFile, long minVLSN) throws RemoteException {
        this.checkVersion((short)14);
        return this.proxyRemote.startNetworkRestore(sourceNode, retainOriginalLogFile, minVLSN, NULL_CTX, this.getSerialVersion());
    }

    public NetworkRestoreStatus getNetworkRestoreStatus() throws RemoteException {
        this.checkVersion((short)14);
        return this.proxyRemote.getNetworkRestoreStatus(NULL_CTX, this.getSerialVersion());
    }

    public void verifyData(boolean verifyBtree, boolean verifyLog, boolean verifyIndex, boolean verifyRecord, long btreeDelay, long logDelay) throws RemoteException, IOException {
        this.checkVersion((short)16);
        this.proxyRemote.verifyData(verifyBtree, verifyLog, verifyIndex, verifyRecord, btreeDelay, logDelay, NULL_CTX, this.getSerialVersion());
    }

    public ResourceInfo exchangeResourceInfo(long sinceMillis, Collection<ResourceInfo.UsageRecord> usageRecords) throws RemoteException {
        this.checkVersion((short)16);
        return this.proxyRemote.exchangeResourceInfo(sinceMillis, usageRecords, NULL_CTX, this.getSerialVersion());
    }

    public MetadataInfo getTableById(long tableId) throws RemoteException {
        this.checkVersion((short)16);
        return this.proxyRemote.getTableById(tableId, NULL_CTX, this.getSerialVersion());
    }

    public MetadataInfo getTable(String namespace, String tableName, int cost) throws RemoteException {
        this.checkVersion((short)17);
        return this.proxyRemote.getTable(namespace, tableName, cost, NULL_CTX, this.getSerialVersion());
    }

    private void checkVersion(short requiredVersion) {
        if (this.getSerialVersion() < requiredVersion) {
            throw new UnsupportedOperationException("Command not available because service has not yet been upgraded.  (Internal local version=" + requiredVersion + ", internal service version=" + this.getSerialVersion() + ")");
        }
    }
}

