/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.util.registry;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.List;
import oracle.kv.impl.util.PortRange;
import oracle.kv.impl.util.registry.AsyncRegistryUtils;
import oracle.kv.impl.util.registry.ServerSocketFactory;
import oracle.kv.impl.util.registry.SocketAdapter;

public class ClearServerSocketFactory
extends ServerSocketFactory {
    public ClearServerSocketFactory(int backlog, int startPort, int endPort) {
        super(backlog, startPort, endPort);
    }

    @Override
    public ClearServerSocketFactory newInstance(int port) {
        return new ClearServerSocketFactory(this.backlog, port, port);
    }

    public String toString() {
        return "<ClearServerSocketFactory backlog=" + this.backlog + " portRange=" + this.startPort + "," + this.endPort + (AsyncRegistryUtils.serverUseAsync ? " useAsync" : "") + ">";
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        return obj instanceof ClearServerSocketFactory;
    }

    public static ClearServerSocketFactory create(int backlog, String portRange) {
        if (PortRange.isUnconstrained((String)portRange)) {
            return new ClearServerSocketFactory(backlog, 0, 0);
        }
        List range = PortRange.getRange((String)portRange);
        return new ClearServerSocketFactory(backlog, (Integer)range.get(0), (Integer)range.get(1));
    }

    @Override
    protected ServerSocket instantiateServerSocket(int port) throws IOException {
        return new ServerSocket(port, this.backlog);
    }

    @Override
    public ServerSocket preallocateServerSocket() {
        return null;
    }

    @Override
    public void discardServerSocket(ServerSocket ss) {
        throw new UnsupportedOperationException("discardServerSocket is not supported by this implementation");
    }

    @Override
    protected ServerSocket createAsyncServerSocket(int port) throws IOException {
        return new ClearAsyncServerSocket(port);
    }

    private static final class ClearSocket
    extends SocketAdapter {
        private final byte[] preReadBytes;
        private PushbackInputStream in;

        ClearSocket(Socket socket, ByteBuffer preReadData) {
            super(socket);
            this.preReadBytes = new byte[preReadData.remaining()];
            preReadData.get(this.preReadBytes);
        }

        @Override
        public synchronized InputStream getInputStream() throws IOException {
            if (this.in == null) {
                this.in = new PushbackInputStream(super.getInputStream(), this.preReadBytes.length);
                this.in.unread(this.preReadBytes);
            }
            return this.in;
        }
    }

    private final class ClearAsyncServerSocket
    extends ServerSocketFactory.AsyncServerSocket {
        ClearAsyncServerSocket(int port) throws IOException {
            super(ClearServerSocketFactory.this, port);
        }

        @Override
        public synchronized void onPrepared(ByteBuffer preReadData, Socket socket) {
            if (!this.addToQueue(preReadData, socket) && ClearServerSocketFactory.this.connectionLogger != null) {
                ClearServerSocketFactory.this.connectionLogger.info("Refused socket because accept queue is full");
            }
        }

        private boolean addToQueue(ByteBuffer preReadData, Socket socket) {
            ClearSocket wrappedSocket = new ClearSocket(socket, preReadData);
            if (this.acceptQueue.offer(wrappedSocket)) {
                return true;
            }
            try {
                ((Socket)wrappedSocket).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return false;
        }
    }
}

